﻿using System;
using NetRuntimeSystem = System;
using System.ComponentModel;
using NetOffice.Attributes;

namespace NetOffice.MSProjectApi.GlobalHelperModules
{
    ///<summary>
    /// Module GlobalModule
    /// SupportByVersion MSProject 11,12,14
    ///</summary>
    [SupportByVersion("MSProject", 11,12,14)]
	[EntityType(EntityType.IsModule), ModuleBaseType(typeof(MSProjectApi.Application))]
	public static class GlobalModule
	{
		#region Fields

		private static ICOMObject _instance;

        #endregion

        #region Internal Properties

        internal static ICOMObject Instance
        {
            get
            {
                return _instance;
            }
            set
            {
                if ((null == value) || (null == _instance))
                    _instance = value;
            }
        }

        internal static Core Factory
		{
			get
			{
				if(null != _instance)
					 return _instance.Factory;
			else
				return Core.Default;
			}
		}

		internal static Invoker Invoker
		{
			get
			{
				if(null != _instance)
					 return _instance.Invoker;
			else
				return Invoker.Default;
			}
		}

        #endregion

        #region Properties

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Application Application
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.MSProjectApi.Application>(_instance, "Application", NetOffice.MSProjectApi.Application.LateBindingApiWrapperType);
            }
            set
            {
                Factory.ExecuteReferencePropertySet(_instance, "Application", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Application Parent
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.MSProjectApi.Application>(_instance, "Parent", NetOffice.MSProjectApi.Application.LateBindingApiWrapperType);
            }
            set
            {
                Factory.ExecuteReferencePropertySet(_instance, "Parent", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Projects Projects
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.MSProjectApi.Projects>(_instance, "Projects", NetOffice.MSProjectApi.Projects.LateBindingApiWrapperType);
            }
            set
            {
                Factory.ExecuteReferencePropertySet(_instance, "Projects", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Selection ActiveSelection
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.MSProjectApi.Selection>(_instance, "ActiveSelection", NetOffice.MSProjectApi.Selection.LateBindingApiWrapperType);
            }
            set
            {
                Factory.ExecuteReferencePropertySet(_instance, "ActiveSelection", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Cell ActiveCell
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.MSProjectApi.Cell>(_instance, "ActiveCell", NetOffice.MSProjectApi.Cell.LateBindingApiWrapperType);
            }
            set
            {
                Factory.ExecuteReferencePropertySet(_instance, "ActiveCell", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Project ActiveProject
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.MSProjectApi.Project>(_instance, "ActiveProject", NetOffice.MSProjectApi.Project.LateBindingApiWrapperType);
            }
            set
            {
                Factory.ExecuteReferencePropertySet(_instance, "ActiveProject", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Window ActiveWindow
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.MSProjectApi.Window>(_instance, "ActiveWindow", NetOffice.MSProjectApi.Window.LateBindingApiWrapperType);
            }
            set
            {
                Factory.ExecuteReferencePropertySet(_instance, "ActiveWindow", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SupportsMultipleDocuments
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "SupportsMultipleDocuments");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "SupportsMultipleDocuments", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SupportsMultipleWindows
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "SupportsMultipleWindows");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "SupportsMultipleWindows", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Visible
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "Visible");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "Visible", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string PathSeparator
        {
            get
            {
                return Factory.ExecuteStringPropertyGet(_instance, "PathSeparator");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "PathSeparator", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string Caption
        {
            get
            {
                return Factory.ExecuteStringPropertyGet(_instance, "Caption");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "Caption", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string Name
        {
            get
            {
                return Factory.ExecuteStringPropertyGet(_instance, "Name");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "Name", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string Path
        {
            get
            {
                return Factory.ExecuteStringPropertyGet(_instance, "Path");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "Path", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string Version
        {
            get
            {
                return Factory.ExecuteStringPropertyGet(_instance, "Version");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "Version", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Enums.PjWindowState WindowState
        {
            get
            {
                return Factory.ExecuteEnumPropertyGet<NetOffice.MSProjectApi.Enums.PjWindowState>(_instance, "WindowState");
            }
            set
            {
                Factory.ExecuteEnumPropertySet(_instance, "WindowState", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static Int32 Left
        {
            get
            {
                return Factory.ExecuteInt32PropertyGet(_instance, "Left");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "Left", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static Int32 Top
        {
            get
            {
                return Factory.ExecuteInt32PropertyGet(_instance, "Top");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "Top", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static Int32 Width
        {
            get
            {
                return Factory.ExecuteInt32PropertyGet(_instance, "Width");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "Width", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static Int32 Height
        {
            get
            {
                return Factory.ExecuteInt32PropertyGet(_instance, "Height");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "Height", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Enums.PjDateOrder DateOrder
        {
            get
            {
                return Factory.ExecuteEnumPropertyGet<NetOffice.MSProjectApi.Enums.PjDateOrder>(_instance, "DateOrder");
            }
            set
            {
                Factory.ExecuteEnumPropertySet(_instance, "DateOrder", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string DateSeparator
        {
            get
            {
                return Factory.ExecuteStringPropertyGet(_instance, "DateSeparator");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "DateSeparator", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string ThousandSeparator
        {
            get
            {
                return Factory.ExecuteStringPropertyGet(_instance, "ThousandSeparator");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "ThousandSeparator", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string DecimalSeparator
        {
            get
            {
                return Factory.ExecuteStringPropertyGet(_instance, "DecimalSeparator");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "DecimalSeparator", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string ListSeparator
        {
            get
            {
                return Factory.ExecuteStringPropertyGet(_instance, "ListSeparator");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "ListSeparator", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string TimeSeparator
        {
            get
            {
                return Factory.ExecuteStringPropertyGet(_instance, "TimeSeparator");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "TimeSeparator", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TwelveHourTimeFormat
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "TwelveHourTimeFormat");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "TwelveHourTimeFormat", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string AMText
        {
            get
            {
                return Factory.ExecuteStringPropertyGet(_instance, "AMText");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "AMText", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string PMText
        {
            get
            {
                return Factory.ExecuteStringPropertyGet(_instance, "PMText");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "PMText", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string DefaultView
        {
            get
            {
                return Factory.ExecuteStringPropertyGet(_instance, "DefaultView");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "DefaultView", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DisplayStatusBar
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "DisplayStatusBar");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "DisplayStatusBar", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DisplayAlerts
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "DisplayAlerts");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "DisplayAlerts", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DisplayEntryBar
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "DisplayEntryBar");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "DisplayEntryBar", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DisplayScrollBars
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "DisplayScrollBars");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "DisplayScrollBars", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DisplayWindowsInTaskbar
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "DisplayWindowsInTaskbar");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "DisplayWindowsInTaskbar", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Enums.PjCalculation Calculation
        {
            get
            {
                return Factory.ExecuteEnumPropertyGet<NetOffice.MSProjectApi.Enums.PjCalculation>(_instance, "Calculation");
            }
            set
            {
                Factory.ExecuteEnumPropertySet(_instance, "Calculation", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AutoLevel
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "AutoLevel");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "AutoLevel", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AutoClearLeveling
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "AutoClearLeveling");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "AutoClearLeveling", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LevelWithinSlack
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "LevelWithinSlack");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "LevelWithinSlack", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Enums.PjLevelOrder LevelOrder
        {
            get
            {
                return Factory.ExecuteEnumPropertyGet<NetOffice.MSProjectApi.Enums.PjLevelOrder>(_instance, "LevelOrder");
            }
            set
            {
                Factory.ExecuteEnumPropertySet(_instance, "LevelOrder", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Enums.PjLevelPeriodBasis LevelPeriodBasis
        {
            get
            {
                return Factory.ExecuteEnumPropertyGet<NetOffice.MSProjectApi.Enums.PjLevelPeriodBasis>(_instance, "LevelPeriodBasis");
            }
            set
            {
                Factory.ExecuteEnumPropertySet(_instance, "LevelPeriodBasis", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LevelIndividualAssignments
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "LevelIndividualAssignments");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "LevelIndividualAssignments", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LevelProposedBookings
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "LevelProposedBookings");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "LevelProposedBookings", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LevelingCanSplit
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "LevelingCanSplit");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "LevelingCanSplit", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MoveAfterReturn
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "MoveAfterReturn");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "MoveAfterReturn", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DisplayScheduleMessages
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "DisplayScheduleMessages");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "DisplayScheduleMessages", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Enums.PjWeekday StartWeekOn
        {
            get
            {
                return Factory.ExecuteEnumPropertyGet<NetOffice.MSProjectApi.Enums.PjWeekday>(_instance, "StartWeekOn");
            }
            set
            {
                Factory.ExecuteEnumPropertySet(_instance, "StartWeekOn", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Enums.PjMonth StartYearIn
        {
            get
            {
                return Factory.ExecuteEnumPropertyGet<NetOffice.MSProjectApi.Enums.PjMonth>(_instance, "StartYearIn");
            }
            set
            {
                Factory.ExecuteEnumPropertySet(_instance, "StartYearIn", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool CellDragAndDrop
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "CellDragAndDrop");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "CellDragAndDrop", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string UserName
        {
            get
            {
                return Factory.ExecuteStringPropertyGet(_instance, "UserName");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "UserName", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        public static bool DisplayNotesIndicator
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "DisplayNotesIndicator");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "DisplayNotesIndicator", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AskToUpdateLinks
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "AskToUpdateLinks");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "AskToUpdateLinks", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DisplayPlanningWizard
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "DisplayPlanningWizard");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "DisplayPlanningWizard", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DisplayWizardUsage
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "DisplayWizardUsage");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "DisplayWizardUsage", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DisplayWizardErrors
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "DisplayWizardErrors");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "DisplayWizardErrors", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DisplayWizardScheduling
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "DisplayWizardScheduling");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "DisplayWizardScheduling", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        public static bool ShowTipOfDay
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "ShowTipOfDay");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "ShowTipOfDay", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        public static bool ShowToolTips
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "ShowToolTips");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "ShowToolTips", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ShowWelcome
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "ShowWelcome");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "ShowWelcome", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LoadLastFile
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "LoadLastFile");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "LoadLastFile", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PromptForSummaryInfo
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "PromptForSummaryInfo");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "PromptForSummaryInfo", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DisplayOLEIndicator
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "DisplayOLEIndicator");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "DisplayOLEIndicator", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Enums.PjDateFormat DefaultDateFormat
        {
            get
            {
                return Factory.ExecuteEnumPropertyGet<NetOffice.MSProjectApi.Enums.PjDateFormat>(_instance, "DefaultDateFormat");
            }
            set
            {
                Factory.ExecuteEnumPropertySet(_instance, "DefaultDateFormat", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DayLeadingZero
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "DayLeadingZero");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "DayLeadingZero", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MonthLeadingZero
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "MonthLeadingZero");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "MonthLeadingZero", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimeLeadingZero
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "TimeLeadingZero");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "TimeLeadingZero", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        public static bool CopyResourceUsageHeader
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "CopyResourceUsageHeader");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "CopyResourceUsageHeader", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static Int32 RecentFilesMaximum
        {
            get
            {
                return Factory.ExecuteInt32PropertyGet(_instance, "RecentFilesMaximum");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "RecentFilesMaximum", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DisplayRecentFiles
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "DisplayRecentFiles");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "DisplayRecentFiles", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        public static bool MacroVirusProtection
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "MacroVirusProtection");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "MacroVirusProtection", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Enums.PjAssignmentUnits ShowAssignmentUnitsAs
        {
            get
            {
                return Factory.ExecuteEnumPropertyGet<NetOffice.MSProjectApi.Enums.PjAssignmentUnits>(_instance, "ShowAssignmentUnitsAs");
            }
            set
            {
                Factory.ExecuteEnumPropertySet(_instance, "ShowAssignmentUnitsAs", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AutomaticallyFillPhoneticFields
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "AutomaticallyFillPhoneticFields");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "AutomaticallyFillPhoneticFields", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DefaultAutoFilter
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "DefaultAutoFilter");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "DefaultAutoFilter", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ShowEstimatedDuration
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "ShowEstimatedDuration");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "ShowEstimatedDuration", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool NewTasksEstimated
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "NewTasksEstimated");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "NewTasksEstimated", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.OfficeApi.Assistant Assistant
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.OfficeApi.Assistant>(_instance, "Assistant", NetOffice.OfficeApi.Assistant.LateBindingApiWrapperType);
            }
            set
            {
                Factory.ExecuteReferencePropertySet(_instance, "Assistant", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DisplayViewBar
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "DisplayViewBar");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "DisplayViewBar", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.VBIDEApi.VBE VBE
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.VBIDEApi.VBE>(_instance, "VBE", NetOffice.VBIDEApi.VBE.LateBindingApiWrapperType);
            }
            set
            {
                Factory.ExecuteReferencePropertySet(_instance, "VBE", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Enums.PjEnableCancelKey EnableCancelKey
        {
            get
            {
                return Factory.ExecuteEnumPropertyGet<NetOffice.MSProjectApi.Enums.PjEnableCancelKey>(_instance, "EnableCancelKey");
            }
            set
            {
                Factory.ExecuteEnumPropertySet(_instance, "EnableCancelKey", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool UserControl
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "UserControl");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "UserControl", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static Double UsableWidth
        {
            get
            {
                return Factory.ExecuteDoublePropertyGet(_instance, "UsableWidth");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "UsableWidth", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static Double UsableHeight
        {
            get
            {
                return Factory.ExecuteDoublePropertyGet(_instance, "UsableHeight");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "UsableHeight", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static object StatusBar
        {
            get
            {
                return Factory.ExecuteVariantPropertyGet(_instance, "StatusBar");
            }
            set
            {
                Factory.ExecuteVariantPropertySet(_instance, "StatusBar", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.OfficeApi.FileSearch FileSearch
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.OfficeApi.FileSearch>(_instance, "FileSearch", NetOffice.OfficeApi.FileSearch.LateBindingApiWrapperType);
            }
            set
            {
                Factory.ExecuteReferencePropertySet(_instance, "FileSearch", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ScreenUpdating
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "ScreenUpdating");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "ScreenUpdating", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DisplayProjectGuide
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "DisplayProjectGuide");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "DisplayProjectGuide", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.OfficeApi.Enums.MsoAutomationSecurity AutomationSecurity
        {
            get
            {
                return Factory.ExecuteEnumPropertyGet<NetOffice.OfficeApi.Enums.MsoAutomationSecurity>(_instance, "AutomationSecurity");
            }
            set
            {
                Factory.ExecuteEnumPropertySet(_instance, "AutomationSecurity", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EnterpriseAllowLocalBaseCalendars
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "EnterpriseAllowLocalBaseCalendars");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "EnterpriseAllowLocalBaseCalendars", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Enums.PjEditionType Edition
        {
            get
            {
                return Factory.ExecuteEnumPropertyGet<NetOffice.MSProjectApi.Enums.PjEditionType>(_instance, "Edition");
            }
            set
            {
                Factory.ExecuteEnumPropertySet(_instance, "Edition", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Profiles Profiles
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.MSProjectApi.Profiles>(_instance, "Profiles", NetOffice.MSProjectApi.Profiles.LateBindingApiWrapperType);
            }
            set
            {
                Factory.ExecuteReferencePropertySet(_instance, "Profiles", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Calendars GlobalBaseCalendars
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.MSProjectApi.Calendars>(_instance, "GlobalBaseCalendars", NetOffice.MSProjectApi.Calendars.LateBindingApiWrapperType);
            }
            set
            {
                Factory.ExecuteReferencePropertySet(_instance, "GlobalBaseCalendars", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        [BaseResult]
        public static NetOffice.MSProjectApi.Views GlobalViews
        {
            get
            {
                return Factory.ExecuteBaseReferencePropertyGet<NetOffice.MSProjectApi.Views>(_instance, "GlobalViews");
            }
            set
            {
                Factory.ExecuteReferencePropertySet(_instance, "GlobalViews", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.ViewsSingle GlobalViewsSingle
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.MSProjectApi.ViewsSingle>(_instance, "GlobalViewsSingle", NetOffice.MSProjectApi.ViewsSingle.LateBindingApiWrapperType);
            }
            set
            {
                Factory.ExecuteReferencePropertySet(_instance, "GlobalViewsSingle", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.ViewsCombination GlobalViewsCombination
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.MSProjectApi.ViewsCombination>(_instance, "GlobalViewsCombination", NetOffice.MSProjectApi.ViewsCombination.LateBindingApiWrapperType);
            }
            set
            {
                Factory.ExecuteReferencePropertySet(_instance, "GlobalViewsCombination", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Tables GlobalTaskTables
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.MSProjectApi.Tables>(_instance, "GlobalTaskTables", NetOffice.MSProjectApi.Tables.LateBindingApiWrapperType);
            }
            set
            {
                Factory.ExecuteReferencePropertySet(_instance, "GlobalTaskTables", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Tables GlobalResourceTables
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.MSProjectApi.Tables>(_instance, "GlobalResourceTables", NetOffice.MSProjectApi.Tables.LateBindingApiWrapperType);
            }
            set
            {
                Factory.ExecuteReferencePropertySet(_instance, "GlobalResourceTables", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Filters GlobalTaskFilters
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.MSProjectApi.Filters>(_instance, "GlobalTaskFilters", NetOffice.MSProjectApi.Filters.LateBindingApiWrapperType);
            }
            set
            {
                Factory.ExecuteReferencePropertySet(_instance, "GlobalTaskFilters", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Filters GlobalResourceFilters
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.MSProjectApi.Filters>(_instance, "GlobalResourceFilters", NetOffice.MSProjectApi.Filters.LateBindingApiWrapperType);
            }
            set
            {
                Factory.ExecuteReferencePropertySet(_instance, "GlobalResourceFilters", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.OutlineCodes GlobalOutlineCodes
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.MSProjectApi.OutlineCodes>(_instance, "GlobalOutlineCodes", NetOffice.MSProjectApi.OutlineCodes.LateBindingApiWrapperType);
            }
            set
            {
                Factory.ExecuteReferencePropertySet(_instance, "GlobalOutlineCodes", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string EnterpriseListSeparator
        {
            get
            {
                return Factory.ExecuteStringPropertyGet(_instance, "EnterpriseListSeparator");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "EnterpriseListSeparator", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EnterpriseProtectActuals
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "EnterpriseProtectActuals");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "EnterpriseProtectActuals", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Windows Windows
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.MSProjectApi.Windows>(_instance, "Windows", NetOffice.MSProjectApi.Windows.LateBindingApiWrapperType);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.OfficeApi.CommandBars CommandBars
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.OfficeApi.CommandBars>(_instance, "CommandBars", NetOffice.OfficeApi.CommandBars.LateBindingApiWrapperType);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.OfficeApi.AnswerWizard AnswerWizard
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.OfficeApi.AnswerWizard>(_instance, "AnswerWizard", NetOffice.OfficeApi.AnswerWizard.LateBindingApiWrapperType);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string OperatingSystem
        {
            get
            {
                return Factory.ExecuteStringPropertyGet(_instance, "OperatingSystem");
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="userID">optional object userID</param>
        /// <param name="databasePassWord">optional object databasePassWord</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        public static string get_FileFormatID(string name, object userID, object databasePassWord)
        {
            return Factory.ExecuteStringPropertyGet(_instance, "FileFormatID", name, userID, databasePassWord);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Alias for get_FileFormatID
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="userID">optional object userID</param>
        /// <param name="databasePassWord">optional object databasePassWord</param>
        [SupportByVersion("MSProject", 11, 12, 14), Redirect("get_FileFormatID")]
        public static string FileFormatID(string name, object userID, object databasePassWord)
        {
            return get_FileFormatID(name, userID, databasePassWord);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get
        /// </summary>
        /// <param name="name">string name</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        public static string get_FileFormatID(string name)
        {
            return Factory.ExecuteStringPropertyGet(_instance, "FileFormatID", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Alias for get_FileFormatID
        /// </summary>
        /// <param name="name">string name</param>
        [SupportByVersion("MSProject", 11, 12, 14), Redirect("get_FileFormatID")]
        public static string FileFormatID(string name)
        {
            return get_FileFormatID(name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="userID">optional object userID</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        public static string get_FileFormatID(string name, object userID)
        {
            return Factory.ExecuteStringPropertyGet(_instance, "FileFormatID", name, userID);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Alias for get_FileFormatID
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="userID">optional object userID</param>
        [SupportByVersion("MSProject", 11, 12, 14), Redirect("get_FileFormatID")]
        public static string FileFormatID(string name, object userID)
        {
            return get_FileFormatID(name, userID);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="userID">optional object userID</param>
        /// <param name="databasePassWord">optional object databasePassWord</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        public static string get_FileBuildID(string name, object userID, object databasePassWord)
        {
            return Factory.ExecuteStringPropertyGet(_instance, "FileBuildID", name, userID, databasePassWord);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Alias for get_FileBuildID
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="userID">optional object userID</param>
        /// <param name="databasePassWord">optional object databasePassWord</param>
        [SupportByVersion("MSProject", 11, 12, 14), Redirect("get_FileBuildID")]
        public static string FileBuildID(string name, object userID, object databasePassWord)
        {
            return get_FileBuildID(name, userID, databasePassWord);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get
        /// </summary>
        /// <param name="name">string name</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        public static string get_FileBuildID(string name)
        {
            return Factory.ExecuteStringPropertyGet(_instance, "FileBuildID", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Alias for get_FileBuildID
        /// </summary>
        /// <param name="name">string name</param>
        [SupportByVersion("MSProject", 11, 12, 14), Redirect("get_FileBuildID")]
        public static string FileBuildID(string name)
        {
            return get_FileBuildID(name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="userID">optional object userID</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        public static string get_FileBuildID(string name, object userID)
        {
            return Factory.ExecuteStringPropertyGet(_instance, "FileBuildID", name, userID);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Alias for get_FileBuildID
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="userID">optional object userID</param>
        [SupportByVersion("MSProject", 11, 12, 14), Redirect("get_FileBuildID")]
        public static string FileBuildID(string name, object userID)
        {
            return get_FileBuildID(name, userID);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.OfficeApi.COMAddIns COMAddIns
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.OfficeApi.COMAddIns>(_instance, "COMAddIns", NetOffice.OfficeApi.COMAddIns.LateBindingApiWrapperType);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Windows2 Windows2
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.MSProjectApi.Windows2>(_instance, "Windows2", NetOffice.MSProjectApi.Windows2.LateBindingApiWrapperType);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.ReportTemplates VisualReportTemplateList
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.MSProjectApi.ReportTemplates>(_instance, "VisualReportTemplateList", NetOffice.MSProjectApi.ReportTemplates.LateBindingApiWrapperType);
            }
            set
            {
                Factory.ExecuteReferencePropertySet(_instance, "VisualReportTemplateList", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Use3DLook
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "Use3DLook");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "Use3DLook", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool UseOMIDs
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "UseOMIDs");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "UseOMIDs", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static Int32 UndoLevels
        {
            get
            {
                return Factory.ExecuteInt32PropertyGet(_instance, "UndoLevels");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "UndoLevels", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EnableChangeHighlighting
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "EnableChangeHighlighting");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "EnableChangeHighlighting", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string VisualReportsAdditionalTemplatePath
        {
            get
            {
                return Factory.ExecuteStringPropertyGet(_instance, "VisualReportsAdditionalTemplatePath");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "VisualReportsAdditionalTemplatePath", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TrustProjectServerAndWSSPages
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "TrustProjectServerAndWSSPages");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "TrustProjectServerAndWSSPages", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// Get
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.OfficeApi.IAssistance Assistance
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.OfficeApi.IAssistance>(_instance, "Assistance", NetOffice.OfficeApi.IAssistance.LateBindingApiWrapperType);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 14)]
        public static object TimescaleStart
        {
            get
            {
                return Factory.ExecuteVariantPropertyGet(_instance, "TimescaleStart");
            }
            set
            {
                Factory.ExecuteVariantPropertySet(_instance, "TimescaleStart", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 14)]
        public static object TimescaleFinish
        {
            get
            {
                return Factory.ExecuteVariantPropertyGet(_instance, "TimescaleFinish");
            }
            set
            {
                Factory.ExecuteVariantPropertySet(_instance, "TimescaleFinish", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 14)]
        public static object PanZoomStart
        {
            get
            {
                return Factory.ExecuteVariantPropertyGet(_instance, "PanZoomStart");
            }
            set
            {
                Factory.ExecuteVariantPropertySet(_instance, "PanZoomStart", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 14)]
        public static object PanZoomFinish
        {
            get
            {
                return Factory.ExecuteVariantPropertyGet(_instance, "PanZoomFinish");
            }
            set
            {
                Factory.ExecuteVariantPropertySet(_instance, "PanZoomFinish", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 14)]
        public static string Build
        {
            get
            {
                return Factory.ExecuteStringPropertyGet(_instance, "Build");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "Build", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 14)]
        public static string CompareProjectsCurrentVersionName
        {
            get
            {
                return Factory.ExecuteStringPropertyGet(_instance, "CompareProjectsCurrentVersionName");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "CompareProjectsCurrentVersionName", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 14)]
        public static string CompareProjectsPreviousVersionName
        {
            get
            {
                return Factory.ExecuteStringPropertyGet(_instance, "CompareProjectsPreviousVersionName");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "CompareProjectsPreviousVersionName", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 14
        /// Get/Set
        /// </summary>
        [SupportByVersion("MSProject", 11, 14)]
        public static bool LevelFreeformTasks
        {
            get
            {
                return Factory.ExecuteBoolPropertyGet(_instance, "LevelFreeformTasks");
            }
            set
            {
                Factory.ExecuteValuePropertySet(_instance, "LevelFreeformTasks", value);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11
        /// Get
        /// </summary>
        [SupportByVersion("MSProject", 11)]
        public static NetOffice.MSProjectApi.Reports GlobalReports
        {
            get
            {
                return Factory.ExecuteKnownReferencePropertyGet<NetOffice.MSProjectApi.Reports>(_instance, "GlobalReports", NetOffice.MSProjectApi.Reports.LateBindingApiWrapperType);
            }
        }

        /// <summary>
        /// SupportByVersion MSProject 11
        /// Get
        /// </summary>
        /// <param name="projectName">string projectName</param>
        /// <param name="projectJobType">NetOffice.MSProjectApi.Enums.PjJobType projectJobType</param>
        [SupportByVersion("MSProject", 11)]
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        public static NetOffice.MSProjectApi.Enums.PjCacheJobState get_GetCacheStatusForProject(string projectName, NetOffice.MSProjectApi.Enums.PjJobType projectJobType)
        {
            return Factory.ExecuteEnumPropertyGet<NetOffice.MSProjectApi.Enums.PjCacheJobState>(_instance, "GetCacheStatusForProject", projectName, projectJobType);
        }

        /// <summary>
        /// SupportByVersion MSProject 11
        /// Alias for get_GetCacheStatusForProject
        /// </summary>
        /// <param name="projectName">string projectName</param>
        /// <param name="projectJobType">NetOffice.MSProjectApi.Enums.PjJobType projectJobType</param>
        [SupportByVersion("MSProject", 11), Redirect("get_GetCacheStatusForProject")]
        public static NetOffice.MSProjectApi.Enums.PjCacheJobState GetCacheStatusForProject(string projectName, NetOffice.MSProjectApi.Enums.PjJobType projectJobType)
        {
            return get_GetCacheStatusForProject(projectName, projectJobType);
        }

        /// <summary>
        /// SupportByVersion MSProject 11
        /// Get
        /// </summary>
        /// <param name="projectName">string projectName</param>
        [SupportByVersion("MSProject", 11)]
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        public static bool get_IsCheckedOut(string projectName)
        {
            return Factory.ExecuteBoolPropertyGet(_instance, "IsCheckedOut", projectName);
        }

        /// <summary>
        /// SupportByVersion MSProject 11
        /// Alias for get_IsCheckedOut
        /// </summary>
        /// <param name="projectName">string projectName</param>
        [SupportByVersion("MSProject", 11), Redirect("get_IsCheckedOut")]
        public static bool IsCheckedOut(string projectName)
        {
            return get_IsCheckedOut(projectName);
        }

        #endregion

        #region Methods

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="saveChanges">optional NetOffice.MSProjectApi.Enums.PjSaveType SaveChanges = 2</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Quit(object saveChanges)
        {
            Factory.ExecuteMethod(_instance, "Quit", saveChanges);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Quit()
        {
            Factory.ExecuteMethod(_instance, "Quit");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="startDate">object startDate</param>
        /// <param name="duration">object duration</param>
        /// <param name="calendar">optional object calendar</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static object DateAdd(object startDate, object duration, object calendar)
        {
            return Factory.ExecuteVariantMethodGet(_instance, "DateAdd", startDate, duration, calendar);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="startDate">object startDate</param>
        /// <param name="duration">object duration</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static object DateAdd(object startDate, object duration)
        {
            return Factory.ExecuteVariantMethodGet(_instance, "DateAdd", startDate, duration);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="finishDate">object finishDate</param>
        /// <param name="duration">object duration</param>
        /// <param name="calendar">optional object calendar</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static object DateSubtract(object finishDate, object duration, object calendar)
        {
            return Factory.ExecuteVariantMethodGet(_instance, "DateSubtract", finishDate, duration, calendar);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="finishDate">object finishDate</param>
        /// <param name="duration">object duration</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static object DateSubtract(object finishDate, object duration)
        {
            return Factory.ExecuteVariantMethodGet(_instance, "DateSubtract", finishDate, duration);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="startDate">object startDate</param>
        /// <param name="finishDate">object finishDate</param>
        /// <param name="calendar">optional object calendar</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static object DateDifference(object startDate, object finishDate, object calendar)
        {
            return Factory.ExecuteVariantMethodGet(_instance, "DateDifference", startDate, finishDate, calendar);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="startDate">object startDate</param>
        /// <param name="finishDate">object finishDate</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static object DateDifference(object startDate, object finishDate)
        {
            return Factory.ExecuteVariantMethodGet(_instance, "DateDifference", startDate, finishDate);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="duration">object duration</param>
        /// <param name="units">optional object units</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string DurationFormat(object duration, object units)
        {
            return Factory.ExecuteStringMethodGet(_instance, "DurationFormat", duration, units);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="duration">object duration</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string DurationFormat(object duration)
        {
            return Factory.ExecuteStringMethodGet(_instance, "DurationFormat", duration);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="duration">string duration</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static object DurationValue(string duration)
        {
            return Factory.ExecuteVariantMethodGet(_instance, "DurationValue", duration);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="date">object date</param>
        /// <param name="format">optional object format</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static object DateFormat(object date, object format)
        {
            return Factory.ExecuteVariantMethodGet(_instance, "DateFormat", date, format);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="date">object date</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static object DateFormat(object date)
        {
            return Factory.ExecuteVariantMethodGet(_instance, "DateFormat", date);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="password">optional object password</param>
        /// <param name="downloadNewMail">optional object downloadNewMail</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void MailLogon(object name, object password, object downloadNewMail)
        {
            Factory.ExecuteMethod(_instance, "MailLogon", name, password, downloadNewMail);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void MailLogon()
        {
            Factory.ExecuteMethod(_instance, "MailLogon");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void MailLogon(object name)
        {
            Factory.ExecuteMethod(_instance, "MailLogon", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="password">optional object password</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void MailLogon(object name, object password)
        {
            Factory.ExecuteMethod(_instance, "MailLogon", name, password);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void MailLogoff()
        {
            Factory.ExecuteMethod(_instance, "MailLogoff");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string MailSession()
        {
            return Factory.ExecuteStringMethodGet(_instance, "MailSession");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Enums.PjMailSystem MailSystem()
        {
            return Factory.ExecuteEnumMethodGet<NetOffice.MSProjectApi.Enums.PjMailSystem>(_instance, "MailSystem");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">Int32 taskID</param>
        /// <param name="resourceID">Int32 resourceID</param>
        /// <param name="startDate">object startDate</param>
        /// <param name="endDate">object endDate</param>
        /// <param name="type">optional NetOffice.MSProjectApi.Enums.PjTimescaledData Type = 0</param>
        /// <param name="timeScaleUnit">optional NetOffice.MSProjectApi.Enums.PjTimescaleUnit TimeScaleUnit = 3</param>
        /// <param name="count">optional object count</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static object TimescaledData(Int32 taskID, Int32 resourceID, object startDate, object endDate, object type, object timeScaleUnit, object count)
        {
            return Factory.ExecuteVariantMethodGet(_instance, "TimescaledData", new object[] { taskID, resourceID, startDate, endDate, type, timeScaleUnit, count });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">Int32 taskID</param>
        /// <param name="resourceID">Int32 resourceID</param>
        /// <param name="startDate">object startDate</param>
        /// <param name="endDate">object endDate</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static object TimescaledData(Int32 taskID, Int32 resourceID, object startDate, object endDate)
        {
            return Factory.ExecuteVariantMethodGet(_instance, "TimescaledData", taskID, resourceID, startDate, endDate);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">Int32 taskID</param>
        /// <param name="resourceID">Int32 resourceID</param>
        /// <param name="startDate">object startDate</param>
        /// <param name="endDate">object endDate</param>
        /// <param name="type">optional NetOffice.MSProjectApi.Enums.PjTimescaledData Type = 0</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static object TimescaledData(Int32 taskID, Int32 resourceID, object startDate, object endDate, object type)
        {
            return Factory.ExecuteVariantMethodGet(_instance, "TimescaledData", new object[] { taskID, resourceID, startDate, endDate, type });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">Int32 taskID</param>
        /// <param name="resourceID">Int32 resourceID</param>
        /// <param name="startDate">object startDate</param>
        /// <param name="endDate">object endDate</param>
        /// <param name="type">optional NetOffice.MSProjectApi.Enums.PjTimescaledData Type = 0</param>
        /// <param name="timeScaleUnit">optional NetOffice.MSProjectApi.Enums.PjTimescaleUnit TimeScaleUnit = 3</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static object TimescaledData(Int32 taskID, Int32 resourceID, object startDate, object endDate, object type, object timeScaleUnit)
        {
            return Factory.ExecuteVariantMethodGet(_instance, "TimescaledData", new object[] { taskID, resourceID, startDate, endDate, type, timeScaleUnit });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fieldID">NetOffice.MSProjectApi.Enums.PjCustomField fieldID</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string CustomFieldGetName(NetOffice.MSProjectApi.Enums.PjCustomField fieldID)
        {
            return Factory.ExecuteStringMethodGet(_instance, "CustomFieldGetName", fieldID);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        /// <param name="arg9">optional object arg9</param>
        /// <param name="arg10">optional object arg10</param>
        /// <param name="arg11">optional object arg11</param>
        /// <param name="arg12">optional object arg12</param>
        /// <param name="arg13">optional object arg13</param>
        /// <param name="arg14">optional object arg14</param>
        /// <param name="arg15">optional object arg15</param>
        /// <param name="arg16">optional object arg16</param>
        /// <param name="arg17">optional object arg17</param>
        /// <param name="arg18">optional object arg18</param>
        /// <param name="arg19">optional object arg19</param>
        /// <param name="arg20">optional object arg20</param>
        /// <param name="arg21">optional object arg21</param>
        /// <param name="arg22">optional object arg22</param>
        /// <param name="arg23">optional object arg23</param>
        /// <param name="arg24">optional object arg24</param>
        /// <param name="arg25">optional object arg25</param>
        /// <param name="arg26">optional object arg26</param>
        /// <param name="arg27">optional object arg27</param>
        /// <param name="arg28">optional object arg28</param>
        /// <param name="arg29">optional object arg29</param>
        /// <param name="arg30">optional object arg30</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, object arg10, object arg11, object arg12, object arg13, object arg14, object arg15, object arg16, object arg17, object arg18, object arg19, object arg20, object arg21, object arg22, object arg23, object arg24, object arg25, object arg26, object arg27, object arg28, object arg29, object arg30)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23, arg24, arg25, arg26, arg27, arg28, arg29, arg30 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name)
        {
            Factory.ExecuteMethod(_instance, "Run", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1)
        {
            Factory.ExecuteMethod(_instance, "Run", name, arg1);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2)
        {
            Factory.ExecuteMethod(_instance, "Run", name, arg1, arg2);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3)
        {
            Factory.ExecuteMethod(_instance, "Run", name, arg1, arg2, arg3);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        /// <param name="arg9">optional object arg9</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        /// <param name="arg9">optional object arg9</param>
        /// <param name="arg10">optional object arg10</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, object arg10)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        /// <param name="arg9">optional object arg9</param>
        /// <param name="arg10">optional object arg10</param>
        /// <param name="arg11">optional object arg11</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, object arg10, object arg11)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        /// <param name="arg9">optional object arg9</param>
        /// <param name="arg10">optional object arg10</param>
        /// <param name="arg11">optional object arg11</param>
        /// <param name="arg12">optional object arg12</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, object arg10, object arg11, object arg12)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        /// <param name="arg9">optional object arg9</param>
        /// <param name="arg10">optional object arg10</param>
        /// <param name="arg11">optional object arg11</param>
        /// <param name="arg12">optional object arg12</param>
        /// <param name="arg13">optional object arg13</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, object arg10, object arg11, object arg12, object arg13)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        /// <param name="arg9">optional object arg9</param>
        /// <param name="arg10">optional object arg10</param>
        /// <param name="arg11">optional object arg11</param>
        /// <param name="arg12">optional object arg12</param>
        /// <param name="arg13">optional object arg13</param>
        /// <param name="arg14">optional object arg14</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, object arg10, object arg11, object arg12, object arg13, object arg14)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        /// <param name="arg9">optional object arg9</param>
        /// <param name="arg10">optional object arg10</param>
        /// <param name="arg11">optional object arg11</param>
        /// <param name="arg12">optional object arg12</param>
        /// <param name="arg13">optional object arg13</param>
        /// <param name="arg14">optional object arg14</param>
        /// <param name="arg15">optional object arg15</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, object arg10, object arg11, object arg12, object arg13, object arg14, object arg15)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        /// <param name="arg9">optional object arg9</param>
        /// <param name="arg10">optional object arg10</param>
        /// <param name="arg11">optional object arg11</param>
        /// <param name="arg12">optional object arg12</param>
        /// <param name="arg13">optional object arg13</param>
        /// <param name="arg14">optional object arg14</param>
        /// <param name="arg15">optional object arg15</param>
        /// <param name="arg16">optional object arg16</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, object arg10, object arg11, object arg12, object arg13, object arg14, object arg15, object arg16)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        /// <param name="arg9">optional object arg9</param>
        /// <param name="arg10">optional object arg10</param>
        /// <param name="arg11">optional object arg11</param>
        /// <param name="arg12">optional object arg12</param>
        /// <param name="arg13">optional object arg13</param>
        /// <param name="arg14">optional object arg14</param>
        /// <param name="arg15">optional object arg15</param>
        /// <param name="arg16">optional object arg16</param>
        /// <param name="arg17">optional object arg17</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, object arg10, object arg11, object arg12, object arg13, object arg14, object arg15, object arg16, object arg17)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        /// <param name="arg9">optional object arg9</param>
        /// <param name="arg10">optional object arg10</param>
        /// <param name="arg11">optional object arg11</param>
        /// <param name="arg12">optional object arg12</param>
        /// <param name="arg13">optional object arg13</param>
        /// <param name="arg14">optional object arg14</param>
        /// <param name="arg15">optional object arg15</param>
        /// <param name="arg16">optional object arg16</param>
        /// <param name="arg17">optional object arg17</param>
        /// <param name="arg18">optional object arg18</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, object arg10, object arg11, object arg12, object arg13, object arg14, object arg15, object arg16, object arg17, object arg18)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        /// <param name="arg9">optional object arg9</param>
        /// <param name="arg10">optional object arg10</param>
        /// <param name="arg11">optional object arg11</param>
        /// <param name="arg12">optional object arg12</param>
        /// <param name="arg13">optional object arg13</param>
        /// <param name="arg14">optional object arg14</param>
        /// <param name="arg15">optional object arg15</param>
        /// <param name="arg16">optional object arg16</param>
        /// <param name="arg17">optional object arg17</param>
        /// <param name="arg18">optional object arg18</param>
        /// <param name="arg19">optional object arg19</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, object arg10, object arg11, object arg12, object arg13, object arg14, object arg15, object arg16, object arg17, object arg18, object arg19)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        /// <param name="arg9">optional object arg9</param>
        /// <param name="arg10">optional object arg10</param>
        /// <param name="arg11">optional object arg11</param>
        /// <param name="arg12">optional object arg12</param>
        /// <param name="arg13">optional object arg13</param>
        /// <param name="arg14">optional object arg14</param>
        /// <param name="arg15">optional object arg15</param>
        /// <param name="arg16">optional object arg16</param>
        /// <param name="arg17">optional object arg17</param>
        /// <param name="arg18">optional object arg18</param>
        /// <param name="arg19">optional object arg19</param>
        /// <param name="arg20">optional object arg20</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, object arg10, object arg11, object arg12, object arg13, object arg14, object arg15, object arg16, object arg17, object arg18, object arg19, object arg20)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        /// <param name="arg9">optional object arg9</param>
        /// <param name="arg10">optional object arg10</param>
        /// <param name="arg11">optional object arg11</param>
        /// <param name="arg12">optional object arg12</param>
        /// <param name="arg13">optional object arg13</param>
        /// <param name="arg14">optional object arg14</param>
        /// <param name="arg15">optional object arg15</param>
        /// <param name="arg16">optional object arg16</param>
        /// <param name="arg17">optional object arg17</param>
        /// <param name="arg18">optional object arg18</param>
        /// <param name="arg19">optional object arg19</param>
        /// <param name="arg20">optional object arg20</param>
        /// <param name="arg21">optional object arg21</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, object arg10, object arg11, object arg12, object arg13, object arg14, object arg15, object arg16, object arg17, object arg18, object arg19, object arg20, object arg21)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        /// <param name="arg9">optional object arg9</param>
        /// <param name="arg10">optional object arg10</param>
        /// <param name="arg11">optional object arg11</param>
        /// <param name="arg12">optional object arg12</param>
        /// <param name="arg13">optional object arg13</param>
        /// <param name="arg14">optional object arg14</param>
        /// <param name="arg15">optional object arg15</param>
        /// <param name="arg16">optional object arg16</param>
        /// <param name="arg17">optional object arg17</param>
        /// <param name="arg18">optional object arg18</param>
        /// <param name="arg19">optional object arg19</param>
        /// <param name="arg20">optional object arg20</param>
        /// <param name="arg21">optional object arg21</param>
        /// <param name="arg22">optional object arg22</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, object arg10, object arg11, object arg12, object arg13, object arg14, object arg15, object arg16, object arg17, object arg18, object arg19, object arg20, object arg21, object arg22)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        /// <param name="arg9">optional object arg9</param>
        /// <param name="arg10">optional object arg10</param>
        /// <param name="arg11">optional object arg11</param>
        /// <param name="arg12">optional object arg12</param>
        /// <param name="arg13">optional object arg13</param>
        /// <param name="arg14">optional object arg14</param>
        /// <param name="arg15">optional object arg15</param>
        /// <param name="arg16">optional object arg16</param>
        /// <param name="arg17">optional object arg17</param>
        /// <param name="arg18">optional object arg18</param>
        /// <param name="arg19">optional object arg19</param>
        /// <param name="arg20">optional object arg20</param>
        /// <param name="arg21">optional object arg21</param>
        /// <param name="arg22">optional object arg22</param>
        /// <param name="arg23">optional object arg23</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, object arg10, object arg11, object arg12, object arg13, object arg14, object arg15, object arg16, object arg17, object arg18, object arg19, object arg20, object arg21, object arg22, object arg23)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        /// <param name="arg9">optional object arg9</param>
        /// <param name="arg10">optional object arg10</param>
        /// <param name="arg11">optional object arg11</param>
        /// <param name="arg12">optional object arg12</param>
        /// <param name="arg13">optional object arg13</param>
        /// <param name="arg14">optional object arg14</param>
        /// <param name="arg15">optional object arg15</param>
        /// <param name="arg16">optional object arg16</param>
        /// <param name="arg17">optional object arg17</param>
        /// <param name="arg18">optional object arg18</param>
        /// <param name="arg19">optional object arg19</param>
        /// <param name="arg20">optional object arg20</param>
        /// <param name="arg21">optional object arg21</param>
        /// <param name="arg22">optional object arg22</param>
        /// <param name="arg23">optional object arg23</param>
        /// <param name="arg24">optional object arg24</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, object arg10, object arg11, object arg12, object arg13, object arg14, object arg15, object arg16, object arg17, object arg18, object arg19, object arg20, object arg21, object arg22, object arg23, object arg24)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23, arg24 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        /// <param name="arg9">optional object arg9</param>
        /// <param name="arg10">optional object arg10</param>
        /// <param name="arg11">optional object arg11</param>
        /// <param name="arg12">optional object arg12</param>
        /// <param name="arg13">optional object arg13</param>
        /// <param name="arg14">optional object arg14</param>
        /// <param name="arg15">optional object arg15</param>
        /// <param name="arg16">optional object arg16</param>
        /// <param name="arg17">optional object arg17</param>
        /// <param name="arg18">optional object arg18</param>
        /// <param name="arg19">optional object arg19</param>
        /// <param name="arg20">optional object arg20</param>
        /// <param name="arg21">optional object arg21</param>
        /// <param name="arg22">optional object arg22</param>
        /// <param name="arg23">optional object arg23</param>
        /// <param name="arg24">optional object arg24</param>
        /// <param name="arg25">optional object arg25</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, object arg10, object arg11, object arg12, object arg13, object arg14, object arg15, object arg16, object arg17, object arg18, object arg19, object arg20, object arg21, object arg22, object arg23, object arg24, object arg25)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23, arg24, arg25 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        /// <param name="arg9">optional object arg9</param>
        /// <param name="arg10">optional object arg10</param>
        /// <param name="arg11">optional object arg11</param>
        /// <param name="arg12">optional object arg12</param>
        /// <param name="arg13">optional object arg13</param>
        /// <param name="arg14">optional object arg14</param>
        /// <param name="arg15">optional object arg15</param>
        /// <param name="arg16">optional object arg16</param>
        /// <param name="arg17">optional object arg17</param>
        /// <param name="arg18">optional object arg18</param>
        /// <param name="arg19">optional object arg19</param>
        /// <param name="arg20">optional object arg20</param>
        /// <param name="arg21">optional object arg21</param>
        /// <param name="arg22">optional object arg22</param>
        /// <param name="arg23">optional object arg23</param>
        /// <param name="arg24">optional object arg24</param>
        /// <param name="arg25">optional object arg25</param>
        /// <param name="arg26">optional object arg26</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, object arg10, object arg11, object arg12, object arg13, object arg14, object arg15, object arg16, object arg17, object arg18, object arg19, object arg20, object arg21, object arg22, object arg23, object arg24, object arg25, object arg26)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23, arg24, arg25, arg26 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        /// <param name="arg9">optional object arg9</param>
        /// <param name="arg10">optional object arg10</param>
        /// <param name="arg11">optional object arg11</param>
        /// <param name="arg12">optional object arg12</param>
        /// <param name="arg13">optional object arg13</param>
        /// <param name="arg14">optional object arg14</param>
        /// <param name="arg15">optional object arg15</param>
        /// <param name="arg16">optional object arg16</param>
        /// <param name="arg17">optional object arg17</param>
        /// <param name="arg18">optional object arg18</param>
        /// <param name="arg19">optional object arg19</param>
        /// <param name="arg20">optional object arg20</param>
        /// <param name="arg21">optional object arg21</param>
        /// <param name="arg22">optional object arg22</param>
        /// <param name="arg23">optional object arg23</param>
        /// <param name="arg24">optional object arg24</param>
        /// <param name="arg25">optional object arg25</param>
        /// <param name="arg26">optional object arg26</param>
        /// <param name="arg27">optional object arg27</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, object arg10, object arg11, object arg12, object arg13, object arg14, object arg15, object arg16, object arg17, object arg18, object arg19, object arg20, object arg21, object arg22, object arg23, object arg24, object arg25, object arg26, object arg27)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23, arg24, arg25, arg26, arg27 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        /// <param name="arg9">optional object arg9</param>
        /// <param name="arg10">optional object arg10</param>
        /// <param name="arg11">optional object arg11</param>
        /// <param name="arg12">optional object arg12</param>
        /// <param name="arg13">optional object arg13</param>
        /// <param name="arg14">optional object arg14</param>
        /// <param name="arg15">optional object arg15</param>
        /// <param name="arg16">optional object arg16</param>
        /// <param name="arg17">optional object arg17</param>
        /// <param name="arg18">optional object arg18</param>
        /// <param name="arg19">optional object arg19</param>
        /// <param name="arg20">optional object arg20</param>
        /// <param name="arg21">optional object arg21</param>
        /// <param name="arg22">optional object arg22</param>
        /// <param name="arg23">optional object arg23</param>
        /// <param name="arg24">optional object arg24</param>
        /// <param name="arg25">optional object arg25</param>
        /// <param name="arg26">optional object arg26</param>
        /// <param name="arg27">optional object arg27</param>
        /// <param name="arg28">optional object arg28</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, object arg10, object arg11, object arg12, object arg13, object arg14, object arg15, object arg16, object arg17, object arg18, object arg19, object arg20, object arg21, object arg22, object arg23, object arg24, object arg25, object arg26, object arg27, object arg28)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23, arg24, arg25, arg26, arg27, arg28 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="arg1">optional object arg1</param>
        /// <param name="arg2">optional object arg2</param>
        /// <param name="arg3">optional object arg3</param>
        /// <param name="arg4">optional object arg4</param>
        /// <param name="arg5">optional object arg5</param>
        /// <param name="arg6">optional object arg6</param>
        /// <param name="arg7">optional object arg7</param>
        /// <param name="arg8">optional object arg8</param>
        /// <param name="arg9">optional object arg9</param>
        /// <param name="arg10">optional object arg10</param>
        /// <param name="arg11">optional object arg11</param>
        /// <param name="arg12">optional object arg12</param>
        /// <param name="arg13">optional object arg13</param>
        /// <param name="arg14">optional object arg14</param>
        /// <param name="arg15">optional object arg15</param>
        /// <param name="arg16">optional object arg16</param>
        /// <param name="arg17">optional object arg17</param>
        /// <param name="arg18">optional object arg18</param>
        /// <param name="arg19">optional object arg19</param>
        /// <param name="arg20">optional object arg20</param>
        /// <param name="arg21">optional object arg21</param>
        /// <param name="arg22">optional object arg22</param>
        /// <param name="arg23">optional object arg23</param>
        /// <param name="arg24">optional object arg24</param>
        /// <param name="arg25">optional object arg25</param>
        /// <param name="arg26">optional object arg26</param>
        /// <param name="arg27">optional object arg27</param>
        /// <param name="arg28">optional object arg28</param>
        /// <param name="arg29">optional object arg29</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void Run(string name, object arg1, object arg2, object arg3, object arg4, object arg5, object arg6, object arg7, object arg8, object arg9, object arg10, object arg11, object arg12, object arg13, object arg14, object arg15, object arg16, object arg17, object arg18, object arg19, object arg20, object arg21, object arg22, object arg23, object arg24, object arg25, object arg26, object arg27, object arg28, object arg29)
        {
            Factory.ExecuteMethod(_instance, "Run", new object[] { name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23, arg24, arg25, arg26, arg27, arg28, arg29 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="index">NetOffice.MSProjectApi.Enums.PjMSApplication index</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void ActivateMicrosoftApp(NetOffice.MSProjectApi.Enums.PjMSApplication index)
        {
            Factory.ExecuteMethod(_instance, "ActivateMicrosoftApp", index);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">Int32 taskID</param>
        /// <param name="projectName">optional object projectName</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static Int32 BoxGetXPosition(Int32 taskID, object projectName)
        {
            return Factory.ExecuteInt32MethodGet(_instance, "BoxGetXPosition", taskID, projectName);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">Int32 taskID</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static Int32 BoxGetXPosition(Int32 taskID)
        {
            return Factory.ExecuteInt32MethodGet(_instance, "BoxGetXPosition", taskID);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">Int32 taskID</param>
        /// <param name="projectName">optional object projectName</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static Int32 BoxGetYPosition(Int32 taskID, object projectName)
        {
            return Factory.ExecuteInt32MethodGet(_instance, "BoxGetYPosition", taskID, projectName);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">Int32 taskID</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static Int32 BoxGetYPosition(Int32 taskID)
        {
            return Factory.ExecuteInt32MethodGet(_instance, "BoxGetYPosition", taskID);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fieldID">NetOffice.MSProjectApi.Enums.PjCustomField fieldID</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string CustomFieldGetFormula(NetOffice.MSProjectApi.Enums.PjCustomField fieldID)
        {
            return Factory.ExecuteStringMethodGet(_instance, "CustomFieldGetFormula", fieldID);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fieldID">NetOffice.MSProjectApi.Enums.PjCustomField fieldID</param>
        /// <param name="item">NetOffice.MSProjectApi.Enums.PjValueListItem item</param>
        /// <param name="index">Int32 index</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string CustomFieldValueListGetItem(NetOffice.MSProjectApi.Enums.PjCustomField fieldID, NetOffice.MSProjectApi.Enums.PjValueListItem item, Int32 index)
        {
            return Factory.ExecuteStringMethodGet(_instance, "CustomFieldValueListGetItem", fieldID, item, index);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="goalArea">Int32 goalArea</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void GoalAreaHighlight(Int32 goalArea)
        {
            Factory.ExecuteMethod(_instance, "GoalAreaHighlight", goalArea);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="displayState">bool displayState</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void SetSidepaneStateButton(bool displayState)
        {
            Factory.ExecuteMethod(_instance, "SetSidepaneStateButton", displayState);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">Int32 taskID</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void GoalAreaTaskHighlight(Int32 taskID)
        {
            Factory.ExecuteMethod(_instance, "GoalAreaTaskHighlight", taskID);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fieldName">string fieldName</param>
        /// <param name="fieldType">optional NetOffice.MSProjectApi.Enums.PjFieldType FieldType = 0</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Enums.PjField FieldNameToFieldConstant(string fieldName, object fieldType)
        {
            return Factory.ExecuteEnumMethodGet<NetOffice.MSProjectApi.Enums.PjField>(_instance, "FieldNameToFieldConstant", fieldName, fieldType);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fieldName">string fieldName</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Enums.PjField FieldNameToFieldConstant(string fieldName)
        {
            return Factory.ExecuteEnumMethodGet<NetOffice.MSProjectApi.Enums.PjField>(_instance, "FieldNameToFieldConstant", fieldName);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">NetOffice.MSProjectApi.Enums.PjField field</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string FieldConstantToFieldName(NetOffice.MSProjectApi.Enums.PjField field)
        {
            return Factory.ExecuteStringMethodGet(_instance, "FieldConstantToFieldName", field);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="requestXML">string requestXML</param>
        /// <param name="project">optional object project</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string GetProjectServerSettings(string requestXML, object project)
        {
            return Factory.ExecuteStringMethodGet(_instance, "GetProjectServerSettings", requestXML, project);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="requestXML">string requestXML</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static string GetProjectServerSettings(string requestXML)
        {
            return Factory.ExecuteStringMethodGet(_instance, "GetProjectServerSettings", requestXML);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="window">optional object window</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void UnloadWebBrowserControl(object window)
        {
            Factory.ExecuteMethod(_instance, "UnloadWebBrowserControl", window);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void UnloadWebBrowserControl()
        {
            Factory.ExecuteMethod(_instance, "UnloadWebBrowserControl");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="xML">string xML</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static Int32 OpenXML(string xML)
        {
            return Factory.ExecuteInt32MethodGet(_instance, "OpenXML", xML);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="serverURL">string serverURL</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static NetOffice.MSProjectApi.Enums.PjServerVersionInfo GetProjectServerVersion(string serverURL)
        {
            return Factory.ExecuteEnumMethodGet<NetOffice.MSProjectApi.Enums.PjServerVersionInfo>(_instance, "GetProjectServerVersion", serverURL);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="dataFile">string dataFile</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static object UpdateFromProjectServer(string dataFile)
        {
            return Factory.ExecuteVariantMethodGet(_instance, "UpdateFromProjectServer", dataFile);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static Int32 LocaleID()
        {
            return Factory.ExecuteInt32MethodGet(_instance, "LocaleID");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void EnterpriseMakeServerURLTrusted()
        {
            Factory.ExecuteMethod(_instance, "EnterpriseMakeServerURLTrusted");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="uRL">string uRL</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool IsURLTrusted(string uRL)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "IsURLTrusted", uRL);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="showDialog">optional bool ShowDialog = false</param>
        /// <param name="itemsScope">optional NetOffice.MSProjectApi.Enums.PjPublishScope ItemsScope = 1</param>
        /// <param name="notifyResources">optional bool NotifyResources = true</param>
        /// <param name="notificationText">optional object notificationText</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void PublishNewAndChangedAssignments(object showDialog, object itemsScope, object notifyResources, object notificationText)
        {
            Factory.ExecuteMethod(_instance, "PublishNewAndChangedAssignments", showDialog, itemsScope, notifyResources, notificationText);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void PublishNewAndChangedAssignments()
        {
            Factory.ExecuteMethod(_instance, "PublishNewAndChangedAssignments");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="showDialog">optional bool ShowDialog = false</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void PublishNewAndChangedAssignments(object showDialog)
        {
            Factory.ExecuteMethod(_instance, "PublishNewAndChangedAssignments", showDialog);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="showDialog">optional bool ShowDialog = false</param>
        /// <param name="itemsScope">optional NetOffice.MSProjectApi.Enums.PjPublishScope ItemsScope = 1</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void PublishNewAndChangedAssignments(object showDialog, object itemsScope)
        {
            Factory.ExecuteMethod(_instance, "PublishNewAndChangedAssignments", showDialog, itemsScope);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="showDialog">optional bool ShowDialog = false</param>
        /// <param name="itemsScope">optional NetOffice.MSProjectApi.Enums.PjPublishScope ItemsScope = 1</param>
        /// <param name="notifyResources">optional bool NotifyResources = true</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void PublishNewAndChangedAssignments(object showDialog, object itemsScope, object notifyResources)
        {
            Factory.ExecuteMethod(_instance, "PublishNewAndChangedAssignments", showDialog, itemsScope, notifyResources);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="showDialog">optional bool ShowDialog = false</param>
        /// <param name="publishFullPlan">optional bool PublishFullPlan = true</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void PublishProjectPlan(object showDialog, object publishFullPlan)
        {
            Factory.ExecuteMethod(_instance, "PublishProjectPlan", showDialog, publishFullPlan);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void PublishProjectPlan()
        {
            Factory.ExecuteMethod(_instance, "PublishProjectPlan");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="showDialog">optional bool ShowDialog = false</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void PublishProjectPlan(object showDialog)
        {
            Factory.ExecuteMethod(_instance, "PublishProjectPlan", showDialog);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void PublishAllInformation()
        {
            Factory.ExecuteMethod(_instance, "PublishAllInformation");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="showDialog">optional bool ShowDialog = false</param>
        /// <param name="itemsScope">optional NetOffice.MSProjectApi.Enums.PjPublishScope ItemsScope = 1</param>
        /// <param name="notifyTaskLead">optional bool NotifyTaskLead = false</param>
        /// <param name="notificationText">optional object notificationText</param>
        /// <param name="reportingPeriodFrom">optional object reportingPeriodFrom</param>
        /// <param name="reportingPeriodTo">optional object reportingPeriodTo</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void RequestProgressInformation(object showDialog, object itemsScope, object notifyTaskLead, object notificationText, object reportingPeriodFrom, object reportingPeriodTo)
        {
            Factory.ExecuteMethod(_instance, "RequestProgressInformation", new object[] { showDialog, itemsScope, notifyTaskLead, notificationText, reportingPeriodFrom, reportingPeriodTo });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void RequestProgressInformation()
        {
            Factory.ExecuteMethod(_instance, "RequestProgressInformation");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="showDialog">optional bool ShowDialog = false</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void RequestProgressInformation(object showDialog)
        {
            Factory.ExecuteMethod(_instance, "RequestProgressInformation", showDialog);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="showDialog">optional bool ShowDialog = false</param>
        /// <param name="itemsScope">optional NetOffice.MSProjectApi.Enums.PjPublishScope ItemsScope = 1</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void RequestProgressInformation(object showDialog, object itemsScope)
        {
            Factory.ExecuteMethod(_instance, "RequestProgressInformation", showDialog, itemsScope);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="showDialog">optional bool ShowDialog = false</param>
        /// <param name="itemsScope">optional NetOffice.MSProjectApi.Enums.PjPublishScope ItemsScope = 1</param>
        /// <param name="notifyTaskLead">optional bool NotifyTaskLead = false</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void RequestProgressInformation(object showDialog, object itemsScope, object notifyTaskLead)
        {
            Factory.ExecuteMethod(_instance, "RequestProgressInformation", showDialog, itemsScope, notifyTaskLead);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="showDialog">optional bool ShowDialog = false</param>
        /// <param name="itemsScope">optional NetOffice.MSProjectApi.Enums.PjPublishScope ItemsScope = 1</param>
        /// <param name="notifyTaskLead">optional bool NotifyTaskLead = false</param>
        /// <param name="notificationText">optional object notificationText</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void RequestProgressInformation(object showDialog, object itemsScope, object notifyTaskLead, object notificationText)
        {
            Factory.ExecuteMethod(_instance, "RequestProgressInformation", showDialog, itemsScope, notifyTaskLead, notificationText);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="showDialog">optional bool ShowDialog = false</param>
        /// <param name="itemsScope">optional NetOffice.MSProjectApi.Enums.PjPublishScope ItemsScope = 1</param>
        /// <param name="notifyTaskLead">optional bool NotifyTaskLead = false</param>
        /// <param name="notificationText">optional object notificationText</param>
        /// <param name="reportingPeriodFrom">optional object reportingPeriodFrom</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void RequestProgressInformation(object showDialog, object itemsScope, object notifyTaskLead, object notificationText, object reportingPeriodFrom)
        {
            Factory.ExecuteMethod(_instance, "RequestProgressInformation", new object[] { showDialog, itemsScope, notifyTaskLead, notificationText, reportingPeriodFrom });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="showDialog">optional bool ShowDialog = false</param>
        /// <param name="itemsScope">optional NetOffice.MSProjectApi.Enums.PjPublishScope ItemsScope = 1</param>
        /// <param name="notifyResources">optional bool NotifyResources = true</param>
        /// <param name="overwriteActuals">optional bool OverwriteActuals = false</param>
        /// <param name="becomeManager">optional bool BecomeManager = false</param>
        /// <param name="notificationText">optional object notificationText</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void RepublishAssignments(object showDialog, object itemsScope, object notifyResources, object overwriteActuals, object becomeManager, object notificationText)
        {
            Factory.ExecuteMethod(_instance, "RepublishAssignments", new object[] { showDialog, itemsScope, notifyResources, overwriteActuals, becomeManager, notificationText });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void RepublishAssignments()
        {
            Factory.ExecuteMethod(_instance, "RepublishAssignments");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="showDialog">optional bool ShowDialog = false</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void RepublishAssignments(object showDialog)
        {
            Factory.ExecuteMethod(_instance, "RepublishAssignments", showDialog);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="showDialog">optional bool ShowDialog = false</param>
        /// <param name="itemsScope">optional NetOffice.MSProjectApi.Enums.PjPublishScope ItemsScope = 1</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void RepublishAssignments(object showDialog, object itemsScope)
        {
            Factory.ExecuteMethod(_instance, "RepublishAssignments", showDialog, itemsScope);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="showDialog">optional bool ShowDialog = false</param>
        /// <param name="itemsScope">optional NetOffice.MSProjectApi.Enums.PjPublishScope ItemsScope = 1</param>
        /// <param name="notifyResources">optional bool NotifyResources = true</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void RepublishAssignments(object showDialog, object itemsScope, object notifyResources)
        {
            Factory.ExecuteMethod(_instance, "RepublishAssignments", showDialog, itemsScope, notifyResources);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="showDialog">optional bool ShowDialog = false</param>
        /// <param name="itemsScope">optional NetOffice.MSProjectApi.Enums.PjPublishScope ItemsScope = 1</param>
        /// <param name="notifyResources">optional bool NotifyResources = true</param>
        /// <param name="overwriteActuals">optional bool OverwriteActuals = false</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void RepublishAssignments(object showDialog, object itemsScope, object notifyResources, object overwriteActuals)
        {
            Factory.ExecuteMethod(_instance, "RepublishAssignments", showDialog, itemsScope, notifyResources, overwriteActuals);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="showDialog">optional bool ShowDialog = false</param>
        /// <param name="itemsScope">optional NetOffice.MSProjectApi.Enums.PjPublishScope ItemsScope = 1</param>
        /// <param name="notifyResources">optional bool NotifyResources = true</param>
        /// <param name="overwriteActuals">optional bool OverwriteActuals = false</param>
        /// <param name="becomeManager">optional bool BecomeManager = false</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void RepublishAssignments(object showDialog, object itemsScope, object notifyResources, object overwriteActuals, object becomeManager)
        {
            Factory.ExecuteMethod(_instance, "RepublishAssignments", new object[] { showDialog, itemsScope, notifyResources, overwriteActuals, becomeManager });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="waitForCompletion">bool waitForCompletion</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static Int32 RegisterProject(bool waitForCompletion)
        {
            return Factory.ExecuteInt32MethodGet(_instance, "RegisterProject", waitForCompletion);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="alertText">string alertText</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SaveProjectIfDirty(string alertText)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SaveProjectIfDirty", alertText);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool IsOfficeTaskPaneVisible()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "IsOfficeTaskPaneVisible");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static void OfficeTaskPaneHide()
        {
            Factory.ExecuteMethod(_instance, "OfficeTaskPaneHide");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static Int32 GetCurrentTheme()
        {
            return Factory.ExecuteInt32MethodGet(_instance, "GetCurrentTheme");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="message">string message</param>
        /// <param name="type">optional NetOffice.MSProjectApi.Enums.PjMessageType Type = 0</param>
        /// <param name="yesText">optional object yesText</param>
        /// <param name="noText">optional object noText</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Message(string message, object type, object yesText, object noText)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Message", message, type, yesText, noText);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="message">string message</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Message(string message)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Message", message);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="message">string message</param>
        /// <param name="type">optional NetOffice.MSProjectApi.Enums.PjMessageType Type = 0</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Message(string message, object type)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Message", message, type);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="message">string message</param>
        /// <param name="type">optional NetOffice.MSProjectApi.Enums.PjMessageType Type = 0</param>
        /// <param name="yesText">optional object yesText</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Message(string message, object type, object yesText)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Message", message, type, yesText);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="show">optional object show</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Alerts(object show)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Alerts", show);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Alerts()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Alerts");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="summaryInfo">optional object summaryInfo</param>
        /// <param name="template">optional object template</param>
        /// <param name="fileNewDialog">optional object fileNewDialog</param>
        /// <param name="fileNewWorkpane">optional object fileNewWorkpane</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileNew(object summaryInfo, object template, object fileNewDialog, object fileNewWorkpane)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileNew", summaryInfo, template, fileNewDialog, fileNewWorkpane);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileNew()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileNew");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="summaryInfo">optional object summaryInfo</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileNew(object summaryInfo)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileNew", summaryInfo);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="summaryInfo">optional object summaryInfo</param>
        /// <param name="template">optional object template</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileNew(object summaryInfo, object template)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileNew", summaryInfo, template);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="summaryInfo">optional object summaryInfo</param>
        /// <param name="template">optional object template</param>
        /// <param name="fileNewDialog">optional object fileNewDialog</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileNew(object summaryInfo, object template, object fileNewDialog)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileNew", summaryInfo, template, fileNewDialog);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileProperties()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileProperties");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="readOnly">object readOnly</param>
        /// <param name="merge">object merge</param>
        /// <param name="taskInformation">object taskInformation</param>
        /// <param name="table">object table</param>
        /// <param name="sheet">object sheet</param>
        /// <param name="noAuto">object noAuto</param>
        /// <param name="userID">object userID</param>
        /// <param name="databasePassWord">object databasePassWord</param>
        /// <param name="formatID">object formatID</param>
        /// <param name="map">object map</param>
        /// <param name="openPool">optional NetOffice.MSProjectApi.Enums.PjPoolOpen openPool = 0</param>
        /// <param name="password">optional object password</param>
        /// <param name="writeResPassword">optional object writeResPassword</param>
        /// <param name="ignoreReadOnlyRecommended">optional object ignoreReadOnlyRecommended</param>
        /// <param name="xMLName">optional object xMLName</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileOpen(object name, object readOnly, object merge, object taskInformation, object table, object sheet, object noAuto, object userID, object databasePassWord, object formatID, object map, object openPool, object password, object writeResPassword, object ignoreReadOnlyRecommended, object xMLName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileOpen", new object[] { name, readOnly, merge, taskInformation, table, sheet, noAuto, userID, databasePassWord, formatID, map, openPool, password, writeResPassword, ignoreReadOnlyRecommended, xMLName });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="readOnly">object readOnly</param>
        /// <param name="merge">object merge</param>
        /// <param name="taskInformation">object taskInformation</param>
        /// <param name="table">object table</param>
        /// <param name="sheet">object sheet</param>
        /// <param name="noAuto">object noAuto</param>
        /// <param name="userID">object userID</param>
        /// <param name="databasePassWord">object databasePassWord</param>
        /// <param name="formatID">object formatID</param>
        /// <param name="map">object map</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileOpen(object name, object readOnly, object merge, object taskInformation, object table, object sheet, object noAuto, object userID, object databasePassWord, object formatID, object map)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileOpen", new object[] { name, readOnly, merge, taskInformation, table, sheet, noAuto, userID, databasePassWord, formatID, map });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="readOnly">object readOnly</param>
        /// <param name="merge">object merge</param>
        /// <param name="taskInformation">object taskInformation</param>
        /// <param name="table">object table</param>
        /// <param name="sheet">object sheet</param>
        /// <param name="noAuto">object noAuto</param>
        /// <param name="userID">object userID</param>
        /// <param name="databasePassWord">object databasePassWord</param>
        /// <param name="formatID">object formatID</param>
        /// <param name="map">object map</param>
        /// <param name="openPool">optional NetOffice.MSProjectApi.Enums.PjPoolOpen openPool = 0</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileOpen(object name, object readOnly, object merge, object taskInformation, object table, object sheet, object noAuto, object userID, object databasePassWord, object formatID, object map, object openPool)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileOpen", new object[] { name, readOnly, merge, taskInformation, table, sheet, noAuto, userID, databasePassWord, formatID, map, openPool });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="readOnly">object readOnly</param>
        /// <param name="merge">object merge</param>
        /// <param name="taskInformation">object taskInformation</param>
        /// <param name="table">object table</param>
        /// <param name="sheet">object sheet</param>
        /// <param name="noAuto">object noAuto</param>
        /// <param name="userID">object userID</param>
        /// <param name="databasePassWord">object databasePassWord</param>
        /// <param name="formatID">object formatID</param>
        /// <param name="map">object map</param>
        /// <param name="openPool">optional NetOffice.MSProjectApi.Enums.PjPoolOpen openPool = 0</param>
        /// <param name="password">optional object password</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileOpen(object name, object readOnly, object merge, object taskInformation, object table, object sheet, object noAuto, object userID, object databasePassWord, object formatID, object map, object openPool, object password)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileOpen", new object[] { name, readOnly, merge, taskInformation, table, sheet, noAuto, userID, databasePassWord, formatID, map, openPool, password });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="readOnly">object readOnly</param>
        /// <param name="merge">object merge</param>
        /// <param name="taskInformation">object taskInformation</param>
        /// <param name="table">object table</param>
        /// <param name="sheet">object sheet</param>
        /// <param name="noAuto">object noAuto</param>
        /// <param name="userID">object userID</param>
        /// <param name="databasePassWord">object databasePassWord</param>
        /// <param name="formatID">object formatID</param>
        /// <param name="map">object map</param>
        /// <param name="openPool">optional NetOffice.MSProjectApi.Enums.PjPoolOpen openPool = 0</param>
        /// <param name="password">optional object password</param>
        /// <param name="writeResPassword">optional object writeResPassword</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileOpen(object name, object readOnly, object merge, object taskInformation, object table, object sheet, object noAuto, object userID, object databasePassWord, object formatID, object map, object openPool, object password, object writeResPassword)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileOpen", new object[] { name, readOnly, merge, taskInformation, table, sheet, noAuto, userID, databasePassWord, formatID, map, openPool, password, writeResPassword });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="readOnly">object readOnly</param>
        /// <param name="merge">object merge</param>
        /// <param name="taskInformation">object taskInformation</param>
        /// <param name="table">object table</param>
        /// <param name="sheet">object sheet</param>
        /// <param name="noAuto">object noAuto</param>
        /// <param name="userID">object userID</param>
        /// <param name="databasePassWord">object databasePassWord</param>
        /// <param name="formatID">object formatID</param>
        /// <param name="map">object map</param>
        /// <param name="openPool">optional NetOffice.MSProjectApi.Enums.PjPoolOpen openPool = 0</param>
        /// <param name="password">optional object password</param>
        /// <param name="writeResPassword">optional object writeResPassword</param>
        /// <param name="ignoreReadOnlyRecommended">optional object ignoreReadOnlyRecommended</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileOpen(object name, object readOnly, object merge, object taskInformation, object table, object sheet, object noAuto, object userID, object databasePassWord, object formatID, object map, object openPool, object password, object writeResPassword, object ignoreReadOnlyRecommended)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileOpen", new object[] { name, readOnly, merge, taskInformation, table, sheet, noAuto, userID, databasePassWord, formatID, map, openPool, password, writeResPassword, ignoreReadOnlyRecommended });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Zoom()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Zoom");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="duration">optional object duration</param>
        /// <param name="entire">optional object entire</param>
        /// <param name="selection">optional object selection</param>
        /// <param name="reset">optional object reset</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ZoomTimescale(object duration, object entire, object selection, object reset)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ZoomTimescale", duration, entire, selection, reset);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ZoomTimescale()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ZoomTimescale");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="duration">optional object duration</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ZoomTimescale(object duration)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ZoomTimescale", duration);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="duration">optional object duration</param>
        /// <param name="entire">optional object entire</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ZoomTimescale(object duration, object entire)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ZoomTimescale", duration, entire);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="duration">optional object duration</param>
        /// <param name="entire">optional object entire</param>
        /// <param name="selection">optional object selection</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ZoomTimescale(object duration, object entire, object selection)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ZoomTimescale", duration, entire, selection);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="percent">optional object percent</param>
        /// <param name="entire">optional object entire</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BoxZoom(object percent, object entire)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BoxZoom", percent, entire);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BoxZoom()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BoxZoom");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="percent">optional object percent</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BoxZoom(object percent)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BoxZoom", percent);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="save">optional NetOffice.MSProjectApi.Enums.PjSaveType Save = 2</param>
        /// <param name="noAuto">optional object noAuto</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileClose(object save, object noAuto)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileClose", save, noAuto);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileClose()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileClose");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="save">optional NetOffice.MSProjectApi.Enums.PjSaveType Save = 2</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileClose(object save)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileClose", save);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="save">optional NetOffice.MSProjectApi.Enums.PjSaveType Save = 2</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileCloseAll(object save)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileCloseAll", save);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileCloseAll()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileCloseAll");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="share">optional object share</param>
        /// <param name="name">optional object name</param>
        /// <param name="pool">optional object pool</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceSharing(object share, object name, object pool)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceSharing", share, name, pool);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceSharing()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceSharing");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="share">optional object share</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceSharing(object share)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceSharing", share);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="share">optional object share</param>
        /// <param name="name">optional object name</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceSharing(object share, object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceSharing", share, name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileSave()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileSave");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="format">optional NetOffice.MSProjectApi.Enums.PjFileFormat Format = 0</param>
        /// <param name="backup">optional object backup</param>
        /// <param name="readOnly">optional object readOnly</param>
        /// <param name="taskInformation">optional object taskInformation</param>
        /// <param name="filtered">optional object filtered</param>
        /// <param name="table">optional object table</param>
        /// <param name="userID">optional object userID</param>
        /// <param name="databasePassWord">optional object databasePassWord</param>
        /// <param name="formatID">optional object formatID</param>
        /// <param name="map">optional object map</param>
        /// <param name="password">optional object password</param>
        /// <param name="writeResPassword">optional object writeResPassword</param>
        /// <param name="clearBaseline">optional object clearBaseline</param>
        /// <param name="clearActuals">optional object clearActuals</param>
        /// <param name="clearResourceRates">optional object clearResourceRates</param>
        /// <param name="clearFixedCosts">optional object clearFixedCosts</param>
        /// <param name="xMLName">optional object xMLName</param>
        /// <param name="clearConfirmed">optional object clearConfirmed</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileSaveAs(object name, object format, object backup, object readOnly, object taskInformation, object filtered, object table, object userID, object databasePassWord, object formatID, object map, object password, object writeResPassword, object clearBaseline, object clearActuals, object clearResourceRates, object clearFixedCosts, object xMLName, object clearConfirmed)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileSaveAs", new object[] { name, format, backup, readOnly, taskInformation, filtered, table, userID, databasePassWord, formatID, map, password, writeResPassword, clearBaseline, clearActuals, clearResourceRates, clearFixedCosts, xMLName, clearConfirmed });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileSaveAs(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileSaveAs", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="format">optional NetOffice.MSProjectApi.Enums.PjFileFormat Format = 0</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileSaveAs(object name, object format)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileSaveAs", name, format);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="format">optional NetOffice.MSProjectApi.Enums.PjFileFormat Format = 0</param>
        /// <param name="backup">optional object backup</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileSaveAs(object name, object format, object backup)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileSaveAs", name, format, backup);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="format">optional NetOffice.MSProjectApi.Enums.PjFileFormat Format = 0</param>
        /// <param name="backup">optional object backup</param>
        /// <param name="readOnly">optional object readOnly</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileSaveAs(object name, object format, object backup, object readOnly)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileSaveAs", name, format, backup, readOnly);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="format">optional NetOffice.MSProjectApi.Enums.PjFileFormat Format = 0</param>
        /// <param name="backup">optional object backup</param>
        /// <param name="readOnly">optional object readOnly</param>
        /// <param name="taskInformation">optional object taskInformation</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileSaveAs(object name, object format, object backup, object readOnly, object taskInformation)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileSaveAs", new object[] { name, format, backup, readOnly, taskInformation });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="format">optional NetOffice.MSProjectApi.Enums.PjFileFormat Format = 0</param>
        /// <param name="backup">optional object backup</param>
        /// <param name="readOnly">optional object readOnly</param>
        /// <param name="taskInformation">optional object taskInformation</param>
        /// <param name="filtered">optional object filtered</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileSaveAs(object name, object format, object backup, object readOnly, object taskInformation, object filtered)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileSaveAs", new object[] { name, format, backup, readOnly, taskInformation, filtered });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="format">optional NetOffice.MSProjectApi.Enums.PjFileFormat Format = 0</param>
        /// <param name="backup">optional object backup</param>
        /// <param name="readOnly">optional object readOnly</param>
        /// <param name="taskInformation">optional object taskInformation</param>
        /// <param name="filtered">optional object filtered</param>
        /// <param name="table">optional object table</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileSaveAs(object name, object format, object backup, object readOnly, object taskInformation, object filtered, object table)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileSaveAs", new object[] { name, format, backup, readOnly, taskInformation, filtered, table });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="format">optional NetOffice.MSProjectApi.Enums.PjFileFormat Format = 0</param>
        /// <param name="backup">optional object backup</param>
        /// <param name="readOnly">optional object readOnly</param>
        /// <param name="taskInformation">optional object taskInformation</param>
        /// <param name="filtered">optional object filtered</param>
        /// <param name="table">optional object table</param>
        /// <param name="userID">optional object userID</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileSaveAs(object name, object format, object backup, object readOnly, object taskInformation, object filtered, object table, object userID)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileSaveAs", new object[] { name, format, backup, readOnly, taskInformation, filtered, table, userID });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="format">optional NetOffice.MSProjectApi.Enums.PjFileFormat Format = 0</param>
        /// <param name="backup">optional object backup</param>
        /// <param name="readOnly">optional object readOnly</param>
        /// <param name="taskInformation">optional object taskInformation</param>
        /// <param name="filtered">optional object filtered</param>
        /// <param name="table">optional object table</param>
        /// <param name="userID">optional object userID</param>
        /// <param name="databasePassWord">optional object databasePassWord</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileSaveAs(object name, object format, object backup, object readOnly, object taskInformation, object filtered, object table, object userID, object databasePassWord)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileSaveAs", new object[] { name, format, backup, readOnly, taskInformation, filtered, table, userID, databasePassWord });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="format">optional NetOffice.MSProjectApi.Enums.PjFileFormat Format = 0</param>
        /// <param name="backup">optional object backup</param>
        /// <param name="readOnly">optional object readOnly</param>
        /// <param name="taskInformation">optional object taskInformation</param>
        /// <param name="filtered">optional object filtered</param>
        /// <param name="table">optional object table</param>
        /// <param name="userID">optional object userID</param>
        /// <param name="databasePassWord">optional object databasePassWord</param>
        /// <param name="formatID">optional object formatID</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileSaveAs(object name, object format, object backup, object readOnly, object taskInformation, object filtered, object table, object userID, object databasePassWord, object formatID)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileSaveAs", new object[] { name, format, backup, readOnly, taskInformation, filtered, table, userID, databasePassWord, formatID });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="format">optional NetOffice.MSProjectApi.Enums.PjFileFormat Format = 0</param>
        /// <param name="backup">optional object backup</param>
        /// <param name="readOnly">optional object readOnly</param>
        /// <param name="taskInformation">optional object taskInformation</param>
        /// <param name="filtered">optional object filtered</param>
        /// <param name="table">optional object table</param>
        /// <param name="userID">optional object userID</param>
        /// <param name="databasePassWord">optional object databasePassWord</param>
        /// <param name="formatID">optional object formatID</param>
        /// <param name="map">optional object map</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileSaveAs(object name, object format, object backup, object readOnly, object taskInformation, object filtered, object table, object userID, object databasePassWord, object formatID, object map)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileSaveAs", new object[] { name, format, backup, readOnly, taskInformation, filtered, table, userID, databasePassWord, formatID, map });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="format">optional NetOffice.MSProjectApi.Enums.PjFileFormat Format = 0</param>
        /// <param name="backup">optional object backup</param>
        /// <param name="readOnly">optional object readOnly</param>
        /// <param name="taskInformation">optional object taskInformation</param>
        /// <param name="filtered">optional object filtered</param>
        /// <param name="table">optional object table</param>
        /// <param name="userID">optional object userID</param>
        /// <param name="databasePassWord">optional object databasePassWord</param>
        /// <param name="formatID">optional object formatID</param>
        /// <param name="map">optional object map</param>
        /// <param name="password">optional object password</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileSaveAs(object name, object format, object backup, object readOnly, object taskInformation, object filtered, object table, object userID, object databasePassWord, object formatID, object map, object password)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileSaveAs", new object[] { name, format, backup, readOnly, taskInformation, filtered, table, userID, databasePassWord, formatID, map, password });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="format">optional NetOffice.MSProjectApi.Enums.PjFileFormat Format = 0</param>
        /// <param name="backup">optional object backup</param>
        /// <param name="readOnly">optional object readOnly</param>
        /// <param name="taskInformation">optional object taskInformation</param>
        /// <param name="filtered">optional object filtered</param>
        /// <param name="table">optional object table</param>
        /// <param name="userID">optional object userID</param>
        /// <param name="databasePassWord">optional object databasePassWord</param>
        /// <param name="formatID">optional object formatID</param>
        /// <param name="map">optional object map</param>
        /// <param name="password">optional object password</param>
        /// <param name="writeResPassword">optional object writeResPassword</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileSaveAs(object name, object format, object backup, object readOnly, object taskInformation, object filtered, object table, object userID, object databasePassWord, object formatID, object map, object password, object writeResPassword)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileSaveAs", new object[] { name, format, backup, readOnly, taskInformation, filtered, table, userID, databasePassWord, formatID, map, password, writeResPassword });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="format">optional NetOffice.MSProjectApi.Enums.PjFileFormat Format = 0</param>
        /// <param name="backup">optional object backup</param>
        /// <param name="readOnly">optional object readOnly</param>
        /// <param name="taskInformation">optional object taskInformation</param>
        /// <param name="filtered">optional object filtered</param>
        /// <param name="table">optional object table</param>
        /// <param name="userID">optional object userID</param>
        /// <param name="databasePassWord">optional object databasePassWord</param>
        /// <param name="formatID">optional object formatID</param>
        /// <param name="map">optional object map</param>
        /// <param name="password">optional object password</param>
        /// <param name="writeResPassword">optional object writeResPassword</param>
        /// <param name="clearBaseline">optional object clearBaseline</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileSaveAs(object name, object format, object backup, object readOnly, object taskInformation, object filtered, object table, object userID, object databasePassWord, object formatID, object map, object password, object writeResPassword, object clearBaseline)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileSaveAs", new object[] { name, format, backup, readOnly, taskInformation, filtered, table, userID, databasePassWord, formatID, map, password, writeResPassword, clearBaseline });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="format">optional NetOffice.MSProjectApi.Enums.PjFileFormat Format = 0</param>
        /// <param name="backup">optional object backup</param>
        /// <param name="readOnly">optional object readOnly</param>
        /// <param name="taskInformation">optional object taskInformation</param>
        /// <param name="filtered">optional object filtered</param>
        /// <param name="table">optional object table</param>
        /// <param name="userID">optional object userID</param>
        /// <param name="databasePassWord">optional object databasePassWord</param>
        /// <param name="formatID">optional object formatID</param>
        /// <param name="map">optional object map</param>
        /// <param name="password">optional object password</param>
        /// <param name="writeResPassword">optional object writeResPassword</param>
        /// <param name="clearBaseline">optional object clearBaseline</param>
        /// <param name="clearActuals">optional object clearActuals</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileSaveAs(object name, object format, object backup, object readOnly, object taskInformation, object filtered, object table, object userID, object databasePassWord, object formatID, object map, object password, object writeResPassword, object clearBaseline, object clearActuals)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileSaveAs", new object[] { name, format, backup, readOnly, taskInformation, filtered, table, userID, databasePassWord, formatID, map, password, writeResPassword, clearBaseline, clearActuals });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="format">optional NetOffice.MSProjectApi.Enums.PjFileFormat Format = 0</param>
        /// <param name="backup">optional object backup</param>
        /// <param name="readOnly">optional object readOnly</param>
        /// <param name="taskInformation">optional object taskInformation</param>
        /// <param name="filtered">optional object filtered</param>
        /// <param name="table">optional object table</param>
        /// <param name="userID">optional object userID</param>
        /// <param name="databasePassWord">optional object databasePassWord</param>
        /// <param name="formatID">optional object formatID</param>
        /// <param name="map">optional object map</param>
        /// <param name="password">optional object password</param>
        /// <param name="writeResPassword">optional object writeResPassword</param>
        /// <param name="clearBaseline">optional object clearBaseline</param>
        /// <param name="clearActuals">optional object clearActuals</param>
        /// <param name="clearResourceRates">optional object clearResourceRates</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileSaveAs(object name, object format, object backup, object readOnly, object taskInformation, object filtered, object table, object userID, object databasePassWord, object formatID, object map, object password, object writeResPassword, object clearBaseline, object clearActuals, object clearResourceRates)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileSaveAs", new object[] { name, format, backup, readOnly, taskInformation, filtered, table, userID, databasePassWord, formatID, map, password, writeResPassword, clearBaseline, clearActuals, clearResourceRates });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="format">optional NetOffice.MSProjectApi.Enums.PjFileFormat Format = 0</param>
        /// <param name="backup">optional object backup</param>
        /// <param name="readOnly">optional object readOnly</param>
        /// <param name="taskInformation">optional object taskInformation</param>
        /// <param name="filtered">optional object filtered</param>
        /// <param name="table">optional object table</param>
        /// <param name="userID">optional object userID</param>
        /// <param name="databasePassWord">optional object databasePassWord</param>
        /// <param name="formatID">optional object formatID</param>
        /// <param name="map">optional object map</param>
        /// <param name="password">optional object password</param>
        /// <param name="writeResPassword">optional object writeResPassword</param>
        /// <param name="clearBaseline">optional object clearBaseline</param>
        /// <param name="clearActuals">optional object clearActuals</param>
        /// <param name="clearResourceRates">optional object clearResourceRates</param>
        /// <param name="clearFixedCosts">optional object clearFixedCosts</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileSaveAs(object name, object format, object backup, object readOnly, object taskInformation, object filtered, object table, object userID, object databasePassWord, object formatID, object map, object password, object writeResPassword, object clearBaseline, object clearActuals, object clearResourceRates, object clearFixedCosts)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileSaveAs", new object[] { name, format, backup, readOnly, taskInformation, filtered, table, userID, databasePassWord, formatID, map, password, writeResPassword, clearBaseline, clearActuals, clearResourceRates, clearFixedCosts });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="format">optional NetOffice.MSProjectApi.Enums.PjFileFormat Format = 0</param>
        /// <param name="backup">optional object backup</param>
        /// <param name="readOnly">optional object readOnly</param>
        /// <param name="taskInformation">optional object taskInformation</param>
        /// <param name="filtered">optional object filtered</param>
        /// <param name="table">optional object table</param>
        /// <param name="userID">optional object userID</param>
        /// <param name="databasePassWord">optional object databasePassWord</param>
        /// <param name="formatID">optional object formatID</param>
        /// <param name="map">optional object map</param>
        /// <param name="password">optional object password</param>
        /// <param name="writeResPassword">optional object writeResPassword</param>
        /// <param name="clearBaseline">optional object clearBaseline</param>
        /// <param name="clearActuals">optional object clearActuals</param>
        /// <param name="clearResourceRates">optional object clearResourceRates</param>
        /// <param name="clearFixedCosts">optional object clearFixedCosts</param>
        /// <param name="xMLName">optional object xMLName</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileSaveAs(object name, object format, object backup, object readOnly, object taskInformation, object filtered, object table, object userID, object databasePassWord, object formatID, object map, object password, object writeResPassword, object clearBaseline, object clearActuals, object clearResourceRates, object clearFixedCosts, object xMLName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileSaveAs", new object[] { name, format, backup, readOnly, taskInformation, filtered, table, userID, databasePassWord, formatID, map, password, writeResPassword, clearBaseline, clearActuals, clearResourceRates, clearFixedCosts, xMLName });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileSaveWorkspace(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileSaveWorkspace", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileSaveWorkspace()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileSaveWorkspace");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fromPage">optional object fromPage</param>
        /// <param name="toPage">optional object toPage</param>
        /// <param name="pageBreaks">optional object pageBreaks</param>
        /// <param name="draft">optional object draft</param>
        /// <param name="copies">optional object copies</param>
        /// <param name="fromDate">optional object fromDate</param>
        /// <param name="toDate">optional object toDate</param>
        /// <param name="onePageWide">optional object onePageWide</param>
        /// <param name="preview">optional object preview</param>
        /// <param name="color">optional object color</param>
        /// <param name="showIEPrintDialog">optional object showIEPrintDialog</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePrint(object fromPage, object toPage, object pageBreaks, object draft, object copies, object fromDate, object toDate, object onePageWide, object preview, object color, object showIEPrintDialog)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePrint", new object[] { fromPage, toPage, pageBreaks, draft, copies, fromDate, toDate, onePageWide, preview, color, showIEPrintDialog });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePrint()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePrint");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fromPage">optional object fromPage</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePrint(object fromPage)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePrint", fromPage);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fromPage">optional object fromPage</param>
        /// <param name="toPage">optional object toPage</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePrint(object fromPage, object toPage)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePrint", fromPage, toPage);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fromPage">optional object fromPage</param>
        /// <param name="toPage">optional object toPage</param>
        /// <param name="pageBreaks">optional object pageBreaks</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePrint(object fromPage, object toPage, object pageBreaks)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePrint", fromPage, toPage, pageBreaks);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fromPage">optional object fromPage</param>
        /// <param name="toPage">optional object toPage</param>
        /// <param name="pageBreaks">optional object pageBreaks</param>
        /// <param name="draft">optional object draft</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePrint(object fromPage, object toPage, object pageBreaks, object draft)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePrint", fromPage, toPage, pageBreaks, draft);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fromPage">optional object fromPage</param>
        /// <param name="toPage">optional object toPage</param>
        /// <param name="pageBreaks">optional object pageBreaks</param>
        /// <param name="draft">optional object draft</param>
        /// <param name="copies">optional object copies</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePrint(object fromPage, object toPage, object pageBreaks, object draft, object copies)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePrint", new object[] { fromPage, toPage, pageBreaks, draft, copies });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fromPage">optional object fromPage</param>
        /// <param name="toPage">optional object toPage</param>
        /// <param name="pageBreaks">optional object pageBreaks</param>
        /// <param name="draft">optional object draft</param>
        /// <param name="copies">optional object copies</param>
        /// <param name="fromDate">optional object fromDate</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePrint(object fromPage, object toPage, object pageBreaks, object draft, object copies, object fromDate)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePrint", new object[] { fromPage, toPage, pageBreaks, draft, copies, fromDate });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fromPage">optional object fromPage</param>
        /// <param name="toPage">optional object toPage</param>
        /// <param name="pageBreaks">optional object pageBreaks</param>
        /// <param name="draft">optional object draft</param>
        /// <param name="copies">optional object copies</param>
        /// <param name="fromDate">optional object fromDate</param>
        /// <param name="toDate">optional object toDate</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePrint(object fromPage, object toPage, object pageBreaks, object draft, object copies, object fromDate, object toDate)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePrint", new object[] { fromPage, toPage, pageBreaks, draft, copies, fromDate, toDate });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fromPage">optional object fromPage</param>
        /// <param name="toPage">optional object toPage</param>
        /// <param name="pageBreaks">optional object pageBreaks</param>
        /// <param name="draft">optional object draft</param>
        /// <param name="copies">optional object copies</param>
        /// <param name="fromDate">optional object fromDate</param>
        /// <param name="toDate">optional object toDate</param>
        /// <param name="onePageWide">optional object onePageWide</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePrint(object fromPage, object toPage, object pageBreaks, object draft, object copies, object fromDate, object toDate, object onePageWide)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePrint", new object[] { fromPage, toPage, pageBreaks, draft, copies, fromDate, toDate, onePageWide });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fromPage">optional object fromPage</param>
        /// <param name="toPage">optional object toPage</param>
        /// <param name="pageBreaks">optional object pageBreaks</param>
        /// <param name="draft">optional object draft</param>
        /// <param name="copies">optional object copies</param>
        /// <param name="fromDate">optional object fromDate</param>
        /// <param name="toDate">optional object toDate</param>
        /// <param name="onePageWide">optional object onePageWide</param>
        /// <param name="preview">optional object preview</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePrint(object fromPage, object toPage, object pageBreaks, object draft, object copies, object fromDate, object toDate, object onePageWide, object preview)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePrint", new object[] { fromPage, toPage, pageBreaks, draft, copies, fromDate, toDate, onePageWide, preview });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fromPage">optional object fromPage</param>
        /// <param name="toPage">optional object toPage</param>
        /// <param name="pageBreaks">optional object pageBreaks</param>
        /// <param name="draft">optional object draft</param>
        /// <param name="copies">optional object copies</param>
        /// <param name="fromDate">optional object fromDate</param>
        /// <param name="toDate">optional object toDate</param>
        /// <param name="onePageWide">optional object onePageWide</param>
        /// <param name="preview">optional object preview</param>
        /// <param name="color">optional object color</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePrint(object fromPage, object toPage, object pageBreaks, object draft, object copies, object fromDate, object toDate, object onePageWide, object preview, object color)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePrint", new object[] { fromPage, toPage, pageBreaks, draft, copies, fromDate, toDate, onePageWide, preview, color });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="fromPage">optional object fromPage</param>
        /// <param name="toPage">optional object toPage</param>
        /// <param name="pageBreaks">optional object pageBreaks</param>
        /// <param name="draft">optional object draft</param>
        /// <param name="copies">optional object copies</param>
        /// <param name="fromDate">optional object fromDate</param>
        /// <param name="toDate">optional object toDate</param>
        /// <param name="preview">optional object preview</param>
        /// <param name="color">optional object color</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ReportPrint(object name, object fromPage, object toPage, object pageBreaks, object draft, object copies, object fromDate, object toDate, object preview, object color)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ReportPrint", new object[] { name, fromPage, toPage, pageBreaks, draft, copies, fromDate, toDate, preview, color });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ReportPrint()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ReportPrint");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ReportPrint(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ReportPrint", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="fromPage">optional object fromPage</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ReportPrint(object name, object fromPage)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ReportPrint", name, fromPage);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="fromPage">optional object fromPage</param>
        /// <param name="toPage">optional object toPage</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ReportPrint(object name, object fromPage, object toPage)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ReportPrint", name, fromPage, toPage);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="fromPage">optional object fromPage</param>
        /// <param name="toPage">optional object toPage</param>
        /// <param name="pageBreaks">optional object pageBreaks</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ReportPrint(object name, object fromPage, object toPage, object pageBreaks)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ReportPrint", name, fromPage, toPage, pageBreaks);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="fromPage">optional object fromPage</param>
        /// <param name="toPage">optional object toPage</param>
        /// <param name="pageBreaks">optional object pageBreaks</param>
        /// <param name="draft">optional object draft</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ReportPrint(object name, object fromPage, object toPage, object pageBreaks, object draft)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ReportPrint", new object[] { name, fromPage, toPage, pageBreaks, draft });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="fromPage">optional object fromPage</param>
        /// <param name="toPage">optional object toPage</param>
        /// <param name="pageBreaks">optional object pageBreaks</param>
        /// <param name="draft">optional object draft</param>
        /// <param name="copies">optional object copies</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ReportPrint(object name, object fromPage, object toPage, object pageBreaks, object draft, object copies)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ReportPrint", new object[] { name, fromPage, toPage, pageBreaks, draft, copies });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="fromPage">optional object fromPage</param>
        /// <param name="toPage">optional object toPage</param>
        /// <param name="pageBreaks">optional object pageBreaks</param>
        /// <param name="draft">optional object draft</param>
        /// <param name="copies">optional object copies</param>
        /// <param name="fromDate">optional object fromDate</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ReportPrint(object name, object fromPage, object toPage, object pageBreaks, object draft, object copies, object fromDate)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ReportPrint", new object[] { name, fromPage, toPage, pageBreaks, draft, copies, fromDate });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="fromPage">optional object fromPage</param>
        /// <param name="toPage">optional object toPage</param>
        /// <param name="pageBreaks">optional object pageBreaks</param>
        /// <param name="draft">optional object draft</param>
        /// <param name="copies">optional object copies</param>
        /// <param name="fromDate">optional object fromDate</param>
        /// <param name="toDate">optional object toDate</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ReportPrint(object name, object fromPage, object toPage, object pageBreaks, object draft, object copies, object fromDate, object toDate)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ReportPrint", new object[] { name, fromPage, toPage, pageBreaks, draft, copies, fromDate, toDate });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="fromPage">optional object fromPage</param>
        /// <param name="toPage">optional object toPage</param>
        /// <param name="pageBreaks">optional object pageBreaks</param>
        /// <param name="draft">optional object draft</param>
        /// <param name="copies">optional object copies</param>
        /// <param name="fromDate">optional object fromDate</param>
        /// <param name="toDate">optional object toDate</param>
        /// <param name="preview">optional object preview</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ReportPrint(object name, object fromPage, object toPage, object pageBreaks, object draft, object copies, object fromDate, object toDate, object preview)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ReportPrint", new object[] { name, fromPage, toPage, pageBreaks, draft, copies, fromDate, toDate, preview });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePrintPreview()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePrintPreview");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ReportPrintPreview(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ReportPrintPreview", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ReportPrintPreview()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ReportPrintPreview");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="printer">optional object printer</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePrintSetup(object printer)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePrintSetup", printer);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePrintSetup()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePrintSetup");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetup(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetup", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetup()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetup");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="portrait">object portrait</param>
        /// <param name="percentScale">object percentScale</param>
        /// <param name="pagesTall">object pagesTall</param>
        /// <param name="pagesWide">object pagesWide</param>
        /// <param name="paperSize">optional NetOffice.MSProjectApi.Enums.PjPaperSize PaperSize = 0</param>
        /// <param name="firstPageNumber">optional object firstPageNumber</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupPage(object name, object portrait, object percentScale, object pagesTall, object pagesWide, object paperSize, object firstPageNumber)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupPage", new object[] { name, portrait, percentScale, pagesTall, pagesWide, paperSize, firstPageNumber });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="portrait">object portrait</param>
        /// <param name="percentScale">object percentScale</param>
        /// <param name="pagesTall">object pagesTall</param>
        /// <param name="pagesWide">object pagesWide</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupPage(object name, object portrait, object percentScale, object pagesTall, object pagesWide)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupPage", new object[] { name, portrait, percentScale, pagesTall, pagesWide });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="portrait">object portrait</param>
        /// <param name="percentScale">object percentScale</param>
        /// <param name="pagesTall">object pagesTall</param>
        /// <param name="pagesWide">object pagesWide</param>
        /// <param name="paperSize">optional NetOffice.MSProjectApi.Enums.PjPaperSize PaperSize = 0</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupPage(object name, object portrait, object percentScale, object pagesTall, object pagesWide, object paperSize)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupPage", new object[] { name, portrait, percentScale, pagesTall, pagesWide, paperSize });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="top">optional object top</param>
        /// <param name="bottom">optional object bottom</param>
        /// <param name="left">optional object left</param>
        /// <param name="right">optional object right</param>
        /// <param name="borders">optional object borders</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupMargins(object name, object top, object bottom, object left, object right, object borders)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupMargins", new object[] { name, top, bottom, left, right, borders });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupMargins()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupMargins");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupMargins(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupMargins", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="top">optional object top</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupMargins(object name, object top)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupMargins", name, top);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="top">optional object top</param>
        /// <param name="bottom">optional object bottom</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupMargins(object name, object top, object bottom)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupMargins", name, top, bottom);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="top">optional object top</param>
        /// <param name="bottom">optional object bottom</param>
        /// <param name="left">optional object left</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupMargins(object name, object top, object bottom, object left)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupMargins", name, top, bottom, left);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="top">optional object top</param>
        /// <param name="bottom">optional object bottom</param>
        /// <param name="left">optional object left</param>
        /// <param name="right">optional object right</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupMargins(object name, object top, object bottom, object left, object right)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupMargins", new object[] { name, top, bottom, left, right });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="alignment">optional NetOffice.MSProjectApi.Enums.PjAlignment Alignment = 1</param>
        /// <param name="text">optional object text</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupHeader(object name, object alignment, object text)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupHeader", name, alignment, text);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupHeader(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupHeader", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="alignment">optional NetOffice.MSProjectApi.Enums.PjAlignment Alignment = 1</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupHeader(object name, object alignment)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupHeader", name, alignment);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="alignment">optional NetOffice.MSProjectApi.Enums.PjAlignment Alignment = 1</param>
        /// <param name="text">optional object text</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupFooter(object name, object alignment, object text)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupFooter", name, alignment, text);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupFooter(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupFooter", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="alignment">optional NetOffice.MSProjectApi.Enums.PjAlignment Alignment = 1</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupFooter(object name, object alignment)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupFooter", name, alignment);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="textWidth">object textWidth</param>
        /// <param name="legendOn">object legendOn</param>
        /// <param name="alignment">optional NetOffice.MSProjectApi.Enums.PjAlignment Alignment = 1</param>
        /// <param name="text">object text</param>
        /// <param name="labelFontName">object labelFontName</param>
        /// <param name="labelFontSize">object labelFontSize</param>
        /// <param name="labelFontBold">object labelFontBold</param>
        /// <param name="labelFontItalic">object labelFontItalic</param>
        /// <param name="labelFontUnderline">object labelFontUnderline</param>
        /// <param name="labelFontColor">optional NetOffice.MSProjectApi.Enums.PjColor LabelFontColor = -1</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupLegend(object name, object textWidth, object legendOn, object alignment, object text, object labelFontName, object labelFontSize, object labelFontBold, object labelFontItalic, object labelFontUnderline, object labelFontColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupLegend", new object[] { name, textWidth, legendOn, alignment, text, labelFontName, labelFontSize, labelFontBold, labelFontItalic, labelFontUnderline, labelFontColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="textWidth">object textWidth</param>
        /// <param name="legendOn">object legendOn</param>
        /// <param name="alignment">optional NetOffice.MSProjectApi.Enums.PjAlignment Alignment = 1</param>
        /// <param name="text">object text</param>
        /// <param name="labelFontName">object labelFontName</param>
        /// <param name="labelFontSize">object labelFontSize</param>
        /// <param name="labelFontBold">object labelFontBold</param>
        /// <param name="labelFontItalic">object labelFontItalic</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupLegend(object name, object textWidth, object legendOn, object alignment, object text, object labelFontName, object labelFontSize, object labelFontBold, object labelFontItalic)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupLegend", new object[] { name, textWidth, legendOn, alignment, text, labelFontName, labelFontSize, labelFontBold, labelFontItalic });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">object name</param>
        /// <param name="textWidth">object textWidth</param>
        /// <param name="legendOn">object legendOn</param>
        /// <param name="alignment">optional NetOffice.MSProjectApi.Enums.PjAlignment Alignment = 1</param>
        /// <param name="text">object text</param>
        /// <param name="labelFontName">object labelFontName</param>
        /// <param name="labelFontSize">object labelFontSize</param>
        /// <param name="labelFontBold">object labelFontBold</param>
        /// <param name="labelFontItalic">object labelFontItalic</param>
        /// <param name="labelFontUnderline">object labelFontUnderline</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupLegend(object name, object textWidth, object legendOn, object alignment, object text, object labelFontName, object labelFontSize, object labelFontBold, object labelFontItalic, object labelFontUnderline)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupLegend", new object[] { name, textWidth, legendOn, alignment, text, labelFontName, labelFontSize, labelFontBold, labelFontItalic, labelFontUnderline });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="allSheetColumns">optional object allSheetColumns</param>
        /// <param name="repeatColumns">optional object repeatColumns</param>
        /// <param name="printNotes">optional object printNotes</param>
        /// <param name="printBlankPages">optional object printBlankPages</param>
        /// <param name="bestPageFitTimescale">optional object bestPageFitTimescale</param>
        /// <param name="printColumnTotals">optional object printColumnTotals</param>
        /// <param name="printRowTotals">optional object printRowTotals</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupView(object name, object allSheetColumns, object repeatColumns, object printNotes, object printBlankPages, object bestPageFitTimescale, object printColumnTotals, object printRowTotals)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupView", new object[] { name, allSheetColumns, repeatColumns, printNotes, printBlankPages, bestPageFitTimescale, printColumnTotals, printRowTotals });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupView()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupView");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupView(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupView", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="allSheetColumns">optional object allSheetColumns</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupView(object name, object allSheetColumns)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupView", name, allSheetColumns);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="allSheetColumns">optional object allSheetColumns</param>
        /// <param name="repeatColumns">optional object repeatColumns</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupView(object name, object allSheetColumns, object repeatColumns)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupView", name, allSheetColumns, repeatColumns);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="allSheetColumns">optional object allSheetColumns</param>
        /// <param name="repeatColumns">optional object repeatColumns</param>
        /// <param name="printNotes">optional object printNotes</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupView(object name, object allSheetColumns, object repeatColumns, object printNotes)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupView", name, allSheetColumns, repeatColumns, printNotes);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="allSheetColumns">optional object allSheetColumns</param>
        /// <param name="repeatColumns">optional object repeatColumns</param>
        /// <param name="printNotes">optional object printNotes</param>
        /// <param name="printBlankPages">optional object printBlankPages</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupView(object name, object allSheetColumns, object repeatColumns, object printNotes, object printBlankPages)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupView", new object[] { name, allSheetColumns, repeatColumns, printNotes, printBlankPages });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="allSheetColumns">optional object allSheetColumns</param>
        /// <param name="repeatColumns">optional object repeatColumns</param>
        /// <param name="printNotes">optional object printNotes</param>
        /// <param name="printBlankPages">optional object printBlankPages</param>
        /// <param name="bestPageFitTimescale">optional object bestPageFitTimescale</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupView(object name, object allSheetColumns, object repeatColumns, object printNotes, object printBlankPages, object bestPageFitTimescale)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupView", new object[] { name, allSheetColumns, repeatColumns, printNotes, printBlankPages, bestPageFitTimescale });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="allSheetColumns">optional object allSheetColumns</param>
        /// <param name="repeatColumns">optional object repeatColumns</param>
        /// <param name="printNotes">optional object printNotes</param>
        /// <param name="printBlankPages">optional object printBlankPages</param>
        /// <param name="bestPageFitTimescale">optional object bestPageFitTimescale</param>
        /// <param name="printColumnTotals">optional object printColumnTotals</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupView(object name, object allSheetColumns, object repeatColumns, object printNotes, object printBlankPages, object bestPageFitTimescale, object printColumnTotals)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupView", new object[] { name, allSheetColumns, repeatColumns, printNotes, printBlankPages, bestPageFitTimescale, printColumnTotals });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="monthsPerPage">optional object monthsPerPage</param>
        /// <param name="weeksPerPage">optional object weeksPerPage</param>
        /// <param name="screenWeekHeight">optional object screenWeekHeight</param>
        /// <param name="onlyDaysInMonth">optional object onlyDaysInMonth</param>
        /// <param name="onlyWeeksInMonth">optional object onlyWeeksInMonth</param>
        /// <param name="monthPreviews">optional object monthPreviews</param>
        /// <param name="monthTitle">optional object monthTitle</param>
        /// <param name="additionalTasks">optional object additionalTasks</param>
        /// <param name="groupAdditionalTasks">optional object groupAdditionalTasks</param>
        /// <param name="printNotes">optional object printNotes</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupCalendar(object name, object monthsPerPage, object weeksPerPage, object screenWeekHeight, object onlyDaysInMonth, object onlyWeeksInMonth, object monthPreviews, object monthTitle, object additionalTasks, object groupAdditionalTasks, object printNotes)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupCalendar", new object[] { name, monthsPerPage, weeksPerPage, screenWeekHeight, onlyDaysInMonth, onlyWeeksInMonth, monthPreviews, monthTitle, additionalTasks, groupAdditionalTasks, printNotes });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupCalendar()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupCalendar");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupCalendar(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupCalendar", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="monthsPerPage">optional object monthsPerPage</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupCalendar(object name, object monthsPerPage)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupCalendar", name, monthsPerPage);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="monthsPerPage">optional object monthsPerPage</param>
        /// <param name="weeksPerPage">optional object weeksPerPage</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupCalendar(object name, object monthsPerPage, object weeksPerPage)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupCalendar", name, monthsPerPage, weeksPerPage);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="monthsPerPage">optional object monthsPerPage</param>
        /// <param name="weeksPerPage">optional object weeksPerPage</param>
        /// <param name="screenWeekHeight">optional object screenWeekHeight</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupCalendar(object name, object monthsPerPage, object weeksPerPage, object screenWeekHeight)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupCalendar", name, monthsPerPage, weeksPerPage, screenWeekHeight);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="monthsPerPage">optional object monthsPerPage</param>
        /// <param name="weeksPerPage">optional object weeksPerPage</param>
        /// <param name="screenWeekHeight">optional object screenWeekHeight</param>
        /// <param name="onlyDaysInMonth">optional object onlyDaysInMonth</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupCalendar(object name, object monthsPerPage, object weeksPerPage, object screenWeekHeight, object onlyDaysInMonth)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupCalendar", new object[] { name, monthsPerPage, weeksPerPage, screenWeekHeight, onlyDaysInMonth });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="monthsPerPage">optional object monthsPerPage</param>
        /// <param name="weeksPerPage">optional object weeksPerPage</param>
        /// <param name="screenWeekHeight">optional object screenWeekHeight</param>
        /// <param name="onlyDaysInMonth">optional object onlyDaysInMonth</param>
        /// <param name="onlyWeeksInMonth">optional object onlyWeeksInMonth</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupCalendar(object name, object monthsPerPage, object weeksPerPage, object screenWeekHeight, object onlyDaysInMonth, object onlyWeeksInMonth)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupCalendar", new object[] { name, monthsPerPage, weeksPerPage, screenWeekHeight, onlyDaysInMonth, onlyWeeksInMonth });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="monthsPerPage">optional object monthsPerPage</param>
        /// <param name="weeksPerPage">optional object weeksPerPage</param>
        /// <param name="screenWeekHeight">optional object screenWeekHeight</param>
        /// <param name="onlyDaysInMonth">optional object onlyDaysInMonth</param>
        /// <param name="onlyWeeksInMonth">optional object onlyWeeksInMonth</param>
        /// <param name="monthPreviews">optional object monthPreviews</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupCalendar(object name, object monthsPerPage, object weeksPerPage, object screenWeekHeight, object onlyDaysInMonth, object onlyWeeksInMonth, object monthPreviews)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupCalendar", new object[] { name, monthsPerPage, weeksPerPage, screenWeekHeight, onlyDaysInMonth, onlyWeeksInMonth, monthPreviews });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="monthsPerPage">optional object monthsPerPage</param>
        /// <param name="weeksPerPage">optional object weeksPerPage</param>
        /// <param name="screenWeekHeight">optional object screenWeekHeight</param>
        /// <param name="onlyDaysInMonth">optional object onlyDaysInMonth</param>
        /// <param name="onlyWeeksInMonth">optional object onlyWeeksInMonth</param>
        /// <param name="monthPreviews">optional object monthPreviews</param>
        /// <param name="monthTitle">optional object monthTitle</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupCalendar(object name, object monthsPerPage, object weeksPerPage, object screenWeekHeight, object onlyDaysInMonth, object onlyWeeksInMonth, object monthPreviews, object monthTitle)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupCalendar", new object[] { name, monthsPerPage, weeksPerPage, screenWeekHeight, onlyDaysInMonth, onlyWeeksInMonth, monthPreviews, monthTitle });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="monthsPerPage">optional object monthsPerPage</param>
        /// <param name="weeksPerPage">optional object weeksPerPage</param>
        /// <param name="screenWeekHeight">optional object screenWeekHeight</param>
        /// <param name="onlyDaysInMonth">optional object onlyDaysInMonth</param>
        /// <param name="onlyWeeksInMonth">optional object onlyWeeksInMonth</param>
        /// <param name="monthPreviews">optional object monthPreviews</param>
        /// <param name="monthTitle">optional object monthTitle</param>
        /// <param name="additionalTasks">optional object additionalTasks</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupCalendar(object name, object monthsPerPage, object weeksPerPage, object screenWeekHeight, object onlyDaysInMonth, object onlyWeeksInMonth, object monthPreviews, object monthTitle, object additionalTasks)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupCalendar", new object[] { name, monthsPerPage, weeksPerPage, screenWeekHeight, onlyDaysInMonth, onlyWeeksInMonth, monthPreviews, monthTitle, additionalTasks });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="monthsPerPage">optional object monthsPerPage</param>
        /// <param name="weeksPerPage">optional object weeksPerPage</param>
        /// <param name="screenWeekHeight">optional object screenWeekHeight</param>
        /// <param name="onlyDaysInMonth">optional object onlyDaysInMonth</param>
        /// <param name="onlyWeeksInMonth">optional object onlyWeeksInMonth</param>
        /// <param name="monthPreviews">optional object monthPreviews</param>
        /// <param name="monthTitle">optional object monthTitle</param>
        /// <param name="additionalTasks">optional object additionalTasks</param>
        /// <param name="groupAdditionalTasks">optional object groupAdditionalTasks</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupCalendar(object name, object monthsPerPage, object weeksPerPage, object screenWeekHeight, object onlyDaysInMonth, object onlyWeeksInMonth, object monthPreviews, object monthTitle, object additionalTasks, object groupAdditionalTasks)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupCalendar", new object[] { name, monthsPerPage, weeksPerPage, screenWeekHeight, onlyDaysInMonth, onlyWeeksInMonth, monthPreviews, monthTitle, additionalTasks, groupAdditionalTasks });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="item">optional object item</param>
        /// <param name="font">optional object font</param>
        /// <param name="size">optional object size</param>
        /// <param name="bold">optional object bold</param>
        /// <param name="italic">optional object italic</param>
        /// <param name="underline">optional object underline</param>
        /// <param name="color">optional object color</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupCalendarText(object name, object item, object font, object size, object bold, object italic, object underline, object color)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupCalendarText", new object[] { name, item, font, size, bold, italic, underline, color });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupCalendarText()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupCalendarText");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupCalendarText(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupCalendarText", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="item">optional object item</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupCalendarText(object name, object item)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupCalendarText", name, item);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="item">optional object item</param>
        /// <param name="font">optional object font</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupCalendarText(object name, object item, object font)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupCalendarText", name, item, font);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="item">optional object item</param>
        /// <param name="font">optional object font</param>
        /// <param name="size">optional object size</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupCalendarText(object name, object item, object font, object size)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupCalendarText", name, item, font, size);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="item">optional object item</param>
        /// <param name="font">optional object font</param>
        /// <param name="size">optional object size</param>
        /// <param name="bold">optional object bold</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupCalendarText(object name, object item, object font, object size, object bold)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupCalendarText", new object[] { name, item, font, size, bold });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="item">optional object item</param>
        /// <param name="font">optional object font</param>
        /// <param name="size">optional object size</param>
        /// <param name="bold">optional object bold</param>
        /// <param name="italic">optional object italic</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupCalendarText(object name, object item, object font, object size, object bold, object italic)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupCalendarText", new object[] { name, item, font, size, bold, italic });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="item">optional object item</param>
        /// <param name="font">optional object font</param>
        /// <param name="size">optional object size</param>
        /// <param name="bold">optional object bold</param>
        /// <param name="italic">optional object italic</param>
        /// <param name="underline">optional object underline</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilePageSetupCalendarText(object name, object item, object font, object size, object bold, object italic, object underline)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilePageSetupCalendarText", new object[] { name, item, font, size, bold, italic, underline });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="any">optional object any</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailOpen(object any)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailOpen", any);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailOpen()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailOpen");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="to">optional object to</param>
        /// <param name="cc">optional object cc</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="body">optional object body</param>
        /// <param name="enclosures">optional object enclosures</param>
        /// <param name="includeDocument">optional object includeDocument</param>
        /// <param name="returnReceipt">optional object returnReceipt</param>
        /// <param name="bcc">optional object bcc</param>
        /// <param name="urgent">optional object urgent</param>
        /// <param name="saveCopy">optional object saveCopy</param>
        /// <param name="addRecipient">optional object addRecipient</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailSend(object to, object cc, object subject, object body, object enclosures, object includeDocument, object returnReceipt, object bcc, object urgent, object saveCopy, object addRecipient)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailSend", new object[] { to, cc, subject, body, enclosures, includeDocument, returnReceipt, bcc, urgent, saveCopy, addRecipient });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailSend()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailSend");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="to">optional object to</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailSend(object to)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailSend", to);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="to">optional object to</param>
        /// <param name="cc">optional object cc</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailSend(object to, object cc)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailSend", to, cc);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="to">optional object to</param>
        /// <param name="cc">optional object cc</param>
        /// <param name="subject">optional object subject</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailSend(object to, object cc, object subject)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailSend", to, cc, subject);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="to">optional object to</param>
        /// <param name="cc">optional object cc</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="body">optional object body</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailSend(object to, object cc, object subject, object body)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailSend", to, cc, subject, body);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="to">optional object to</param>
        /// <param name="cc">optional object cc</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="body">optional object body</param>
        /// <param name="enclosures">optional object enclosures</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailSend(object to, object cc, object subject, object body, object enclosures)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailSend", new object[] { to, cc, subject, body, enclosures });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="to">optional object to</param>
        /// <param name="cc">optional object cc</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="body">optional object body</param>
        /// <param name="enclosures">optional object enclosures</param>
        /// <param name="includeDocument">optional object includeDocument</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailSend(object to, object cc, object subject, object body, object enclosures, object includeDocument)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailSend", new object[] { to, cc, subject, body, enclosures, includeDocument });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="to">optional object to</param>
        /// <param name="cc">optional object cc</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="body">optional object body</param>
        /// <param name="enclosures">optional object enclosures</param>
        /// <param name="includeDocument">optional object includeDocument</param>
        /// <param name="returnReceipt">optional object returnReceipt</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailSend(object to, object cc, object subject, object body, object enclosures, object includeDocument, object returnReceipt)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailSend", new object[] { to, cc, subject, body, enclosures, includeDocument, returnReceipt });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="to">optional object to</param>
        /// <param name="cc">optional object cc</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="body">optional object body</param>
        /// <param name="enclosures">optional object enclosures</param>
        /// <param name="includeDocument">optional object includeDocument</param>
        /// <param name="returnReceipt">optional object returnReceipt</param>
        /// <param name="bcc">optional object bcc</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailSend(object to, object cc, object subject, object body, object enclosures, object includeDocument, object returnReceipt, object bcc)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailSend", new object[] { to, cc, subject, body, enclosures, includeDocument, returnReceipt, bcc });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="to">optional object to</param>
        /// <param name="cc">optional object cc</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="body">optional object body</param>
        /// <param name="enclosures">optional object enclosures</param>
        /// <param name="includeDocument">optional object includeDocument</param>
        /// <param name="returnReceipt">optional object returnReceipt</param>
        /// <param name="bcc">optional object bcc</param>
        /// <param name="urgent">optional object urgent</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailSend(object to, object cc, object subject, object body, object enclosures, object includeDocument, object returnReceipt, object bcc, object urgent)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailSend", new object[] { to, cc, subject, body, enclosures, includeDocument, returnReceipt, bcc, urgent });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="to">optional object to</param>
        /// <param name="cc">optional object cc</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="body">optional object body</param>
        /// <param name="enclosures">optional object enclosures</param>
        /// <param name="includeDocument">optional object includeDocument</param>
        /// <param name="returnReceipt">optional object returnReceipt</param>
        /// <param name="bcc">optional object bcc</param>
        /// <param name="urgent">optional object urgent</param>
        /// <param name="saveCopy">optional object saveCopy</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailSend(object to, object cc, object subject, object body, object enclosures, object includeDocument, object returnReceipt, object bcc, object urgent, object saveCopy)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailSend", new object[] { to, cc, subject, body, enclosures, includeDocument, returnReceipt, bcc, urgent, saveCopy });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="manager">optional object manager</param>
        /// <param name="resources">optional object resources</param>
        /// <param name="taskContacts">optional object taskContacts</param>
        /// <param name="selection">optional object selection</param>
        /// <param name="includeDocument">optional object includeDocument</param>
        /// <param name="includePicture">optional object includePicture</param>
        /// <param name="body">optional object body</param>
        /// <param name="subject">optional object subject</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailSendScheduleNote(object manager, object resources, object taskContacts, object selection, object includeDocument, object includePicture, object body, object subject)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailSendScheduleNote", new object[] { manager, resources, taskContacts, selection, includeDocument, includePicture, body, subject });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailSendScheduleNote()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailSendScheduleNote");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="manager">optional object manager</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailSendScheduleNote(object manager)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailSendScheduleNote", manager);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="manager">optional object manager</param>
        /// <param name="resources">optional object resources</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailSendScheduleNote(object manager, object resources)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailSendScheduleNote", manager, resources);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="manager">optional object manager</param>
        /// <param name="resources">optional object resources</param>
        /// <param name="taskContacts">optional object taskContacts</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailSendScheduleNote(object manager, object resources, object taskContacts)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailSendScheduleNote", manager, resources, taskContacts);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="manager">optional object manager</param>
        /// <param name="resources">optional object resources</param>
        /// <param name="taskContacts">optional object taskContacts</param>
        /// <param name="selection">optional object selection</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailSendScheduleNote(object manager, object resources, object taskContacts, object selection)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailSendScheduleNote", manager, resources, taskContacts, selection);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="manager">optional object manager</param>
        /// <param name="resources">optional object resources</param>
        /// <param name="taskContacts">optional object taskContacts</param>
        /// <param name="selection">optional object selection</param>
        /// <param name="includeDocument">optional object includeDocument</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailSendScheduleNote(object manager, object resources, object taskContacts, object selection, object includeDocument)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailSendScheduleNote", new object[] { manager, resources, taskContacts, selection, includeDocument });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="manager">optional object manager</param>
        /// <param name="resources">optional object resources</param>
        /// <param name="taskContacts">optional object taskContacts</param>
        /// <param name="selection">optional object selection</param>
        /// <param name="includeDocument">optional object includeDocument</param>
        /// <param name="includePicture">optional object includePicture</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailSendScheduleNote(object manager, object resources, object taskContacts, object selection, object includeDocument, object includePicture)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailSendScheduleNote", new object[] { manager, resources, taskContacts, selection, includeDocument, includePicture });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="manager">optional object manager</param>
        /// <param name="resources">optional object resources</param>
        /// <param name="taskContacts">optional object taskContacts</param>
        /// <param name="selection">optional object selection</param>
        /// <param name="includeDocument">optional object includeDocument</param>
        /// <param name="includePicture">optional object includePicture</param>
        /// <param name="body">optional object body</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailSendScheduleNote(object manager, object resources, object taskContacts, object selection, object includeDocument, object includePicture, object body)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailSendScheduleNote", new object[] { manager, resources, taskContacts, selection, includeDocument, includePicture, body });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailPostDocument()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailPostDocument");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ODBCManageDataSources()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ODBCManageDataSources");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ODBCCreateDataSource()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ODBCCreateDataSource");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="to">optional object to</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="body">optional object body</param>
        /// <param name="allAtOnce">optional object allAtOnce</param>
        /// <param name="returnWhenDone">optional object returnWhenDone</param>
        /// <param name="trackStatus">optional object trackStatus</param>
        /// <param name="clear">optional object clear</param>
        /// <param name="sendNow">optional object sendNow</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailRoutingSlip(object to, object subject, object body, object allAtOnce, object returnWhenDone, object trackStatus, object clear, object sendNow)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailRoutingSlip", new object[] { to, subject, body, allAtOnce, returnWhenDone, trackStatus, clear, sendNow });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailRoutingSlip()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailRoutingSlip");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="to">optional object to</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailRoutingSlip(object to)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailRoutingSlip", to);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="to">optional object to</param>
        /// <param name="subject">optional object subject</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailRoutingSlip(object to, object subject)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailRoutingSlip", to, subject);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="to">optional object to</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="body">optional object body</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailRoutingSlip(object to, object subject, object body)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailRoutingSlip", to, subject, body);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="to">optional object to</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="body">optional object body</param>
        /// <param name="allAtOnce">optional object allAtOnce</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailRoutingSlip(object to, object subject, object body, object allAtOnce)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailRoutingSlip", to, subject, body, allAtOnce);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="to">optional object to</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="body">optional object body</param>
        /// <param name="allAtOnce">optional object allAtOnce</param>
        /// <param name="returnWhenDone">optional object returnWhenDone</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailRoutingSlip(object to, object subject, object body, object allAtOnce, object returnWhenDone)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailRoutingSlip", new object[] { to, subject, body, allAtOnce, returnWhenDone });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="to">optional object to</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="body">optional object body</param>
        /// <param name="allAtOnce">optional object allAtOnce</param>
        /// <param name="returnWhenDone">optional object returnWhenDone</param>
        /// <param name="trackStatus">optional object trackStatus</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailRoutingSlip(object to, object subject, object body, object allAtOnce, object returnWhenDone, object trackStatus)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailRoutingSlip", new object[] { to, subject, body, allAtOnce, returnWhenDone, trackStatus });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="to">optional object to</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="body">optional object body</param>
        /// <param name="allAtOnce">optional object allAtOnce</param>
        /// <param name="returnWhenDone">optional object returnWhenDone</param>
        /// <param name="trackStatus">optional object trackStatus</param>
        /// <param name="clear">optional object clear</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MailRoutingSlip(object to, object subject, object body, object allAtOnce, object returnWhenDone, object trackStatus, object clear)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MailRoutingSlip", new object[] { to, subject, body, allAtOnce, returnWhenDone, trackStatus, clear });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="number">optional object number</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileLoadLast(object number)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileLoadLast", number);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileLoadLast()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileLoadLast");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="save">optional NetOffice.MSProjectApi.Enums.PjSaveType Save = 2</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileExit(object save)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileExit", save);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FileExit()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FileExit");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MenuBars()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MenuBars");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="copy">optional object copy</param>
        /// <param name="create">optional object create</param>
        /// <param name="name">optional object name</param>
        /// <param name="newName">optional object newName</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MenuBarEdit(object copy, object create, object name, object newName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MenuBarEdit", copy, create, name, newName);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MenuBarEdit()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MenuBarEdit");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="copy">optional object copy</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MenuBarEdit(object copy)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MenuBarEdit", copy);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="copy">optional object copy</param>
        /// <param name="create">optional object create</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MenuBarEdit(object copy, object create)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MenuBarEdit", copy, create);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="copy">optional object copy</param>
        /// <param name="create">optional object create</param>
        /// <param name="name">optional object name</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MenuBarEdit(object copy, object create, object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MenuBarEdit", copy, create, name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="_default">optional object default</param>
        /// <param name="noFiles">optional object noFiles</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MenuBarApply(string name, object _default, object noFiles)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MenuBarApply", name, _default, noFiles);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MenuBarApply(string name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MenuBarApply", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="_default">optional object default</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool MenuBarApply(string name, object _default)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "MenuBarApply", name, _default);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditUndo()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditUndo");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditCut()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditCut");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditCopy()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditCopy");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="_object">object object</param>
        /// <param name="forPrinter">object forPrinter</param>
        /// <param name="selectedRows">object selectedRows</param>
        /// <param name="fromDate">object fromDate</param>
        /// <param name="toDate">object toDate</param>
        /// <param name="fileName">object fileName</param>
        /// <param name="scaleOption">optional NetOffice.MSProjectApi.Enums.PjCopyPictureScaleOption ScaleOption = 1</param>
        /// <param name="maxImageHeight">optional object maxImageHeight</param>
        /// <param name="maxImageWidth">optional object maxImageWidth</param>
        /// <param name="measurementUnits">optional object measurementUnits</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditCopyPicture(object _object, object forPrinter, object selectedRows, object fromDate, object toDate, object fileName, object scaleOption, object maxImageHeight, object maxImageWidth, object measurementUnits)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditCopyPicture", new object[] { _object, forPrinter, selectedRows, fromDate, toDate, fileName, scaleOption, maxImageHeight, maxImageWidth, measurementUnits });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="_object">object object</param>
        /// <param name="forPrinter">object forPrinter</param>
        /// <param name="selectedRows">object selectedRows</param>
        /// <param name="fromDate">object fromDate</param>
        /// <param name="toDate">object toDate</param>
        /// <param name="fileName">object fileName</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditCopyPicture(object _object, object forPrinter, object selectedRows, object fromDate, object toDate, object fileName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditCopyPicture", new object[] { _object, forPrinter, selectedRows, fromDate, toDate, fileName });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="_object">object object</param>
        /// <param name="forPrinter">object forPrinter</param>
        /// <param name="selectedRows">object selectedRows</param>
        /// <param name="fromDate">object fromDate</param>
        /// <param name="toDate">object toDate</param>
        /// <param name="fileName">object fileName</param>
        /// <param name="scaleOption">optional NetOffice.MSProjectApi.Enums.PjCopyPictureScaleOption ScaleOption = 1</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditCopyPicture(object _object, object forPrinter, object selectedRows, object fromDate, object toDate, object fileName, object scaleOption)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditCopyPicture", new object[] { _object, forPrinter, selectedRows, fromDate, toDate, fileName, scaleOption });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="_object">object object</param>
        /// <param name="forPrinter">object forPrinter</param>
        /// <param name="selectedRows">object selectedRows</param>
        /// <param name="fromDate">object fromDate</param>
        /// <param name="toDate">object toDate</param>
        /// <param name="fileName">object fileName</param>
        /// <param name="scaleOption">optional NetOffice.MSProjectApi.Enums.PjCopyPictureScaleOption ScaleOption = 1</param>
        /// <param name="maxImageHeight">optional object maxImageHeight</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditCopyPicture(object _object, object forPrinter, object selectedRows, object fromDate, object toDate, object fileName, object scaleOption, object maxImageHeight)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditCopyPicture", new object[] { _object, forPrinter, selectedRows, fromDate, toDate, fileName, scaleOption, maxImageHeight });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="_object">object object</param>
        /// <param name="forPrinter">object forPrinter</param>
        /// <param name="selectedRows">object selectedRows</param>
        /// <param name="fromDate">object fromDate</param>
        /// <param name="toDate">object toDate</param>
        /// <param name="fileName">object fileName</param>
        /// <param name="scaleOption">optional NetOffice.MSProjectApi.Enums.PjCopyPictureScaleOption ScaleOption = 1</param>
        /// <param name="maxImageHeight">optional object maxImageHeight</param>
        /// <param name="maxImageWidth">optional object maxImageWidth</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditCopyPicture(object _object, object forPrinter, object selectedRows, object fromDate, object toDate, object fileName, object scaleOption, object maxImageHeight, object maxImageWidth)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditCopyPicture", new object[] { _object, forPrinter, selectedRows, fromDate, toDate, fileName, scaleOption, maxImageHeight, maxImageWidth });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditPaste()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditPaste");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="link">optional object link</param>
        /// <param name="type">optional object type</param>
        /// <param name="displayAsIcon">optional object displayAsIcon</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditPasteSpecial(object link, object type, object displayAsIcon)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditPasteSpecial", link, type, displayAsIcon);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditPasteSpecial()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditPasteSpecial");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="link">optional object link</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditPasteSpecial(object link)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditPasteSpecial", link);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="link">optional object link</param>
        /// <param name="type">optional object type</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditPasteSpecial(object link, object type)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditPasteSpecial", link, type);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditClearFormats()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditClearFormats");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="contents">optional object contents</param>
        /// <param name="formats">optional object formats</param>
        /// <param name="notes">optional object notes</param>
        /// <param name="hyperlinks">optional object hyperlinks</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditClear(object contents, object formats, object notes, object hyperlinks)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditClear", contents, formats, notes, hyperlinks);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditClear()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditClear");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="contents">optional object contents</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditClear(object contents)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditClear", contents);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="contents">optional object contents</param>
        /// <param name="formats">optional object formats</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditClear(object contents, object formats)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditClear", contents, formats);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="contents">optional object contents</param>
        /// <param name="formats">optional object formats</param>
        /// <param name="notes">optional object notes</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditClear(object contents, object formats, object notes)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditClear", contents, formats, notes);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool RowClear()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "RowClear");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DDEPasteLink()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DDEPasteLink");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditDelete()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditDelete");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ColumnDelete()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ColumnDelete");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool RowDelete()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "RowDelete");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="verb">optional object verb</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ObjectVerb(object verb)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ObjectVerb", verb);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ObjectVerb()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ObjectVerb");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ObjectLinks()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ObjectLinks");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ObjectChangeIcon()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ObjectChangeIcon");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ObjectConvert()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ObjectConvert");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditInsert()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditInsert");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ColumnInsert()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ColumnInsert");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool RowInsert()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "RowInsert");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LinkTasks()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LinkTasks");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="from">Int32 from</param>
        /// <param name="to">Int32 to</param>
        /// <param name="delete">optional object delete</param>
        /// <param name="type">optional object type</param>
        /// <param name="lag">optional object lag</param>
        /// <param name="predecessorProjectName">optional object predecessorProjectName</param>
        /// <param name="successorProjectName">optional object successorProjectName</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LinkTasksEdit(Int32 from, Int32 to, object delete, object type, object lag, object predecessorProjectName, object successorProjectName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LinkTasksEdit", new object[] { from, to, delete, type, lag, predecessorProjectName, successorProjectName });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="from">Int32 from</param>
        /// <param name="to">Int32 to</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LinkTasksEdit(Int32 from, Int32 to)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LinkTasksEdit", from, to);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="from">Int32 from</param>
        /// <param name="to">Int32 to</param>
        /// <param name="delete">optional object delete</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LinkTasksEdit(Int32 from, Int32 to, object delete)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LinkTasksEdit", from, to, delete);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="from">Int32 from</param>
        /// <param name="to">Int32 to</param>
        /// <param name="delete">optional object delete</param>
        /// <param name="type">optional object type</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LinkTasksEdit(Int32 from, Int32 to, object delete, object type)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LinkTasksEdit", from, to, delete, type);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="from">Int32 from</param>
        /// <param name="to">Int32 to</param>
        /// <param name="delete">optional object delete</param>
        /// <param name="type">optional object type</param>
        /// <param name="lag">optional object lag</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LinkTasksEdit(Int32 from, Int32 to, object delete, object type, object lag)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LinkTasksEdit", new object[] { from, to, delete, type, lag });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="from">Int32 from</param>
        /// <param name="to">Int32 to</param>
        /// <param name="delete">optional object delete</param>
        /// <param name="type">optional object type</param>
        /// <param name="lag">optional object lag</param>
        /// <param name="predecessorProjectName">optional object predecessorProjectName</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LinkTasksEdit(Int32 from, Int32 to, object delete, object type, object lag, object predecessorProjectName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LinkTasksEdit", new object[] { from, to, delete, type, lag, predecessorProjectName });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool UnlinkTasks()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "UnlinkTasks");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="resources">object resources</param>
        /// <param name="operation">optional NetOffice.MSProjectApi.Enums.PjResAssignOperation Operation = 0</param>
        /// <param name="with">optional object with</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceAssignment(object resources, object operation, object with)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceAssignment", resources, operation, with);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="resources">object resources</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceAssignment(object resources)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceAssignment", resources);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="resources">object resources</param>
        /// <param name="operation">optional NetOffice.MSProjectApi.Enums.PjResAssignOperation Operation = 0</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceAssignment(object resources, object operation)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceAssignment", resources, operation);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="iD">optional object iD</param>
        /// <param name="date">optional object date</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditGoTo(object iD, object date)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditGoTo", iD, date);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditGoTo()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditGoTo");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="iD">optional object iD</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditGoTo(object iD)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditGoTo", iD);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GotoNextOverAllocation()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GotoNextOverAllocation");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool InsertNotes()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "InsertNotes");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">optional object field</param>
        /// <param name="test">optional object test</param>
        /// <param name="value">optional object value</param>
        /// <param name="next">optional object next</param>
        /// <param name="matchCase">optional object matchCase</param>
        /// <param name="fieldID">optional object fieldID</param>
        /// <param name="testID">optional object testID</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Find(object field, object test, object value, object next, object matchCase, object fieldID, object testID)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Find", new object[] { field, test, value, next, matchCase, fieldID, testID });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Find()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Find");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">optional object field</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Find(object field)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Find", field);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">optional object field</param>
        /// <param name="test">optional object test</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Find(object field, object test)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Find", field, test);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">optional object field</param>
        /// <param name="test">optional object test</param>
        /// <param name="value">optional object value</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Find(object field, object test, object value)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Find", field, test, value);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">optional object field</param>
        /// <param name="test">optional object test</param>
        /// <param name="value">optional object value</param>
        /// <param name="next">optional object next</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Find(object field, object test, object value, object next)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Find", field, test, value, next);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">optional object field</param>
        /// <param name="test">optional object test</param>
        /// <param name="value">optional object value</param>
        /// <param name="next">optional object next</param>
        /// <param name="matchCase">optional object matchCase</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Find(object field, object test, object value, object next, object matchCase)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Find", new object[] { field, test, value, next, matchCase });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">optional object field</param>
        /// <param name="test">optional object test</param>
        /// <param name="value">optional object value</param>
        /// <param name="next">optional object next</param>
        /// <param name="matchCase">optional object matchCase</param>
        /// <param name="fieldID">optional object fieldID</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Find(object field, object test, object value, object next, object matchCase, object fieldID)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Find", new object[] { field, test, value, next, matchCase, fieldID });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">optional object field</param>
        /// <param name="test">optional object test</param>
        /// <param name="value">optional object value</param>
        /// <param name="replacement">optional object replacement</param>
        /// <param name="replaceAll">optional object replaceAll</param>
        /// <param name="next">optional object next</param>
        /// <param name="matchCase">optional object matchCase</param>
        /// <param name="fieldID">optional object fieldID</param>
        /// <param name="testID">optional object testID</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Replace(object field, object test, object value, object replacement, object replaceAll, object next, object matchCase, object fieldID, object testID)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Replace", new object[] { field, test, value, replacement, replaceAll, next, matchCase, fieldID, testID });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Replace()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Replace");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">optional object field</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Replace(object field)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Replace", field);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">optional object field</param>
        /// <param name="test">optional object test</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Replace(object field, object test)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Replace", field, test);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">optional object field</param>
        /// <param name="test">optional object test</param>
        /// <param name="value">optional object value</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Replace(object field, object test, object value)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Replace", field, test, value);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">optional object field</param>
        /// <param name="test">optional object test</param>
        /// <param name="value">optional object value</param>
        /// <param name="replacement">optional object replacement</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Replace(object field, object test, object value, object replacement)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Replace", field, test, value, replacement);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">optional object field</param>
        /// <param name="test">optional object test</param>
        /// <param name="value">optional object value</param>
        /// <param name="replacement">optional object replacement</param>
        /// <param name="replaceAll">optional object replaceAll</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Replace(object field, object test, object value, object replacement, object replaceAll)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Replace", new object[] { field, test, value, replacement, replaceAll });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">optional object field</param>
        /// <param name="test">optional object test</param>
        /// <param name="value">optional object value</param>
        /// <param name="replacement">optional object replacement</param>
        /// <param name="replaceAll">optional object replaceAll</param>
        /// <param name="next">optional object next</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Replace(object field, object test, object value, object replacement, object replaceAll, object next)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Replace", new object[] { field, test, value, replacement, replaceAll, next });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">optional object field</param>
        /// <param name="test">optional object test</param>
        /// <param name="value">optional object value</param>
        /// <param name="replacement">optional object replacement</param>
        /// <param name="replaceAll">optional object replaceAll</param>
        /// <param name="next">optional object next</param>
        /// <param name="matchCase">optional object matchCase</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Replace(object field, object test, object value, object replacement, object replaceAll, object next, object matchCase)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Replace", new object[] { field, test, value, replacement, replaceAll, next, matchCase });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">optional object field</param>
        /// <param name="test">optional object test</param>
        /// <param name="value">optional object value</param>
        /// <param name="replacement">optional object replacement</param>
        /// <param name="replaceAll">optional object replaceAll</param>
        /// <param name="next">optional object next</param>
        /// <param name="matchCase">optional object matchCase</param>
        /// <param name="fieldID">optional object fieldID</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Replace(object field, object test, object value, object replacement, object replaceAll, object next, object matchCase, object fieldID)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Replace", new object[] { field, test, value, replacement, replaceAll, next, matchCase, fieldID });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectAll()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectAll");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ObjectInsert()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ObjectInsert");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="edition">object edition</param>
        /// <param name="format">optional NetOffice.MSProjectApi.Enums.PjSubscribeFormat Format = 1</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SubscribeTo(object edition, object format)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SubscribeTo", edition, format);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="edition">object edition</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SubscribeTo(object edition)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SubscribeTo", edition);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="isTask">optional object isTask</param>
        /// <param name="uniqueID">optional object uniqueID</param>
        /// <param name="field">optional object field</param>
        /// <param name="automatically">optional object automatically</param>
        /// <param name="action">optional object action</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SubscriberOptions(object name, object isTask, object uniqueID, object field, object automatically, object action)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SubscriberOptions", new object[] { name, isTask, uniqueID, field, automatically, action });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SubscriberOptions()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SubscriberOptions");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SubscriberOptions(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SubscriberOptions", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="isTask">optional object isTask</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SubscriberOptions(object name, object isTask)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SubscriberOptions", name, isTask);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="isTask">optional object isTask</param>
        /// <param name="uniqueID">optional object uniqueID</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SubscriberOptions(object name, object isTask, object uniqueID)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SubscriberOptions", name, isTask, uniqueID);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="isTask">optional object isTask</param>
        /// <param name="uniqueID">optional object uniqueID</param>
        /// <param name="field">optional object field</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SubscriberOptions(object name, object isTask, object uniqueID, object field)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SubscriberOptions", name, isTask, uniqueID, field);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="isTask">optional object isTask</param>
        /// <param name="uniqueID">optional object uniqueID</param>
        /// <param name="field">optional object field</param>
        /// <param name="automatically">optional object automatically</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SubscriberOptions(object name, object isTask, object uniqueID, object field, object automatically)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SubscriberOptions", new object[] { name, isTask, uniqueID, field, automatically });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="edition">optional object edition</param>
        /// <param name="contains">optional object contains</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool CreatePublisher(object edition, object contains)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "CreatePublisher", edition, contains);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool CreatePublisher()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "CreatePublisher");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="edition">optional object edition</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool CreatePublisher(object edition)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "CreatePublisher", edition);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="view">optional object view</param>
        /// <param name="isTask">optional object isTask</param>
        /// <param name="uniqueID">optional object uniqueID</param>
        /// <param name="field">optional object field</param>
        /// <param name="onSave">optional object onSave</param>
        /// <param name="action">optional object action</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PublisherOptions(object name, object view, object isTask, object uniqueID, object field, object onSave, object action)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PublisherOptions", new object[] { name, view, isTask, uniqueID, field, onSave, action });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PublisherOptions()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PublisherOptions");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PublisherOptions(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PublisherOptions", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="view">optional object view</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PublisherOptions(object name, object view)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PublisherOptions", name, view);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="view">optional object view</param>
        /// <param name="isTask">optional object isTask</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PublisherOptions(object name, object view, object isTask)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PublisherOptions", name, view, isTask);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="view">optional object view</param>
        /// <param name="isTask">optional object isTask</param>
        /// <param name="uniqueID">optional object uniqueID</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PublisherOptions(object name, object view, object isTask, object uniqueID)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PublisherOptions", name, view, isTask, uniqueID);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="view">optional object view</param>
        /// <param name="isTask">optional object isTask</param>
        /// <param name="uniqueID">optional object uniqueID</param>
        /// <param name="field">optional object field</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PublisherOptions(object name, object view, object isTask, object uniqueID, object field)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PublisherOptions", new object[] { name, view, isTask, uniqueID, field });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="view">optional object view</param>
        /// <param name="isTask">optional object isTask</param>
        /// <param name="uniqueID">optional object uniqueID</param>
        /// <param name="field">optional object field</param>
        /// <param name="onSave">optional object onSave</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PublisherOptions(object name, object view, object isTask, object uniqueID, object field, object onSave)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PublisherOptions", new object[] { name, view, isTask, uniqueID, field, onSave });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="stop">optional object stop</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditionStopAll(object stop)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditionStopAll", stop);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool EditionStopAll()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "EditionStopAll");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ClipboardShow()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ClipboardShow");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="singlePane">optional object singlePane</param>
        /// <param name="toggle">optional object toggle</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewApply(object name, object singlePane, object toggle)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewApply", name, singlePane, toggle);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewApply()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewApply");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewApply(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewApply", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="singlePane">optional object singlePane</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewApply(object name, object singlePane)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewApply", name, singlePane);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="create">optional object create</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="screen">optional object screen</param>
        /// <param name="showInMenu">optional object showInMenu</param>
        /// <param name="highlightFilter">optional object highlightFilter</param>
        /// <param name="table">optional object table</param>
        /// <param name="filter">optional object filter</param>
        /// <param name="group">optional object group</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewEditSingle(object name, object create, object newName, object screen, object showInMenu, object highlightFilter, object table, object filter, object group)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewEditSingle", new object[] { name, create, newName, screen, showInMenu, highlightFilter, table, filter, group });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewEditSingle()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewEditSingle");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewEditSingle(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewEditSingle", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="create">optional object create</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewEditSingle(object name, object create)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewEditSingle", name, create);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="create">optional object create</param>
        /// <param name="newName">optional object newName</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewEditSingle(object name, object create, object newName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewEditSingle", name, create, newName);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="create">optional object create</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="screen">optional object screen</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewEditSingle(object name, object create, object newName, object screen)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewEditSingle", name, create, newName, screen);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="create">optional object create</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="screen">optional object screen</param>
        /// <param name="showInMenu">optional object showInMenu</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewEditSingle(object name, object create, object newName, object screen, object showInMenu)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewEditSingle", new object[] { name, create, newName, screen, showInMenu });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="create">optional object create</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="screen">optional object screen</param>
        /// <param name="showInMenu">optional object showInMenu</param>
        /// <param name="highlightFilter">optional object highlightFilter</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewEditSingle(object name, object create, object newName, object screen, object showInMenu, object highlightFilter)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewEditSingle", new object[] { name, create, newName, screen, showInMenu, highlightFilter });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="create">optional object create</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="screen">optional object screen</param>
        /// <param name="showInMenu">optional object showInMenu</param>
        /// <param name="highlightFilter">optional object highlightFilter</param>
        /// <param name="table">optional object table</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewEditSingle(object name, object create, object newName, object screen, object showInMenu, object highlightFilter, object table)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewEditSingle", new object[] { name, create, newName, screen, showInMenu, highlightFilter, table });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="create">optional object create</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="screen">optional object screen</param>
        /// <param name="showInMenu">optional object showInMenu</param>
        /// <param name="highlightFilter">optional object highlightFilter</param>
        /// <param name="table">optional object table</param>
        /// <param name="filter">optional object filter</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewEditSingle(object name, object create, object newName, object screen, object showInMenu, object highlightFilter, object table, object filter)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewEditSingle", new object[] { name, create, newName, screen, showInMenu, highlightFilter, table, filter });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="create">optional object create</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="topView">optional object topView</param>
        /// <param name="bottomView">optional object bottomView</param>
        /// <param name="showInMenu">optional object showInMenu</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewEditCombination(object name, object create, object newName, object topView, object bottomView, object showInMenu)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewEditCombination", new object[] { name, create, newName, topView, bottomView, showInMenu });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewEditCombination()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewEditCombination");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewEditCombination(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewEditCombination", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="create">optional object create</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewEditCombination(object name, object create)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewEditCombination", name, create);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="create">optional object create</param>
        /// <param name="newName">optional object newName</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewEditCombination(object name, object create, object newName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewEditCombination", name, create, newName);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="create">optional object create</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="topView">optional object topView</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewEditCombination(object name, object create, object newName, object topView)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewEditCombination", name, create, newName, topView);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="create">optional object create</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="topView">optional object topView</param>
        /// <param name="bottomView">optional object bottomView</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewEditCombination(object name, object create, object newName, object topView, object bottomView)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewEditCombination", new object[] { name, create, newName, topView, bottomView });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TableApply(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TableApply", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TableApply()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TableApply");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskTable">bool taskTable</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="fieldName">optional object fieldName</param>
        /// <param name="newFieldName">optional object newFieldName</param>
        /// <param name="title">optional object title</param>
        /// <param name="width">optional object width</param>
        /// <param name="align">optional object align</param>
        /// <param name="showInMenu">optional object showInMenu</param>
        /// <param name="lockFirstColumn">optional object lockFirstColumn</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="rowHeight">optional object rowHeight</param>
        /// <param name="columnPosition">optional object columnPosition</param>
        /// <param name="alignTitle">optional object alignTitle</param>
        /// <param name="headerAutoRowHeightAdjustment">optional object headerAutoRowHeightAdjustment</param>
        /// <param name="headerTextWrap">optional object headerTextWrap</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TableEdit(string name, bool taskTable, object create, object overwriteExisting, object newName, object fieldName, object newFieldName, object title, object width, object align, object showInMenu, object lockFirstColumn, object dateFormat, object rowHeight, object columnPosition, object alignTitle, object headerAutoRowHeightAdjustment, object headerTextWrap)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TableEdit", new object[] { name, taskTable, create, overwriteExisting, newName, fieldName, newFieldName, title, width, align, showInMenu, lockFirstColumn, dateFormat, rowHeight, columnPosition, alignTitle, headerAutoRowHeightAdjustment, headerTextWrap });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskTable">bool taskTable</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TableEdit(string name, bool taskTable)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TableEdit", name, taskTable);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskTable">bool taskTable</param>
        /// <param name="create">optional object create</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TableEdit(string name, bool taskTable, object create)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TableEdit", name, taskTable, create);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskTable">bool taskTable</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TableEdit(string name, bool taskTable, object create, object overwriteExisting)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TableEdit", name, taskTable, create, overwriteExisting);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskTable">bool taskTable</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="newName">optional object newName</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TableEdit(string name, bool taskTable, object create, object overwriteExisting, object newName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TableEdit", new object[] { name, taskTable, create, overwriteExisting, newName });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskTable">bool taskTable</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="fieldName">optional object fieldName</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TableEdit(string name, bool taskTable, object create, object overwriteExisting, object newName, object fieldName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TableEdit", new object[] { name, taskTable, create, overwriteExisting, newName, fieldName });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskTable">bool taskTable</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="fieldName">optional object fieldName</param>
        /// <param name="newFieldName">optional object newFieldName</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TableEdit(string name, bool taskTable, object create, object overwriteExisting, object newName, object fieldName, object newFieldName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TableEdit", new object[] { name, taskTable, create, overwriteExisting, newName, fieldName, newFieldName });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskTable">bool taskTable</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="fieldName">optional object fieldName</param>
        /// <param name="newFieldName">optional object newFieldName</param>
        /// <param name="title">optional object title</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TableEdit(string name, bool taskTable, object create, object overwriteExisting, object newName, object fieldName, object newFieldName, object title)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TableEdit", new object[] { name, taskTable, create, overwriteExisting, newName, fieldName, newFieldName, title });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskTable">bool taskTable</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="fieldName">optional object fieldName</param>
        /// <param name="newFieldName">optional object newFieldName</param>
        /// <param name="title">optional object title</param>
        /// <param name="width">optional object width</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TableEdit(string name, bool taskTable, object create, object overwriteExisting, object newName, object fieldName, object newFieldName, object title, object width)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TableEdit", new object[] { name, taskTable, create, overwriteExisting, newName, fieldName, newFieldName, title, width });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskTable">bool taskTable</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="fieldName">optional object fieldName</param>
        /// <param name="newFieldName">optional object newFieldName</param>
        /// <param name="title">optional object title</param>
        /// <param name="width">optional object width</param>
        /// <param name="align">optional object align</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TableEdit(string name, bool taskTable, object create, object overwriteExisting, object newName, object fieldName, object newFieldName, object title, object width, object align)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TableEdit", new object[] { name, taskTable, create, overwriteExisting, newName, fieldName, newFieldName, title, width, align });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskTable">bool taskTable</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="fieldName">optional object fieldName</param>
        /// <param name="newFieldName">optional object newFieldName</param>
        /// <param name="title">optional object title</param>
        /// <param name="width">optional object width</param>
        /// <param name="align">optional object align</param>
        /// <param name="showInMenu">optional object showInMenu</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TableEdit(string name, bool taskTable, object create, object overwriteExisting, object newName, object fieldName, object newFieldName, object title, object width, object align, object showInMenu)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TableEdit", new object[] { name, taskTable, create, overwriteExisting, newName, fieldName, newFieldName, title, width, align, showInMenu });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskTable">bool taskTable</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="fieldName">optional object fieldName</param>
        /// <param name="newFieldName">optional object newFieldName</param>
        /// <param name="title">optional object title</param>
        /// <param name="width">optional object width</param>
        /// <param name="align">optional object align</param>
        /// <param name="showInMenu">optional object showInMenu</param>
        /// <param name="lockFirstColumn">optional object lockFirstColumn</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TableEdit(string name, bool taskTable, object create, object overwriteExisting, object newName, object fieldName, object newFieldName, object title, object width, object align, object showInMenu, object lockFirstColumn)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TableEdit", new object[] { name, taskTable, create, overwriteExisting, newName, fieldName, newFieldName, title, width, align, showInMenu, lockFirstColumn });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskTable">bool taskTable</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="fieldName">optional object fieldName</param>
        /// <param name="newFieldName">optional object newFieldName</param>
        /// <param name="title">optional object title</param>
        /// <param name="width">optional object width</param>
        /// <param name="align">optional object align</param>
        /// <param name="showInMenu">optional object showInMenu</param>
        /// <param name="lockFirstColumn">optional object lockFirstColumn</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TableEdit(string name, bool taskTable, object create, object overwriteExisting, object newName, object fieldName, object newFieldName, object title, object width, object align, object showInMenu, object lockFirstColumn, object dateFormat)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TableEdit", new object[] { name, taskTable, create, overwriteExisting, newName, fieldName, newFieldName, title, width, align, showInMenu, lockFirstColumn, dateFormat });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskTable">bool taskTable</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="fieldName">optional object fieldName</param>
        /// <param name="newFieldName">optional object newFieldName</param>
        /// <param name="title">optional object title</param>
        /// <param name="width">optional object width</param>
        /// <param name="align">optional object align</param>
        /// <param name="showInMenu">optional object showInMenu</param>
        /// <param name="lockFirstColumn">optional object lockFirstColumn</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="rowHeight">optional object rowHeight</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TableEdit(string name, bool taskTable, object create, object overwriteExisting, object newName, object fieldName, object newFieldName, object title, object width, object align, object showInMenu, object lockFirstColumn, object dateFormat, object rowHeight)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TableEdit", new object[] { name, taskTable, create, overwriteExisting, newName, fieldName, newFieldName, title, width, align, showInMenu, lockFirstColumn, dateFormat, rowHeight });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskTable">bool taskTable</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="fieldName">optional object fieldName</param>
        /// <param name="newFieldName">optional object newFieldName</param>
        /// <param name="title">optional object title</param>
        /// <param name="width">optional object width</param>
        /// <param name="align">optional object align</param>
        /// <param name="showInMenu">optional object showInMenu</param>
        /// <param name="lockFirstColumn">optional object lockFirstColumn</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="rowHeight">optional object rowHeight</param>
        /// <param name="columnPosition">optional object columnPosition</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TableEdit(string name, bool taskTable, object create, object overwriteExisting, object newName, object fieldName, object newFieldName, object title, object width, object align, object showInMenu, object lockFirstColumn, object dateFormat, object rowHeight, object columnPosition)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TableEdit", new object[] { name, taskTable, create, overwriteExisting, newName, fieldName, newFieldName, title, width, align, showInMenu, lockFirstColumn, dateFormat, rowHeight, columnPosition });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskTable">bool taskTable</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="fieldName">optional object fieldName</param>
        /// <param name="newFieldName">optional object newFieldName</param>
        /// <param name="title">optional object title</param>
        /// <param name="width">optional object width</param>
        /// <param name="align">optional object align</param>
        /// <param name="showInMenu">optional object showInMenu</param>
        /// <param name="lockFirstColumn">optional object lockFirstColumn</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="rowHeight">optional object rowHeight</param>
        /// <param name="columnPosition">optional object columnPosition</param>
        /// <param name="alignTitle">optional object alignTitle</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TableEdit(string name, bool taskTable, object create, object overwriteExisting, object newName, object fieldName, object newFieldName, object title, object width, object align, object showInMenu, object lockFirstColumn, object dateFormat, object rowHeight, object columnPosition, object alignTitle)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TableEdit", new object[] { name, taskTable, create, overwriteExisting, newName, fieldName, newFieldName, title, width, align, showInMenu, lockFirstColumn, dateFormat, rowHeight, columnPosition, alignTitle });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskTable">bool taskTable</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="fieldName">optional object fieldName</param>
        /// <param name="newFieldName">optional object newFieldName</param>
        /// <param name="title">optional object title</param>
        /// <param name="width">optional object width</param>
        /// <param name="align">optional object align</param>
        /// <param name="showInMenu">optional object showInMenu</param>
        /// <param name="lockFirstColumn">optional object lockFirstColumn</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="rowHeight">optional object rowHeight</param>
        /// <param name="columnPosition">optional object columnPosition</param>
        /// <param name="alignTitle">optional object alignTitle</param>
        /// <param name="headerAutoRowHeightAdjustment">optional object headerAutoRowHeightAdjustment</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TableEdit(string name, bool taskTable, object create, object overwriteExisting, object newName, object fieldName, object newFieldName, object title, object width, object align, object showInMenu, object lockFirstColumn, object dateFormat, object rowHeight, object columnPosition, object alignTitle, object headerAutoRowHeightAdjustment)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TableEdit", new object[] { name, taskTable, create, overwriteExisting, newName, fieldName, newFieldName, title, width, align, showInMenu, lockFirstColumn, dateFormat, rowHeight, columnPosition, alignTitle, headerAutoRowHeightAdjustment });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="highlight">optional object highlight</param>
        /// <param name="value1">optional object value1</param>
        /// <param name="value2">optional object value2</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilterApply(object name, object highlight, object value1, object value2)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilterApply", name, highlight, value1, value2);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilterApply()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilterApply");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilterApply(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilterApply", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="highlight">optional object highlight</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilterApply(object name, object highlight)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilterApply", name, highlight);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="highlight">optional object highlight</param>
        /// <param name="value1">optional object value1</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilterApply(object name, object highlight, object value1)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilterApply", name, highlight, value1);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskFilter">bool taskFilter</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="parenthesis">optional object parenthesis</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="fieldName">optional object fieldName</param>
        /// <param name="newFieldName">optional object newFieldName</param>
        /// <param name="test">optional object test</param>
        /// <param name="value">optional object value</param>
        /// <param name="operation">optional object operation</param>
        /// <param name="showInMenu">optional object showInMenu</param>
        /// <param name="showSummaryTasks">optional object showSummaryTasks</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilterEdit(string name, bool taskFilter, object create, object overwriteExisting, object parenthesis, object newName, object fieldName, object newFieldName, object test, object value, object operation, object showInMenu, object showSummaryTasks)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilterEdit", new object[] { name, taskFilter, create, overwriteExisting, parenthesis, newName, fieldName, newFieldName, test, value, operation, showInMenu, showSummaryTasks });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskFilter">bool taskFilter</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilterEdit(string name, bool taskFilter)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilterEdit", name, taskFilter);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskFilter">bool taskFilter</param>
        /// <param name="create">optional object create</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilterEdit(string name, bool taskFilter, object create)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilterEdit", name, taskFilter, create);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskFilter">bool taskFilter</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilterEdit(string name, bool taskFilter, object create, object overwriteExisting)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilterEdit", name, taskFilter, create, overwriteExisting);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskFilter">bool taskFilter</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="parenthesis">optional object parenthesis</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilterEdit(string name, bool taskFilter, object create, object overwriteExisting, object parenthesis)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilterEdit", new object[] { name, taskFilter, create, overwriteExisting, parenthesis });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskFilter">bool taskFilter</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="parenthesis">optional object parenthesis</param>
        /// <param name="newName">optional object newName</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilterEdit(string name, bool taskFilter, object create, object overwriteExisting, object parenthesis, object newName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilterEdit", new object[] { name, taskFilter, create, overwriteExisting, parenthesis, newName });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskFilter">bool taskFilter</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="parenthesis">optional object parenthesis</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="fieldName">optional object fieldName</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilterEdit(string name, bool taskFilter, object create, object overwriteExisting, object parenthesis, object newName, object fieldName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilterEdit", new object[] { name, taskFilter, create, overwriteExisting, parenthesis, newName, fieldName });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskFilter">bool taskFilter</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="parenthesis">optional object parenthesis</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="fieldName">optional object fieldName</param>
        /// <param name="newFieldName">optional object newFieldName</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilterEdit(string name, bool taskFilter, object create, object overwriteExisting, object parenthesis, object newName, object fieldName, object newFieldName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilterEdit", new object[] { name, taskFilter, create, overwriteExisting, parenthesis, newName, fieldName, newFieldName });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskFilter">bool taskFilter</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="parenthesis">optional object parenthesis</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="fieldName">optional object fieldName</param>
        /// <param name="newFieldName">optional object newFieldName</param>
        /// <param name="test">optional object test</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilterEdit(string name, bool taskFilter, object create, object overwriteExisting, object parenthesis, object newName, object fieldName, object newFieldName, object test)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilterEdit", new object[] { name, taskFilter, create, overwriteExisting, parenthesis, newName, fieldName, newFieldName, test });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskFilter">bool taskFilter</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="parenthesis">optional object parenthesis</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="fieldName">optional object fieldName</param>
        /// <param name="newFieldName">optional object newFieldName</param>
        /// <param name="test">optional object test</param>
        /// <param name="value">optional object value</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilterEdit(string name, bool taskFilter, object create, object overwriteExisting, object parenthesis, object newName, object fieldName, object newFieldName, object test, object value)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilterEdit", new object[] { name, taskFilter, create, overwriteExisting, parenthesis, newName, fieldName, newFieldName, test, value });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskFilter">bool taskFilter</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="parenthesis">optional object parenthesis</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="fieldName">optional object fieldName</param>
        /// <param name="newFieldName">optional object newFieldName</param>
        /// <param name="test">optional object test</param>
        /// <param name="value">optional object value</param>
        /// <param name="operation">optional object operation</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilterEdit(string name, bool taskFilter, object create, object overwriteExisting, object parenthesis, object newName, object fieldName, object newFieldName, object test, object value, object operation)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilterEdit", new object[] { name, taskFilter, create, overwriteExisting, parenthesis, newName, fieldName, newFieldName, test, value, operation });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="taskFilter">bool taskFilter</param>
        /// <param name="create">optional object create</param>
        /// <param name="overwriteExisting">optional object overwriteExisting</param>
        /// <param name="parenthesis">optional object parenthesis</param>
        /// <param name="newName">optional object newName</param>
        /// <param name="fieldName">optional object fieldName</param>
        /// <param name="newFieldName">optional object newFieldName</param>
        /// <param name="test">optional object test</param>
        /// <param name="value">optional object value</param>
        /// <param name="operation">optional object operation</param>
        /// <param name="showInMenu">optional object showInMenu</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FilterEdit(string name, bool taskFilter, object create, object overwriteExisting, object parenthesis, object newName, object fieldName, object newFieldName, object test, object value, object operation, object showInMenu)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FilterEdit", new object[] { name, taskFilter, create, overwriteExisting, parenthesis, newName, fieldName, newFieldName, test, value, operation, showInMenu });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="project">optional object project</param>
        /// <param name="title">optional object title</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="author">optional object author</param>
        /// <param name="company">optional object company</param>
        /// <param name="manager">optional object manager</param>
        /// <param name="keywords">optional object keywords</param>
        /// <param name="comments">optional object comments</param>
        /// <param name="start">optional object start</param>
        /// <param name="finish">optional object finish</param>
        /// <param name="scheduleFrom">optional object scheduleFrom</param>
        /// <param name="currentDate">optional object currentDate</param>
        /// <param name="calendar">optional object calendar</param>
        /// <param name="statusDate">optional object statusDate</param>
        /// <param name="priority">optional object priority</param>
        /// <param name="partiallyDisabled">optional object partiallyDisabled</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ProjectSummaryInfo(object project, object title, object subject, object author, object company, object manager, object keywords, object comments, object start, object finish, object scheduleFrom, object currentDate, object calendar, object statusDate, object priority, object partiallyDisabled)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ProjectSummaryInfo", new object[] { project, title, subject, author, company, manager, keywords, comments, start, finish, scheduleFrom, currentDate, calendar, statusDate, priority, partiallyDisabled });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ProjectSummaryInfo()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ProjectSummaryInfo");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="project">optional object project</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ProjectSummaryInfo(object project)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ProjectSummaryInfo", project);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="project">optional object project</param>
        /// <param name="title">optional object title</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ProjectSummaryInfo(object project, object title)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ProjectSummaryInfo", project, title);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="project">optional object project</param>
        /// <param name="title">optional object title</param>
        /// <param name="subject">optional object subject</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ProjectSummaryInfo(object project, object title, object subject)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ProjectSummaryInfo", project, title, subject);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="project">optional object project</param>
        /// <param name="title">optional object title</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="author">optional object author</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ProjectSummaryInfo(object project, object title, object subject, object author)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ProjectSummaryInfo", project, title, subject, author);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="project">optional object project</param>
        /// <param name="title">optional object title</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="author">optional object author</param>
        /// <param name="company">optional object company</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ProjectSummaryInfo(object project, object title, object subject, object author, object company)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ProjectSummaryInfo", new object[] { project, title, subject, author, company });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="project">optional object project</param>
        /// <param name="title">optional object title</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="author">optional object author</param>
        /// <param name="company">optional object company</param>
        /// <param name="manager">optional object manager</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ProjectSummaryInfo(object project, object title, object subject, object author, object company, object manager)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ProjectSummaryInfo", new object[] { project, title, subject, author, company, manager });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="project">optional object project</param>
        /// <param name="title">optional object title</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="author">optional object author</param>
        /// <param name="company">optional object company</param>
        /// <param name="manager">optional object manager</param>
        /// <param name="keywords">optional object keywords</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ProjectSummaryInfo(object project, object title, object subject, object author, object company, object manager, object keywords)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ProjectSummaryInfo", new object[] { project, title, subject, author, company, manager, keywords });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="project">optional object project</param>
        /// <param name="title">optional object title</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="author">optional object author</param>
        /// <param name="company">optional object company</param>
        /// <param name="manager">optional object manager</param>
        /// <param name="keywords">optional object keywords</param>
        /// <param name="comments">optional object comments</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ProjectSummaryInfo(object project, object title, object subject, object author, object company, object manager, object keywords, object comments)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ProjectSummaryInfo", new object[] { project, title, subject, author, company, manager, keywords, comments });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="project">optional object project</param>
        /// <param name="title">optional object title</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="author">optional object author</param>
        /// <param name="company">optional object company</param>
        /// <param name="manager">optional object manager</param>
        /// <param name="keywords">optional object keywords</param>
        /// <param name="comments">optional object comments</param>
        /// <param name="start">optional object start</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ProjectSummaryInfo(object project, object title, object subject, object author, object company, object manager, object keywords, object comments, object start)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ProjectSummaryInfo", new object[] { project, title, subject, author, company, manager, keywords, comments, start });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="project">optional object project</param>
        /// <param name="title">optional object title</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="author">optional object author</param>
        /// <param name="company">optional object company</param>
        /// <param name="manager">optional object manager</param>
        /// <param name="keywords">optional object keywords</param>
        /// <param name="comments">optional object comments</param>
        /// <param name="start">optional object start</param>
        /// <param name="finish">optional object finish</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ProjectSummaryInfo(object project, object title, object subject, object author, object company, object manager, object keywords, object comments, object start, object finish)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ProjectSummaryInfo", new object[] { project, title, subject, author, company, manager, keywords, comments, start, finish });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="project">optional object project</param>
        /// <param name="title">optional object title</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="author">optional object author</param>
        /// <param name="company">optional object company</param>
        /// <param name="manager">optional object manager</param>
        /// <param name="keywords">optional object keywords</param>
        /// <param name="comments">optional object comments</param>
        /// <param name="start">optional object start</param>
        /// <param name="finish">optional object finish</param>
        /// <param name="scheduleFrom">optional object scheduleFrom</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ProjectSummaryInfo(object project, object title, object subject, object author, object company, object manager, object keywords, object comments, object start, object finish, object scheduleFrom)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ProjectSummaryInfo", new object[] { project, title, subject, author, company, manager, keywords, comments, start, finish, scheduleFrom });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="project">optional object project</param>
        /// <param name="title">optional object title</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="author">optional object author</param>
        /// <param name="company">optional object company</param>
        /// <param name="manager">optional object manager</param>
        /// <param name="keywords">optional object keywords</param>
        /// <param name="comments">optional object comments</param>
        /// <param name="start">optional object start</param>
        /// <param name="finish">optional object finish</param>
        /// <param name="scheduleFrom">optional object scheduleFrom</param>
        /// <param name="currentDate">optional object currentDate</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ProjectSummaryInfo(object project, object title, object subject, object author, object company, object manager, object keywords, object comments, object start, object finish, object scheduleFrom, object currentDate)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ProjectSummaryInfo", new object[] { project, title, subject, author, company, manager, keywords, comments, start, finish, scheduleFrom, currentDate });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="project">optional object project</param>
        /// <param name="title">optional object title</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="author">optional object author</param>
        /// <param name="company">optional object company</param>
        /// <param name="manager">optional object manager</param>
        /// <param name="keywords">optional object keywords</param>
        /// <param name="comments">optional object comments</param>
        /// <param name="start">optional object start</param>
        /// <param name="finish">optional object finish</param>
        /// <param name="scheduleFrom">optional object scheduleFrom</param>
        /// <param name="currentDate">optional object currentDate</param>
        /// <param name="calendar">optional object calendar</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ProjectSummaryInfo(object project, object title, object subject, object author, object company, object manager, object keywords, object comments, object start, object finish, object scheduleFrom, object currentDate, object calendar)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ProjectSummaryInfo", new object[] { project, title, subject, author, company, manager, keywords, comments, start, finish, scheduleFrom, currentDate, calendar });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="project">optional object project</param>
        /// <param name="title">optional object title</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="author">optional object author</param>
        /// <param name="company">optional object company</param>
        /// <param name="manager">optional object manager</param>
        /// <param name="keywords">optional object keywords</param>
        /// <param name="comments">optional object comments</param>
        /// <param name="start">optional object start</param>
        /// <param name="finish">optional object finish</param>
        /// <param name="scheduleFrom">optional object scheduleFrom</param>
        /// <param name="currentDate">optional object currentDate</param>
        /// <param name="calendar">optional object calendar</param>
        /// <param name="statusDate">optional object statusDate</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ProjectSummaryInfo(object project, object title, object subject, object author, object company, object manager, object keywords, object comments, object start, object finish, object scheduleFrom, object currentDate, object calendar, object statusDate)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ProjectSummaryInfo", new object[] { project, title, subject, author, company, manager, keywords, comments, start, finish, scheduleFrom, currentDate, calendar, statusDate });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="project">optional object project</param>
        /// <param name="title">optional object title</param>
        /// <param name="subject">optional object subject</param>
        /// <param name="author">optional object author</param>
        /// <param name="company">optional object company</param>
        /// <param name="manager">optional object manager</param>
        /// <param name="keywords">optional object keywords</param>
        /// <param name="comments">optional object comments</param>
        /// <param name="start">optional object start</param>
        /// <param name="finish">optional object finish</param>
        /// <param name="scheduleFrom">optional object scheduleFrom</param>
        /// <param name="currentDate">optional object currentDate</param>
        /// <param name="calendar">optional object calendar</param>
        /// <param name="statusDate">optional object statusDate</param>
        /// <param name="priority">optional object priority</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ProjectSummaryInfo(object project, object title, object subject, object author, object company, object manager, object keywords, object comments, object start, object finish, object scheduleFrom, object currentDate, object calendar, object statusDate, object priority)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ProjectSummaryInfo", new object[] { project, title, subject, author, company, manager, keywords, comments, start, finish, scheduleFrom, currentDate, calendar, statusDate, priority });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="project">optional object project</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ProjectStatistics(object project)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ProjectStatistics", project);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ProjectStatistics()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ProjectStatistics");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="startWeekOnMonday">optional object startWeekOnMonday</param>
        /// <param name="startYearIn">optional object startYearIn</param>
        /// <param name="startTime">optional object startTime</param>
        /// <param name="finishTime">optional object finishTime</param>
        /// <param name="hoursPerDay">optional object hoursPerDay</param>
        /// <param name="hoursPerWeek">optional object hoursPerWeek</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="startWeekOn">optional object startWeekOn</param>
        /// <param name="useFYStartYear">optional object useFYStartYear</param>
        /// <param name="daysPerMonth">optional object daysPerMonth</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalendar(object startWeekOnMonday, object startYearIn, object startTime, object finishTime, object hoursPerDay, object hoursPerWeek, object setDefaults, object startWeekOn, object useFYStartYear, object daysPerMonth)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalendar", new object[] { startWeekOnMonday, startYearIn, startTime, finishTime, hoursPerDay, hoursPerWeek, setDefaults, startWeekOn, useFYStartYear, daysPerMonth });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalendar()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalendar");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="startWeekOnMonday">optional object startWeekOnMonday</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalendar(object startWeekOnMonday)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalendar", startWeekOnMonday);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="startWeekOnMonday">optional object startWeekOnMonday</param>
        /// <param name="startYearIn">optional object startYearIn</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalendar(object startWeekOnMonday, object startYearIn)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalendar", startWeekOnMonday, startYearIn);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="startWeekOnMonday">optional object startWeekOnMonday</param>
        /// <param name="startYearIn">optional object startYearIn</param>
        /// <param name="startTime">optional object startTime</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalendar(object startWeekOnMonday, object startYearIn, object startTime)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalendar", startWeekOnMonday, startYearIn, startTime);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="startWeekOnMonday">optional object startWeekOnMonday</param>
        /// <param name="startYearIn">optional object startYearIn</param>
        /// <param name="startTime">optional object startTime</param>
        /// <param name="finishTime">optional object finishTime</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalendar(object startWeekOnMonday, object startYearIn, object startTime, object finishTime)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalendar", startWeekOnMonday, startYearIn, startTime, finishTime);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="startWeekOnMonday">optional object startWeekOnMonday</param>
        /// <param name="startYearIn">optional object startYearIn</param>
        /// <param name="startTime">optional object startTime</param>
        /// <param name="finishTime">optional object finishTime</param>
        /// <param name="hoursPerDay">optional object hoursPerDay</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalendar(object startWeekOnMonday, object startYearIn, object startTime, object finishTime, object hoursPerDay)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalendar", new object[] { startWeekOnMonday, startYearIn, startTime, finishTime, hoursPerDay });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="startWeekOnMonday">optional object startWeekOnMonday</param>
        /// <param name="startYearIn">optional object startYearIn</param>
        /// <param name="startTime">optional object startTime</param>
        /// <param name="finishTime">optional object finishTime</param>
        /// <param name="hoursPerDay">optional object hoursPerDay</param>
        /// <param name="hoursPerWeek">optional object hoursPerWeek</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalendar(object startWeekOnMonday, object startYearIn, object startTime, object finishTime, object hoursPerDay, object hoursPerWeek)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalendar", new object[] { startWeekOnMonday, startYearIn, startTime, finishTime, hoursPerDay, hoursPerWeek });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="startWeekOnMonday">optional object startWeekOnMonday</param>
        /// <param name="startYearIn">optional object startYearIn</param>
        /// <param name="startTime">optional object startTime</param>
        /// <param name="finishTime">optional object finishTime</param>
        /// <param name="hoursPerDay">optional object hoursPerDay</param>
        /// <param name="hoursPerWeek">optional object hoursPerWeek</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalendar(object startWeekOnMonday, object startYearIn, object startTime, object finishTime, object hoursPerDay, object hoursPerWeek, object setDefaults)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalendar", new object[] { startWeekOnMonday, startYearIn, startTime, finishTime, hoursPerDay, hoursPerWeek, setDefaults });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="startWeekOnMonday">optional object startWeekOnMonday</param>
        /// <param name="startYearIn">optional object startYearIn</param>
        /// <param name="startTime">optional object startTime</param>
        /// <param name="finishTime">optional object finishTime</param>
        /// <param name="hoursPerDay">optional object hoursPerDay</param>
        /// <param name="hoursPerWeek">optional object hoursPerWeek</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="startWeekOn">optional object startWeekOn</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalendar(object startWeekOnMonday, object startYearIn, object startTime, object finishTime, object hoursPerDay, object hoursPerWeek, object setDefaults, object startWeekOn)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalendar", new object[] { startWeekOnMonday, startYearIn, startTime, finishTime, hoursPerDay, hoursPerWeek, setDefaults, startWeekOn });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="startWeekOnMonday">optional object startWeekOnMonday</param>
        /// <param name="startYearIn">optional object startYearIn</param>
        /// <param name="startTime">optional object startTime</param>
        /// <param name="finishTime">optional object finishTime</param>
        /// <param name="hoursPerDay">optional object hoursPerDay</param>
        /// <param name="hoursPerWeek">optional object hoursPerWeek</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="startWeekOn">optional object startWeekOn</param>
        /// <param name="useFYStartYear">optional object useFYStartYear</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalendar(object startWeekOnMonday, object startYearIn, object startTime, object finishTime, object hoursPerDay, object hoursPerWeek, object setDefaults, object startWeekOn, object useFYStartYear)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalendar", new object[] { startWeekOnMonday, startYearIn, startTime, finishTime, hoursPerDay, hoursPerWeek, setDefaults, startWeekOn, useFYStartYear });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="moveAfterReturn">optional object moveAfterReturn</param>
        /// <param name="dragAndDrop">optional object dragAndDrop</param>
        /// <param name="updateLinks">optional object updateLinks</param>
        /// <param name="copyResourceUsageHeader">optional object copyResourceUsageHeader</param>
        /// <param name="phoneticInfo">optional object phoneticInfo</param>
        /// <param name="phoneticType">optional object phoneticType</param>
        /// <param name="minuteLabelDisplay">optional object minuteLabelDisplay</param>
        /// <param name="hourLabelDisplay">optional object hourLabelDisplay</param>
        /// <param name="dayLabelDisplay">optional object dayLabelDisplay</param>
        /// <param name="weekLabelDisplay">optional object weekLabelDisplay</param>
        /// <param name="yearLabelDisplay">optional object yearLabelDisplay</param>
        /// <param name="spaceBeforeTimeLabel">optional object spaceBeforeTimeLabel</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="monthLabelDisplay">optional object monthLabelDisplay</param>
        /// <param name="setDefaultsTimeUnits">optional object setDefaultsTimeUnits</param>
        /// <param name="hyperlinkColor">optional object hyperlinkColor</param>
        /// <param name="followedHyperlinkColor">optional object followedHyperlinkColor</param>
        /// <param name="underlineHyperlinks">optional object underlineHyperlinks</param>
        /// <param name="setDefaultsHyperlink">optional object setDefaultsHyperlink</param>
        /// <param name="inCellEditing">optional object inCellEditing</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsEdit(object moveAfterReturn, object dragAndDrop, object updateLinks, object copyResourceUsageHeader, object phoneticInfo, object phoneticType, object minuteLabelDisplay, object hourLabelDisplay, object dayLabelDisplay, object weekLabelDisplay, object yearLabelDisplay, object spaceBeforeTimeLabel, object setDefaults, object monthLabelDisplay, object setDefaultsTimeUnits, object hyperlinkColor, object followedHyperlinkColor, object underlineHyperlinks, object setDefaultsHyperlink, object inCellEditing)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsEdit", new object[] { moveAfterReturn, dragAndDrop, updateLinks, copyResourceUsageHeader, phoneticInfo, phoneticType, minuteLabelDisplay, hourLabelDisplay, dayLabelDisplay, weekLabelDisplay, yearLabelDisplay, spaceBeforeTimeLabel, setDefaults, monthLabelDisplay, setDefaultsTimeUnits, hyperlinkColor, followedHyperlinkColor, underlineHyperlinks, setDefaultsHyperlink, inCellEditing });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsEdit()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsEdit");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="moveAfterReturn">optional object moveAfterReturn</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsEdit(object moveAfterReturn)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsEdit", moveAfterReturn);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="moveAfterReturn">optional object moveAfterReturn</param>
        /// <param name="dragAndDrop">optional object dragAndDrop</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsEdit(object moveAfterReturn, object dragAndDrop)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsEdit", moveAfterReturn, dragAndDrop);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="moveAfterReturn">optional object moveAfterReturn</param>
        /// <param name="dragAndDrop">optional object dragAndDrop</param>
        /// <param name="updateLinks">optional object updateLinks</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsEdit(object moveAfterReturn, object dragAndDrop, object updateLinks)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsEdit", moveAfterReturn, dragAndDrop, updateLinks);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="moveAfterReturn">optional object moveAfterReturn</param>
        /// <param name="dragAndDrop">optional object dragAndDrop</param>
        /// <param name="updateLinks">optional object updateLinks</param>
        /// <param name="copyResourceUsageHeader">optional object copyResourceUsageHeader</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsEdit(object moveAfterReturn, object dragAndDrop, object updateLinks, object copyResourceUsageHeader)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsEdit", moveAfterReturn, dragAndDrop, updateLinks, copyResourceUsageHeader);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="moveAfterReturn">optional object moveAfterReturn</param>
        /// <param name="dragAndDrop">optional object dragAndDrop</param>
        /// <param name="updateLinks">optional object updateLinks</param>
        /// <param name="copyResourceUsageHeader">optional object copyResourceUsageHeader</param>
        /// <param name="phoneticInfo">optional object phoneticInfo</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsEdit(object moveAfterReturn, object dragAndDrop, object updateLinks, object copyResourceUsageHeader, object phoneticInfo)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsEdit", new object[] { moveAfterReturn, dragAndDrop, updateLinks, copyResourceUsageHeader, phoneticInfo });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="moveAfterReturn">optional object moveAfterReturn</param>
        /// <param name="dragAndDrop">optional object dragAndDrop</param>
        /// <param name="updateLinks">optional object updateLinks</param>
        /// <param name="copyResourceUsageHeader">optional object copyResourceUsageHeader</param>
        /// <param name="phoneticInfo">optional object phoneticInfo</param>
        /// <param name="phoneticType">optional object phoneticType</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsEdit(object moveAfterReturn, object dragAndDrop, object updateLinks, object copyResourceUsageHeader, object phoneticInfo, object phoneticType)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsEdit", new object[] { moveAfterReturn, dragAndDrop, updateLinks, copyResourceUsageHeader, phoneticInfo, phoneticType });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="moveAfterReturn">optional object moveAfterReturn</param>
        /// <param name="dragAndDrop">optional object dragAndDrop</param>
        /// <param name="updateLinks">optional object updateLinks</param>
        /// <param name="copyResourceUsageHeader">optional object copyResourceUsageHeader</param>
        /// <param name="phoneticInfo">optional object phoneticInfo</param>
        /// <param name="phoneticType">optional object phoneticType</param>
        /// <param name="minuteLabelDisplay">optional object minuteLabelDisplay</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsEdit(object moveAfterReturn, object dragAndDrop, object updateLinks, object copyResourceUsageHeader, object phoneticInfo, object phoneticType, object minuteLabelDisplay)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsEdit", new object[] { moveAfterReturn, dragAndDrop, updateLinks, copyResourceUsageHeader, phoneticInfo, phoneticType, minuteLabelDisplay });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="moveAfterReturn">optional object moveAfterReturn</param>
        /// <param name="dragAndDrop">optional object dragAndDrop</param>
        /// <param name="updateLinks">optional object updateLinks</param>
        /// <param name="copyResourceUsageHeader">optional object copyResourceUsageHeader</param>
        /// <param name="phoneticInfo">optional object phoneticInfo</param>
        /// <param name="phoneticType">optional object phoneticType</param>
        /// <param name="minuteLabelDisplay">optional object minuteLabelDisplay</param>
        /// <param name="hourLabelDisplay">optional object hourLabelDisplay</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsEdit(object moveAfterReturn, object dragAndDrop, object updateLinks, object copyResourceUsageHeader, object phoneticInfo, object phoneticType, object minuteLabelDisplay, object hourLabelDisplay)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsEdit", new object[] { moveAfterReturn, dragAndDrop, updateLinks, copyResourceUsageHeader, phoneticInfo, phoneticType, minuteLabelDisplay, hourLabelDisplay });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="moveAfterReturn">optional object moveAfterReturn</param>
        /// <param name="dragAndDrop">optional object dragAndDrop</param>
        /// <param name="updateLinks">optional object updateLinks</param>
        /// <param name="copyResourceUsageHeader">optional object copyResourceUsageHeader</param>
        /// <param name="phoneticInfo">optional object phoneticInfo</param>
        /// <param name="phoneticType">optional object phoneticType</param>
        /// <param name="minuteLabelDisplay">optional object minuteLabelDisplay</param>
        /// <param name="hourLabelDisplay">optional object hourLabelDisplay</param>
        /// <param name="dayLabelDisplay">optional object dayLabelDisplay</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsEdit(object moveAfterReturn, object dragAndDrop, object updateLinks, object copyResourceUsageHeader, object phoneticInfo, object phoneticType, object minuteLabelDisplay, object hourLabelDisplay, object dayLabelDisplay)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsEdit", new object[] { moveAfterReturn, dragAndDrop, updateLinks, copyResourceUsageHeader, phoneticInfo, phoneticType, minuteLabelDisplay, hourLabelDisplay, dayLabelDisplay });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="moveAfterReturn">optional object moveAfterReturn</param>
        /// <param name="dragAndDrop">optional object dragAndDrop</param>
        /// <param name="updateLinks">optional object updateLinks</param>
        /// <param name="copyResourceUsageHeader">optional object copyResourceUsageHeader</param>
        /// <param name="phoneticInfo">optional object phoneticInfo</param>
        /// <param name="phoneticType">optional object phoneticType</param>
        /// <param name="minuteLabelDisplay">optional object minuteLabelDisplay</param>
        /// <param name="hourLabelDisplay">optional object hourLabelDisplay</param>
        /// <param name="dayLabelDisplay">optional object dayLabelDisplay</param>
        /// <param name="weekLabelDisplay">optional object weekLabelDisplay</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsEdit(object moveAfterReturn, object dragAndDrop, object updateLinks, object copyResourceUsageHeader, object phoneticInfo, object phoneticType, object minuteLabelDisplay, object hourLabelDisplay, object dayLabelDisplay, object weekLabelDisplay)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsEdit", new object[] { moveAfterReturn, dragAndDrop, updateLinks, copyResourceUsageHeader, phoneticInfo, phoneticType, minuteLabelDisplay, hourLabelDisplay, dayLabelDisplay, weekLabelDisplay });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="moveAfterReturn">optional object moveAfterReturn</param>
        /// <param name="dragAndDrop">optional object dragAndDrop</param>
        /// <param name="updateLinks">optional object updateLinks</param>
        /// <param name="copyResourceUsageHeader">optional object copyResourceUsageHeader</param>
        /// <param name="phoneticInfo">optional object phoneticInfo</param>
        /// <param name="phoneticType">optional object phoneticType</param>
        /// <param name="minuteLabelDisplay">optional object minuteLabelDisplay</param>
        /// <param name="hourLabelDisplay">optional object hourLabelDisplay</param>
        /// <param name="dayLabelDisplay">optional object dayLabelDisplay</param>
        /// <param name="weekLabelDisplay">optional object weekLabelDisplay</param>
        /// <param name="yearLabelDisplay">optional object yearLabelDisplay</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsEdit(object moveAfterReturn, object dragAndDrop, object updateLinks, object copyResourceUsageHeader, object phoneticInfo, object phoneticType, object minuteLabelDisplay, object hourLabelDisplay, object dayLabelDisplay, object weekLabelDisplay, object yearLabelDisplay)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsEdit", new object[] { moveAfterReturn, dragAndDrop, updateLinks, copyResourceUsageHeader, phoneticInfo, phoneticType, minuteLabelDisplay, hourLabelDisplay, dayLabelDisplay, weekLabelDisplay, yearLabelDisplay });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="moveAfterReturn">optional object moveAfterReturn</param>
        /// <param name="dragAndDrop">optional object dragAndDrop</param>
        /// <param name="updateLinks">optional object updateLinks</param>
        /// <param name="copyResourceUsageHeader">optional object copyResourceUsageHeader</param>
        /// <param name="phoneticInfo">optional object phoneticInfo</param>
        /// <param name="phoneticType">optional object phoneticType</param>
        /// <param name="minuteLabelDisplay">optional object minuteLabelDisplay</param>
        /// <param name="hourLabelDisplay">optional object hourLabelDisplay</param>
        /// <param name="dayLabelDisplay">optional object dayLabelDisplay</param>
        /// <param name="weekLabelDisplay">optional object weekLabelDisplay</param>
        /// <param name="yearLabelDisplay">optional object yearLabelDisplay</param>
        /// <param name="spaceBeforeTimeLabel">optional object spaceBeforeTimeLabel</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsEdit(object moveAfterReturn, object dragAndDrop, object updateLinks, object copyResourceUsageHeader, object phoneticInfo, object phoneticType, object minuteLabelDisplay, object hourLabelDisplay, object dayLabelDisplay, object weekLabelDisplay, object yearLabelDisplay, object spaceBeforeTimeLabel)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsEdit", new object[] { moveAfterReturn, dragAndDrop, updateLinks, copyResourceUsageHeader, phoneticInfo, phoneticType, minuteLabelDisplay, hourLabelDisplay, dayLabelDisplay, weekLabelDisplay, yearLabelDisplay, spaceBeforeTimeLabel });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="moveAfterReturn">optional object moveAfterReturn</param>
        /// <param name="dragAndDrop">optional object dragAndDrop</param>
        /// <param name="updateLinks">optional object updateLinks</param>
        /// <param name="copyResourceUsageHeader">optional object copyResourceUsageHeader</param>
        /// <param name="phoneticInfo">optional object phoneticInfo</param>
        /// <param name="phoneticType">optional object phoneticType</param>
        /// <param name="minuteLabelDisplay">optional object minuteLabelDisplay</param>
        /// <param name="hourLabelDisplay">optional object hourLabelDisplay</param>
        /// <param name="dayLabelDisplay">optional object dayLabelDisplay</param>
        /// <param name="weekLabelDisplay">optional object weekLabelDisplay</param>
        /// <param name="yearLabelDisplay">optional object yearLabelDisplay</param>
        /// <param name="spaceBeforeTimeLabel">optional object spaceBeforeTimeLabel</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsEdit(object moveAfterReturn, object dragAndDrop, object updateLinks, object copyResourceUsageHeader, object phoneticInfo, object phoneticType, object minuteLabelDisplay, object hourLabelDisplay, object dayLabelDisplay, object weekLabelDisplay, object yearLabelDisplay, object spaceBeforeTimeLabel, object setDefaults)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsEdit", new object[] { moveAfterReturn, dragAndDrop, updateLinks, copyResourceUsageHeader, phoneticInfo, phoneticType, minuteLabelDisplay, hourLabelDisplay, dayLabelDisplay, weekLabelDisplay, yearLabelDisplay, spaceBeforeTimeLabel, setDefaults });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="moveAfterReturn">optional object moveAfterReturn</param>
        /// <param name="dragAndDrop">optional object dragAndDrop</param>
        /// <param name="updateLinks">optional object updateLinks</param>
        /// <param name="copyResourceUsageHeader">optional object copyResourceUsageHeader</param>
        /// <param name="phoneticInfo">optional object phoneticInfo</param>
        /// <param name="phoneticType">optional object phoneticType</param>
        /// <param name="minuteLabelDisplay">optional object minuteLabelDisplay</param>
        /// <param name="hourLabelDisplay">optional object hourLabelDisplay</param>
        /// <param name="dayLabelDisplay">optional object dayLabelDisplay</param>
        /// <param name="weekLabelDisplay">optional object weekLabelDisplay</param>
        /// <param name="yearLabelDisplay">optional object yearLabelDisplay</param>
        /// <param name="spaceBeforeTimeLabel">optional object spaceBeforeTimeLabel</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="monthLabelDisplay">optional object monthLabelDisplay</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsEdit(object moveAfterReturn, object dragAndDrop, object updateLinks, object copyResourceUsageHeader, object phoneticInfo, object phoneticType, object minuteLabelDisplay, object hourLabelDisplay, object dayLabelDisplay, object weekLabelDisplay, object yearLabelDisplay, object spaceBeforeTimeLabel, object setDefaults, object monthLabelDisplay)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsEdit", new object[] { moveAfterReturn, dragAndDrop, updateLinks, copyResourceUsageHeader, phoneticInfo, phoneticType, minuteLabelDisplay, hourLabelDisplay, dayLabelDisplay, weekLabelDisplay, yearLabelDisplay, spaceBeforeTimeLabel, setDefaults, monthLabelDisplay });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="moveAfterReturn">optional object moveAfterReturn</param>
        /// <param name="dragAndDrop">optional object dragAndDrop</param>
        /// <param name="updateLinks">optional object updateLinks</param>
        /// <param name="copyResourceUsageHeader">optional object copyResourceUsageHeader</param>
        /// <param name="phoneticInfo">optional object phoneticInfo</param>
        /// <param name="phoneticType">optional object phoneticType</param>
        /// <param name="minuteLabelDisplay">optional object minuteLabelDisplay</param>
        /// <param name="hourLabelDisplay">optional object hourLabelDisplay</param>
        /// <param name="dayLabelDisplay">optional object dayLabelDisplay</param>
        /// <param name="weekLabelDisplay">optional object weekLabelDisplay</param>
        /// <param name="yearLabelDisplay">optional object yearLabelDisplay</param>
        /// <param name="spaceBeforeTimeLabel">optional object spaceBeforeTimeLabel</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="monthLabelDisplay">optional object monthLabelDisplay</param>
        /// <param name="setDefaultsTimeUnits">optional object setDefaultsTimeUnits</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsEdit(object moveAfterReturn, object dragAndDrop, object updateLinks, object copyResourceUsageHeader, object phoneticInfo, object phoneticType, object minuteLabelDisplay, object hourLabelDisplay, object dayLabelDisplay, object weekLabelDisplay, object yearLabelDisplay, object spaceBeforeTimeLabel, object setDefaults, object monthLabelDisplay, object setDefaultsTimeUnits)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsEdit", new object[] { moveAfterReturn, dragAndDrop, updateLinks, copyResourceUsageHeader, phoneticInfo, phoneticType, minuteLabelDisplay, hourLabelDisplay, dayLabelDisplay, weekLabelDisplay, yearLabelDisplay, spaceBeforeTimeLabel, setDefaults, monthLabelDisplay, setDefaultsTimeUnits });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="moveAfterReturn">optional object moveAfterReturn</param>
        /// <param name="dragAndDrop">optional object dragAndDrop</param>
        /// <param name="updateLinks">optional object updateLinks</param>
        /// <param name="copyResourceUsageHeader">optional object copyResourceUsageHeader</param>
        /// <param name="phoneticInfo">optional object phoneticInfo</param>
        /// <param name="phoneticType">optional object phoneticType</param>
        /// <param name="minuteLabelDisplay">optional object minuteLabelDisplay</param>
        /// <param name="hourLabelDisplay">optional object hourLabelDisplay</param>
        /// <param name="dayLabelDisplay">optional object dayLabelDisplay</param>
        /// <param name="weekLabelDisplay">optional object weekLabelDisplay</param>
        /// <param name="yearLabelDisplay">optional object yearLabelDisplay</param>
        /// <param name="spaceBeforeTimeLabel">optional object spaceBeforeTimeLabel</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="monthLabelDisplay">optional object monthLabelDisplay</param>
        /// <param name="setDefaultsTimeUnits">optional object setDefaultsTimeUnits</param>
        /// <param name="hyperlinkColor">optional object hyperlinkColor</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsEdit(object moveAfterReturn, object dragAndDrop, object updateLinks, object copyResourceUsageHeader, object phoneticInfo, object phoneticType, object minuteLabelDisplay, object hourLabelDisplay, object dayLabelDisplay, object weekLabelDisplay, object yearLabelDisplay, object spaceBeforeTimeLabel, object setDefaults, object monthLabelDisplay, object setDefaultsTimeUnits, object hyperlinkColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsEdit", new object[] { moveAfterReturn, dragAndDrop, updateLinks, copyResourceUsageHeader, phoneticInfo, phoneticType, minuteLabelDisplay, hourLabelDisplay, dayLabelDisplay, weekLabelDisplay, yearLabelDisplay, spaceBeforeTimeLabel, setDefaults, monthLabelDisplay, setDefaultsTimeUnits, hyperlinkColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="moveAfterReturn">optional object moveAfterReturn</param>
        /// <param name="dragAndDrop">optional object dragAndDrop</param>
        /// <param name="updateLinks">optional object updateLinks</param>
        /// <param name="copyResourceUsageHeader">optional object copyResourceUsageHeader</param>
        /// <param name="phoneticInfo">optional object phoneticInfo</param>
        /// <param name="phoneticType">optional object phoneticType</param>
        /// <param name="minuteLabelDisplay">optional object minuteLabelDisplay</param>
        /// <param name="hourLabelDisplay">optional object hourLabelDisplay</param>
        /// <param name="dayLabelDisplay">optional object dayLabelDisplay</param>
        /// <param name="weekLabelDisplay">optional object weekLabelDisplay</param>
        /// <param name="yearLabelDisplay">optional object yearLabelDisplay</param>
        /// <param name="spaceBeforeTimeLabel">optional object spaceBeforeTimeLabel</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="monthLabelDisplay">optional object monthLabelDisplay</param>
        /// <param name="setDefaultsTimeUnits">optional object setDefaultsTimeUnits</param>
        /// <param name="hyperlinkColor">optional object hyperlinkColor</param>
        /// <param name="followedHyperlinkColor">optional object followedHyperlinkColor</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsEdit(object moveAfterReturn, object dragAndDrop, object updateLinks, object copyResourceUsageHeader, object phoneticInfo, object phoneticType, object minuteLabelDisplay, object hourLabelDisplay, object dayLabelDisplay, object weekLabelDisplay, object yearLabelDisplay, object spaceBeforeTimeLabel, object setDefaults, object monthLabelDisplay, object setDefaultsTimeUnits, object hyperlinkColor, object followedHyperlinkColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsEdit", new object[] { moveAfterReturn, dragAndDrop, updateLinks, copyResourceUsageHeader, phoneticInfo, phoneticType, minuteLabelDisplay, hourLabelDisplay, dayLabelDisplay, weekLabelDisplay, yearLabelDisplay, spaceBeforeTimeLabel, setDefaults, monthLabelDisplay, setDefaultsTimeUnits, hyperlinkColor, followedHyperlinkColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="moveAfterReturn">optional object moveAfterReturn</param>
        /// <param name="dragAndDrop">optional object dragAndDrop</param>
        /// <param name="updateLinks">optional object updateLinks</param>
        /// <param name="copyResourceUsageHeader">optional object copyResourceUsageHeader</param>
        /// <param name="phoneticInfo">optional object phoneticInfo</param>
        /// <param name="phoneticType">optional object phoneticType</param>
        /// <param name="minuteLabelDisplay">optional object minuteLabelDisplay</param>
        /// <param name="hourLabelDisplay">optional object hourLabelDisplay</param>
        /// <param name="dayLabelDisplay">optional object dayLabelDisplay</param>
        /// <param name="weekLabelDisplay">optional object weekLabelDisplay</param>
        /// <param name="yearLabelDisplay">optional object yearLabelDisplay</param>
        /// <param name="spaceBeforeTimeLabel">optional object spaceBeforeTimeLabel</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="monthLabelDisplay">optional object monthLabelDisplay</param>
        /// <param name="setDefaultsTimeUnits">optional object setDefaultsTimeUnits</param>
        /// <param name="hyperlinkColor">optional object hyperlinkColor</param>
        /// <param name="followedHyperlinkColor">optional object followedHyperlinkColor</param>
        /// <param name="underlineHyperlinks">optional object underlineHyperlinks</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsEdit(object moveAfterReturn, object dragAndDrop, object updateLinks, object copyResourceUsageHeader, object phoneticInfo, object phoneticType, object minuteLabelDisplay, object hourLabelDisplay, object dayLabelDisplay, object weekLabelDisplay, object yearLabelDisplay, object spaceBeforeTimeLabel, object setDefaults, object monthLabelDisplay, object setDefaultsTimeUnits, object hyperlinkColor, object followedHyperlinkColor, object underlineHyperlinks)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsEdit", new object[] { moveAfterReturn, dragAndDrop, updateLinks, copyResourceUsageHeader, phoneticInfo, phoneticType, minuteLabelDisplay, hourLabelDisplay, dayLabelDisplay, weekLabelDisplay, yearLabelDisplay, spaceBeforeTimeLabel, setDefaults, monthLabelDisplay, setDefaultsTimeUnits, hyperlinkColor, followedHyperlinkColor, underlineHyperlinks });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="moveAfterReturn">optional object moveAfterReturn</param>
        /// <param name="dragAndDrop">optional object dragAndDrop</param>
        /// <param name="updateLinks">optional object updateLinks</param>
        /// <param name="copyResourceUsageHeader">optional object copyResourceUsageHeader</param>
        /// <param name="phoneticInfo">optional object phoneticInfo</param>
        /// <param name="phoneticType">optional object phoneticType</param>
        /// <param name="minuteLabelDisplay">optional object minuteLabelDisplay</param>
        /// <param name="hourLabelDisplay">optional object hourLabelDisplay</param>
        /// <param name="dayLabelDisplay">optional object dayLabelDisplay</param>
        /// <param name="weekLabelDisplay">optional object weekLabelDisplay</param>
        /// <param name="yearLabelDisplay">optional object yearLabelDisplay</param>
        /// <param name="spaceBeforeTimeLabel">optional object spaceBeforeTimeLabel</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="monthLabelDisplay">optional object monthLabelDisplay</param>
        /// <param name="setDefaultsTimeUnits">optional object setDefaultsTimeUnits</param>
        /// <param name="hyperlinkColor">optional object hyperlinkColor</param>
        /// <param name="followedHyperlinkColor">optional object followedHyperlinkColor</param>
        /// <param name="underlineHyperlinks">optional object underlineHyperlinks</param>
        /// <param name="setDefaultsHyperlink">optional object setDefaultsHyperlink</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsEdit(object moveAfterReturn, object dragAndDrop, object updateLinks, object copyResourceUsageHeader, object phoneticInfo, object phoneticType, object minuteLabelDisplay, object hourLabelDisplay, object dayLabelDisplay, object weekLabelDisplay, object yearLabelDisplay, object spaceBeforeTimeLabel, object setDefaults, object monthLabelDisplay, object setDefaultsTimeUnits, object hyperlinkColor, object followedHyperlinkColor, object underlineHyperlinks, object setDefaultsHyperlink)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsEdit", new object[] { moveAfterReturn, dragAndDrop, updateLinks, copyResourceUsageHeader, phoneticInfo, phoneticType, minuteLabelDisplay, hourLabelDisplay, dayLabelDisplay, weekLabelDisplay, yearLabelDisplay, spaceBeforeTimeLabel, setDefaults, monthLabelDisplay, setDefaultsTimeUnits, hyperlinkColor, followedHyperlinkColor, underlineHyperlinks, setDefaultsHyperlink });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="planningWizard">optional object planningWizard</param>
        /// <param name="wizardUsage">optional object wizardUsage</param>
        /// <param name="wizardErrors">optional object wizardErrors</param>
        /// <param name="wizardScheduling">optional object wizardScheduling</param>
        /// <param name="showTipOfDay">optional object showTipOfDay</param>
        /// <param name="autoAddResources">optional object autoAddResources</param>
        /// <param name="standardRate">optional object standardRate</param>
        /// <param name="overtimeRate">optional object overtimeRate</param>
        /// <param name="lastFile">optional object lastFile</param>
        /// <param name="summaryInfo">optional object summaryInfo</param>
        /// <param name="userName">optional object userName</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="showWelcome">optional object showWelcome</param>
        /// <param name="autoFilter">optional object autoFilter</param>
        /// <param name="macroVirusProtection">optional object macroVirusProtection</param>
        /// <param name="displayRecentFiles">optional object displayRecentFiles</param>
        /// <param name="recentFilesMaximum">optional object recentFilesMaximum</param>
        /// <param name="fontConversion">optional object fontConversion</param>
        /// <param name="showStartupWorkpane">optional object showStartupWorkpane</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsGeneral(object planningWizard, object wizardUsage, object wizardErrors, object wizardScheduling, object showTipOfDay, object autoAddResources, object standardRate, object overtimeRate, object lastFile, object summaryInfo, object userName, object setDefaults, object showWelcome, object autoFilter, object macroVirusProtection, object displayRecentFiles, object recentFilesMaximum, object fontConversion, object showStartupWorkpane)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsGeneral", new object[] { planningWizard, wizardUsage, wizardErrors, wizardScheduling, showTipOfDay, autoAddResources, standardRate, overtimeRate, lastFile, summaryInfo, userName, setDefaults, showWelcome, autoFilter, macroVirusProtection, displayRecentFiles, recentFilesMaximum, fontConversion, showStartupWorkpane });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsGeneral()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsGeneral");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="planningWizard">optional object planningWizard</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsGeneral(object planningWizard)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsGeneral", planningWizard);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="planningWizard">optional object planningWizard</param>
        /// <param name="wizardUsage">optional object wizardUsage</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsGeneral(object planningWizard, object wizardUsage)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsGeneral", planningWizard, wizardUsage);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="planningWizard">optional object planningWizard</param>
        /// <param name="wizardUsage">optional object wizardUsage</param>
        /// <param name="wizardErrors">optional object wizardErrors</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsGeneral(object planningWizard, object wizardUsage, object wizardErrors)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsGeneral", planningWizard, wizardUsage, wizardErrors);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="planningWizard">optional object planningWizard</param>
        /// <param name="wizardUsage">optional object wizardUsage</param>
        /// <param name="wizardErrors">optional object wizardErrors</param>
        /// <param name="wizardScheduling">optional object wizardScheduling</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsGeneral(object planningWizard, object wizardUsage, object wizardErrors, object wizardScheduling)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsGeneral", planningWizard, wizardUsage, wizardErrors, wizardScheduling);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="planningWizard">optional object planningWizard</param>
        /// <param name="wizardUsage">optional object wizardUsage</param>
        /// <param name="wizardErrors">optional object wizardErrors</param>
        /// <param name="wizardScheduling">optional object wizardScheduling</param>
        /// <param name="showTipOfDay">optional object showTipOfDay</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsGeneral(object planningWizard, object wizardUsage, object wizardErrors, object wizardScheduling, object showTipOfDay)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsGeneral", new object[] { planningWizard, wizardUsage, wizardErrors, wizardScheduling, showTipOfDay });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="planningWizard">optional object planningWizard</param>
        /// <param name="wizardUsage">optional object wizardUsage</param>
        /// <param name="wizardErrors">optional object wizardErrors</param>
        /// <param name="wizardScheduling">optional object wizardScheduling</param>
        /// <param name="showTipOfDay">optional object showTipOfDay</param>
        /// <param name="autoAddResources">optional object autoAddResources</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsGeneral(object planningWizard, object wizardUsage, object wizardErrors, object wizardScheduling, object showTipOfDay, object autoAddResources)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsGeneral", new object[] { planningWizard, wizardUsage, wizardErrors, wizardScheduling, showTipOfDay, autoAddResources });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="planningWizard">optional object planningWizard</param>
        /// <param name="wizardUsage">optional object wizardUsage</param>
        /// <param name="wizardErrors">optional object wizardErrors</param>
        /// <param name="wizardScheduling">optional object wizardScheduling</param>
        /// <param name="showTipOfDay">optional object showTipOfDay</param>
        /// <param name="autoAddResources">optional object autoAddResources</param>
        /// <param name="standardRate">optional object standardRate</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsGeneral(object planningWizard, object wizardUsage, object wizardErrors, object wizardScheduling, object showTipOfDay, object autoAddResources, object standardRate)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsGeneral", new object[] { planningWizard, wizardUsage, wizardErrors, wizardScheduling, showTipOfDay, autoAddResources, standardRate });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="planningWizard">optional object planningWizard</param>
        /// <param name="wizardUsage">optional object wizardUsage</param>
        /// <param name="wizardErrors">optional object wizardErrors</param>
        /// <param name="wizardScheduling">optional object wizardScheduling</param>
        /// <param name="showTipOfDay">optional object showTipOfDay</param>
        /// <param name="autoAddResources">optional object autoAddResources</param>
        /// <param name="standardRate">optional object standardRate</param>
        /// <param name="overtimeRate">optional object overtimeRate</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsGeneral(object planningWizard, object wizardUsage, object wizardErrors, object wizardScheduling, object showTipOfDay, object autoAddResources, object standardRate, object overtimeRate)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsGeneral", new object[] { planningWizard, wizardUsage, wizardErrors, wizardScheduling, showTipOfDay, autoAddResources, standardRate, overtimeRate });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="planningWizard">optional object planningWizard</param>
        /// <param name="wizardUsage">optional object wizardUsage</param>
        /// <param name="wizardErrors">optional object wizardErrors</param>
        /// <param name="wizardScheduling">optional object wizardScheduling</param>
        /// <param name="showTipOfDay">optional object showTipOfDay</param>
        /// <param name="autoAddResources">optional object autoAddResources</param>
        /// <param name="standardRate">optional object standardRate</param>
        /// <param name="overtimeRate">optional object overtimeRate</param>
        /// <param name="lastFile">optional object lastFile</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsGeneral(object planningWizard, object wizardUsage, object wizardErrors, object wizardScheduling, object showTipOfDay, object autoAddResources, object standardRate, object overtimeRate, object lastFile)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsGeneral", new object[] { planningWizard, wizardUsage, wizardErrors, wizardScheduling, showTipOfDay, autoAddResources, standardRate, overtimeRate, lastFile });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="planningWizard">optional object planningWizard</param>
        /// <param name="wizardUsage">optional object wizardUsage</param>
        /// <param name="wizardErrors">optional object wizardErrors</param>
        /// <param name="wizardScheduling">optional object wizardScheduling</param>
        /// <param name="showTipOfDay">optional object showTipOfDay</param>
        /// <param name="autoAddResources">optional object autoAddResources</param>
        /// <param name="standardRate">optional object standardRate</param>
        /// <param name="overtimeRate">optional object overtimeRate</param>
        /// <param name="lastFile">optional object lastFile</param>
        /// <param name="summaryInfo">optional object summaryInfo</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsGeneral(object planningWizard, object wizardUsage, object wizardErrors, object wizardScheduling, object showTipOfDay, object autoAddResources, object standardRate, object overtimeRate, object lastFile, object summaryInfo)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsGeneral", new object[] { planningWizard, wizardUsage, wizardErrors, wizardScheduling, showTipOfDay, autoAddResources, standardRate, overtimeRate, lastFile, summaryInfo });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="planningWizard">optional object planningWizard</param>
        /// <param name="wizardUsage">optional object wizardUsage</param>
        /// <param name="wizardErrors">optional object wizardErrors</param>
        /// <param name="wizardScheduling">optional object wizardScheduling</param>
        /// <param name="showTipOfDay">optional object showTipOfDay</param>
        /// <param name="autoAddResources">optional object autoAddResources</param>
        /// <param name="standardRate">optional object standardRate</param>
        /// <param name="overtimeRate">optional object overtimeRate</param>
        /// <param name="lastFile">optional object lastFile</param>
        /// <param name="summaryInfo">optional object summaryInfo</param>
        /// <param name="userName">optional object userName</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsGeneral(object planningWizard, object wizardUsage, object wizardErrors, object wizardScheduling, object showTipOfDay, object autoAddResources, object standardRate, object overtimeRate, object lastFile, object summaryInfo, object userName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsGeneral", new object[] { planningWizard, wizardUsage, wizardErrors, wizardScheduling, showTipOfDay, autoAddResources, standardRate, overtimeRate, lastFile, summaryInfo, userName });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="planningWizard">optional object planningWizard</param>
        /// <param name="wizardUsage">optional object wizardUsage</param>
        /// <param name="wizardErrors">optional object wizardErrors</param>
        /// <param name="wizardScheduling">optional object wizardScheduling</param>
        /// <param name="showTipOfDay">optional object showTipOfDay</param>
        /// <param name="autoAddResources">optional object autoAddResources</param>
        /// <param name="standardRate">optional object standardRate</param>
        /// <param name="overtimeRate">optional object overtimeRate</param>
        /// <param name="lastFile">optional object lastFile</param>
        /// <param name="summaryInfo">optional object summaryInfo</param>
        /// <param name="userName">optional object userName</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsGeneral(object planningWizard, object wizardUsage, object wizardErrors, object wizardScheduling, object showTipOfDay, object autoAddResources, object standardRate, object overtimeRate, object lastFile, object summaryInfo, object userName, object setDefaults)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsGeneral", new object[] { planningWizard, wizardUsage, wizardErrors, wizardScheduling, showTipOfDay, autoAddResources, standardRate, overtimeRate, lastFile, summaryInfo, userName, setDefaults });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="planningWizard">optional object planningWizard</param>
        /// <param name="wizardUsage">optional object wizardUsage</param>
        /// <param name="wizardErrors">optional object wizardErrors</param>
        /// <param name="wizardScheduling">optional object wizardScheduling</param>
        /// <param name="showTipOfDay">optional object showTipOfDay</param>
        /// <param name="autoAddResources">optional object autoAddResources</param>
        /// <param name="standardRate">optional object standardRate</param>
        /// <param name="overtimeRate">optional object overtimeRate</param>
        /// <param name="lastFile">optional object lastFile</param>
        /// <param name="summaryInfo">optional object summaryInfo</param>
        /// <param name="userName">optional object userName</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="showWelcome">optional object showWelcome</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsGeneral(object planningWizard, object wizardUsage, object wizardErrors, object wizardScheduling, object showTipOfDay, object autoAddResources, object standardRate, object overtimeRate, object lastFile, object summaryInfo, object userName, object setDefaults, object showWelcome)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsGeneral", new object[] { planningWizard, wizardUsage, wizardErrors, wizardScheduling, showTipOfDay, autoAddResources, standardRate, overtimeRate, lastFile, summaryInfo, userName, setDefaults, showWelcome });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="planningWizard">optional object planningWizard</param>
        /// <param name="wizardUsage">optional object wizardUsage</param>
        /// <param name="wizardErrors">optional object wizardErrors</param>
        /// <param name="wizardScheduling">optional object wizardScheduling</param>
        /// <param name="showTipOfDay">optional object showTipOfDay</param>
        /// <param name="autoAddResources">optional object autoAddResources</param>
        /// <param name="standardRate">optional object standardRate</param>
        /// <param name="overtimeRate">optional object overtimeRate</param>
        /// <param name="lastFile">optional object lastFile</param>
        /// <param name="summaryInfo">optional object summaryInfo</param>
        /// <param name="userName">optional object userName</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="showWelcome">optional object showWelcome</param>
        /// <param name="autoFilter">optional object autoFilter</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsGeneral(object planningWizard, object wizardUsage, object wizardErrors, object wizardScheduling, object showTipOfDay, object autoAddResources, object standardRate, object overtimeRate, object lastFile, object summaryInfo, object userName, object setDefaults, object showWelcome, object autoFilter)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsGeneral", new object[] { planningWizard, wizardUsage, wizardErrors, wizardScheduling, showTipOfDay, autoAddResources, standardRate, overtimeRate, lastFile, summaryInfo, userName, setDefaults, showWelcome, autoFilter });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="planningWizard">optional object planningWizard</param>
        /// <param name="wizardUsage">optional object wizardUsage</param>
        /// <param name="wizardErrors">optional object wizardErrors</param>
        /// <param name="wizardScheduling">optional object wizardScheduling</param>
        /// <param name="showTipOfDay">optional object showTipOfDay</param>
        /// <param name="autoAddResources">optional object autoAddResources</param>
        /// <param name="standardRate">optional object standardRate</param>
        /// <param name="overtimeRate">optional object overtimeRate</param>
        /// <param name="lastFile">optional object lastFile</param>
        /// <param name="summaryInfo">optional object summaryInfo</param>
        /// <param name="userName">optional object userName</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="showWelcome">optional object showWelcome</param>
        /// <param name="autoFilter">optional object autoFilter</param>
        /// <param name="macroVirusProtection">optional object macroVirusProtection</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsGeneral(object planningWizard, object wizardUsage, object wizardErrors, object wizardScheduling, object showTipOfDay, object autoAddResources, object standardRate, object overtimeRate, object lastFile, object summaryInfo, object userName, object setDefaults, object showWelcome, object autoFilter, object macroVirusProtection)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsGeneral", new object[] { planningWizard, wizardUsage, wizardErrors, wizardScheduling, showTipOfDay, autoAddResources, standardRate, overtimeRate, lastFile, summaryInfo, userName, setDefaults, showWelcome, autoFilter, macroVirusProtection });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="planningWizard">optional object planningWizard</param>
        /// <param name="wizardUsage">optional object wizardUsage</param>
        /// <param name="wizardErrors">optional object wizardErrors</param>
        /// <param name="wizardScheduling">optional object wizardScheduling</param>
        /// <param name="showTipOfDay">optional object showTipOfDay</param>
        /// <param name="autoAddResources">optional object autoAddResources</param>
        /// <param name="standardRate">optional object standardRate</param>
        /// <param name="overtimeRate">optional object overtimeRate</param>
        /// <param name="lastFile">optional object lastFile</param>
        /// <param name="summaryInfo">optional object summaryInfo</param>
        /// <param name="userName">optional object userName</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="showWelcome">optional object showWelcome</param>
        /// <param name="autoFilter">optional object autoFilter</param>
        /// <param name="macroVirusProtection">optional object macroVirusProtection</param>
        /// <param name="displayRecentFiles">optional object displayRecentFiles</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsGeneral(object planningWizard, object wizardUsage, object wizardErrors, object wizardScheduling, object showTipOfDay, object autoAddResources, object standardRate, object overtimeRate, object lastFile, object summaryInfo, object userName, object setDefaults, object showWelcome, object autoFilter, object macroVirusProtection, object displayRecentFiles)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsGeneral", new object[] { planningWizard, wizardUsage, wizardErrors, wizardScheduling, showTipOfDay, autoAddResources, standardRate, overtimeRate, lastFile, summaryInfo, userName, setDefaults, showWelcome, autoFilter, macroVirusProtection, displayRecentFiles });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="planningWizard">optional object planningWizard</param>
        /// <param name="wizardUsage">optional object wizardUsage</param>
        /// <param name="wizardErrors">optional object wizardErrors</param>
        /// <param name="wizardScheduling">optional object wizardScheduling</param>
        /// <param name="showTipOfDay">optional object showTipOfDay</param>
        /// <param name="autoAddResources">optional object autoAddResources</param>
        /// <param name="standardRate">optional object standardRate</param>
        /// <param name="overtimeRate">optional object overtimeRate</param>
        /// <param name="lastFile">optional object lastFile</param>
        /// <param name="summaryInfo">optional object summaryInfo</param>
        /// <param name="userName">optional object userName</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="showWelcome">optional object showWelcome</param>
        /// <param name="autoFilter">optional object autoFilter</param>
        /// <param name="macroVirusProtection">optional object macroVirusProtection</param>
        /// <param name="displayRecentFiles">optional object displayRecentFiles</param>
        /// <param name="recentFilesMaximum">optional object recentFilesMaximum</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsGeneral(object planningWizard, object wizardUsage, object wizardErrors, object wizardScheduling, object showTipOfDay, object autoAddResources, object standardRate, object overtimeRate, object lastFile, object summaryInfo, object userName, object setDefaults, object showWelcome, object autoFilter, object macroVirusProtection, object displayRecentFiles, object recentFilesMaximum)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsGeneral", new object[] { planningWizard, wizardUsage, wizardErrors, wizardScheduling, showTipOfDay, autoAddResources, standardRate, overtimeRate, lastFile, summaryInfo, userName, setDefaults, showWelcome, autoFilter, macroVirusProtection, displayRecentFiles, recentFilesMaximum });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="planningWizard">optional object planningWizard</param>
        /// <param name="wizardUsage">optional object wizardUsage</param>
        /// <param name="wizardErrors">optional object wizardErrors</param>
        /// <param name="wizardScheduling">optional object wizardScheduling</param>
        /// <param name="showTipOfDay">optional object showTipOfDay</param>
        /// <param name="autoAddResources">optional object autoAddResources</param>
        /// <param name="standardRate">optional object standardRate</param>
        /// <param name="overtimeRate">optional object overtimeRate</param>
        /// <param name="lastFile">optional object lastFile</param>
        /// <param name="summaryInfo">optional object summaryInfo</param>
        /// <param name="userName">optional object userName</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="showWelcome">optional object showWelcome</param>
        /// <param name="autoFilter">optional object autoFilter</param>
        /// <param name="macroVirusProtection">optional object macroVirusProtection</param>
        /// <param name="displayRecentFiles">optional object displayRecentFiles</param>
        /// <param name="recentFilesMaximum">optional object recentFilesMaximum</param>
        /// <param name="fontConversion">optional object fontConversion</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsGeneral(object planningWizard, object wizardUsage, object wizardErrors, object wizardScheduling, object showTipOfDay, object autoAddResources, object standardRate, object overtimeRate, object lastFile, object summaryInfo, object userName, object setDefaults, object showWelcome, object autoFilter, object macroVirusProtection, object displayRecentFiles, object recentFilesMaximum, object fontConversion)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsGeneral", new object[] { planningWizard, wizardUsage, wizardErrors, wizardScheduling, showTipOfDay, autoAddResources, standardRate, overtimeRate, lastFile, summaryInfo, userName, setDefaults, showWelcome, autoFilter, macroVirusProtection, displayRecentFiles, recentFilesMaximum, fontConversion });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="scheduleMessages">optional object scheduleMessages</param>
        /// <param name="startOnCurrentDate">optional object startOnCurrentDate</param>
        /// <param name="autoLink">optional object autoLink</param>
        /// <param name="autoSplit">optional object autoSplit</param>
        /// <param name="criticalSlack">optional object criticalSlack</param>
        /// <param name="taskType">optional object taskType</param>
        /// <param name="durationUnits">optional object durationUnits</param>
        /// <param name="workUnits">optional object workUnits</param>
        /// <param name="autoTrack">optional object autoTrack</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="assignmentUnits">optional object assignmentUnits</param>
        /// <param name="effortDriven">optional object effortDriven</param>
        /// <param name="honorConstraints">optional object honorConstraints</param>
        /// <param name="showEstimated">optional object showEstimated</param>
        /// <param name="newTasksEstimated">optional object newTasksEstimated</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSchedule(object scheduleMessages, object startOnCurrentDate, object autoLink, object autoSplit, object criticalSlack, object taskType, object durationUnits, object workUnits, object autoTrack, object setDefaults, object assignmentUnits, object effortDriven, object honorConstraints, object showEstimated, object newTasksEstimated)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSchedule", new object[] { scheduleMessages, startOnCurrentDate, autoLink, autoSplit, criticalSlack, taskType, durationUnits, workUnits, autoTrack, setDefaults, assignmentUnits, effortDriven, honorConstraints, showEstimated, newTasksEstimated });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSchedule()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSchedule");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="scheduleMessages">optional object scheduleMessages</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSchedule(object scheduleMessages)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSchedule", scheduleMessages);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="scheduleMessages">optional object scheduleMessages</param>
        /// <param name="startOnCurrentDate">optional object startOnCurrentDate</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSchedule(object scheduleMessages, object startOnCurrentDate)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSchedule", scheduleMessages, startOnCurrentDate);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="scheduleMessages">optional object scheduleMessages</param>
        /// <param name="startOnCurrentDate">optional object startOnCurrentDate</param>
        /// <param name="autoLink">optional object autoLink</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSchedule(object scheduleMessages, object startOnCurrentDate, object autoLink)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSchedule", scheduleMessages, startOnCurrentDate, autoLink);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="scheduleMessages">optional object scheduleMessages</param>
        /// <param name="startOnCurrentDate">optional object startOnCurrentDate</param>
        /// <param name="autoLink">optional object autoLink</param>
        /// <param name="autoSplit">optional object autoSplit</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSchedule(object scheduleMessages, object startOnCurrentDate, object autoLink, object autoSplit)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSchedule", scheduleMessages, startOnCurrentDate, autoLink, autoSplit);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="scheduleMessages">optional object scheduleMessages</param>
        /// <param name="startOnCurrentDate">optional object startOnCurrentDate</param>
        /// <param name="autoLink">optional object autoLink</param>
        /// <param name="autoSplit">optional object autoSplit</param>
        /// <param name="criticalSlack">optional object criticalSlack</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSchedule(object scheduleMessages, object startOnCurrentDate, object autoLink, object autoSplit, object criticalSlack)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSchedule", new object[] { scheduleMessages, startOnCurrentDate, autoLink, autoSplit, criticalSlack });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="scheduleMessages">optional object scheduleMessages</param>
        /// <param name="startOnCurrentDate">optional object startOnCurrentDate</param>
        /// <param name="autoLink">optional object autoLink</param>
        /// <param name="autoSplit">optional object autoSplit</param>
        /// <param name="criticalSlack">optional object criticalSlack</param>
        /// <param name="taskType">optional object taskType</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSchedule(object scheduleMessages, object startOnCurrentDate, object autoLink, object autoSplit, object criticalSlack, object taskType)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSchedule", new object[] { scheduleMessages, startOnCurrentDate, autoLink, autoSplit, criticalSlack, taskType });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="scheduleMessages">optional object scheduleMessages</param>
        /// <param name="startOnCurrentDate">optional object startOnCurrentDate</param>
        /// <param name="autoLink">optional object autoLink</param>
        /// <param name="autoSplit">optional object autoSplit</param>
        /// <param name="criticalSlack">optional object criticalSlack</param>
        /// <param name="taskType">optional object taskType</param>
        /// <param name="durationUnits">optional object durationUnits</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSchedule(object scheduleMessages, object startOnCurrentDate, object autoLink, object autoSplit, object criticalSlack, object taskType, object durationUnits)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSchedule", new object[] { scheduleMessages, startOnCurrentDate, autoLink, autoSplit, criticalSlack, taskType, durationUnits });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="scheduleMessages">optional object scheduleMessages</param>
        /// <param name="startOnCurrentDate">optional object startOnCurrentDate</param>
        /// <param name="autoLink">optional object autoLink</param>
        /// <param name="autoSplit">optional object autoSplit</param>
        /// <param name="criticalSlack">optional object criticalSlack</param>
        /// <param name="taskType">optional object taskType</param>
        /// <param name="durationUnits">optional object durationUnits</param>
        /// <param name="workUnits">optional object workUnits</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSchedule(object scheduleMessages, object startOnCurrentDate, object autoLink, object autoSplit, object criticalSlack, object taskType, object durationUnits, object workUnits)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSchedule", new object[] { scheduleMessages, startOnCurrentDate, autoLink, autoSplit, criticalSlack, taskType, durationUnits, workUnits });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="scheduleMessages">optional object scheduleMessages</param>
        /// <param name="startOnCurrentDate">optional object startOnCurrentDate</param>
        /// <param name="autoLink">optional object autoLink</param>
        /// <param name="autoSplit">optional object autoSplit</param>
        /// <param name="criticalSlack">optional object criticalSlack</param>
        /// <param name="taskType">optional object taskType</param>
        /// <param name="durationUnits">optional object durationUnits</param>
        /// <param name="workUnits">optional object workUnits</param>
        /// <param name="autoTrack">optional object autoTrack</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSchedule(object scheduleMessages, object startOnCurrentDate, object autoLink, object autoSplit, object criticalSlack, object taskType, object durationUnits, object workUnits, object autoTrack)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSchedule", new object[] { scheduleMessages, startOnCurrentDate, autoLink, autoSplit, criticalSlack, taskType, durationUnits, workUnits, autoTrack });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="scheduleMessages">optional object scheduleMessages</param>
        /// <param name="startOnCurrentDate">optional object startOnCurrentDate</param>
        /// <param name="autoLink">optional object autoLink</param>
        /// <param name="autoSplit">optional object autoSplit</param>
        /// <param name="criticalSlack">optional object criticalSlack</param>
        /// <param name="taskType">optional object taskType</param>
        /// <param name="durationUnits">optional object durationUnits</param>
        /// <param name="workUnits">optional object workUnits</param>
        /// <param name="autoTrack">optional object autoTrack</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSchedule(object scheduleMessages, object startOnCurrentDate, object autoLink, object autoSplit, object criticalSlack, object taskType, object durationUnits, object workUnits, object autoTrack, object setDefaults)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSchedule", new object[] { scheduleMessages, startOnCurrentDate, autoLink, autoSplit, criticalSlack, taskType, durationUnits, workUnits, autoTrack, setDefaults });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="scheduleMessages">optional object scheduleMessages</param>
        /// <param name="startOnCurrentDate">optional object startOnCurrentDate</param>
        /// <param name="autoLink">optional object autoLink</param>
        /// <param name="autoSplit">optional object autoSplit</param>
        /// <param name="criticalSlack">optional object criticalSlack</param>
        /// <param name="taskType">optional object taskType</param>
        /// <param name="durationUnits">optional object durationUnits</param>
        /// <param name="workUnits">optional object workUnits</param>
        /// <param name="autoTrack">optional object autoTrack</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="assignmentUnits">optional object assignmentUnits</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSchedule(object scheduleMessages, object startOnCurrentDate, object autoLink, object autoSplit, object criticalSlack, object taskType, object durationUnits, object workUnits, object autoTrack, object setDefaults, object assignmentUnits)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSchedule", new object[] { scheduleMessages, startOnCurrentDate, autoLink, autoSplit, criticalSlack, taskType, durationUnits, workUnits, autoTrack, setDefaults, assignmentUnits });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="scheduleMessages">optional object scheduleMessages</param>
        /// <param name="startOnCurrentDate">optional object startOnCurrentDate</param>
        /// <param name="autoLink">optional object autoLink</param>
        /// <param name="autoSplit">optional object autoSplit</param>
        /// <param name="criticalSlack">optional object criticalSlack</param>
        /// <param name="taskType">optional object taskType</param>
        /// <param name="durationUnits">optional object durationUnits</param>
        /// <param name="workUnits">optional object workUnits</param>
        /// <param name="autoTrack">optional object autoTrack</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="assignmentUnits">optional object assignmentUnits</param>
        /// <param name="effortDriven">optional object effortDriven</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSchedule(object scheduleMessages, object startOnCurrentDate, object autoLink, object autoSplit, object criticalSlack, object taskType, object durationUnits, object workUnits, object autoTrack, object setDefaults, object assignmentUnits, object effortDriven)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSchedule", new object[] { scheduleMessages, startOnCurrentDate, autoLink, autoSplit, criticalSlack, taskType, durationUnits, workUnits, autoTrack, setDefaults, assignmentUnits, effortDriven });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="scheduleMessages">optional object scheduleMessages</param>
        /// <param name="startOnCurrentDate">optional object startOnCurrentDate</param>
        /// <param name="autoLink">optional object autoLink</param>
        /// <param name="autoSplit">optional object autoSplit</param>
        /// <param name="criticalSlack">optional object criticalSlack</param>
        /// <param name="taskType">optional object taskType</param>
        /// <param name="durationUnits">optional object durationUnits</param>
        /// <param name="workUnits">optional object workUnits</param>
        /// <param name="autoTrack">optional object autoTrack</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="assignmentUnits">optional object assignmentUnits</param>
        /// <param name="effortDriven">optional object effortDriven</param>
        /// <param name="honorConstraints">optional object honorConstraints</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSchedule(object scheduleMessages, object startOnCurrentDate, object autoLink, object autoSplit, object criticalSlack, object taskType, object durationUnits, object workUnits, object autoTrack, object setDefaults, object assignmentUnits, object effortDriven, object honorConstraints)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSchedule", new object[] { scheduleMessages, startOnCurrentDate, autoLink, autoSplit, criticalSlack, taskType, durationUnits, workUnits, autoTrack, setDefaults, assignmentUnits, effortDriven, honorConstraints });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="scheduleMessages">optional object scheduleMessages</param>
        /// <param name="startOnCurrentDate">optional object startOnCurrentDate</param>
        /// <param name="autoLink">optional object autoLink</param>
        /// <param name="autoSplit">optional object autoSplit</param>
        /// <param name="criticalSlack">optional object criticalSlack</param>
        /// <param name="taskType">optional object taskType</param>
        /// <param name="durationUnits">optional object durationUnits</param>
        /// <param name="workUnits">optional object workUnits</param>
        /// <param name="autoTrack">optional object autoTrack</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="assignmentUnits">optional object assignmentUnits</param>
        /// <param name="effortDriven">optional object effortDriven</param>
        /// <param name="honorConstraints">optional object honorConstraints</param>
        /// <param name="showEstimated">optional object showEstimated</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSchedule(object scheduleMessages, object startOnCurrentDate, object autoLink, object autoSplit, object criticalSlack, object taskType, object durationUnits, object workUnits, object autoTrack, object setDefaults, object assignmentUnits, object effortDriven, object honorConstraints, object showEstimated)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSchedule", new object[] { scheduleMessages, startOnCurrentDate, autoLink, autoSplit, criticalSlack, taskType, durationUnits, workUnits, autoTrack, setDefaults, assignmentUnits, effortDriven, honorConstraints, showEstimated });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="defaultView">optional object defaultView</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="projectSummary">optional object projectSummary</param>
        /// <param name="displayStatusBar">optional object displayStatusBar</param>
        /// <param name="displayEntryBar">optional object displayEntryBar</param>
        /// <param name="displayScrollBars">optional object displayScrollBars</param>
        /// <param name="currencySymbol">optional object currencySymbol</param>
        /// <param name="symbolPlacement">optional object symbolPlacement</param>
        /// <param name="currencyDigits">optional object currencyDigits</param>
        /// <param name="displayOutlineNumber">optional object displayOutlineNumber</param>
        /// <param name="displayOutlineSymbols">optional object displayOutlineSymbols</param>
        /// <param name="displayNameIndent">optional object displayNameIndent</param>
        /// <param name="displaySummaryTasks">optional object displaySummaryTasks</param>
        /// <param name="displayOLEIndicator">optional object displayOLEIndicator</param>
        /// <param name="displayExternalSuccessors">optional object displayExternalSuccessors</param>
        /// <param name="displayExternalPredecessors">optional object displayExternalPredecessors</param>
        /// <param name="crossProjectLinksInfo">optional object crossProjectLinksInfo</param>
        /// <param name="acceptNewExternalData">optional object acceptNewExternalData</param>
        /// <param name="displayWindowsInTaskbar">optional object displayWindowsInTaskbar</param>
        /// <param name="displayScreentips">optional object displayScreentips</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsView(object defaultView, object dateFormat, object projectSummary, object displayStatusBar, object displayEntryBar, object displayScrollBars, object currencySymbol, object symbolPlacement, object currencyDigits, object displayOutlineNumber, object displayOutlineSymbols, object displayNameIndent, object displaySummaryTasks, object displayOLEIndicator, object displayExternalSuccessors, object displayExternalPredecessors, object crossProjectLinksInfo, object acceptNewExternalData, object displayWindowsInTaskbar, object displayScreentips)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsView", new object[] { defaultView, dateFormat, projectSummary, displayStatusBar, displayEntryBar, displayScrollBars, currencySymbol, symbolPlacement, currencyDigits, displayOutlineNumber, displayOutlineSymbols, displayNameIndent, displaySummaryTasks, displayOLEIndicator, displayExternalSuccessors, displayExternalPredecessors, crossProjectLinksInfo, acceptNewExternalData, displayWindowsInTaskbar, displayScreentips });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsView()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsView");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="defaultView">optional object defaultView</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsView(object defaultView)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsView", defaultView);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="defaultView">optional object defaultView</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsView(object defaultView, object dateFormat)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsView", defaultView, dateFormat);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="defaultView">optional object defaultView</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="projectSummary">optional object projectSummary</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsView(object defaultView, object dateFormat, object projectSummary)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsView", defaultView, dateFormat, projectSummary);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="defaultView">optional object defaultView</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="projectSummary">optional object projectSummary</param>
        /// <param name="displayStatusBar">optional object displayStatusBar</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsView(object defaultView, object dateFormat, object projectSummary, object displayStatusBar)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsView", defaultView, dateFormat, projectSummary, displayStatusBar);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="defaultView">optional object defaultView</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="projectSummary">optional object projectSummary</param>
        /// <param name="displayStatusBar">optional object displayStatusBar</param>
        /// <param name="displayEntryBar">optional object displayEntryBar</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsView(object defaultView, object dateFormat, object projectSummary, object displayStatusBar, object displayEntryBar)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsView", new object[] { defaultView, dateFormat, projectSummary, displayStatusBar, displayEntryBar });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="defaultView">optional object defaultView</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="projectSummary">optional object projectSummary</param>
        /// <param name="displayStatusBar">optional object displayStatusBar</param>
        /// <param name="displayEntryBar">optional object displayEntryBar</param>
        /// <param name="displayScrollBars">optional object displayScrollBars</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsView(object defaultView, object dateFormat, object projectSummary, object displayStatusBar, object displayEntryBar, object displayScrollBars)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsView", new object[] { defaultView, dateFormat, projectSummary, displayStatusBar, displayEntryBar, displayScrollBars });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="defaultView">optional object defaultView</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="projectSummary">optional object projectSummary</param>
        /// <param name="displayStatusBar">optional object displayStatusBar</param>
        /// <param name="displayEntryBar">optional object displayEntryBar</param>
        /// <param name="displayScrollBars">optional object displayScrollBars</param>
        /// <param name="currencySymbol">optional object currencySymbol</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsView(object defaultView, object dateFormat, object projectSummary, object displayStatusBar, object displayEntryBar, object displayScrollBars, object currencySymbol)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsView", new object[] { defaultView, dateFormat, projectSummary, displayStatusBar, displayEntryBar, displayScrollBars, currencySymbol });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="defaultView">optional object defaultView</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="projectSummary">optional object projectSummary</param>
        /// <param name="displayStatusBar">optional object displayStatusBar</param>
        /// <param name="displayEntryBar">optional object displayEntryBar</param>
        /// <param name="displayScrollBars">optional object displayScrollBars</param>
        /// <param name="currencySymbol">optional object currencySymbol</param>
        /// <param name="symbolPlacement">optional object symbolPlacement</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsView(object defaultView, object dateFormat, object projectSummary, object displayStatusBar, object displayEntryBar, object displayScrollBars, object currencySymbol, object symbolPlacement)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsView", new object[] { defaultView, dateFormat, projectSummary, displayStatusBar, displayEntryBar, displayScrollBars, currencySymbol, symbolPlacement });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="defaultView">optional object defaultView</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="projectSummary">optional object projectSummary</param>
        /// <param name="displayStatusBar">optional object displayStatusBar</param>
        /// <param name="displayEntryBar">optional object displayEntryBar</param>
        /// <param name="displayScrollBars">optional object displayScrollBars</param>
        /// <param name="currencySymbol">optional object currencySymbol</param>
        /// <param name="symbolPlacement">optional object symbolPlacement</param>
        /// <param name="currencyDigits">optional object currencyDigits</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsView(object defaultView, object dateFormat, object projectSummary, object displayStatusBar, object displayEntryBar, object displayScrollBars, object currencySymbol, object symbolPlacement, object currencyDigits)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsView", new object[] { defaultView, dateFormat, projectSummary, displayStatusBar, displayEntryBar, displayScrollBars, currencySymbol, symbolPlacement, currencyDigits });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="defaultView">optional object defaultView</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="projectSummary">optional object projectSummary</param>
        /// <param name="displayStatusBar">optional object displayStatusBar</param>
        /// <param name="displayEntryBar">optional object displayEntryBar</param>
        /// <param name="displayScrollBars">optional object displayScrollBars</param>
        /// <param name="currencySymbol">optional object currencySymbol</param>
        /// <param name="symbolPlacement">optional object symbolPlacement</param>
        /// <param name="currencyDigits">optional object currencyDigits</param>
        /// <param name="displayOutlineNumber">optional object displayOutlineNumber</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsView(object defaultView, object dateFormat, object projectSummary, object displayStatusBar, object displayEntryBar, object displayScrollBars, object currencySymbol, object symbolPlacement, object currencyDigits, object displayOutlineNumber)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsView", new object[] { defaultView, dateFormat, projectSummary, displayStatusBar, displayEntryBar, displayScrollBars, currencySymbol, symbolPlacement, currencyDigits, displayOutlineNumber });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="defaultView">optional object defaultView</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="projectSummary">optional object projectSummary</param>
        /// <param name="displayStatusBar">optional object displayStatusBar</param>
        /// <param name="displayEntryBar">optional object displayEntryBar</param>
        /// <param name="displayScrollBars">optional object displayScrollBars</param>
        /// <param name="currencySymbol">optional object currencySymbol</param>
        /// <param name="symbolPlacement">optional object symbolPlacement</param>
        /// <param name="currencyDigits">optional object currencyDigits</param>
        /// <param name="displayOutlineNumber">optional object displayOutlineNumber</param>
        /// <param name="displayOutlineSymbols">optional object displayOutlineSymbols</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsView(object defaultView, object dateFormat, object projectSummary, object displayStatusBar, object displayEntryBar, object displayScrollBars, object currencySymbol, object symbolPlacement, object currencyDigits, object displayOutlineNumber, object displayOutlineSymbols)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsView", new object[] { defaultView, dateFormat, projectSummary, displayStatusBar, displayEntryBar, displayScrollBars, currencySymbol, symbolPlacement, currencyDigits, displayOutlineNumber, displayOutlineSymbols });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="defaultView">optional object defaultView</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="projectSummary">optional object projectSummary</param>
        /// <param name="displayStatusBar">optional object displayStatusBar</param>
        /// <param name="displayEntryBar">optional object displayEntryBar</param>
        /// <param name="displayScrollBars">optional object displayScrollBars</param>
        /// <param name="currencySymbol">optional object currencySymbol</param>
        /// <param name="symbolPlacement">optional object symbolPlacement</param>
        /// <param name="currencyDigits">optional object currencyDigits</param>
        /// <param name="displayOutlineNumber">optional object displayOutlineNumber</param>
        /// <param name="displayOutlineSymbols">optional object displayOutlineSymbols</param>
        /// <param name="displayNameIndent">optional object displayNameIndent</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsView(object defaultView, object dateFormat, object projectSummary, object displayStatusBar, object displayEntryBar, object displayScrollBars, object currencySymbol, object symbolPlacement, object currencyDigits, object displayOutlineNumber, object displayOutlineSymbols, object displayNameIndent)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsView", new object[] { defaultView, dateFormat, projectSummary, displayStatusBar, displayEntryBar, displayScrollBars, currencySymbol, symbolPlacement, currencyDigits, displayOutlineNumber, displayOutlineSymbols, displayNameIndent });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="defaultView">optional object defaultView</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="projectSummary">optional object projectSummary</param>
        /// <param name="displayStatusBar">optional object displayStatusBar</param>
        /// <param name="displayEntryBar">optional object displayEntryBar</param>
        /// <param name="displayScrollBars">optional object displayScrollBars</param>
        /// <param name="currencySymbol">optional object currencySymbol</param>
        /// <param name="symbolPlacement">optional object symbolPlacement</param>
        /// <param name="currencyDigits">optional object currencyDigits</param>
        /// <param name="displayOutlineNumber">optional object displayOutlineNumber</param>
        /// <param name="displayOutlineSymbols">optional object displayOutlineSymbols</param>
        /// <param name="displayNameIndent">optional object displayNameIndent</param>
        /// <param name="displaySummaryTasks">optional object displaySummaryTasks</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsView(object defaultView, object dateFormat, object projectSummary, object displayStatusBar, object displayEntryBar, object displayScrollBars, object currencySymbol, object symbolPlacement, object currencyDigits, object displayOutlineNumber, object displayOutlineSymbols, object displayNameIndent, object displaySummaryTasks)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsView", new object[] { defaultView, dateFormat, projectSummary, displayStatusBar, displayEntryBar, displayScrollBars, currencySymbol, symbolPlacement, currencyDigits, displayOutlineNumber, displayOutlineSymbols, displayNameIndent, displaySummaryTasks });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="defaultView">optional object defaultView</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="projectSummary">optional object projectSummary</param>
        /// <param name="displayStatusBar">optional object displayStatusBar</param>
        /// <param name="displayEntryBar">optional object displayEntryBar</param>
        /// <param name="displayScrollBars">optional object displayScrollBars</param>
        /// <param name="currencySymbol">optional object currencySymbol</param>
        /// <param name="symbolPlacement">optional object symbolPlacement</param>
        /// <param name="currencyDigits">optional object currencyDigits</param>
        /// <param name="displayOutlineNumber">optional object displayOutlineNumber</param>
        /// <param name="displayOutlineSymbols">optional object displayOutlineSymbols</param>
        /// <param name="displayNameIndent">optional object displayNameIndent</param>
        /// <param name="displaySummaryTasks">optional object displaySummaryTasks</param>
        /// <param name="displayOLEIndicator">optional object displayOLEIndicator</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsView(object defaultView, object dateFormat, object projectSummary, object displayStatusBar, object displayEntryBar, object displayScrollBars, object currencySymbol, object symbolPlacement, object currencyDigits, object displayOutlineNumber, object displayOutlineSymbols, object displayNameIndent, object displaySummaryTasks, object displayOLEIndicator)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsView", new object[] { defaultView, dateFormat, projectSummary, displayStatusBar, displayEntryBar, displayScrollBars, currencySymbol, symbolPlacement, currencyDigits, displayOutlineNumber, displayOutlineSymbols, displayNameIndent, displaySummaryTasks, displayOLEIndicator });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="defaultView">optional object defaultView</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="projectSummary">optional object projectSummary</param>
        /// <param name="displayStatusBar">optional object displayStatusBar</param>
        /// <param name="displayEntryBar">optional object displayEntryBar</param>
        /// <param name="displayScrollBars">optional object displayScrollBars</param>
        /// <param name="currencySymbol">optional object currencySymbol</param>
        /// <param name="symbolPlacement">optional object symbolPlacement</param>
        /// <param name="currencyDigits">optional object currencyDigits</param>
        /// <param name="displayOutlineNumber">optional object displayOutlineNumber</param>
        /// <param name="displayOutlineSymbols">optional object displayOutlineSymbols</param>
        /// <param name="displayNameIndent">optional object displayNameIndent</param>
        /// <param name="displaySummaryTasks">optional object displaySummaryTasks</param>
        /// <param name="displayOLEIndicator">optional object displayOLEIndicator</param>
        /// <param name="displayExternalSuccessors">optional object displayExternalSuccessors</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsView(object defaultView, object dateFormat, object projectSummary, object displayStatusBar, object displayEntryBar, object displayScrollBars, object currencySymbol, object symbolPlacement, object currencyDigits, object displayOutlineNumber, object displayOutlineSymbols, object displayNameIndent, object displaySummaryTasks, object displayOLEIndicator, object displayExternalSuccessors)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsView", new object[] { defaultView, dateFormat, projectSummary, displayStatusBar, displayEntryBar, displayScrollBars, currencySymbol, symbolPlacement, currencyDigits, displayOutlineNumber, displayOutlineSymbols, displayNameIndent, displaySummaryTasks, displayOLEIndicator, displayExternalSuccessors });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="defaultView">optional object defaultView</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="projectSummary">optional object projectSummary</param>
        /// <param name="displayStatusBar">optional object displayStatusBar</param>
        /// <param name="displayEntryBar">optional object displayEntryBar</param>
        /// <param name="displayScrollBars">optional object displayScrollBars</param>
        /// <param name="currencySymbol">optional object currencySymbol</param>
        /// <param name="symbolPlacement">optional object symbolPlacement</param>
        /// <param name="currencyDigits">optional object currencyDigits</param>
        /// <param name="displayOutlineNumber">optional object displayOutlineNumber</param>
        /// <param name="displayOutlineSymbols">optional object displayOutlineSymbols</param>
        /// <param name="displayNameIndent">optional object displayNameIndent</param>
        /// <param name="displaySummaryTasks">optional object displaySummaryTasks</param>
        /// <param name="displayOLEIndicator">optional object displayOLEIndicator</param>
        /// <param name="displayExternalSuccessors">optional object displayExternalSuccessors</param>
        /// <param name="displayExternalPredecessors">optional object displayExternalPredecessors</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsView(object defaultView, object dateFormat, object projectSummary, object displayStatusBar, object displayEntryBar, object displayScrollBars, object currencySymbol, object symbolPlacement, object currencyDigits, object displayOutlineNumber, object displayOutlineSymbols, object displayNameIndent, object displaySummaryTasks, object displayOLEIndicator, object displayExternalSuccessors, object displayExternalPredecessors)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsView", new object[] { defaultView, dateFormat, projectSummary, displayStatusBar, displayEntryBar, displayScrollBars, currencySymbol, symbolPlacement, currencyDigits, displayOutlineNumber, displayOutlineSymbols, displayNameIndent, displaySummaryTasks, displayOLEIndicator, displayExternalSuccessors, displayExternalPredecessors });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="defaultView">optional object defaultView</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="projectSummary">optional object projectSummary</param>
        /// <param name="displayStatusBar">optional object displayStatusBar</param>
        /// <param name="displayEntryBar">optional object displayEntryBar</param>
        /// <param name="displayScrollBars">optional object displayScrollBars</param>
        /// <param name="currencySymbol">optional object currencySymbol</param>
        /// <param name="symbolPlacement">optional object symbolPlacement</param>
        /// <param name="currencyDigits">optional object currencyDigits</param>
        /// <param name="displayOutlineNumber">optional object displayOutlineNumber</param>
        /// <param name="displayOutlineSymbols">optional object displayOutlineSymbols</param>
        /// <param name="displayNameIndent">optional object displayNameIndent</param>
        /// <param name="displaySummaryTasks">optional object displaySummaryTasks</param>
        /// <param name="displayOLEIndicator">optional object displayOLEIndicator</param>
        /// <param name="displayExternalSuccessors">optional object displayExternalSuccessors</param>
        /// <param name="displayExternalPredecessors">optional object displayExternalPredecessors</param>
        /// <param name="crossProjectLinksInfo">optional object crossProjectLinksInfo</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsView(object defaultView, object dateFormat, object projectSummary, object displayStatusBar, object displayEntryBar, object displayScrollBars, object currencySymbol, object symbolPlacement, object currencyDigits, object displayOutlineNumber, object displayOutlineSymbols, object displayNameIndent, object displaySummaryTasks, object displayOLEIndicator, object displayExternalSuccessors, object displayExternalPredecessors, object crossProjectLinksInfo)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsView", new object[] { defaultView, dateFormat, projectSummary, displayStatusBar, displayEntryBar, displayScrollBars, currencySymbol, symbolPlacement, currencyDigits, displayOutlineNumber, displayOutlineSymbols, displayNameIndent, displaySummaryTasks, displayOLEIndicator, displayExternalSuccessors, displayExternalPredecessors, crossProjectLinksInfo });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="defaultView">optional object defaultView</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="projectSummary">optional object projectSummary</param>
        /// <param name="displayStatusBar">optional object displayStatusBar</param>
        /// <param name="displayEntryBar">optional object displayEntryBar</param>
        /// <param name="displayScrollBars">optional object displayScrollBars</param>
        /// <param name="currencySymbol">optional object currencySymbol</param>
        /// <param name="symbolPlacement">optional object symbolPlacement</param>
        /// <param name="currencyDigits">optional object currencyDigits</param>
        /// <param name="displayOutlineNumber">optional object displayOutlineNumber</param>
        /// <param name="displayOutlineSymbols">optional object displayOutlineSymbols</param>
        /// <param name="displayNameIndent">optional object displayNameIndent</param>
        /// <param name="displaySummaryTasks">optional object displaySummaryTasks</param>
        /// <param name="displayOLEIndicator">optional object displayOLEIndicator</param>
        /// <param name="displayExternalSuccessors">optional object displayExternalSuccessors</param>
        /// <param name="displayExternalPredecessors">optional object displayExternalPredecessors</param>
        /// <param name="crossProjectLinksInfo">optional object crossProjectLinksInfo</param>
        /// <param name="acceptNewExternalData">optional object acceptNewExternalData</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsView(object defaultView, object dateFormat, object projectSummary, object displayStatusBar, object displayEntryBar, object displayScrollBars, object currencySymbol, object symbolPlacement, object currencyDigits, object displayOutlineNumber, object displayOutlineSymbols, object displayNameIndent, object displaySummaryTasks, object displayOLEIndicator, object displayExternalSuccessors, object displayExternalPredecessors, object crossProjectLinksInfo, object acceptNewExternalData)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsView", new object[] { defaultView, dateFormat, projectSummary, displayStatusBar, displayEntryBar, displayScrollBars, currencySymbol, symbolPlacement, currencyDigits, displayOutlineNumber, displayOutlineSymbols, displayNameIndent, displaySummaryTasks, displayOLEIndicator, displayExternalSuccessors, displayExternalPredecessors, crossProjectLinksInfo, acceptNewExternalData });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="defaultView">optional object defaultView</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="projectSummary">optional object projectSummary</param>
        /// <param name="displayStatusBar">optional object displayStatusBar</param>
        /// <param name="displayEntryBar">optional object displayEntryBar</param>
        /// <param name="displayScrollBars">optional object displayScrollBars</param>
        /// <param name="currencySymbol">optional object currencySymbol</param>
        /// <param name="symbolPlacement">optional object symbolPlacement</param>
        /// <param name="currencyDigits">optional object currencyDigits</param>
        /// <param name="displayOutlineNumber">optional object displayOutlineNumber</param>
        /// <param name="displayOutlineSymbols">optional object displayOutlineSymbols</param>
        /// <param name="displayNameIndent">optional object displayNameIndent</param>
        /// <param name="displaySummaryTasks">optional object displaySummaryTasks</param>
        /// <param name="displayOLEIndicator">optional object displayOLEIndicator</param>
        /// <param name="displayExternalSuccessors">optional object displayExternalSuccessors</param>
        /// <param name="displayExternalPredecessors">optional object displayExternalPredecessors</param>
        /// <param name="crossProjectLinksInfo">optional object crossProjectLinksInfo</param>
        /// <param name="acceptNewExternalData">optional object acceptNewExternalData</param>
        /// <param name="displayWindowsInTaskbar">optional object displayWindowsInTaskbar</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsView(object defaultView, object dateFormat, object projectSummary, object displayStatusBar, object displayEntryBar, object displayScrollBars, object currencySymbol, object symbolPlacement, object currencyDigits, object displayOutlineNumber, object displayOutlineSymbols, object displayNameIndent, object displaySummaryTasks, object displayOLEIndicator, object displayExternalSuccessors, object displayExternalPredecessors, object crossProjectLinksInfo, object acceptNewExternalData, object displayWindowsInTaskbar)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsView", new object[] { defaultView, dateFormat, projectSummary, displayStatusBar, displayEntryBar, displayScrollBars, currencySymbol, symbolPlacement, currencyDigits, displayOutlineNumber, displayOutlineSymbols, displayNameIndent, displaySummaryTasks, displayOLEIndicator, displayExternalSuccessors, displayExternalPredecessors, crossProjectLinksInfo, acceptNewExternalData, displayWindowsInTaskbar });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="workgroupMessages">optional object workgroupMessages</param>
        /// <param name="serverURL">optional object serverURL</param>
        /// <param name="serverPath">optional object serverPath</param>
        /// <param name="receiveNotifications">optional object receiveNotifications</param>
        /// <param name="sendHyperlinkNote">optional object sendHyperlinkNote</param>
        /// <param name="hyperlinkColor">optional object hyperlinkColor</param>
        /// <param name="followedHyperlinkColor">optional object followedHyperlinkColor</param>
        /// <param name="underlineHyperlinks">optional object underlineHyperlinks</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="serverIdentification">optional object serverIdentification</param>
        /// <param name="allowTaskDelegation">optional object allowTaskDelegation</param>
        /// <param name="updateProjectToWeb">optional object updateProjectToWeb</param>
        /// <param name="publishInformationOnSave">optional object publishInformationOnSave</param>
        /// <param name="setDefaultsMessaging">optional object setDefaultsMessaging</param>
        /// <param name="setDefaultsWebServer">optional object setDefaultsWebServer</param>
        /// <param name="managerEmail">optional object managerEmail</param>
        /// <param name="confirmationDialog">optional object confirmationDialog</param>
        /// <param name="changesMarkAssnDirty">optional object changesMarkAssnDirty</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsWorkgroup(object workgroupMessages, object serverURL, object serverPath, object receiveNotifications, object sendHyperlinkNote, object hyperlinkColor, object followedHyperlinkColor, object underlineHyperlinks, object setDefaults, object serverIdentification, object allowTaskDelegation, object updateProjectToWeb, object publishInformationOnSave, object setDefaultsMessaging, object setDefaultsWebServer, object managerEmail, object confirmationDialog, object changesMarkAssnDirty)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsWorkgroup", new object[] { workgroupMessages, serverURL, serverPath, receiveNotifications, sendHyperlinkNote, hyperlinkColor, followedHyperlinkColor, underlineHyperlinks, setDefaults, serverIdentification, allowTaskDelegation, updateProjectToWeb, publishInformationOnSave, setDefaultsMessaging, setDefaultsWebServer, managerEmail, confirmationDialog, changesMarkAssnDirty });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsWorkgroup()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsWorkgroup");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="workgroupMessages">optional object workgroupMessages</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsWorkgroup(object workgroupMessages)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsWorkgroup", workgroupMessages);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="workgroupMessages">optional object workgroupMessages</param>
        /// <param name="serverURL">optional object serverURL</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsWorkgroup(object workgroupMessages, object serverURL)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsWorkgroup", workgroupMessages, serverURL);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="workgroupMessages">optional object workgroupMessages</param>
        /// <param name="serverURL">optional object serverURL</param>
        /// <param name="serverPath">optional object serverPath</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsWorkgroup(object workgroupMessages, object serverURL, object serverPath)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsWorkgroup", workgroupMessages, serverURL, serverPath);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="workgroupMessages">optional object workgroupMessages</param>
        /// <param name="serverURL">optional object serverURL</param>
        /// <param name="serverPath">optional object serverPath</param>
        /// <param name="receiveNotifications">optional object receiveNotifications</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsWorkgroup(object workgroupMessages, object serverURL, object serverPath, object receiveNotifications)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsWorkgroup", workgroupMessages, serverURL, serverPath, receiveNotifications);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="workgroupMessages">optional object workgroupMessages</param>
        /// <param name="serverURL">optional object serverURL</param>
        /// <param name="serverPath">optional object serverPath</param>
        /// <param name="receiveNotifications">optional object receiveNotifications</param>
        /// <param name="sendHyperlinkNote">optional object sendHyperlinkNote</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsWorkgroup(object workgroupMessages, object serverURL, object serverPath, object receiveNotifications, object sendHyperlinkNote)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsWorkgroup", new object[] { workgroupMessages, serverURL, serverPath, receiveNotifications, sendHyperlinkNote });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="workgroupMessages">optional object workgroupMessages</param>
        /// <param name="serverURL">optional object serverURL</param>
        /// <param name="serverPath">optional object serverPath</param>
        /// <param name="receiveNotifications">optional object receiveNotifications</param>
        /// <param name="sendHyperlinkNote">optional object sendHyperlinkNote</param>
        /// <param name="hyperlinkColor">optional object hyperlinkColor</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsWorkgroup(object workgroupMessages, object serverURL, object serverPath, object receiveNotifications, object sendHyperlinkNote, object hyperlinkColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsWorkgroup", new object[] { workgroupMessages, serverURL, serverPath, receiveNotifications, sendHyperlinkNote, hyperlinkColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="workgroupMessages">optional object workgroupMessages</param>
        /// <param name="serverURL">optional object serverURL</param>
        /// <param name="serverPath">optional object serverPath</param>
        /// <param name="receiveNotifications">optional object receiveNotifications</param>
        /// <param name="sendHyperlinkNote">optional object sendHyperlinkNote</param>
        /// <param name="hyperlinkColor">optional object hyperlinkColor</param>
        /// <param name="followedHyperlinkColor">optional object followedHyperlinkColor</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsWorkgroup(object workgroupMessages, object serverURL, object serverPath, object receiveNotifications, object sendHyperlinkNote, object hyperlinkColor, object followedHyperlinkColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsWorkgroup", new object[] { workgroupMessages, serverURL, serverPath, receiveNotifications, sendHyperlinkNote, hyperlinkColor, followedHyperlinkColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="workgroupMessages">optional object workgroupMessages</param>
        /// <param name="serverURL">optional object serverURL</param>
        /// <param name="serverPath">optional object serverPath</param>
        /// <param name="receiveNotifications">optional object receiveNotifications</param>
        /// <param name="sendHyperlinkNote">optional object sendHyperlinkNote</param>
        /// <param name="hyperlinkColor">optional object hyperlinkColor</param>
        /// <param name="followedHyperlinkColor">optional object followedHyperlinkColor</param>
        /// <param name="underlineHyperlinks">optional object underlineHyperlinks</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsWorkgroup(object workgroupMessages, object serverURL, object serverPath, object receiveNotifications, object sendHyperlinkNote, object hyperlinkColor, object followedHyperlinkColor, object underlineHyperlinks)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsWorkgroup", new object[] { workgroupMessages, serverURL, serverPath, receiveNotifications, sendHyperlinkNote, hyperlinkColor, followedHyperlinkColor, underlineHyperlinks });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="workgroupMessages">optional object workgroupMessages</param>
        /// <param name="serverURL">optional object serverURL</param>
        /// <param name="serverPath">optional object serverPath</param>
        /// <param name="receiveNotifications">optional object receiveNotifications</param>
        /// <param name="sendHyperlinkNote">optional object sendHyperlinkNote</param>
        /// <param name="hyperlinkColor">optional object hyperlinkColor</param>
        /// <param name="followedHyperlinkColor">optional object followedHyperlinkColor</param>
        /// <param name="underlineHyperlinks">optional object underlineHyperlinks</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsWorkgroup(object workgroupMessages, object serverURL, object serverPath, object receiveNotifications, object sendHyperlinkNote, object hyperlinkColor, object followedHyperlinkColor, object underlineHyperlinks, object setDefaults)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsWorkgroup", new object[] { workgroupMessages, serverURL, serverPath, receiveNotifications, sendHyperlinkNote, hyperlinkColor, followedHyperlinkColor, underlineHyperlinks, setDefaults });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="workgroupMessages">optional object workgroupMessages</param>
        /// <param name="serverURL">optional object serverURL</param>
        /// <param name="serverPath">optional object serverPath</param>
        /// <param name="receiveNotifications">optional object receiveNotifications</param>
        /// <param name="sendHyperlinkNote">optional object sendHyperlinkNote</param>
        /// <param name="hyperlinkColor">optional object hyperlinkColor</param>
        /// <param name="followedHyperlinkColor">optional object followedHyperlinkColor</param>
        /// <param name="underlineHyperlinks">optional object underlineHyperlinks</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="serverIdentification">optional object serverIdentification</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsWorkgroup(object workgroupMessages, object serverURL, object serverPath, object receiveNotifications, object sendHyperlinkNote, object hyperlinkColor, object followedHyperlinkColor, object underlineHyperlinks, object setDefaults, object serverIdentification)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsWorkgroup", new object[] { workgroupMessages, serverURL, serverPath, receiveNotifications, sendHyperlinkNote, hyperlinkColor, followedHyperlinkColor, underlineHyperlinks, setDefaults, serverIdentification });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="workgroupMessages">optional object workgroupMessages</param>
        /// <param name="serverURL">optional object serverURL</param>
        /// <param name="serverPath">optional object serverPath</param>
        /// <param name="receiveNotifications">optional object receiveNotifications</param>
        /// <param name="sendHyperlinkNote">optional object sendHyperlinkNote</param>
        /// <param name="hyperlinkColor">optional object hyperlinkColor</param>
        /// <param name="followedHyperlinkColor">optional object followedHyperlinkColor</param>
        /// <param name="underlineHyperlinks">optional object underlineHyperlinks</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="serverIdentification">optional object serverIdentification</param>
        /// <param name="allowTaskDelegation">optional object allowTaskDelegation</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsWorkgroup(object workgroupMessages, object serverURL, object serverPath, object receiveNotifications, object sendHyperlinkNote, object hyperlinkColor, object followedHyperlinkColor, object underlineHyperlinks, object setDefaults, object serverIdentification, object allowTaskDelegation)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsWorkgroup", new object[] { workgroupMessages, serverURL, serverPath, receiveNotifications, sendHyperlinkNote, hyperlinkColor, followedHyperlinkColor, underlineHyperlinks, setDefaults, serverIdentification, allowTaskDelegation });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="workgroupMessages">optional object workgroupMessages</param>
        /// <param name="serverURL">optional object serverURL</param>
        /// <param name="serverPath">optional object serverPath</param>
        /// <param name="receiveNotifications">optional object receiveNotifications</param>
        /// <param name="sendHyperlinkNote">optional object sendHyperlinkNote</param>
        /// <param name="hyperlinkColor">optional object hyperlinkColor</param>
        /// <param name="followedHyperlinkColor">optional object followedHyperlinkColor</param>
        /// <param name="underlineHyperlinks">optional object underlineHyperlinks</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="serverIdentification">optional object serverIdentification</param>
        /// <param name="allowTaskDelegation">optional object allowTaskDelegation</param>
        /// <param name="updateProjectToWeb">optional object updateProjectToWeb</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsWorkgroup(object workgroupMessages, object serverURL, object serverPath, object receiveNotifications, object sendHyperlinkNote, object hyperlinkColor, object followedHyperlinkColor, object underlineHyperlinks, object setDefaults, object serverIdentification, object allowTaskDelegation, object updateProjectToWeb)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsWorkgroup", new object[] { workgroupMessages, serverURL, serverPath, receiveNotifications, sendHyperlinkNote, hyperlinkColor, followedHyperlinkColor, underlineHyperlinks, setDefaults, serverIdentification, allowTaskDelegation, updateProjectToWeb });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="workgroupMessages">optional object workgroupMessages</param>
        /// <param name="serverURL">optional object serverURL</param>
        /// <param name="serverPath">optional object serverPath</param>
        /// <param name="receiveNotifications">optional object receiveNotifications</param>
        /// <param name="sendHyperlinkNote">optional object sendHyperlinkNote</param>
        /// <param name="hyperlinkColor">optional object hyperlinkColor</param>
        /// <param name="followedHyperlinkColor">optional object followedHyperlinkColor</param>
        /// <param name="underlineHyperlinks">optional object underlineHyperlinks</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="serverIdentification">optional object serverIdentification</param>
        /// <param name="allowTaskDelegation">optional object allowTaskDelegation</param>
        /// <param name="updateProjectToWeb">optional object updateProjectToWeb</param>
        /// <param name="publishInformationOnSave">optional object publishInformationOnSave</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsWorkgroup(object workgroupMessages, object serverURL, object serverPath, object receiveNotifications, object sendHyperlinkNote, object hyperlinkColor, object followedHyperlinkColor, object underlineHyperlinks, object setDefaults, object serverIdentification, object allowTaskDelegation, object updateProjectToWeb, object publishInformationOnSave)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsWorkgroup", new object[] { workgroupMessages, serverURL, serverPath, receiveNotifications, sendHyperlinkNote, hyperlinkColor, followedHyperlinkColor, underlineHyperlinks, setDefaults, serverIdentification, allowTaskDelegation, updateProjectToWeb, publishInformationOnSave });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="workgroupMessages">optional object workgroupMessages</param>
        /// <param name="serverURL">optional object serverURL</param>
        /// <param name="serverPath">optional object serverPath</param>
        /// <param name="receiveNotifications">optional object receiveNotifications</param>
        /// <param name="sendHyperlinkNote">optional object sendHyperlinkNote</param>
        /// <param name="hyperlinkColor">optional object hyperlinkColor</param>
        /// <param name="followedHyperlinkColor">optional object followedHyperlinkColor</param>
        /// <param name="underlineHyperlinks">optional object underlineHyperlinks</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="serverIdentification">optional object serverIdentification</param>
        /// <param name="allowTaskDelegation">optional object allowTaskDelegation</param>
        /// <param name="updateProjectToWeb">optional object updateProjectToWeb</param>
        /// <param name="publishInformationOnSave">optional object publishInformationOnSave</param>
        /// <param name="setDefaultsMessaging">optional object setDefaultsMessaging</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsWorkgroup(object workgroupMessages, object serverURL, object serverPath, object receiveNotifications, object sendHyperlinkNote, object hyperlinkColor, object followedHyperlinkColor, object underlineHyperlinks, object setDefaults, object serverIdentification, object allowTaskDelegation, object updateProjectToWeb, object publishInformationOnSave, object setDefaultsMessaging)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsWorkgroup", new object[] { workgroupMessages, serverURL, serverPath, receiveNotifications, sendHyperlinkNote, hyperlinkColor, followedHyperlinkColor, underlineHyperlinks, setDefaults, serverIdentification, allowTaskDelegation, updateProjectToWeb, publishInformationOnSave, setDefaultsMessaging });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="workgroupMessages">optional object workgroupMessages</param>
        /// <param name="serverURL">optional object serverURL</param>
        /// <param name="serverPath">optional object serverPath</param>
        /// <param name="receiveNotifications">optional object receiveNotifications</param>
        /// <param name="sendHyperlinkNote">optional object sendHyperlinkNote</param>
        /// <param name="hyperlinkColor">optional object hyperlinkColor</param>
        /// <param name="followedHyperlinkColor">optional object followedHyperlinkColor</param>
        /// <param name="underlineHyperlinks">optional object underlineHyperlinks</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="serverIdentification">optional object serverIdentification</param>
        /// <param name="allowTaskDelegation">optional object allowTaskDelegation</param>
        /// <param name="updateProjectToWeb">optional object updateProjectToWeb</param>
        /// <param name="publishInformationOnSave">optional object publishInformationOnSave</param>
        /// <param name="setDefaultsMessaging">optional object setDefaultsMessaging</param>
        /// <param name="setDefaultsWebServer">optional object setDefaultsWebServer</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsWorkgroup(object workgroupMessages, object serverURL, object serverPath, object receiveNotifications, object sendHyperlinkNote, object hyperlinkColor, object followedHyperlinkColor, object underlineHyperlinks, object setDefaults, object serverIdentification, object allowTaskDelegation, object updateProjectToWeb, object publishInformationOnSave, object setDefaultsMessaging, object setDefaultsWebServer)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsWorkgroup", new object[] { workgroupMessages, serverURL, serverPath, receiveNotifications, sendHyperlinkNote, hyperlinkColor, followedHyperlinkColor, underlineHyperlinks, setDefaults, serverIdentification, allowTaskDelegation, updateProjectToWeb, publishInformationOnSave, setDefaultsMessaging, setDefaultsWebServer });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="workgroupMessages">optional object workgroupMessages</param>
        /// <param name="serverURL">optional object serverURL</param>
        /// <param name="serverPath">optional object serverPath</param>
        /// <param name="receiveNotifications">optional object receiveNotifications</param>
        /// <param name="sendHyperlinkNote">optional object sendHyperlinkNote</param>
        /// <param name="hyperlinkColor">optional object hyperlinkColor</param>
        /// <param name="followedHyperlinkColor">optional object followedHyperlinkColor</param>
        /// <param name="underlineHyperlinks">optional object underlineHyperlinks</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="serverIdentification">optional object serverIdentification</param>
        /// <param name="allowTaskDelegation">optional object allowTaskDelegation</param>
        /// <param name="updateProjectToWeb">optional object updateProjectToWeb</param>
        /// <param name="publishInformationOnSave">optional object publishInformationOnSave</param>
        /// <param name="setDefaultsMessaging">optional object setDefaultsMessaging</param>
        /// <param name="setDefaultsWebServer">optional object setDefaultsWebServer</param>
        /// <param name="managerEmail">optional object managerEmail</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsWorkgroup(object workgroupMessages, object serverURL, object serverPath, object receiveNotifications, object sendHyperlinkNote, object hyperlinkColor, object followedHyperlinkColor, object underlineHyperlinks, object setDefaults, object serverIdentification, object allowTaskDelegation, object updateProjectToWeb, object publishInformationOnSave, object setDefaultsMessaging, object setDefaultsWebServer, object managerEmail)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsWorkgroup", new object[] { workgroupMessages, serverURL, serverPath, receiveNotifications, sendHyperlinkNote, hyperlinkColor, followedHyperlinkColor, underlineHyperlinks, setDefaults, serverIdentification, allowTaskDelegation, updateProjectToWeb, publishInformationOnSave, setDefaultsMessaging, setDefaultsWebServer, managerEmail });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="workgroupMessages">optional object workgroupMessages</param>
        /// <param name="serverURL">optional object serverURL</param>
        /// <param name="serverPath">optional object serverPath</param>
        /// <param name="receiveNotifications">optional object receiveNotifications</param>
        /// <param name="sendHyperlinkNote">optional object sendHyperlinkNote</param>
        /// <param name="hyperlinkColor">optional object hyperlinkColor</param>
        /// <param name="followedHyperlinkColor">optional object followedHyperlinkColor</param>
        /// <param name="underlineHyperlinks">optional object underlineHyperlinks</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="serverIdentification">optional object serverIdentification</param>
        /// <param name="allowTaskDelegation">optional object allowTaskDelegation</param>
        /// <param name="updateProjectToWeb">optional object updateProjectToWeb</param>
        /// <param name="publishInformationOnSave">optional object publishInformationOnSave</param>
        /// <param name="setDefaultsMessaging">optional object setDefaultsMessaging</param>
        /// <param name="setDefaultsWebServer">optional object setDefaultsWebServer</param>
        /// <param name="managerEmail">optional object managerEmail</param>
        /// <param name="confirmationDialog">optional object confirmationDialog</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsWorkgroup(object workgroupMessages, object serverURL, object serverPath, object receiveNotifications, object sendHyperlinkNote, object hyperlinkColor, object followedHyperlinkColor, object underlineHyperlinks, object setDefaults, object serverIdentification, object allowTaskDelegation, object updateProjectToWeb, object publishInformationOnSave, object setDefaultsMessaging, object setDefaultsWebServer, object managerEmail, object confirmationDialog)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsWorkgroup", new object[] { workgroupMessages, serverURL, serverPath, receiveNotifications, sendHyperlinkNote, hyperlinkColor, followedHyperlinkColor, underlineHyperlinks, setDefaults, serverIdentification, allowTaskDelegation, updateProjectToWeb, publishInformationOnSave, setDefaultsMessaging, setDefaultsWebServer, managerEmail, confirmationDialog });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="autoTrack">optional object autoTrack</param>
        /// <param name="spreadPercentToStatusDate">optional object spreadPercentToStatusDate</param>
        /// <param name="spreadCostsToStatusDate">optional object spreadCostsToStatusDate</param>
        /// <param name="autoCalcCosts">optional object autoCalcCosts</param>
        /// <param name="fixedCostAccrual">optional object fixedCostAccrual</param>
        /// <param name="calcMultipleCriticalPaths">optional object calcMultipleCriticalPaths</param>
        /// <param name="criticalSlack">optional object criticalSlack</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="calcInsProjLikeSummTask">optional object calcInsProjLikeSummTask</param>
        /// <param name="moveCompleted">optional object moveCompleted</param>
        /// <param name="andMoveRemaining">optional object andMoveRemaining</param>
        /// <param name="moveRemaining">optional object moveRemaining</param>
        /// <param name="andMoveCompleted">optional object andMoveCompleted</param>
        /// <param name="eVMethod">optional object eVMethod</param>
        /// <param name="eVBaseline">optional object eVBaseline</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalculation(object automatic, object autoTrack, object spreadPercentToStatusDate, object spreadCostsToStatusDate, object autoCalcCosts, object fixedCostAccrual, object calcMultipleCriticalPaths, object criticalSlack, object setDefaults, object calcInsProjLikeSummTask, object moveCompleted, object andMoveRemaining, object moveRemaining, object andMoveCompleted, object eVMethod, object eVBaseline)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalculation", new object[] { automatic, autoTrack, spreadPercentToStatusDate, spreadCostsToStatusDate, autoCalcCosts, fixedCostAccrual, calcMultipleCriticalPaths, criticalSlack, setDefaults, calcInsProjLikeSummTask, moveCompleted, andMoveRemaining, moveRemaining, andMoveCompleted, eVMethod, eVBaseline });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalculation()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalculation");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalculation(object automatic)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalculation", automatic);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="autoTrack">optional object autoTrack</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalculation(object automatic, object autoTrack)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalculation", automatic, autoTrack);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="autoTrack">optional object autoTrack</param>
        /// <param name="spreadPercentToStatusDate">optional object spreadPercentToStatusDate</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalculation(object automatic, object autoTrack, object spreadPercentToStatusDate)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalculation", automatic, autoTrack, spreadPercentToStatusDate);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="autoTrack">optional object autoTrack</param>
        /// <param name="spreadPercentToStatusDate">optional object spreadPercentToStatusDate</param>
        /// <param name="spreadCostsToStatusDate">optional object spreadCostsToStatusDate</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalculation(object automatic, object autoTrack, object spreadPercentToStatusDate, object spreadCostsToStatusDate)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalculation", automatic, autoTrack, spreadPercentToStatusDate, spreadCostsToStatusDate);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="autoTrack">optional object autoTrack</param>
        /// <param name="spreadPercentToStatusDate">optional object spreadPercentToStatusDate</param>
        /// <param name="spreadCostsToStatusDate">optional object spreadCostsToStatusDate</param>
        /// <param name="autoCalcCosts">optional object autoCalcCosts</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalculation(object automatic, object autoTrack, object spreadPercentToStatusDate, object spreadCostsToStatusDate, object autoCalcCosts)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalculation", new object[] { automatic, autoTrack, spreadPercentToStatusDate, spreadCostsToStatusDate, autoCalcCosts });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="autoTrack">optional object autoTrack</param>
        /// <param name="spreadPercentToStatusDate">optional object spreadPercentToStatusDate</param>
        /// <param name="spreadCostsToStatusDate">optional object spreadCostsToStatusDate</param>
        /// <param name="autoCalcCosts">optional object autoCalcCosts</param>
        /// <param name="fixedCostAccrual">optional object fixedCostAccrual</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalculation(object automatic, object autoTrack, object spreadPercentToStatusDate, object spreadCostsToStatusDate, object autoCalcCosts, object fixedCostAccrual)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalculation", new object[] { automatic, autoTrack, spreadPercentToStatusDate, spreadCostsToStatusDate, autoCalcCosts, fixedCostAccrual });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="autoTrack">optional object autoTrack</param>
        /// <param name="spreadPercentToStatusDate">optional object spreadPercentToStatusDate</param>
        /// <param name="spreadCostsToStatusDate">optional object spreadCostsToStatusDate</param>
        /// <param name="autoCalcCosts">optional object autoCalcCosts</param>
        /// <param name="fixedCostAccrual">optional object fixedCostAccrual</param>
        /// <param name="calcMultipleCriticalPaths">optional object calcMultipleCriticalPaths</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalculation(object automatic, object autoTrack, object spreadPercentToStatusDate, object spreadCostsToStatusDate, object autoCalcCosts, object fixedCostAccrual, object calcMultipleCriticalPaths)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalculation", new object[] { automatic, autoTrack, spreadPercentToStatusDate, spreadCostsToStatusDate, autoCalcCosts, fixedCostAccrual, calcMultipleCriticalPaths });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="autoTrack">optional object autoTrack</param>
        /// <param name="spreadPercentToStatusDate">optional object spreadPercentToStatusDate</param>
        /// <param name="spreadCostsToStatusDate">optional object spreadCostsToStatusDate</param>
        /// <param name="autoCalcCosts">optional object autoCalcCosts</param>
        /// <param name="fixedCostAccrual">optional object fixedCostAccrual</param>
        /// <param name="calcMultipleCriticalPaths">optional object calcMultipleCriticalPaths</param>
        /// <param name="criticalSlack">optional object criticalSlack</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalculation(object automatic, object autoTrack, object spreadPercentToStatusDate, object spreadCostsToStatusDate, object autoCalcCosts, object fixedCostAccrual, object calcMultipleCriticalPaths, object criticalSlack)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalculation", new object[] { automatic, autoTrack, spreadPercentToStatusDate, spreadCostsToStatusDate, autoCalcCosts, fixedCostAccrual, calcMultipleCriticalPaths, criticalSlack });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="autoTrack">optional object autoTrack</param>
        /// <param name="spreadPercentToStatusDate">optional object spreadPercentToStatusDate</param>
        /// <param name="spreadCostsToStatusDate">optional object spreadCostsToStatusDate</param>
        /// <param name="autoCalcCosts">optional object autoCalcCosts</param>
        /// <param name="fixedCostAccrual">optional object fixedCostAccrual</param>
        /// <param name="calcMultipleCriticalPaths">optional object calcMultipleCriticalPaths</param>
        /// <param name="criticalSlack">optional object criticalSlack</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalculation(object automatic, object autoTrack, object spreadPercentToStatusDate, object spreadCostsToStatusDate, object autoCalcCosts, object fixedCostAccrual, object calcMultipleCriticalPaths, object criticalSlack, object setDefaults)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalculation", new object[] { automatic, autoTrack, spreadPercentToStatusDate, spreadCostsToStatusDate, autoCalcCosts, fixedCostAccrual, calcMultipleCriticalPaths, criticalSlack, setDefaults });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="autoTrack">optional object autoTrack</param>
        /// <param name="spreadPercentToStatusDate">optional object spreadPercentToStatusDate</param>
        /// <param name="spreadCostsToStatusDate">optional object spreadCostsToStatusDate</param>
        /// <param name="autoCalcCosts">optional object autoCalcCosts</param>
        /// <param name="fixedCostAccrual">optional object fixedCostAccrual</param>
        /// <param name="calcMultipleCriticalPaths">optional object calcMultipleCriticalPaths</param>
        /// <param name="criticalSlack">optional object criticalSlack</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="calcInsProjLikeSummTask">optional object calcInsProjLikeSummTask</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalculation(object automatic, object autoTrack, object spreadPercentToStatusDate, object spreadCostsToStatusDate, object autoCalcCosts, object fixedCostAccrual, object calcMultipleCriticalPaths, object criticalSlack, object setDefaults, object calcInsProjLikeSummTask)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalculation", new object[] { automatic, autoTrack, spreadPercentToStatusDate, spreadCostsToStatusDate, autoCalcCosts, fixedCostAccrual, calcMultipleCriticalPaths, criticalSlack, setDefaults, calcInsProjLikeSummTask });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="autoTrack">optional object autoTrack</param>
        /// <param name="spreadPercentToStatusDate">optional object spreadPercentToStatusDate</param>
        /// <param name="spreadCostsToStatusDate">optional object spreadCostsToStatusDate</param>
        /// <param name="autoCalcCosts">optional object autoCalcCosts</param>
        /// <param name="fixedCostAccrual">optional object fixedCostAccrual</param>
        /// <param name="calcMultipleCriticalPaths">optional object calcMultipleCriticalPaths</param>
        /// <param name="criticalSlack">optional object criticalSlack</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="calcInsProjLikeSummTask">optional object calcInsProjLikeSummTask</param>
        /// <param name="moveCompleted">optional object moveCompleted</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalculation(object automatic, object autoTrack, object spreadPercentToStatusDate, object spreadCostsToStatusDate, object autoCalcCosts, object fixedCostAccrual, object calcMultipleCriticalPaths, object criticalSlack, object setDefaults, object calcInsProjLikeSummTask, object moveCompleted)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalculation", new object[] { automatic, autoTrack, spreadPercentToStatusDate, spreadCostsToStatusDate, autoCalcCosts, fixedCostAccrual, calcMultipleCriticalPaths, criticalSlack, setDefaults, calcInsProjLikeSummTask, moveCompleted });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="autoTrack">optional object autoTrack</param>
        /// <param name="spreadPercentToStatusDate">optional object spreadPercentToStatusDate</param>
        /// <param name="spreadCostsToStatusDate">optional object spreadCostsToStatusDate</param>
        /// <param name="autoCalcCosts">optional object autoCalcCosts</param>
        /// <param name="fixedCostAccrual">optional object fixedCostAccrual</param>
        /// <param name="calcMultipleCriticalPaths">optional object calcMultipleCriticalPaths</param>
        /// <param name="criticalSlack">optional object criticalSlack</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="calcInsProjLikeSummTask">optional object calcInsProjLikeSummTask</param>
        /// <param name="moveCompleted">optional object moveCompleted</param>
        /// <param name="andMoveRemaining">optional object andMoveRemaining</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalculation(object automatic, object autoTrack, object spreadPercentToStatusDate, object spreadCostsToStatusDate, object autoCalcCosts, object fixedCostAccrual, object calcMultipleCriticalPaths, object criticalSlack, object setDefaults, object calcInsProjLikeSummTask, object moveCompleted, object andMoveRemaining)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalculation", new object[] { automatic, autoTrack, spreadPercentToStatusDate, spreadCostsToStatusDate, autoCalcCosts, fixedCostAccrual, calcMultipleCriticalPaths, criticalSlack, setDefaults, calcInsProjLikeSummTask, moveCompleted, andMoveRemaining });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="autoTrack">optional object autoTrack</param>
        /// <param name="spreadPercentToStatusDate">optional object spreadPercentToStatusDate</param>
        /// <param name="spreadCostsToStatusDate">optional object spreadCostsToStatusDate</param>
        /// <param name="autoCalcCosts">optional object autoCalcCosts</param>
        /// <param name="fixedCostAccrual">optional object fixedCostAccrual</param>
        /// <param name="calcMultipleCriticalPaths">optional object calcMultipleCriticalPaths</param>
        /// <param name="criticalSlack">optional object criticalSlack</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="calcInsProjLikeSummTask">optional object calcInsProjLikeSummTask</param>
        /// <param name="moveCompleted">optional object moveCompleted</param>
        /// <param name="andMoveRemaining">optional object andMoveRemaining</param>
        /// <param name="moveRemaining">optional object moveRemaining</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalculation(object automatic, object autoTrack, object spreadPercentToStatusDate, object spreadCostsToStatusDate, object autoCalcCosts, object fixedCostAccrual, object calcMultipleCriticalPaths, object criticalSlack, object setDefaults, object calcInsProjLikeSummTask, object moveCompleted, object andMoveRemaining, object moveRemaining)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalculation", new object[] { automatic, autoTrack, spreadPercentToStatusDate, spreadCostsToStatusDate, autoCalcCosts, fixedCostAccrual, calcMultipleCriticalPaths, criticalSlack, setDefaults, calcInsProjLikeSummTask, moveCompleted, andMoveRemaining, moveRemaining });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="autoTrack">optional object autoTrack</param>
        /// <param name="spreadPercentToStatusDate">optional object spreadPercentToStatusDate</param>
        /// <param name="spreadCostsToStatusDate">optional object spreadCostsToStatusDate</param>
        /// <param name="autoCalcCosts">optional object autoCalcCosts</param>
        /// <param name="fixedCostAccrual">optional object fixedCostAccrual</param>
        /// <param name="calcMultipleCriticalPaths">optional object calcMultipleCriticalPaths</param>
        /// <param name="criticalSlack">optional object criticalSlack</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="calcInsProjLikeSummTask">optional object calcInsProjLikeSummTask</param>
        /// <param name="moveCompleted">optional object moveCompleted</param>
        /// <param name="andMoveRemaining">optional object andMoveRemaining</param>
        /// <param name="moveRemaining">optional object moveRemaining</param>
        /// <param name="andMoveCompleted">optional object andMoveCompleted</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalculation(object automatic, object autoTrack, object spreadPercentToStatusDate, object spreadCostsToStatusDate, object autoCalcCosts, object fixedCostAccrual, object calcMultipleCriticalPaths, object criticalSlack, object setDefaults, object calcInsProjLikeSummTask, object moveCompleted, object andMoveRemaining, object moveRemaining, object andMoveCompleted)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalculation", new object[] { automatic, autoTrack, spreadPercentToStatusDate, spreadCostsToStatusDate, autoCalcCosts, fixedCostAccrual, calcMultipleCriticalPaths, criticalSlack, setDefaults, calcInsProjLikeSummTask, moveCompleted, andMoveRemaining, moveRemaining, andMoveCompleted });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="autoTrack">optional object autoTrack</param>
        /// <param name="spreadPercentToStatusDate">optional object spreadPercentToStatusDate</param>
        /// <param name="spreadCostsToStatusDate">optional object spreadCostsToStatusDate</param>
        /// <param name="autoCalcCosts">optional object autoCalcCosts</param>
        /// <param name="fixedCostAccrual">optional object fixedCostAccrual</param>
        /// <param name="calcMultipleCriticalPaths">optional object calcMultipleCriticalPaths</param>
        /// <param name="criticalSlack">optional object criticalSlack</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        /// <param name="calcInsProjLikeSummTask">optional object calcInsProjLikeSummTask</param>
        /// <param name="moveCompleted">optional object moveCompleted</param>
        /// <param name="andMoveRemaining">optional object andMoveRemaining</param>
        /// <param name="moveRemaining">optional object moveRemaining</param>
        /// <param name="andMoveCompleted">optional object andMoveCompleted</param>
        /// <param name="eVMethod">optional object eVMethod</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsCalculation(object automatic, object autoTrack, object spreadPercentToStatusDate, object spreadCostsToStatusDate, object autoCalcCosts, object fixedCostAccrual, object calcMultipleCriticalPaths, object criticalSlack, object setDefaults, object calcInsProjLikeSummTask, object moveCompleted, object andMoveRemaining, object moveRemaining, object andMoveCompleted, object eVMethod)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsCalculation", new object[] { automatic, autoTrack, spreadPercentToStatusDate, spreadCostsToStatusDate, autoCalcCosts, fixedCostAccrual, calcMultipleCriticalPaths, criticalSlack, setDefaults, calcInsProjLikeSummTask, moveCompleted, andMoveRemaining, moveRemaining, andMoveCompleted, eVMethod });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool CalculateAll()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "CalculateAll");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsPreferences()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsPreferences");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="calendarName">optional object calendarName</param>
        /// <param name="locked">optional object locked</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ChangeWorkingTime(object calendarName, object locked)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ChangeWorkingTime", calendarName, locked);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ChangeWorkingTime()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ChangeWorkingTime");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="calendarName">optional object calendarName</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ChangeWorkingTime(object calendarName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ChangeWorkingTime", calendarName);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="index">optional object index</param>
        /// <param name="locked">optional object locked</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendars(object index, object locked)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendars", index, locked);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendars()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendars");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="index">optional object index</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendars(object index)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendars", index);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="fromName">optional object fromName</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendarCreate(string name, object fromName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendarCreate", name, fromName);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendarCreate(string name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendarCreate", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fromName">string fromName</param>
        /// <param name="toName">string toName</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendarRename(string fromName, string toName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendarRename", fromName, toName);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendarDelete(string name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendarDelete", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        /// <param name="from1">optional object from1</param>
        /// <param name="to1">optional object to1</param>
        /// <param name="from2">optional object from2</param>
        /// <param name="to2">optional object to2</param>
        /// <param name="from3">optional object from3</param>
        /// <param name="to3">optional object to3</param>
        /// <param name="_default">optional object default</param>
        /// <param name="from4">optional object from4</param>
        /// <param name="to4">optional object to4</param>
        /// <param name="from5">optional object from5</param>
        /// <param name="to5">optional object to5</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendarEditDays(string name, object startDate, object endDate, object weekDay, object working, object from1, object to1, object from2, object to2, object from3, object to3, object _default, object from4, object to4, object from5, object to5)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendarEditDays", new object[] { name, startDate, endDate, weekDay, working, from1, to1, from2, to2, from3, to3, _default, from4, to4, from5, to5 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendarEditDays(string name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendarEditDays", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="startDate">optional object startDate</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendarEditDays(string name, object startDate)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendarEditDays", name, startDate);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendarEditDays(string name, object startDate, object endDate)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendarEditDays", name, startDate, endDate);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendarEditDays(string name, object startDate, object endDate, object weekDay)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendarEditDays", name, startDate, endDate, weekDay);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendarEditDays(string name, object startDate, object endDate, object weekDay, object working)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendarEditDays", new object[] { name, startDate, endDate, weekDay, working });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        /// <param name="from1">optional object from1</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendarEditDays(string name, object startDate, object endDate, object weekDay, object working, object from1)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendarEditDays", new object[] { name, startDate, endDate, weekDay, working, from1 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        /// <param name="from1">optional object from1</param>
        /// <param name="to1">optional object to1</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendarEditDays(string name, object startDate, object endDate, object weekDay, object working, object from1, object to1)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendarEditDays", new object[] { name, startDate, endDate, weekDay, working, from1, to1 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        /// <param name="from1">optional object from1</param>
        /// <param name="to1">optional object to1</param>
        /// <param name="from2">optional object from2</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendarEditDays(string name, object startDate, object endDate, object weekDay, object working, object from1, object to1, object from2)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendarEditDays", new object[] { name, startDate, endDate, weekDay, working, from1, to1, from2 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        /// <param name="from1">optional object from1</param>
        /// <param name="to1">optional object to1</param>
        /// <param name="from2">optional object from2</param>
        /// <param name="to2">optional object to2</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendarEditDays(string name, object startDate, object endDate, object weekDay, object working, object from1, object to1, object from2, object to2)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendarEditDays", new object[] { name, startDate, endDate, weekDay, working, from1, to1, from2, to2 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        /// <param name="from1">optional object from1</param>
        /// <param name="to1">optional object to1</param>
        /// <param name="from2">optional object from2</param>
        /// <param name="to2">optional object to2</param>
        /// <param name="from3">optional object from3</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendarEditDays(string name, object startDate, object endDate, object weekDay, object working, object from1, object to1, object from2, object to2, object from3)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendarEditDays", new object[] { name, startDate, endDate, weekDay, working, from1, to1, from2, to2, from3 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        /// <param name="from1">optional object from1</param>
        /// <param name="to1">optional object to1</param>
        /// <param name="from2">optional object from2</param>
        /// <param name="to2">optional object to2</param>
        /// <param name="from3">optional object from3</param>
        /// <param name="to3">optional object to3</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendarEditDays(string name, object startDate, object endDate, object weekDay, object working, object from1, object to1, object from2, object to2, object from3, object to3)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendarEditDays", new object[] { name, startDate, endDate, weekDay, working, from1, to1, from2, to2, from3, to3 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        /// <param name="from1">optional object from1</param>
        /// <param name="to1">optional object to1</param>
        /// <param name="from2">optional object from2</param>
        /// <param name="to2">optional object to2</param>
        /// <param name="from3">optional object from3</param>
        /// <param name="to3">optional object to3</param>
        /// <param name="_default">optional object default</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendarEditDays(string name, object startDate, object endDate, object weekDay, object working, object from1, object to1, object from2, object to2, object from3, object to3, object _default)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendarEditDays", new object[] { name, startDate, endDate, weekDay, working, from1, to1, from2, to2, from3, to3, _default });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        /// <param name="from1">optional object from1</param>
        /// <param name="to1">optional object to1</param>
        /// <param name="from2">optional object from2</param>
        /// <param name="to2">optional object to2</param>
        /// <param name="from3">optional object from3</param>
        /// <param name="to3">optional object to3</param>
        /// <param name="_default">optional object default</param>
        /// <param name="from4">optional object from4</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendarEditDays(string name, object startDate, object endDate, object weekDay, object working, object from1, object to1, object from2, object to2, object from3, object to3, object _default, object from4)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendarEditDays", new object[] { name, startDate, endDate, weekDay, working, from1, to1, from2, to2, from3, to3, _default, from4 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        /// <param name="from1">optional object from1</param>
        /// <param name="to1">optional object to1</param>
        /// <param name="from2">optional object from2</param>
        /// <param name="to2">optional object to2</param>
        /// <param name="from3">optional object from3</param>
        /// <param name="to3">optional object to3</param>
        /// <param name="_default">optional object default</param>
        /// <param name="from4">optional object from4</param>
        /// <param name="to4">optional object to4</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendarEditDays(string name, object startDate, object endDate, object weekDay, object working, object from1, object to1, object from2, object to2, object from3, object to3, object _default, object from4, object to4)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendarEditDays", new object[] { name, startDate, endDate, weekDay, working, from1, to1, from2, to2, from3, to3, _default, from4, to4 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        /// <param name="from1">optional object from1</param>
        /// <param name="to1">optional object to1</param>
        /// <param name="from2">optional object from2</param>
        /// <param name="to2">optional object to2</param>
        /// <param name="from3">optional object from3</param>
        /// <param name="to3">optional object to3</param>
        /// <param name="_default">optional object default</param>
        /// <param name="from4">optional object from4</param>
        /// <param name="to4">optional object to4</param>
        /// <param name="from5">optional object from5</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendarEditDays(string name, object startDate, object endDate, object weekDay, object working, object from1, object to1, object from2, object to2, object from3, object to3, object _default, object from4, object to4, object from5)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendarEditDays", new object[] { name, startDate, endDate, weekDay, working, from1, to1, from2, to2, from3, to3, _default, from4, to4, from5 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="projectName">string projectName</param>
        /// <param name="resourceName">string resourceName</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        /// <param name="_default">optional object default</param>
        /// <param name="from1">optional object from1</param>
        /// <param name="to1">optional object to1</param>
        /// <param name="from2">optional object from2</param>
        /// <param name="to2">optional object to2</param>
        /// <param name="from3">optional object from3</param>
        /// <param name="to3">optional object to3</param>
        /// <param name="from4">optional object from4</param>
        /// <param name="to4">optional object to4</param>
        /// <param name="from5">optional object from5</param>
        /// <param name="to5">optional object to5</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceCalendarEditDays(string projectName, string resourceName, object startDate, object endDate, object weekDay, object working, object _default, object from1, object to1, object from2, object to2, object from3, object to3, object from4, object to4, object from5, object to5)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceCalendarEditDays", new object[] { projectName, resourceName, startDate, endDate, weekDay, working, _default, from1, to1, from2, to2, from3, to3, from4, to4, from5, to5 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="projectName">string projectName</param>
        /// <param name="resourceName">string resourceName</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceCalendarEditDays(string projectName, string resourceName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceCalendarEditDays", projectName, resourceName);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="projectName">string projectName</param>
        /// <param name="resourceName">string resourceName</param>
        /// <param name="startDate">optional object startDate</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceCalendarEditDays(string projectName, string resourceName, object startDate)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceCalendarEditDays", projectName, resourceName, startDate);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="projectName">string projectName</param>
        /// <param name="resourceName">string resourceName</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceCalendarEditDays(string projectName, string resourceName, object startDate, object endDate)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceCalendarEditDays", projectName, resourceName, startDate, endDate);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="projectName">string projectName</param>
        /// <param name="resourceName">string resourceName</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceCalendarEditDays(string projectName, string resourceName, object startDate, object endDate, object weekDay)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceCalendarEditDays", new object[] { projectName, resourceName, startDate, endDate, weekDay });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="projectName">string projectName</param>
        /// <param name="resourceName">string resourceName</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceCalendarEditDays(string projectName, string resourceName, object startDate, object endDate, object weekDay, object working)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceCalendarEditDays", new object[] { projectName, resourceName, startDate, endDate, weekDay, working });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="projectName">string projectName</param>
        /// <param name="resourceName">string resourceName</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        /// <param name="_default">optional object default</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceCalendarEditDays(string projectName, string resourceName, object startDate, object endDate, object weekDay, object working, object _default)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceCalendarEditDays", new object[] { projectName, resourceName, startDate, endDate, weekDay, working, _default });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="projectName">string projectName</param>
        /// <param name="resourceName">string resourceName</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        /// <param name="_default">optional object default</param>
        /// <param name="from1">optional object from1</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceCalendarEditDays(string projectName, string resourceName, object startDate, object endDate, object weekDay, object working, object _default, object from1)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceCalendarEditDays", new object[] { projectName, resourceName, startDate, endDate, weekDay, working, _default, from1 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="projectName">string projectName</param>
        /// <param name="resourceName">string resourceName</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        /// <param name="_default">optional object default</param>
        /// <param name="from1">optional object from1</param>
        /// <param name="to1">optional object to1</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceCalendarEditDays(string projectName, string resourceName, object startDate, object endDate, object weekDay, object working, object _default, object from1, object to1)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceCalendarEditDays", new object[] { projectName, resourceName, startDate, endDate, weekDay, working, _default, from1, to1 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="projectName">string projectName</param>
        /// <param name="resourceName">string resourceName</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        /// <param name="_default">optional object default</param>
        /// <param name="from1">optional object from1</param>
        /// <param name="to1">optional object to1</param>
        /// <param name="from2">optional object from2</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceCalendarEditDays(string projectName, string resourceName, object startDate, object endDate, object weekDay, object working, object _default, object from1, object to1, object from2)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceCalendarEditDays", new object[] { projectName, resourceName, startDate, endDate, weekDay, working, _default, from1, to1, from2 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="projectName">string projectName</param>
        /// <param name="resourceName">string resourceName</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        /// <param name="_default">optional object default</param>
        /// <param name="from1">optional object from1</param>
        /// <param name="to1">optional object to1</param>
        /// <param name="from2">optional object from2</param>
        /// <param name="to2">optional object to2</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceCalendarEditDays(string projectName, string resourceName, object startDate, object endDate, object weekDay, object working, object _default, object from1, object to1, object from2, object to2)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceCalendarEditDays", new object[] { projectName, resourceName, startDate, endDate, weekDay, working, _default, from1, to1, from2, to2 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="projectName">string projectName</param>
        /// <param name="resourceName">string resourceName</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        /// <param name="_default">optional object default</param>
        /// <param name="from1">optional object from1</param>
        /// <param name="to1">optional object to1</param>
        /// <param name="from2">optional object from2</param>
        /// <param name="to2">optional object to2</param>
        /// <param name="from3">optional object from3</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceCalendarEditDays(string projectName, string resourceName, object startDate, object endDate, object weekDay, object working, object _default, object from1, object to1, object from2, object to2, object from3)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceCalendarEditDays", new object[] { projectName, resourceName, startDate, endDate, weekDay, working, _default, from1, to1, from2, to2, from3 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="projectName">string projectName</param>
        /// <param name="resourceName">string resourceName</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        /// <param name="_default">optional object default</param>
        /// <param name="from1">optional object from1</param>
        /// <param name="to1">optional object to1</param>
        /// <param name="from2">optional object from2</param>
        /// <param name="to2">optional object to2</param>
        /// <param name="from3">optional object from3</param>
        /// <param name="to3">optional object to3</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceCalendarEditDays(string projectName, string resourceName, object startDate, object endDate, object weekDay, object working, object _default, object from1, object to1, object from2, object to2, object from3, object to3)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceCalendarEditDays", new object[] { projectName, resourceName, startDate, endDate, weekDay, working, _default, from1, to1, from2, to2, from3, to3 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="projectName">string projectName</param>
        /// <param name="resourceName">string resourceName</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        /// <param name="_default">optional object default</param>
        /// <param name="from1">optional object from1</param>
        /// <param name="to1">optional object to1</param>
        /// <param name="from2">optional object from2</param>
        /// <param name="to2">optional object to2</param>
        /// <param name="from3">optional object from3</param>
        /// <param name="to3">optional object to3</param>
        /// <param name="from4">optional object from4</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceCalendarEditDays(string projectName, string resourceName, object startDate, object endDate, object weekDay, object working, object _default, object from1, object to1, object from2, object to2, object from3, object to3, object from4)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceCalendarEditDays", new object[] { projectName, resourceName, startDate, endDate, weekDay, working, _default, from1, to1, from2, to2, from3, to3, from4 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="projectName">string projectName</param>
        /// <param name="resourceName">string resourceName</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        /// <param name="_default">optional object default</param>
        /// <param name="from1">optional object from1</param>
        /// <param name="to1">optional object to1</param>
        /// <param name="from2">optional object from2</param>
        /// <param name="to2">optional object to2</param>
        /// <param name="from3">optional object from3</param>
        /// <param name="to3">optional object to3</param>
        /// <param name="from4">optional object from4</param>
        /// <param name="to4">optional object to4</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceCalendarEditDays(string projectName, string resourceName, object startDate, object endDate, object weekDay, object working, object _default, object from1, object to1, object from2, object to2, object from3, object to3, object from4, object to4)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceCalendarEditDays", new object[] { projectName, resourceName, startDate, endDate, weekDay, working, _default, from1, to1, from2, to2, from3, to3, from4, to4 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="projectName">string projectName</param>
        /// <param name="resourceName">string resourceName</param>
        /// <param name="startDate">optional object startDate</param>
        /// <param name="endDate">optional object endDate</param>
        /// <param name="weekDay">optional object weekDay</param>
        /// <param name="working">optional object working</param>
        /// <param name="_default">optional object default</param>
        /// <param name="from1">optional object from1</param>
        /// <param name="to1">optional object to1</param>
        /// <param name="from2">optional object from2</param>
        /// <param name="to2">optional object to2</param>
        /// <param name="from3">optional object from3</param>
        /// <param name="to3">optional object to3</param>
        /// <param name="from4">optional object from4</param>
        /// <param name="to4">optional object to4</param>
        /// <param name="from5">optional object from5</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceCalendarEditDays(string projectName, string resourceName, object startDate, object endDate, object weekDay, object working, object _default, object from1, object to1, object from2, object to2, object from3, object to3, object from4, object to4, object from5)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceCalendarEditDays", new object[] { projectName, resourceName, startDate, endDate, weekDay, working, _default, from1, to1, from2, to2, from3, to3, from4, to4, from5 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">string name</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaseCalendarReset(string name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaseCalendarReset", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="projectName">string projectName</param>
        /// <param name="resourceName">string resourceName</param>
        /// <param name="baseCalendar">optional object baseCalendar</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceCalendarReset(string projectName, string resourceName, object baseCalendar)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceCalendarReset", projectName, resourceName, baseCalendar);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="projectName">string projectName</param>
        /// <param name="resourceName">string resourceName</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceCalendarReset(string projectName, string resourceName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceCalendarReset", projectName, resourceName);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="index">optional object index</param>
        /// <param name="locked">optional object locked</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceCalendars(object index, object locked)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceCalendars", index, locked);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceCalendars()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceCalendars");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="index">optional object index</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceCalendars(object index)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceCalendars", index);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="delayInSlack">optional object delayInSlack</param>
        /// <param name="autoClearLeveling">optional object autoClearLeveling</param>
        /// <param name="order">optional object order</param>
        /// <param name="levelEntireProject">optional object levelEntireProject</param>
        /// <param name="fromDate">optional object fromDate</param>
        /// <param name="toDate">optional object toDate</param>
        /// <param name="periodBasis">optional object periodBasis</param>
        /// <param name="levelIndividualAssignments">optional object levelIndividualAssignments</param>
        /// <param name="levelingCanSplit">optional object levelingCanSplit</param>
        /// <param name="levelProposedBookings">optional object levelProposedBookings</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LevelingOptions(object automatic, object delayInSlack, object autoClearLeveling, object order, object levelEntireProject, object fromDate, object toDate, object periodBasis, object levelIndividualAssignments, object levelingCanSplit, object levelProposedBookings)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LevelingOptions", new object[] { automatic, delayInSlack, autoClearLeveling, order, levelEntireProject, fromDate, toDate, periodBasis, levelIndividualAssignments, levelingCanSplit, levelProposedBookings });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LevelingOptions()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LevelingOptions");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LevelingOptions(object automatic)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LevelingOptions", automatic);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="delayInSlack">optional object delayInSlack</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LevelingOptions(object automatic, object delayInSlack)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LevelingOptions", automatic, delayInSlack);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="delayInSlack">optional object delayInSlack</param>
        /// <param name="autoClearLeveling">optional object autoClearLeveling</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LevelingOptions(object automatic, object delayInSlack, object autoClearLeveling)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LevelingOptions", automatic, delayInSlack, autoClearLeveling);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="delayInSlack">optional object delayInSlack</param>
        /// <param name="autoClearLeveling">optional object autoClearLeveling</param>
        /// <param name="order">optional object order</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LevelingOptions(object automatic, object delayInSlack, object autoClearLeveling, object order)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LevelingOptions", automatic, delayInSlack, autoClearLeveling, order);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="delayInSlack">optional object delayInSlack</param>
        /// <param name="autoClearLeveling">optional object autoClearLeveling</param>
        /// <param name="order">optional object order</param>
        /// <param name="levelEntireProject">optional object levelEntireProject</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LevelingOptions(object automatic, object delayInSlack, object autoClearLeveling, object order, object levelEntireProject)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LevelingOptions", new object[] { automatic, delayInSlack, autoClearLeveling, order, levelEntireProject });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="delayInSlack">optional object delayInSlack</param>
        /// <param name="autoClearLeveling">optional object autoClearLeveling</param>
        /// <param name="order">optional object order</param>
        /// <param name="levelEntireProject">optional object levelEntireProject</param>
        /// <param name="fromDate">optional object fromDate</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LevelingOptions(object automatic, object delayInSlack, object autoClearLeveling, object order, object levelEntireProject, object fromDate)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LevelingOptions", new object[] { automatic, delayInSlack, autoClearLeveling, order, levelEntireProject, fromDate });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="delayInSlack">optional object delayInSlack</param>
        /// <param name="autoClearLeveling">optional object autoClearLeveling</param>
        /// <param name="order">optional object order</param>
        /// <param name="levelEntireProject">optional object levelEntireProject</param>
        /// <param name="fromDate">optional object fromDate</param>
        /// <param name="toDate">optional object toDate</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LevelingOptions(object automatic, object delayInSlack, object autoClearLeveling, object order, object levelEntireProject, object fromDate, object toDate)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LevelingOptions", new object[] { automatic, delayInSlack, autoClearLeveling, order, levelEntireProject, fromDate, toDate });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="delayInSlack">optional object delayInSlack</param>
        /// <param name="autoClearLeveling">optional object autoClearLeveling</param>
        /// <param name="order">optional object order</param>
        /// <param name="levelEntireProject">optional object levelEntireProject</param>
        /// <param name="fromDate">optional object fromDate</param>
        /// <param name="toDate">optional object toDate</param>
        /// <param name="periodBasis">optional object periodBasis</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LevelingOptions(object automatic, object delayInSlack, object autoClearLeveling, object order, object levelEntireProject, object fromDate, object toDate, object periodBasis)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LevelingOptions", new object[] { automatic, delayInSlack, autoClearLeveling, order, levelEntireProject, fromDate, toDate, periodBasis });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="delayInSlack">optional object delayInSlack</param>
        /// <param name="autoClearLeveling">optional object autoClearLeveling</param>
        /// <param name="order">optional object order</param>
        /// <param name="levelEntireProject">optional object levelEntireProject</param>
        /// <param name="fromDate">optional object fromDate</param>
        /// <param name="toDate">optional object toDate</param>
        /// <param name="periodBasis">optional object periodBasis</param>
        /// <param name="levelIndividualAssignments">optional object levelIndividualAssignments</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LevelingOptions(object automatic, object delayInSlack, object autoClearLeveling, object order, object levelEntireProject, object fromDate, object toDate, object periodBasis, object levelIndividualAssignments)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LevelingOptions", new object[] { automatic, delayInSlack, autoClearLeveling, order, levelEntireProject, fromDate, toDate, periodBasis, levelIndividualAssignments });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="automatic">optional object automatic</param>
        /// <param name="delayInSlack">optional object delayInSlack</param>
        /// <param name="autoClearLeveling">optional object autoClearLeveling</param>
        /// <param name="order">optional object order</param>
        /// <param name="levelEntireProject">optional object levelEntireProject</param>
        /// <param name="fromDate">optional object fromDate</param>
        /// <param name="toDate">optional object toDate</param>
        /// <param name="periodBasis">optional object periodBasis</param>
        /// <param name="levelIndividualAssignments">optional object levelIndividualAssignments</param>
        /// <param name="levelingCanSplit">optional object levelingCanSplit</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LevelingOptions(object automatic, object delayInSlack, object autoClearLeveling, object order, object levelEntireProject, object fromDate, object toDate, object periodBasis, object levelIndividualAssignments, object levelingCanSplit)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LevelingOptions", new object[] { automatic, delayInSlack, autoClearLeveling, order, levelEntireProject, fromDate, toDate, periodBasis, levelIndividualAssignments, levelingCanSplit });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="all">optional object all</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LevelNow(object all)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LevelNow", all);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LevelNow()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LevelNow");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="all">optional object all</param>
        /// <param name="copy">optional object copy</param>
        /// <param name="into">optional object into</param>
        /// <param name="rollupToSummaryTasks">optional object rollupToSummaryTasks</param>
        /// <param name="rollupFromSubtasks">optional object rollupFromSubtasks</param>
        /// <param name="setDefaults">optional object setDefaults</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaselineSave(object all, object copy, object into, object rollupToSummaryTasks, object rollupFromSubtasks, object setDefaults)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaselineSave", new object[] { all, copy, into, rollupToSummaryTasks, rollupFromSubtasks, setDefaults });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaselineSave()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaselineSave");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="all">optional object all</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaselineSave(object all)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaselineSave", all);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="all">optional object all</param>
        /// <param name="copy">optional object copy</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaselineSave(object all, object copy)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaselineSave", all, copy);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="all">optional object all</param>
        /// <param name="copy">optional object copy</param>
        /// <param name="into">optional object into</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaselineSave(object all, object copy, object into)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaselineSave", all, copy, into);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="all">optional object all</param>
        /// <param name="copy">optional object copy</param>
        /// <param name="into">optional object into</param>
        /// <param name="rollupToSummaryTasks">optional object rollupToSummaryTasks</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaselineSave(object all, object copy, object into, object rollupToSummaryTasks)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaselineSave", all, copy, into, rollupToSummaryTasks);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="all">optional object all</param>
        /// <param name="copy">optional object copy</param>
        /// <param name="into">optional object into</param>
        /// <param name="rollupToSummaryTasks">optional object rollupToSummaryTasks</param>
        /// <param name="rollupFromSubtasks">optional object rollupFromSubtasks</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BaselineSave(object all, object copy, object into, object rollupToSummaryTasks, object rollupFromSubtasks)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BaselineSave", new object[] { all, copy, into, rollupToSummaryTasks, rollupFromSubtasks });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="all">optional object all</param>
        /// <param name="updateDate">optional object updateDate</param>
        /// <param name="action">optional object action</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool UpdateProject(object all, object updateDate, object action)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "UpdateProject", all, updateDate, action);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool UpdateProject()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "UpdateProject");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="all">optional object all</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool UpdateProject(object all)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "UpdateProject", all);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="all">optional object all</param>
        /// <param name="updateDate">optional object updateDate</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool UpdateProject(object all, object updateDate)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "UpdateProject", all, updateDate);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="percentComplete">optional object percentComplete</param>
        /// <param name="actualDuration">optional object actualDuration</param>
        /// <param name="remainingDuration">optional object remainingDuration</param>
        /// <param name="actualStart">optional object actualStart</param>
        /// <param name="actualFinish">optional object actualFinish</param>
        /// <param name="notes">optional object notes</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool UpdateTasks(object percentComplete, object actualDuration, object remainingDuration, object actualStart, object actualFinish, object notes)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "UpdateTasks", new object[] { percentComplete, actualDuration, remainingDuration, actualStart, actualFinish, notes });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool UpdateTasks()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "UpdateTasks");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="percentComplete">optional object percentComplete</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool UpdateTasks(object percentComplete)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "UpdateTasks", percentComplete);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="percentComplete">optional object percentComplete</param>
        /// <param name="actualDuration">optional object actualDuration</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool UpdateTasks(object percentComplete, object actualDuration)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "UpdateTasks", percentComplete, actualDuration);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="percentComplete">optional object percentComplete</param>
        /// <param name="actualDuration">optional object actualDuration</param>
        /// <param name="remainingDuration">optional object remainingDuration</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool UpdateTasks(object percentComplete, object actualDuration, object remainingDuration)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "UpdateTasks", percentComplete, actualDuration, remainingDuration);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="percentComplete">optional object percentComplete</param>
        /// <param name="actualDuration">optional object actualDuration</param>
        /// <param name="remainingDuration">optional object remainingDuration</param>
        /// <param name="actualStart">optional object actualStart</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool UpdateTasks(object percentComplete, object actualDuration, object remainingDuration, object actualStart)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "UpdateTasks", percentComplete, actualDuration, remainingDuration, actualStart);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="percentComplete">optional object percentComplete</param>
        /// <param name="actualDuration">optional object actualDuration</param>
        /// <param name="remainingDuration">optional object remainingDuration</param>
        /// <param name="actualStart">optional object actualStart</param>
        /// <param name="actualFinish">optional object actualFinish</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool UpdateTasks(object percentComplete, object actualDuration, object remainingDuration, object actualStart, object actualFinish)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "UpdateTasks", new object[] { percentComplete, actualDuration, remainingDuration, actualStart, actualFinish });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="projects">optional object projects</param>
        /// <param name="view">optional object view</param>
        /// <param name="allProjects">optional object allProjects</param>
        /// <param name="showDialog">optional object showDialog</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool WindowNewWindow(object projects, object view, object allProjects, object showDialog)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "WindowNewWindow", projects, view, allProjects, showDialog);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool WindowNewWindow()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "WindowNewWindow");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="projects">optional object projects</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool WindowNewWindow(object projects)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "WindowNewWindow", projects);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="projects">optional object projects</param>
        /// <param name="view">optional object view</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool WindowNewWindow(object projects, object view)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "WindowNewWindow", projects, view);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="projects">optional object projects</param>
        /// <param name="view">optional object view</param>
        /// <param name="allProjects">optional object allProjects</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool WindowNewWindow(object projects, object view, object allProjects)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "WindowNewWindow", projects, view, allProjects);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool WindowArrangeAll()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "WindowArrangeAll");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool WindowHide(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "WindowHide", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool WindowHide()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "WindowHide");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool WindowUnhide(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "WindowUnhide", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool WindowUnhide()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "WindowUnhide");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="windowName">optional object windowName</param>
        /// <param name="dialogID">optional object dialogID</param>
        /// <param name="topPane">optional object topPane</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool WindowActivate(object windowName, object dialogID, object topPane)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "WindowActivate", windowName, dialogID, topPane);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool WindowActivate()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "WindowActivate");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="windowName">optional object windowName</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool WindowActivate(object windowName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "WindowActivate", windowName);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="windowName">optional object windowName</param>
        /// <param name="dialogID">optional object dialogID</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool WindowActivate(object windowName, object dialogID)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "WindowActivate", windowName, dialogID);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PageBreakSet()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PageBreakSet");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PageBreakRemove()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PageBreakRemove");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PageBreaksRemoveAll()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PageBreaksRemoveAll");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewShowResourcesPredecessors()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewShowResourcesPredecessors");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewShowResourcesSuccessors()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewShowResourcesSuccessors");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewShowPredecessorsSuccessors()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewShowPredecessorsSuccessors");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewShowNotes()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewShowNotes");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewShowObjects()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewShowObjects");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewShowOverallocation()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewShowOverallocation");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewShowPercentAllocation()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewShowPercentAllocation");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewShowWork()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewShowWork");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewShowCost()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewShowCost");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewShowSchedule()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewShowSchedule");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewShowPeakUnits()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewShowPeakUnits");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewShowAvailability()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewShowAvailability");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewShowRemainingAvailability()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewShowRemainingAvailability");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewShowCumulativeWork()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewShowCumulativeWork");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewShowCumulativeCost()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewShowCumulativeCost");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PaneNext()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PaneNext");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PaneCreate()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PaneCreate");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FormViewShow()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FormViewShow");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PaneClose()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PaneClose");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool WindowSplit()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "WindowSplit");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="noWrap">optional object noWrap</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool WindowNext(object noWrap)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "WindowNext", noWrap);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool WindowNext()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "WindowNext");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="noWrap">optional object noWrap</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool WindowPrev(object noWrap)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "WindowPrev", noWrap);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool WindowPrev()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "WindowPrev");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DocClose()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DocClose");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AppMaximize()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "AppMaximize");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AppMinimize()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "AppMinimize");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="xPosition">optional object xPosition</param>
        /// <param name="yPosition">optional object yPosition</param>
        /// <param name="points">optional object points</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AppMove(object xPosition, object yPosition, object points)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "AppMove", xPosition, yPosition, points);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AppMove()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "AppMove");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="xPosition">optional object xPosition</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AppMove(object xPosition)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "AppMove", xPosition);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="xPosition">optional object xPosition</param>
        /// <param name="yPosition">optional object yPosition</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AppMove(object xPosition, object yPosition)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "AppMove", xPosition, yPosition);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AppRestore()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "AppRestore");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="width">optional object width</param>
        /// <param name="height">optional object height</param>
        /// <param name="points">optional object points</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AppSize(object width, object height, object points)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "AppSize", width, height, points);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AppSize()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "AppSize");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="width">optional object width</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AppSize(object width)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "AppSize", width);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="width">optional object width</param>
        /// <param name="height">optional object height</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AppSize(object width, object height)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "AppSize", width, height);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DocMaximize()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DocMaximize");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="xPosition">optional object xPosition</param>
        /// <param name="yPosition">optional object yPosition</param>
        /// <param name="points">optional object points</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DocMove(object xPosition, object yPosition, object points)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DocMove", xPosition, yPosition, points);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DocMove()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DocMove");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="xPosition">optional object xPosition</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DocMove(object xPosition)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DocMove", xPosition);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="xPosition">optional object xPosition</param>
        /// <param name="yPosition">optional object yPosition</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DocMove(object xPosition, object yPosition)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DocMove", xPosition, yPosition);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DocRestore()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DocRestore");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="width">optional object width</param>
        /// <param name="height">optional object height</param>
        /// <param name="points">optional object points</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DocSize(object width, object height, object points)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DocSize", width, height, points);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DocSize()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DocSize");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="width">optional object width</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DocSize(object width)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DocSize", width);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="width">optional object width</param>
        /// <param name="height">optional object height</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DocSize(object width, object height)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DocSize", width, height);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="levels">optional object levels</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OutlineOutdent(object levels)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OutlineOutdent", levels);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OutlineOutdent()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OutlineOutdent");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="outlineNumber">optional NetOffice.MSProjectApi.Enums.PJTaskOutlineShowLevel OutlineNumber = 65535</param>
        /// <param name="expandInsertedProjects">optional object expandInsertedProjects</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OutlineShowTasks(object outlineNumber, object expandInsertedProjects)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OutlineShowTasks", outlineNumber, expandInsertedProjects);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OutlineShowTasks()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OutlineShowTasks");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="outlineNumber">optional NetOffice.MSProjectApi.Enums.PJTaskOutlineShowLevel OutlineNumber = 65535</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OutlineShowTasks(object outlineNumber)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OutlineShowTasks", outlineNumber);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="levels">optional object levels</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OutlineIndent(object levels)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OutlineIndent", levels);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OutlineIndent()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OutlineIndent");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OutlineHideSubTasks()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OutlineHideSubTasks");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OutlineShowSubTasks()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OutlineShowSubTasks");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OutlineShowAllTasks()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OutlineShowAllTasks");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="extend">optional object extend</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectBeginning(object extend)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectBeginning", extend);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectBeginning()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectBeginning");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="extend">optional object extend</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectEnd(object extend)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectEnd", extend);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectEnd()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectEnd");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="extend">optional object extend</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectRowStart(object extend)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectRowStart", extend);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectRowStart()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectRowStart");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="extend">optional object extend</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectRowEnd(object extend)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectRowEnd", extend);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectRowEnd()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectRowEnd");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="numCells">optional object numCells</param>
        /// <param name="extend">optional object extend</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectCellLeft(object numCells, object extend)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectCellLeft", numCells, extend);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectCellLeft()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectCellLeft");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="numCells">optional object numCells</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectCellLeft(object numCells)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectCellLeft", numCells);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="numCells">optional object numCells</param>
        /// <param name="extend">optional object extend</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectCellRight(object numCells, object extend)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectCellRight", numCells, extend);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectCellRight()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectCellRight");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="numCells">optional object numCells</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectCellRight(object numCells)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectCellRight", numCells);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="numCells">optional object numCells</param>
        /// <param name="extend">optional object extend</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectCellUp(object numCells, object extend)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectCellUp", numCells, extend);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectCellUp()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectCellUp");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="numCells">optional object numCells</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectCellUp(object numCells)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectCellUp", numCells);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="numCells">optional object numCells</param>
        /// <param name="extend">optional object extend</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectCellDown(object numCells, object extend)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectCellDown", numCells, extend);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectCellDown()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectCellDown");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="numCells">optional object numCells</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectCellDown(object numCells)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectCellDown", numCells);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="extend">optional object extend</param>
        /// <param name="add">optional object add</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectionExtend(object extend, object add)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectionExtend", extend, add);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectionExtend()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectionExtend");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="extend">optional object extend</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectionExtend(object extend)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectionExtend", extend);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="column">optional object column</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ColumnBestFit(object column)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ColumnBestFit", column);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ColumnBestFit()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ColumnBestFit");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="column">optional object column</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ColumnEdit(object column)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ColumnEdit", column);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ColumnEdit()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ColumnEdit");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">Int32 row</param>
        /// <param name="column">Int16 column</param>
        /// <param name="rowRelative">optional object rowRelative</param>
        /// <param name="width">optional object width</param>
        /// <param name="height">optional object height</param>
        /// <param name="extend">optional object extend</param>
        /// <param name="add">optional object add</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectRange(Int32 row, Int16 column, object rowRelative, object width, object height, object extend, object add)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectRange", new object[] { row, column, rowRelative, width, height, extend, add });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">Int32 row</param>
        /// <param name="column">Int16 column</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectRange(Int32 row, Int16 column)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectRange", row, column);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">Int32 row</param>
        /// <param name="column">Int16 column</param>
        /// <param name="rowRelative">optional object rowRelative</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectRange(Int32 row, Int16 column, object rowRelative)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectRange", row, column, rowRelative);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">Int32 row</param>
        /// <param name="column">Int16 column</param>
        /// <param name="rowRelative">optional object rowRelative</param>
        /// <param name="width">optional object width</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectRange(Int32 row, Int16 column, object rowRelative, object width)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectRange", row, column, rowRelative, width);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">Int32 row</param>
        /// <param name="column">Int16 column</param>
        /// <param name="rowRelative">optional object rowRelative</param>
        /// <param name="width">optional object width</param>
        /// <param name="height">optional object height</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectRange(Int32 row, Int16 column, object rowRelative, object width, object height)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectRange", new object[] { row, column, rowRelative, width, height });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">Int32 row</param>
        /// <param name="column">Int16 column</param>
        /// <param name="rowRelative">optional object rowRelative</param>
        /// <param name="width">optional object width</param>
        /// <param name="height">optional object height</param>
        /// <param name="extend">optional object extend</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectRange(Int32 row, Int16 column, object rowRelative, object width, object height, object extend)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectRange", new object[] { row, column, rowRelative, width, height, extend });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">Int32 row</param>
        /// <param name="startTime">string startTime</param>
        /// <param name="width">Int16 width</param>
        /// <param name="height">Int32 height</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectTimescaleRange(Int32 row, string startTime, Int16 width, Int32 height)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectTimescaleRange", row, startTime, width, height);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">Int32 row</param>
        /// <param name="column">string column</param>
        /// <param name="rowRelative">optional object rowRelative</param>
        /// <param name="width">optional object width</param>
        /// <param name="height">optional object height</param>
        /// <param name="extend">optional object extend</param>
        /// <param name="add">optional object add</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectTaskField(Int32 row, string column, object rowRelative, object width, object height, object extend, object add)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectTaskField", new object[] { row, column, rowRelative, width, height, extend, add });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">Int32 row</param>
        /// <param name="column">string column</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectTaskField(Int32 row, string column)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectTaskField", row, column);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">Int32 row</param>
        /// <param name="column">string column</param>
        /// <param name="rowRelative">optional object rowRelative</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectTaskField(Int32 row, string column, object rowRelative)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectTaskField", row, column, rowRelative);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">Int32 row</param>
        /// <param name="column">string column</param>
        /// <param name="rowRelative">optional object rowRelative</param>
        /// <param name="width">optional object width</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectTaskField(Int32 row, string column, object rowRelative, object width)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectTaskField", row, column, rowRelative, width);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">Int32 row</param>
        /// <param name="column">string column</param>
        /// <param name="rowRelative">optional object rowRelative</param>
        /// <param name="width">optional object width</param>
        /// <param name="height">optional object height</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectTaskField(Int32 row, string column, object rowRelative, object width, object height)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectTaskField", new object[] { row, column, rowRelative, width, height });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">Int32 row</param>
        /// <param name="column">string column</param>
        /// <param name="rowRelative">optional object rowRelative</param>
        /// <param name="width">optional object width</param>
        /// <param name="height">optional object height</param>
        /// <param name="extend">optional object extend</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectTaskField(Int32 row, string column, object rowRelative, object width, object height, object extend)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectTaskField", new object[] { row, column, rowRelative, width, height, extend });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">Int32 row</param>
        /// <param name="column">string column</param>
        /// <param name="rowRelative">optional object rowRelative</param>
        /// <param name="width">optional object width</param>
        /// <param name="height">optional object height</param>
        /// <param name="extend">optional object extend</param>
        /// <param name="add">optional object add</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectResourceField(Int32 row, string column, object rowRelative, object width, object height, object extend, object add)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectResourceField", new object[] { row, column, rowRelative, width, height, extend, add });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">Int32 row</param>
        /// <param name="column">string column</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectResourceField(Int32 row, string column)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectResourceField", row, column);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">Int32 row</param>
        /// <param name="column">string column</param>
        /// <param name="rowRelative">optional object rowRelative</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectResourceField(Int32 row, string column, object rowRelative)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectResourceField", row, column, rowRelative);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">Int32 row</param>
        /// <param name="column">string column</param>
        /// <param name="rowRelative">optional object rowRelative</param>
        /// <param name="width">optional object width</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectResourceField(Int32 row, string column, object rowRelative, object width)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectResourceField", row, column, rowRelative, width);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">Int32 row</param>
        /// <param name="column">string column</param>
        /// <param name="rowRelative">optional object rowRelative</param>
        /// <param name="width">optional object width</param>
        /// <param name="height">optional object height</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectResourceField(Int32 row, string column, object rowRelative, object width, object height)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectResourceField", new object[] { row, column, rowRelative, width, height });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">Int32 row</param>
        /// <param name="column">string column</param>
        /// <param name="rowRelative">optional object rowRelative</param>
        /// <param name="width">optional object width</param>
        /// <param name="height">optional object height</param>
        /// <param name="extend">optional object extend</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectResourceField(Int32 row, string column, object rowRelative, object width, object height, object extend)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectResourceField", new object[] { row, column, rowRelative, width, height, extend });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">optional object row</param>
        /// <param name="rowRelative">optional object rowRelative</param>
        /// <param name="height">optional object height</param>
        /// <param name="extend">optional object extend</param>
        /// <param name="add">optional object add</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectRow(object row, object rowRelative, object height, object extend, object add)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectRow", new object[] { row, rowRelative, height, extend, add });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectRow()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectRow");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">optional object row</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectRow(object row)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectRow", row);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">optional object row</param>
        /// <param name="rowRelative">optional object rowRelative</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectRow(object row, object rowRelative)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectRow", row, rowRelative);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">optional object row</param>
        /// <param name="rowRelative">optional object rowRelative</param>
        /// <param name="height">optional object height</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectRow(object row, object rowRelative, object height)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectRow", row, rowRelative, height);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">optional object row</param>
        /// <param name="rowRelative">optional object rowRelative</param>
        /// <param name="height">optional object height</param>
        /// <param name="extend">optional object extend</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectRow(object row, object rowRelative, object height, object extend)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectRow", row, rowRelative, height, extend);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="column">optional object column</param>
        /// <param name="additional">optional object additional</param>
        /// <param name="extend">optional object extend</param>
        /// <param name="add">optional object add</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectColumn(object column, object additional, object extend, object add)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectColumn", column, additional, extend, add);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectColumn()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectColumn");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="column">optional object column</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectColumn(object column)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectColumn", column);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="column">optional object column</param>
        /// <param name="additional">optional object additional</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectColumn(object column, object additional)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectColumn", column, additional);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="column">optional object column</param>
        /// <param name="additional">optional object additional</param>
        /// <param name="extend">optional object extend</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectColumn(object column, object additional, object extend)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectColumn", column, additional, extend);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="column">optional object column</param>
        /// <param name="additional">optional object additional</param>
        /// <param name="extend">optional object extend</param>
        /// <param name="add">optional object add</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectTaskColumn(object column, object additional, object extend, object add)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectTaskColumn", column, additional, extend, add);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectTaskColumn()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectTaskColumn");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="column">optional object column</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectTaskColumn(object column)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectTaskColumn", column);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="column">optional object column</param>
        /// <param name="additional">optional object additional</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectTaskColumn(object column, object additional)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectTaskColumn", column, additional);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="column">optional object column</param>
        /// <param name="additional">optional object additional</param>
        /// <param name="extend">optional object extend</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectTaskColumn(object column, object additional, object extend)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectTaskColumn", column, additional, extend);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="column">optional object column</param>
        /// <param name="additional">optional object additional</param>
        /// <param name="extend">optional object extend</param>
        /// <param name="add">optional object add</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectResourceColumn(object column, object additional, object extend, object add)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectResourceColumn", column, additional, extend, add);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectResourceColumn()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectResourceColumn");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="column">optional object column</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectResourceColumn(object column)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectResourceColumn", column);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="column">optional object column</param>
        /// <param name="additional">optional object additional</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectResourceColumn(object column, object additional)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectResourceColumn", column, additional);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="column">optional object column</param>
        /// <param name="additional">optional object additional</param>
        /// <param name="extend">optional object extend</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectResourceColumn(object column, object additional, object extend)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectResourceColumn", column, additional, extend);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">optional object row</param>
        /// <param name="column">optional object column</param>
        /// <param name="rowRelative">optional object rowRelative</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectTaskCell(object row, object column, object rowRelative)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectTaskCell", row, column, rowRelative);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectTaskCell()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectTaskCell");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">optional object row</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectTaskCell(object row)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectTaskCell", row);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">optional object row</param>
        /// <param name="column">optional object column</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectTaskCell(object row, object column)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectTaskCell", row, column);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">optional object row</param>
        /// <param name="column">optional object column</param>
        /// <param name="rowRelative">optional object rowRelative</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectResourceCell(object row, object column, object rowRelative)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectResourceCell", row, column, rowRelative);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectResourceCell()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectResourceCell");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">optional object row</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectResourceCell(object row)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectResourceCell", row);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">optional object row</param>
        /// <param name="column">optional object column</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectResourceCell(object row, object column)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectResourceCell", row, column);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">optional object row</param>
        /// <param name="column">optional object column</param>
        /// <param name="rowRelative">optional object rowRelative</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectCell(object row, object column, object rowRelative)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectCell", row, column, rowRelative);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectCell()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectCell");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">optional object row</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectCell(object row)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectCell", row);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="row">optional object row</param>
        /// <param name="column">optional object column</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectCell(object row, object column)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectCell", row, column);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SelectSheet()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SelectSheet");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="app">string app</param>
        /// <param name="topic">string topic</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DDEInitiate(string app, string topic)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DDEInitiate", app, topic);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="command">string command</param>
        /// <param name="timeOut">optional object timeOut</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DDEExecute(string command, object timeOut)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DDEExecute", command, timeOut);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="command">string command</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DDEExecute(string command)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DDEExecute", command);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DDETerminate()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DDETerminate");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="tab">optional object tab</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool InformationDialog(object tab)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "InformationDialog", tab);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool InformationDialog()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "InformationDialog");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Form(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Form", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Form()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Form");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool CustomForms()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "CustomForms");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Tables()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Tables");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Filters()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Filters");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Macro(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Macro", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Macro()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Macro");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="down">optional object down</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FillDown(object down)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FillDown", down);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FillDown()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FillDown");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Views()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Views");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool CalculateProject()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "CalculateProject");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="all">optional object all</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LevelingClear(object all)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LevelingClear", all);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LevelingClear()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LevelingClear");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SpellingCheck()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SpellingCheck");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        /// <param name="taskText3">optional object taskText3</param>
        /// <param name="taskText4">optional object taskText4</param>
        /// <param name="taskText5">optional object taskText5</param>
        /// <param name="taskText6">optional object taskText6</param>
        /// <param name="taskText7">optional object taskText7</param>
        /// <param name="taskText8">optional object taskText8</param>
        /// <param name="taskText9">optional object taskText9</param>
        /// <param name="taskText10">optional object taskText10</param>
        /// <param name="resourceCode">optional object resourceCode</param>
        /// <param name="resourceName">optional object resourceName</param>
        /// <param name="resourceNotes">optional object resourceNotes</param>
        /// <param name="resourceGroup">optional object resourceGroup</param>
        /// <param name="resourceText1">optional object resourceText1</param>
        /// <param name="resourceText2">optional object resourceText2</param>
        /// <param name="resourceText3">optional object resourceText3</param>
        /// <param name="resourceText4">optional object resourceText4</param>
        /// <param name="resourceText5">optional object resourceText5</param>
        /// <param name="assignNotes">optional object assignNotes</param>
        /// <param name="ignoreUppercase">optional object ignoreUppercase</param>
        /// <param name="ignoreNumberWords">optional object ignoreNumberWords</param>
        /// <param name="alwaysSuggest">optional object alwaysSuggest</param>
        /// <param name="useCustomDictionary">optional object useCustomDictionary</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2, object taskText3, object taskText4, object taskText5, object taskText6, object taskText7, object taskText8, object taskText9, object taskText10, object resourceCode, object resourceName, object resourceNotes, object resourceGroup, object resourceText1, object resourceText2, object resourceText3, object resourceText4, object resourceText5, object assignNotes, object ignoreUppercase, object ignoreNumberWords, object alwaysSuggest, object useCustomDictionary)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", new object[] { taskName, taskNotes, taskText1, taskText2, taskText3, taskText4, taskText5, taskText6, taskText7, taskText8, taskText9, taskText10, resourceCode, resourceName, resourceNotes, resourceGroup, resourceText1, resourceText2, resourceText3, resourceText4, resourceText5, assignNotes, ignoreUppercase, ignoreNumberWords, alwaysSuggest, useCustomDictionary });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", taskName);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", taskName, taskNotes);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", taskName, taskNotes, taskText1);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", taskName, taskNotes, taskText1, taskText2);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        /// <param name="taskText3">optional object taskText3</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2, object taskText3)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", new object[] { taskName, taskNotes, taskText1, taskText2, taskText3 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        /// <param name="taskText3">optional object taskText3</param>
        /// <param name="taskText4">optional object taskText4</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2, object taskText3, object taskText4)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", new object[] { taskName, taskNotes, taskText1, taskText2, taskText3, taskText4 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        /// <param name="taskText3">optional object taskText3</param>
        /// <param name="taskText4">optional object taskText4</param>
        /// <param name="taskText5">optional object taskText5</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2, object taskText3, object taskText4, object taskText5)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", new object[] { taskName, taskNotes, taskText1, taskText2, taskText3, taskText4, taskText5 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        /// <param name="taskText3">optional object taskText3</param>
        /// <param name="taskText4">optional object taskText4</param>
        /// <param name="taskText5">optional object taskText5</param>
        /// <param name="taskText6">optional object taskText6</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2, object taskText3, object taskText4, object taskText5, object taskText6)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", new object[] { taskName, taskNotes, taskText1, taskText2, taskText3, taskText4, taskText5, taskText6 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        /// <param name="taskText3">optional object taskText3</param>
        /// <param name="taskText4">optional object taskText4</param>
        /// <param name="taskText5">optional object taskText5</param>
        /// <param name="taskText6">optional object taskText6</param>
        /// <param name="taskText7">optional object taskText7</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2, object taskText3, object taskText4, object taskText5, object taskText6, object taskText7)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", new object[] { taskName, taskNotes, taskText1, taskText2, taskText3, taskText4, taskText5, taskText6, taskText7 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        /// <param name="taskText3">optional object taskText3</param>
        /// <param name="taskText4">optional object taskText4</param>
        /// <param name="taskText5">optional object taskText5</param>
        /// <param name="taskText6">optional object taskText6</param>
        /// <param name="taskText7">optional object taskText7</param>
        /// <param name="taskText8">optional object taskText8</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2, object taskText3, object taskText4, object taskText5, object taskText6, object taskText7, object taskText8)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", new object[] { taskName, taskNotes, taskText1, taskText2, taskText3, taskText4, taskText5, taskText6, taskText7, taskText8 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        /// <param name="taskText3">optional object taskText3</param>
        /// <param name="taskText4">optional object taskText4</param>
        /// <param name="taskText5">optional object taskText5</param>
        /// <param name="taskText6">optional object taskText6</param>
        /// <param name="taskText7">optional object taskText7</param>
        /// <param name="taskText8">optional object taskText8</param>
        /// <param name="taskText9">optional object taskText9</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2, object taskText3, object taskText4, object taskText5, object taskText6, object taskText7, object taskText8, object taskText9)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", new object[] { taskName, taskNotes, taskText1, taskText2, taskText3, taskText4, taskText5, taskText6, taskText7, taskText8, taskText9 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        /// <param name="taskText3">optional object taskText3</param>
        /// <param name="taskText4">optional object taskText4</param>
        /// <param name="taskText5">optional object taskText5</param>
        /// <param name="taskText6">optional object taskText6</param>
        /// <param name="taskText7">optional object taskText7</param>
        /// <param name="taskText8">optional object taskText8</param>
        /// <param name="taskText9">optional object taskText9</param>
        /// <param name="taskText10">optional object taskText10</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2, object taskText3, object taskText4, object taskText5, object taskText6, object taskText7, object taskText8, object taskText9, object taskText10)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", new object[] { taskName, taskNotes, taskText1, taskText2, taskText3, taskText4, taskText5, taskText6, taskText7, taskText8, taskText9, taskText10 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        /// <param name="taskText3">optional object taskText3</param>
        /// <param name="taskText4">optional object taskText4</param>
        /// <param name="taskText5">optional object taskText5</param>
        /// <param name="taskText6">optional object taskText6</param>
        /// <param name="taskText7">optional object taskText7</param>
        /// <param name="taskText8">optional object taskText8</param>
        /// <param name="taskText9">optional object taskText9</param>
        /// <param name="taskText10">optional object taskText10</param>
        /// <param name="resourceCode">optional object resourceCode</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2, object taskText3, object taskText4, object taskText5, object taskText6, object taskText7, object taskText8, object taskText9, object taskText10, object resourceCode)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", new object[] { taskName, taskNotes, taskText1, taskText2, taskText3, taskText4, taskText5, taskText6, taskText7, taskText8, taskText9, taskText10, resourceCode });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        /// <param name="taskText3">optional object taskText3</param>
        /// <param name="taskText4">optional object taskText4</param>
        /// <param name="taskText5">optional object taskText5</param>
        /// <param name="taskText6">optional object taskText6</param>
        /// <param name="taskText7">optional object taskText7</param>
        /// <param name="taskText8">optional object taskText8</param>
        /// <param name="taskText9">optional object taskText9</param>
        /// <param name="taskText10">optional object taskText10</param>
        /// <param name="resourceCode">optional object resourceCode</param>
        /// <param name="resourceName">optional object resourceName</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2, object taskText3, object taskText4, object taskText5, object taskText6, object taskText7, object taskText8, object taskText9, object taskText10, object resourceCode, object resourceName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", new object[] { taskName, taskNotes, taskText1, taskText2, taskText3, taskText4, taskText5, taskText6, taskText7, taskText8, taskText9, taskText10, resourceCode, resourceName });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        /// <param name="taskText3">optional object taskText3</param>
        /// <param name="taskText4">optional object taskText4</param>
        /// <param name="taskText5">optional object taskText5</param>
        /// <param name="taskText6">optional object taskText6</param>
        /// <param name="taskText7">optional object taskText7</param>
        /// <param name="taskText8">optional object taskText8</param>
        /// <param name="taskText9">optional object taskText9</param>
        /// <param name="taskText10">optional object taskText10</param>
        /// <param name="resourceCode">optional object resourceCode</param>
        /// <param name="resourceName">optional object resourceName</param>
        /// <param name="resourceNotes">optional object resourceNotes</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2, object taskText3, object taskText4, object taskText5, object taskText6, object taskText7, object taskText8, object taskText9, object taskText10, object resourceCode, object resourceName, object resourceNotes)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", new object[] { taskName, taskNotes, taskText1, taskText2, taskText3, taskText4, taskText5, taskText6, taskText7, taskText8, taskText9, taskText10, resourceCode, resourceName, resourceNotes });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        /// <param name="taskText3">optional object taskText3</param>
        /// <param name="taskText4">optional object taskText4</param>
        /// <param name="taskText5">optional object taskText5</param>
        /// <param name="taskText6">optional object taskText6</param>
        /// <param name="taskText7">optional object taskText7</param>
        /// <param name="taskText8">optional object taskText8</param>
        /// <param name="taskText9">optional object taskText9</param>
        /// <param name="taskText10">optional object taskText10</param>
        /// <param name="resourceCode">optional object resourceCode</param>
        /// <param name="resourceName">optional object resourceName</param>
        /// <param name="resourceNotes">optional object resourceNotes</param>
        /// <param name="resourceGroup">optional object resourceGroup</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2, object taskText3, object taskText4, object taskText5, object taskText6, object taskText7, object taskText8, object taskText9, object taskText10, object resourceCode, object resourceName, object resourceNotes, object resourceGroup)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", new object[] { taskName, taskNotes, taskText1, taskText2, taskText3, taskText4, taskText5, taskText6, taskText7, taskText8, taskText9, taskText10, resourceCode, resourceName, resourceNotes, resourceGroup });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        /// <param name="taskText3">optional object taskText3</param>
        /// <param name="taskText4">optional object taskText4</param>
        /// <param name="taskText5">optional object taskText5</param>
        /// <param name="taskText6">optional object taskText6</param>
        /// <param name="taskText7">optional object taskText7</param>
        /// <param name="taskText8">optional object taskText8</param>
        /// <param name="taskText9">optional object taskText9</param>
        /// <param name="taskText10">optional object taskText10</param>
        /// <param name="resourceCode">optional object resourceCode</param>
        /// <param name="resourceName">optional object resourceName</param>
        /// <param name="resourceNotes">optional object resourceNotes</param>
        /// <param name="resourceGroup">optional object resourceGroup</param>
        /// <param name="resourceText1">optional object resourceText1</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2, object taskText3, object taskText4, object taskText5, object taskText6, object taskText7, object taskText8, object taskText9, object taskText10, object resourceCode, object resourceName, object resourceNotes, object resourceGroup, object resourceText1)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", new object[] { taskName, taskNotes, taskText1, taskText2, taskText3, taskText4, taskText5, taskText6, taskText7, taskText8, taskText9, taskText10, resourceCode, resourceName, resourceNotes, resourceGroup, resourceText1 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        /// <param name="taskText3">optional object taskText3</param>
        /// <param name="taskText4">optional object taskText4</param>
        /// <param name="taskText5">optional object taskText5</param>
        /// <param name="taskText6">optional object taskText6</param>
        /// <param name="taskText7">optional object taskText7</param>
        /// <param name="taskText8">optional object taskText8</param>
        /// <param name="taskText9">optional object taskText9</param>
        /// <param name="taskText10">optional object taskText10</param>
        /// <param name="resourceCode">optional object resourceCode</param>
        /// <param name="resourceName">optional object resourceName</param>
        /// <param name="resourceNotes">optional object resourceNotes</param>
        /// <param name="resourceGroup">optional object resourceGroup</param>
        /// <param name="resourceText1">optional object resourceText1</param>
        /// <param name="resourceText2">optional object resourceText2</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2, object taskText3, object taskText4, object taskText5, object taskText6, object taskText7, object taskText8, object taskText9, object taskText10, object resourceCode, object resourceName, object resourceNotes, object resourceGroup, object resourceText1, object resourceText2)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", new object[] { taskName, taskNotes, taskText1, taskText2, taskText3, taskText4, taskText5, taskText6, taskText7, taskText8, taskText9, taskText10, resourceCode, resourceName, resourceNotes, resourceGroup, resourceText1, resourceText2 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        /// <param name="taskText3">optional object taskText3</param>
        /// <param name="taskText4">optional object taskText4</param>
        /// <param name="taskText5">optional object taskText5</param>
        /// <param name="taskText6">optional object taskText6</param>
        /// <param name="taskText7">optional object taskText7</param>
        /// <param name="taskText8">optional object taskText8</param>
        /// <param name="taskText9">optional object taskText9</param>
        /// <param name="taskText10">optional object taskText10</param>
        /// <param name="resourceCode">optional object resourceCode</param>
        /// <param name="resourceName">optional object resourceName</param>
        /// <param name="resourceNotes">optional object resourceNotes</param>
        /// <param name="resourceGroup">optional object resourceGroup</param>
        /// <param name="resourceText1">optional object resourceText1</param>
        /// <param name="resourceText2">optional object resourceText2</param>
        /// <param name="resourceText3">optional object resourceText3</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2, object taskText3, object taskText4, object taskText5, object taskText6, object taskText7, object taskText8, object taskText9, object taskText10, object resourceCode, object resourceName, object resourceNotes, object resourceGroup, object resourceText1, object resourceText2, object resourceText3)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", new object[] { taskName, taskNotes, taskText1, taskText2, taskText3, taskText4, taskText5, taskText6, taskText7, taskText8, taskText9, taskText10, resourceCode, resourceName, resourceNotes, resourceGroup, resourceText1, resourceText2, resourceText3 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        /// <param name="taskText3">optional object taskText3</param>
        /// <param name="taskText4">optional object taskText4</param>
        /// <param name="taskText5">optional object taskText5</param>
        /// <param name="taskText6">optional object taskText6</param>
        /// <param name="taskText7">optional object taskText7</param>
        /// <param name="taskText8">optional object taskText8</param>
        /// <param name="taskText9">optional object taskText9</param>
        /// <param name="taskText10">optional object taskText10</param>
        /// <param name="resourceCode">optional object resourceCode</param>
        /// <param name="resourceName">optional object resourceName</param>
        /// <param name="resourceNotes">optional object resourceNotes</param>
        /// <param name="resourceGroup">optional object resourceGroup</param>
        /// <param name="resourceText1">optional object resourceText1</param>
        /// <param name="resourceText2">optional object resourceText2</param>
        /// <param name="resourceText3">optional object resourceText3</param>
        /// <param name="resourceText4">optional object resourceText4</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2, object taskText3, object taskText4, object taskText5, object taskText6, object taskText7, object taskText8, object taskText9, object taskText10, object resourceCode, object resourceName, object resourceNotes, object resourceGroup, object resourceText1, object resourceText2, object resourceText3, object resourceText4)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", new object[] { taskName, taskNotes, taskText1, taskText2, taskText3, taskText4, taskText5, taskText6, taskText7, taskText8, taskText9, taskText10, resourceCode, resourceName, resourceNotes, resourceGroup, resourceText1, resourceText2, resourceText3, resourceText4 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        /// <param name="taskText3">optional object taskText3</param>
        /// <param name="taskText4">optional object taskText4</param>
        /// <param name="taskText5">optional object taskText5</param>
        /// <param name="taskText6">optional object taskText6</param>
        /// <param name="taskText7">optional object taskText7</param>
        /// <param name="taskText8">optional object taskText8</param>
        /// <param name="taskText9">optional object taskText9</param>
        /// <param name="taskText10">optional object taskText10</param>
        /// <param name="resourceCode">optional object resourceCode</param>
        /// <param name="resourceName">optional object resourceName</param>
        /// <param name="resourceNotes">optional object resourceNotes</param>
        /// <param name="resourceGroup">optional object resourceGroup</param>
        /// <param name="resourceText1">optional object resourceText1</param>
        /// <param name="resourceText2">optional object resourceText2</param>
        /// <param name="resourceText3">optional object resourceText3</param>
        /// <param name="resourceText4">optional object resourceText4</param>
        /// <param name="resourceText5">optional object resourceText5</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2, object taskText3, object taskText4, object taskText5, object taskText6, object taskText7, object taskText8, object taskText9, object taskText10, object resourceCode, object resourceName, object resourceNotes, object resourceGroup, object resourceText1, object resourceText2, object resourceText3, object resourceText4, object resourceText5)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", new object[] { taskName, taskNotes, taskText1, taskText2, taskText3, taskText4, taskText5, taskText6, taskText7, taskText8, taskText9, taskText10, resourceCode, resourceName, resourceNotes, resourceGroup, resourceText1, resourceText2, resourceText3, resourceText4, resourceText5 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        /// <param name="taskText3">optional object taskText3</param>
        /// <param name="taskText4">optional object taskText4</param>
        /// <param name="taskText5">optional object taskText5</param>
        /// <param name="taskText6">optional object taskText6</param>
        /// <param name="taskText7">optional object taskText7</param>
        /// <param name="taskText8">optional object taskText8</param>
        /// <param name="taskText9">optional object taskText9</param>
        /// <param name="taskText10">optional object taskText10</param>
        /// <param name="resourceCode">optional object resourceCode</param>
        /// <param name="resourceName">optional object resourceName</param>
        /// <param name="resourceNotes">optional object resourceNotes</param>
        /// <param name="resourceGroup">optional object resourceGroup</param>
        /// <param name="resourceText1">optional object resourceText1</param>
        /// <param name="resourceText2">optional object resourceText2</param>
        /// <param name="resourceText3">optional object resourceText3</param>
        /// <param name="resourceText4">optional object resourceText4</param>
        /// <param name="resourceText5">optional object resourceText5</param>
        /// <param name="assignNotes">optional object assignNotes</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2, object taskText3, object taskText4, object taskText5, object taskText6, object taskText7, object taskText8, object taskText9, object taskText10, object resourceCode, object resourceName, object resourceNotes, object resourceGroup, object resourceText1, object resourceText2, object resourceText3, object resourceText4, object resourceText5, object assignNotes)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", new object[] { taskName, taskNotes, taskText1, taskText2, taskText3, taskText4, taskText5, taskText6, taskText7, taskText8, taskText9, taskText10, resourceCode, resourceName, resourceNotes, resourceGroup, resourceText1, resourceText2, resourceText3, resourceText4, resourceText5, assignNotes });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        /// <param name="taskText3">optional object taskText3</param>
        /// <param name="taskText4">optional object taskText4</param>
        /// <param name="taskText5">optional object taskText5</param>
        /// <param name="taskText6">optional object taskText6</param>
        /// <param name="taskText7">optional object taskText7</param>
        /// <param name="taskText8">optional object taskText8</param>
        /// <param name="taskText9">optional object taskText9</param>
        /// <param name="taskText10">optional object taskText10</param>
        /// <param name="resourceCode">optional object resourceCode</param>
        /// <param name="resourceName">optional object resourceName</param>
        /// <param name="resourceNotes">optional object resourceNotes</param>
        /// <param name="resourceGroup">optional object resourceGroup</param>
        /// <param name="resourceText1">optional object resourceText1</param>
        /// <param name="resourceText2">optional object resourceText2</param>
        /// <param name="resourceText3">optional object resourceText3</param>
        /// <param name="resourceText4">optional object resourceText4</param>
        /// <param name="resourceText5">optional object resourceText5</param>
        /// <param name="assignNotes">optional object assignNotes</param>
        /// <param name="ignoreUppercase">optional object ignoreUppercase</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2, object taskText3, object taskText4, object taskText5, object taskText6, object taskText7, object taskText8, object taskText9, object taskText10, object resourceCode, object resourceName, object resourceNotes, object resourceGroup, object resourceText1, object resourceText2, object resourceText3, object resourceText4, object resourceText5, object assignNotes, object ignoreUppercase)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", new object[] { taskName, taskNotes, taskText1, taskText2, taskText3, taskText4, taskText5, taskText6, taskText7, taskText8, taskText9, taskText10, resourceCode, resourceName, resourceNotes, resourceGroup, resourceText1, resourceText2, resourceText3, resourceText4, resourceText5, assignNotes, ignoreUppercase });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        /// <param name="taskText3">optional object taskText3</param>
        /// <param name="taskText4">optional object taskText4</param>
        /// <param name="taskText5">optional object taskText5</param>
        /// <param name="taskText6">optional object taskText6</param>
        /// <param name="taskText7">optional object taskText7</param>
        /// <param name="taskText8">optional object taskText8</param>
        /// <param name="taskText9">optional object taskText9</param>
        /// <param name="taskText10">optional object taskText10</param>
        /// <param name="resourceCode">optional object resourceCode</param>
        /// <param name="resourceName">optional object resourceName</param>
        /// <param name="resourceNotes">optional object resourceNotes</param>
        /// <param name="resourceGroup">optional object resourceGroup</param>
        /// <param name="resourceText1">optional object resourceText1</param>
        /// <param name="resourceText2">optional object resourceText2</param>
        /// <param name="resourceText3">optional object resourceText3</param>
        /// <param name="resourceText4">optional object resourceText4</param>
        /// <param name="resourceText5">optional object resourceText5</param>
        /// <param name="assignNotes">optional object assignNotes</param>
        /// <param name="ignoreUppercase">optional object ignoreUppercase</param>
        /// <param name="ignoreNumberWords">optional object ignoreNumberWords</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2, object taskText3, object taskText4, object taskText5, object taskText6, object taskText7, object taskText8, object taskText9, object taskText10, object resourceCode, object resourceName, object resourceNotes, object resourceGroup, object resourceText1, object resourceText2, object resourceText3, object resourceText4, object resourceText5, object assignNotes, object ignoreUppercase, object ignoreNumberWords)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", new object[] { taskName, taskNotes, taskText1, taskText2, taskText3, taskText4, taskText5, taskText6, taskText7, taskText8, taskText9, taskText10, resourceCode, resourceName, resourceNotes, resourceGroup, resourceText1, resourceText2, resourceText3, resourceText4, resourceText5, assignNotes, ignoreUppercase, ignoreNumberWords });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskName">optional object taskName</param>
        /// <param name="taskNotes">optional object taskNotes</param>
        /// <param name="taskText1">optional object taskText1</param>
        /// <param name="taskText2">optional object taskText2</param>
        /// <param name="taskText3">optional object taskText3</param>
        /// <param name="taskText4">optional object taskText4</param>
        /// <param name="taskText5">optional object taskText5</param>
        /// <param name="taskText6">optional object taskText6</param>
        /// <param name="taskText7">optional object taskText7</param>
        /// <param name="taskText8">optional object taskText8</param>
        /// <param name="taskText9">optional object taskText9</param>
        /// <param name="taskText10">optional object taskText10</param>
        /// <param name="resourceCode">optional object resourceCode</param>
        /// <param name="resourceName">optional object resourceName</param>
        /// <param name="resourceNotes">optional object resourceNotes</param>
        /// <param name="resourceGroup">optional object resourceGroup</param>
        /// <param name="resourceText1">optional object resourceText1</param>
        /// <param name="resourceText2">optional object resourceText2</param>
        /// <param name="resourceText3">optional object resourceText3</param>
        /// <param name="resourceText4">optional object resourceText4</param>
        /// <param name="resourceText5">optional object resourceText5</param>
        /// <param name="assignNotes">optional object assignNotes</param>
        /// <param name="ignoreUppercase">optional object ignoreUppercase</param>
        /// <param name="ignoreNumberWords">optional object ignoreNumberWords</param>
        /// <param name="alwaysSuggest">optional object alwaysSuggest</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool OptionsSpelling(object taskName, object taskNotes, object taskText1, object taskText2, object taskText3, object taskText4, object taskText5, object taskText6, object taskText7, object taskText8, object taskText9, object taskText10, object resourceCode, object resourceName, object resourceNotes, object resourceGroup, object resourceText1, object resourceText2, object resourceText3, object resourceText4, object resourceText5, object assignNotes, object ignoreUppercase, object ignoreNumberWords, object alwaysSuggest)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "OptionsSpelling", new object[] { taskName, taskNotes, taskText1, taskText2, taskText3, taskText4, taskText5, taskText6, taskText7, taskText8, taskText9, taskText10, resourceCode, resourceName, resourceNotes, resourceGroup, resourceText1, resourceText2, resourceText3, resourceText4, resourceText5, assignNotes, ignoreUppercase, ignoreNumberWords, alwaysSuggest });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool WindowMoreWindows()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "WindowMoreWindows");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool HelpContents()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "HelpContents");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool HelpSearch()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "HelpSearch");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool HelpOnlineIndex()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "HelpOnlineIndex");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool HelpAbout()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "HelpAbout");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fileName">optional object fileName</param>
        /// <param name="contextNumber">optional object contextNumber</param>
        /// <param name="search">optional object search</param>
        /// <param name="searchKey">optional object searchKey</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool HelpLaunch(object fileName, object contextNumber, object search, object searchKey)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "HelpLaunch", fileName, contextNumber, search, searchKey);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool HelpLaunch()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "HelpLaunch");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fileName">optional object fileName</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool HelpLaunch(object fileName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "HelpLaunch", fileName);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fileName">optional object fileName</param>
        /// <param name="contextNumber">optional object contextNumber</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool HelpLaunch(object fileName, object contextNumber)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "HelpLaunch", fileName, contextNumber);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fileName">optional object fileName</param>
        /// <param name="contextNumber">optional object contextNumber</param>
        /// <param name="search">optional object search</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool HelpLaunch(object fileName, object contextNumber, object search)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "HelpLaunch", fileName, contextNumber, search);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fileName">optional object fileName</param>
        /// <param name="contextNumber">optional object contextNumber</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool HelpCueCards(object fileName, object contextNumber)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "HelpCueCards", fileName, contextNumber);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool HelpCueCards()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "HelpCueCards");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="fileName">optional object fileName</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool HelpCueCards(object fileName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "HelpCueCards", fileName);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool HelpTopics()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "HelpTopics");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool HelpAnswerWizard()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "HelpAnswerWizard");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool HelpMSProjectFundamentals()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "HelpMSProjectFundamentals");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AutoCorrect()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "AutoCorrect");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool HelpQuickPreview()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "HelpQuickPreview");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool HelpTechnicalSupport()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "HelpTechnicalSupport");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool HelpCreateYourProject()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "HelpCreateYourProject");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool HelpContextHelp()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "HelpContextHelp");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">optional object item</param>
        /// <param name="font">optional object font</param>
        /// <param name="size">optional object size</param>
        /// <param name="bold">optional object bold</param>
        /// <param name="italic">optional object italic</param>
        /// <param name="underline">optional object underline</param>
        /// <param name="color">optional object color</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TextStyles(object item, object font, object size, object bold, object italic, object underline, object color)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TextStyles", new object[] { item, font, size, bold, italic, underline, color });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TextStyles()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TextStyles");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">optional object item</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TextStyles(object item)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TextStyles", item);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">optional object item</param>
        /// <param name="font">optional object font</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TextStyles(object item, object font)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TextStyles", item, font);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">optional object item</param>
        /// <param name="font">optional object font</param>
        /// <param name="size">optional object size</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TextStyles(object item, object font, object size)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TextStyles", item, font, size);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">optional object item</param>
        /// <param name="font">optional object font</param>
        /// <param name="size">optional object size</param>
        /// <param name="bold">optional object bold</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TextStyles(object item, object font, object size, object bold)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TextStyles", item, font, size, bold);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">optional object item</param>
        /// <param name="font">optional object font</param>
        /// <param name="size">optional object size</param>
        /// <param name="bold">optional object bold</param>
        /// <param name="italic">optional object italic</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TextStyles(object item, object font, object size, object bold, object italic)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TextStyles", new object[] { item, font, size, bold, italic });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">optional object item</param>
        /// <param name="font">optional object font</param>
        /// <param name="size">optional object size</param>
        /// <param name="bold">optional object bold</param>
        /// <param name="italic">optional object italic</param>
        /// <param name="underline">optional object underline</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TextStyles(object item, object font, object size, object bold, object italic, object underline)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TextStyles", new object[] { item, font, size, bold, italic, underline });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">optional object item</param>
        /// <param name="font">optional object font</param>
        /// <param name="size">optional object size</param>
        /// <param name="bold">optional object bold</param>
        /// <param name="italic">optional object italic</param>
        /// <param name="underline">optional object underline</param>
        /// <param name="color">optional object color</param>
        /// <param name="cellColor">optional object cellColor</param>
        /// <param name="pattern">optional object pattern</param>
        /// <param name="showInMenu">optional object showInMenu</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DetailStylesFormat(object item, object font, object size, object bold, object italic, object underline, object color, object cellColor, object pattern, object showInMenu)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DetailStylesFormat", new object[] { item, font, size, bold, italic, underline, color, cellColor, pattern, showInMenu });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DetailStylesFormat()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DetailStylesFormat");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">optional object item</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DetailStylesFormat(object item)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DetailStylesFormat", item);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">optional object item</param>
        /// <param name="font">optional object font</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DetailStylesFormat(object item, object font)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DetailStylesFormat", item, font);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">optional object item</param>
        /// <param name="font">optional object font</param>
        /// <param name="size">optional object size</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DetailStylesFormat(object item, object font, object size)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DetailStylesFormat", item, font, size);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">optional object item</param>
        /// <param name="font">optional object font</param>
        /// <param name="size">optional object size</param>
        /// <param name="bold">optional object bold</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DetailStylesFormat(object item, object font, object size, object bold)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DetailStylesFormat", item, font, size, bold);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">optional object item</param>
        /// <param name="font">optional object font</param>
        /// <param name="size">optional object size</param>
        /// <param name="bold">optional object bold</param>
        /// <param name="italic">optional object italic</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DetailStylesFormat(object item, object font, object size, object bold, object italic)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DetailStylesFormat", new object[] { item, font, size, bold, italic });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">optional object item</param>
        /// <param name="font">optional object font</param>
        /// <param name="size">optional object size</param>
        /// <param name="bold">optional object bold</param>
        /// <param name="italic">optional object italic</param>
        /// <param name="underline">optional object underline</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DetailStylesFormat(object item, object font, object size, object bold, object italic, object underline)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DetailStylesFormat", new object[] { item, font, size, bold, italic, underline });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">optional object item</param>
        /// <param name="font">optional object font</param>
        /// <param name="size">optional object size</param>
        /// <param name="bold">optional object bold</param>
        /// <param name="italic">optional object italic</param>
        /// <param name="underline">optional object underline</param>
        /// <param name="color">optional object color</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DetailStylesFormat(object item, object font, object size, object bold, object italic, object underline, object color)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DetailStylesFormat", new object[] { item, font, size, bold, italic, underline, color });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">optional object item</param>
        /// <param name="font">optional object font</param>
        /// <param name="size">optional object size</param>
        /// <param name="bold">optional object bold</param>
        /// <param name="italic">optional object italic</param>
        /// <param name="underline">optional object underline</param>
        /// <param name="color">optional object color</param>
        /// <param name="cellColor">optional object cellColor</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DetailStylesFormat(object item, object font, object size, object bold, object italic, object underline, object color, object cellColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DetailStylesFormat", new object[] { item, font, size, bold, italic, underline, color, cellColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">optional object item</param>
        /// <param name="font">optional object font</param>
        /// <param name="size">optional object size</param>
        /// <param name="bold">optional object bold</param>
        /// <param name="italic">optional object italic</param>
        /// <param name="underline">optional object underline</param>
        /// <param name="color">optional object color</param>
        /// <param name="cellColor">optional object cellColor</param>
        /// <param name="pattern">optional object pattern</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DetailStylesFormat(object item, object font, object size, object bold, object italic, object underline, object color, object cellColor, object pattern)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DetailStylesFormat", new object[] { item, font, size, bold, italic, underline, color, cellColor, pattern });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">optional NetOffice.MSProjectApi.Enums.PjTimescaledData Item = 0</param>
        /// <param name="position">optional object position</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DetailStylesAdd(object item, object position)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DetailStylesAdd", item, position);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DetailStylesAdd()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DetailStylesAdd");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">optional NetOffice.MSProjectApi.Enums.PjTimescaledData Item = 0</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DetailStylesAdd(object item)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DetailStylesAdd", item);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">optional NetOffice.MSProjectApi.Enums.PjTimescaledData Item = 0</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DetailStylesRemove(object item)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DetailStylesRemove", item);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DetailStylesRemove()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DetailStylesRemove");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DetailStylesRemoveAll()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DetailStylesRemoveAll");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="size">optional object size</param>
        /// <param name="bold">optional object bold</param>
        /// <param name="italic">optional object italic</param>
        /// <param name="underline">optional object underline</param>
        /// <param name="color">optional object color</param>
        /// <param name="reset">optional object reset</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Font(object name, object size, object bold, object italic, object underline, object color, object reset)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Font", new object[] { name, size, bold, italic, underline, color, reset });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Font()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Font");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Font(object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Font", name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="size">optional object size</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Font(object name, object size)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Font", name, size);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="size">optional object size</param>
        /// <param name="bold">optional object bold</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Font(object name, object size, object bold)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Font", name, size, bold);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="size">optional object size</param>
        /// <param name="bold">optional object bold</param>
        /// <param name="italic">optional object italic</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Font(object name, object size, object bold, object italic)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Font", name, size, bold, italic);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="size">optional object size</param>
        /// <param name="bold">optional object bold</param>
        /// <param name="italic">optional object italic</param>
        /// <param name="underline">optional object underline</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Font(object name, object size, object bold, object italic, object underline)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Font", new object[] { name, size, bold, italic, underline });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="name">optional object name</param>
        /// <param name="size">optional object size</param>
        /// <param name="bold">optional object bold</param>
        /// <param name="italic">optional object italic</param>
        /// <param name="underline">optional object underline</param>
        /// <param name="color">optional object color</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Font(object name, object size, object bold, object italic, object underline, object color)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Font", new object[] { name, size, bold, italic, underline, color });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Timescale()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Timescale");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="majorUnits">optional object majorUnits</param>
        /// <param name="minorUnits">optional object minorUnits</param>
        /// <param name="majorLabel">optional object majorLabel</param>
        /// <param name="minorLabel">optional object minorLabel</param>
        /// <param name="majorAlign">optional object majorAlign</param>
        /// <param name="minorAlign">optional object minorAlign</param>
        /// <param name="majorCount">optional object majorCount</param>
        /// <param name="minorCount">optional object minorCount</param>
        /// <param name="majorTicks">optional object majorTicks</param>
        /// <param name="minorTicks">optional object minorTicks</param>
        /// <param name="enlarge">optional object enlarge</param>
        /// <param name="separator">optional object separator</param>
        /// <param name="majorUseFY">optional object majorUseFY</param>
        /// <param name="minorUseFY">optional object minorUseFY</param>
        /// <param name="topUnits">optional object topUnits</param>
        /// <param name="topLabel">optional object topLabel</param>
        /// <param name="topAlign">optional object topAlign</param>
        /// <param name="topCount">optional object topCount</param>
        /// <param name="topTicks">optional object topTicks</param>
        /// <param name="topUseFY">optional object topUseFY</param>
        /// <param name="tierCount">optional object tierCount</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleEdit(object majorUnits, object minorUnits, object majorLabel, object minorLabel, object majorAlign, object minorAlign, object majorCount, object minorCount, object majorTicks, object minorTicks, object enlarge, object separator, object majorUseFY, object minorUseFY, object topUnits, object topLabel, object topAlign, object topCount, object topTicks, object topUseFY, object tierCount)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleEdit", new object[] { majorUnits, minorUnits, majorLabel, minorLabel, majorAlign, minorAlign, majorCount, minorCount, majorTicks, minorTicks, enlarge, separator, majorUseFY, minorUseFY, topUnits, topLabel, topAlign, topCount, topTicks, topUseFY, tierCount });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleEdit()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleEdit");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="majorUnits">optional object majorUnits</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleEdit(object majorUnits)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleEdit", majorUnits);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="majorUnits">optional object majorUnits</param>
        /// <param name="minorUnits">optional object minorUnits</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleEdit(object majorUnits, object minorUnits)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleEdit", majorUnits, minorUnits);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="majorUnits">optional object majorUnits</param>
        /// <param name="minorUnits">optional object minorUnits</param>
        /// <param name="majorLabel">optional object majorLabel</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleEdit(object majorUnits, object minorUnits, object majorLabel)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleEdit", majorUnits, minorUnits, majorLabel);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="majorUnits">optional object majorUnits</param>
        /// <param name="minorUnits">optional object minorUnits</param>
        /// <param name="majorLabel">optional object majorLabel</param>
        /// <param name="minorLabel">optional object minorLabel</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleEdit(object majorUnits, object minorUnits, object majorLabel, object minorLabel)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleEdit", majorUnits, minorUnits, majorLabel, minorLabel);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="majorUnits">optional object majorUnits</param>
        /// <param name="minorUnits">optional object minorUnits</param>
        /// <param name="majorLabel">optional object majorLabel</param>
        /// <param name="minorLabel">optional object minorLabel</param>
        /// <param name="majorAlign">optional object majorAlign</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleEdit(object majorUnits, object minorUnits, object majorLabel, object minorLabel, object majorAlign)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleEdit", new object[] { majorUnits, minorUnits, majorLabel, minorLabel, majorAlign });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="majorUnits">optional object majorUnits</param>
        /// <param name="minorUnits">optional object minorUnits</param>
        /// <param name="majorLabel">optional object majorLabel</param>
        /// <param name="minorLabel">optional object minorLabel</param>
        /// <param name="majorAlign">optional object majorAlign</param>
        /// <param name="minorAlign">optional object minorAlign</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleEdit(object majorUnits, object minorUnits, object majorLabel, object minorLabel, object majorAlign, object minorAlign)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleEdit", new object[] { majorUnits, minorUnits, majorLabel, minorLabel, majorAlign, minorAlign });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="majorUnits">optional object majorUnits</param>
        /// <param name="minorUnits">optional object minorUnits</param>
        /// <param name="majorLabel">optional object majorLabel</param>
        /// <param name="minorLabel">optional object minorLabel</param>
        /// <param name="majorAlign">optional object majorAlign</param>
        /// <param name="minorAlign">optional object minorAlign</param>
        /// <param name="majorCount">optional object majorCount</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleEdit(object majorUnits, object minorUnits, object majorLabel, object minorLabel, object majorAlign, object minorAlign, object majorCount)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleEdit", new object[] { majorUnits, minorUnits, majorLabel, minorLabel, majorAlign, minorAlign, majorCount });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="majorUnits">optional object majorUnits</param>
        /// <param name="minorUnits">optional object minorUnits</param>
        /// <param name="majorLabel">optional object majorLabel</param>
        /// <param name="minorLabel">optional object minorLabel</param>
        /// <param name="majorAlign">optional object majorAlign</param>
        /// <param name="minorAlign">optional object minorAlign</param>
        /// <param name="majorCount">optional object majorCount</param>
        /// <param name="minorCount">optional object minorCount</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleEdit(object majorUnits, object minorUnits, object majorLabel, object minorLabel, object majorAlign, object minorAlign, object majorCount, object minorCount)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleEdit", new object[] { majorUnits, minorUnits, majorLabel, minorLabel, majorAlign, minorAlign, majorCount, minorCount });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="majorUnits">optional object majorUnits</param>
        /// <param name="minorUnits">optional object minorUnits</param>
        /// <param name="majorLabel">optional object majorLabel</param>
        /// <param name="minorLabel">optional object minorLabel</param>
        /// <param name="majorAlign">optional object majorAlign</param>
        /// <param name="minorAlign">optional object minorAlign</param>
        /// <param name="majorCount">optional object majorCount</param>
        /// <param name="minorCount">optional object minorCount</param>
        /// <param name="majorTicks">optional object majorTicks</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleEdit(object majorUnits, object minorUnits, object majorLabel, object minorLabel, object majorAlign, object minorAlign, object majorCount, object minorCount, object majorTicks)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleEdit", new object[] { majorUnits, minorUnits, majorLabel, minorLabel, majorAlign, minorAlign, majorCount, minorCount, majorTicks });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="majorUnits">optional object majorUnits</param>
        /// <param name="minorUnits">optional object minorUnits</param>
        /// <param name="majorLabel">optional object majorLabel</param>
        /// <param name="minorLabel">optional object minorLabel</param>
        /// <param name="majorAlign">optional object majorAlign</param>
        /// <param name="minorAlign">optional object minorAlign</param>
        /// <param name="majorCount">optional object majorCount</param>
        /// <param name="minorCount">optional object minorCount</param>
        /// <param name="majorTicks">optional object majorTicks</param>
        /// <param name="minorTicks">optional object minorTicks</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleEdit(object majorUnits, object minorUnits, object majorLabel, object minorLabel, object majorAlign, object minorAlign, object majorCount, object minorCount, object majorTicks, object minorTicks)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleEdit", new object[] { majorUnits, minorUnits, majorLabel, minorLabel, majorAlign, minorAlign, majorCount, minorCount, majorTicks, minorTicks });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="majorUnits">optional object majorUnits</param>
        /// <param name="minorUnits">optional object minorUnits</param>
        /// <param name="majorLabel">optional object majorLabel</param>
        /// <param name="minorLabel">optional object minorLabel</param>
        /// <param name="majorAlign">optional object majorAlign</param>
        /// <param name="minorAlign">optional object minorAlign</param>
        /// <param name="majorCount">optional object majorCount</param>
        /// <param name="minorCount">optional object minorCount</param>
        /// <param name="majorTicks">optional object majorTicks</param>
        /// <param name="minorTicks">optional object minorTicks</param>
        /// <param name="enlarge">optional object enlarge</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleEdit(object majorUnits, object minorUnits, object majorLabel, object minorLabel, object majorAlign, object minorAlign, object majorCount, object minorCount, object majorTicks, object minorTicks, object enlarge)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleEdit", new object[] { majorUnits, minorUnits, majorLabel, minorLabel, majorAlign, minorAlign, majorCount, minorCount, majorTicks, minorTicks, enlarge });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="majorUnits">optional object majorUnits</param>
        /// <param name="minorUnits">optional object minorUnits</param>
        /// <param name="majorLabel">optional object majorLabel</param>
        /// <param name="minorLabel">optional object minorLabel</param>
        /// <param name="majorAlign">optional object majorAlign</param>
        /// <param name="minorAlign">optional object minorAlign</param>
        /// <param name="majorCount">optional object majorCount</param>
        /// <param name="minorCount">optional object minorCount</param>
        /// <param name="majorTicks">optional object majorTicks</param>
        /// <param name="minorTicks">optional object minorTicks</param>
        /// <param name="enlarge">optional object enlarge</param>
        /// <param name="separator">optional object separator</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleEdit(object majorUnits, object minorUnits, object majorLabel, object minorLabel, object majorAlign, object minorAlign, object majorCount, object minorCount, object majorTicks, object minorTicks, object enlarge, object separator)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleEdit", new object[] { majorUnits, minorUnits, majorLabel, minorLabel, majorAlign, minorAlign, majorCount, minorCount, majorTicks, minorTicks, enlarge, separator });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="majorUnits">optional object majorUnits</param>
        /// <param name="minorUnits">optional object minorUnits</param>
        /// <param name="majorLabel">optional object majorLabel</param>
        /// <param name="minorLabel">optional object minorLabel</param>
        /// <param name="majorAlign">optional object majorAlign</param>
        /// <param name="minorAlign">optional object minorAlign</param>
        /// <param name="majorCount">optional object majorCount</param>
        /// <param name="minorCount">optional object minorCount</param>
        /// <param name="majorTicks">optional object majorTicks</param>
        /// <param name="minorTicks">optional object minorTicks</param>
        /// <param name="enlarge">optional object enlarge</param>
        /// <param name="separator">optional object separator</param>
        /// <param name="majorUseFY">optional object majorUseFY</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleEdit(object majorUnits, object minorUnits, object majorLabel, object minorLabel, object majorAlign, object minorAlign, object majorCount, object minorCount, object majorTicks, object minorTicks, object enlarge, object separator, object majorUseFY)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleEdit", new object[] { majorUnits, minorUnits, majorLabel, minorLabel, majorAlign, minorAlign, majorCount, minorCount, majorTicks, minorTicks, enlarge, separator, majorUseFY });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="majorUnits">optional object majorUnits</param>
        /// <param name="minorUnits">optional object minorUnits</param>
        /// <param name="majorLabel">optional object majorLabel</param>
        /// <param name="minorLabel">optional object minorLabel</param>
        /// <param name="majorAlign">optional object majorAlign</param>
        /// <param name="minorAlign">optional object minorAlign</param>
        /// <param name="majorCount">optional object majorCount</param>
        /// <param name="minorCount">optional object minorCount</param>
        /// <param name="majorTicks">optional object majorTicks</param>
        /// <param name="minorTicks">optional object minorTicks</param>
        /// <param name="enlarge">optional object enlarge</param>
        /// <param name="separator">optional object separator</param>
        /// <param name="majorUseFY">optional object majorUseFY</param>
        /// <param name="minorUseFY">optional object minorUseFY</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleEdit(object majorUnits, object minorUnits, object majorLabel, object minorLabel, object majorAlign, object minorAlign, object majorCount, object minorCount, object majorTicks, object minorTicks, object enlarge, object separator, object majorUseFY, object minorUseFY)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleEdit", new object[] { majorUnits, minorUnits, majorLabel, minorLabel, majorAlign, minorAlign, majorCount, minorCount, majorTicks, minorTicks, enlarge, separator, majorUseFY, minorUseFY });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="majorUnits">optional object majorUnits</param>
        /// <param name="minorUnits">optional object minorUnits</param>
        /// <param name="majorLabel">optional object majorLabel</param>
        /// <param name="minorLabel">optional object minorLabel</param>
        /// <param name="majorAlign">optional object majorAlign</param>
        /// <param name="minorAlign">optional object minorAlign</param>
        /// <param name="majorCount">optional object majorCount</param>
        /// <param name="minorCount">optional object minorCount</param>
        /// <param name="majorTicks">optional object majorTicks</param>
        /// <param name="minorTicks">optional object minorTicks</param>
        /// <param name="enlarge">optional object enlarge</param>
        /// <param name="separator">optional object separator</param>
        /// <param name="majorUseFY">optional object majorUseFY</param>
        /// <param name="minorUseFY">optional object minorUseFY</param>
        /// <param name="topUnits">optional object topUnits</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleEdit(object majorUnits, object minorUnits, object majorLabel, object minorLabel, object majorAlign, object minorAlign, object majorCount, object minorCount, object majorTicks, object minorTicks, object enlarge, object separator, object majorUseFY, object minorUseFY, object topUnits)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleEdit", new object[] { majorUnits, minorUnits, majorLabel, minorLabel, majorAlign, minorAlign, majorCount, minorCount, majorTicks, minorTicks, enlarge, separator, majorUseFY, minorUseFY, topUnits });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="majorUnits">optional object majorUnits</param>
        /// <param name="minorUnits">optional object minorUnits</param>
        /// <param name="majorLabel">optional object majorLabel</param>
        /// <param name="minorLabel">optional object minorLabel</param>
        /// <param name="majorAlign">optional object majorAlign</param>
        /// <param name="minorAlign">optional object minorAlign</param>
        /// <param name="majorCount">optional object majorCount</param>
        /// <param name="minorCount">optional object minorCount</param>
        /// <param name="majorTicks">optional object majorTicks</param>
        /// <param name="minorTicks">optional object minorTicks</param>
        /// <param name="enlarge">optional object enlarge</param>
        /// <param name="separator">optional object separator</param>
        /// <param name="majorUseFY">optional object majorUseFY</param>
        /// <param name="minorUseFY">optional object minorUseFY</param>
        /// <param name="topUnits">optional object topUnits</param>
        /// <param name="topLabel">optional object topLabel</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleEdit(object majorUnits, object minorUnits, object majorLabel, object minorLabel, object majorAlign, object minorAlign, object majorCount, object minorCount, object majorTicks, object minorTicks, object enlarge, object separator, object majorUseFY, object minorUseFY, object topUnits, object topLabel)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleEdit", new object[] { majorUnits, minorUnits, majorLabel, minorLabel, majorAlign, minorAlign, majorCount, minorCount, majorTicks, minorTicks, enlarge, separator, majorUseFY, minorUseFY, topUnits, topLabel });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="majorUnits">optional object majorUnits</param>
        /// <param name="minorUnits">optional object minorUnits</param>
        /// <param name="majorLabel">optional object majorLabel</param>
        /// <param name="minorLabel">optional object minorLabel</param>
        /// <param name="majorAlign">optional object majorAlign</param>
        /// <param name="minorAlign">optional object minorAlign</param>
        /// <param name="majorCount">optional object majorCount</param>
        /// <param name="minorCount">optional object minorCount</param>
        /// <param name="majorTicks">optional object majorTicks</param>
        /// <param name="minorTicks">optional object minorTicks</param>
        /// <param name="enlarge">optional object enlarge</param>
        /// <param name="separator">optional object separator</param>
        /// <param name="majorUseFY">optional object majorUseFY</param>
        /// <param name="minorUseFY">optional object minorUseFY</param>
        /// <param name="topUnits">optional object topUnits</param>
        /// <param name="topLabel">optional object topLabel</param>
        /// <param name="topAlign">optional object topAlign</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleEdit(object majorUnits, object minorUnits, object majorLabel, object minorLabel, object majorAlign, object minorAlign, object majorCount, object minorCount, object majorTicks, object minorTicks, object enlarge, object separator, object majorUseFY, object minorUseFY, object topUnits, object topLabel, object topAlign)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleEdit", new object[] { majorUnits, minorUnits, majorLabel, minorLabel, majorAlign, minorAlign, majorCount, minorCount, majorTicks, minorTicks, enlarge, separator, majorUseFY, minorUseFY, topUnits, topLabel, topAlign });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="majorUnits">optional object majorUnits</param>
        /// <param name="minorUnits">optional object minorUnits</param>
        /// <param name="majorLabel">optional object majorLabel</param>
        /// <param name="minorLabel">optional object minorLabel</param>
        /// <param name="majorAlign">optional object majorAlign</param>
        /// <param name="minorAlign">optional object minorAlign</param>
        /// <param name="majorCount">optional object majorCount</param>
        /// <param name="minorCount">optional object minorCount</param>
        /// <param name="majorTicks">optional object majorTicks</param>
        /// <param name="minorTicks">optional object minorTicks</param>
        /// <param name="enlarge">optional object enlarge</param>
        /// <param name="separator">optional object separator</param>
        /// <param name="majorUseFY">optional object majorUseFY</param>
        /// <param name="minorUseFY">optional object minorUseFY</param>
        /// <param name="topUnits">optional object topUnits</param>
        /// <param name="topLabel">optional object topLabel</param>
        /// <param name="topAlign">optional object topAlign</param>
        /// <param name="topCount">optional object topCount</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleEdit(object majorUnits, object minorUnits, object majorLabel, object minorLabel, object majorAlign, object minorAlign, object majorCount, object minorCount, object majorTicks, object minorTicks, object enlarge, object separator, object majorUseFY, object minorUseFY, object topUnits, object topLabel, object topAlign, object topCount)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleEdit", new object[] { majorUnits, minorUnits, majorLabel, minorLabel, majorAlign, minorAlign, majorCount, minorCount, majorTicks, minorTicks, enlarge, separator, majorUseFY, minorUseFY, topUnits, topLabel, topAlign, topCount });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="majorUnits">optional object majorUnits</param>
        /// <param name="minorUnits">optional object minorUnits</param>
        /// <param name="majorLabel">optional object majorLabel</param>
        /// <param name="minorLabel">optional object minorLabel</param>
        /// <param name="majorAlign">optional object majorAlign</param>
        /// <param name="minorAlign">optional object minorAlign</param>
        /// <param name="majorCount">optional object majorCount</param>
        /// <param name="minorCount">optional object minorCount</param>
        /// <param name="majorTicks">optional object majorTicks</param>
        /// <param name="minorTicks">optional object minorTicks</param>
        /// <param name="enlarge">optional object enlarge</param>
        /// <param name="separator">optional object separator</param>
        /// <param name="majorUseFY">optional object majorUseFY</param>
        /// <param name="minorUseFY">optional object minorUseFY</param>
        /// <param name="topUnits">optional object topUnits</param>
        /// <param name="topLabel">optional object topLabel</param>
        /// <param name="topAlign">optional object topAlign</param>
        /// <param name="topCount">optional object topCount</param>
        /// <param name="topTicks">optional object topTicks</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleEdit(object majorUnits, object minorUnits, object majorLabel, object minorLabel, object majorAlign, object minorAlign, object majorCount, object minorCount, object majorTicks, object minorTicks, object enlarge, object separator, object majorUseFY, object minorUseFY, object topUnits, object topLabel, object topAlign, object topCount, object topTicks)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleEdit", new object[] { majorUnits, minorUnits, majorLabel, minorLabel, majorAlign, minorAlign, majorCount, minorCount, majorTicks, minorTicks, enlarge, separator, majorUseFY, minorUseFY, topUnits, topLabel, topAlign, topCount, topTicks });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="majorUnits">optional object majorUnits</param>
        /// <param name="minorUnits">optional object minorUnits</param>
        /// <param name="majorLabel">optional object majorLabel</param>
        /// <param name="minorLabel">optional object minorLabel</param>
        /// <param name="majorAlign">optional object majorAlign</param>
        /// <param name="minorAlign">optional object minorAlign</param>
        /// <param name="majorCount">optional object majorCount</param>
        /// <param name="minorCount">optional object minorCount</param>
        /// <param name="majorTicks">optional object majorTicks</param>
        /// <param name="minorTicks">optional object minorTicks</param>
        /// <param name="enlarge">optional object enlarge</param>
        /// <param name="separator">optional object separator</param>
        /// <param name="majorUseFY">optional object majorUseFY</param>
        /// <param name="minorUseFY">optional object minorUseFY</param>
        /// <param name="topUnits">optional object topUnits</param>
        /// <param name="topLabel">optional object topLabel</param>
        /// <param name="topAlign">optional object topAlign</param>
        /// <param name="topCount">optional object topCount</param>
        /// <param name="topTicks">optional object topTicks</param>
        /// <param name="topUseFY">optional object topUseFY</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleEdit(object majorUnits, object minorUnits, object majorLabel, object minorLabel, object majorAlign, object minorAlign, object majorCount, object minorCount, object majorTicks, object minorTicks, object enlarge, object separator, object majorUseFY, object minorUseFY, object topUnits, object topLabel, object topAlign, object topCount, object topTicks, object topUseFY)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleEdit", new object[] { majorUnits, minorUnits, majorLabel, minorLabel, majorAlign, minorAlign, majorCount, minorCount, majorTicks, minorTicks, enlarge, separator, majorUseFY, minorUseFY, topUnits, topLabel, topAlign, topCount, topTicks, topUseFY });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="key1">optional object key1</param>
        /// <param name="ascending1">optional object ascending1</param>
        /// <param name="key2">optional object key2</param>
        /// <param name="ascending2">optional object ascending2</param>
        /// <param name="key3">optional object key3</param>
        /// <param name="ascending3">optional object ascending3</param>
        /// <param name="renumber">optional object renumber</param>
        /// <param name="outline">optional object outline</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Sort(object key1, object ascending1, object key2, object ascending2, object key3, object ascending3, object renumber, object outline)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Sort", new object[] { key1, ascending1, key2, ascending2, key3, ascending3, renumber, outline });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Sort()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Sort");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="key1">optional object key1</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Sort(object key1)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Sort", key1);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="key1">optional object key1</param>
        /// <param name="ascending1">optional object ascending1</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Sort(object key1, object ascending1)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Sort", key1, ascending1);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="key1">optional object key1</param>
        /// <param name="ascending1">optional object ascending1</param>
        /// <param name="key2">optional object key2</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Sort(object key1, object ascending1, object key2)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Sort", key1, ascending1, key2);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="key1">optional object key1</param>
        /// <param name="ascending1">optional object ascending1</param>
        /// <param name="key2">optional object key2</param>
        /// <param name="ascending2">optional object ascending2</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Sort(object key1, object ascending1, object key2, object ascending2)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Sort", key1, ascending1, key2, ascending2);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="key1">optional object key1</param>
        /// <param name="ascending1">optional object ascending1</param>
        /// <param name="key2">optional object key2</param>
        /// <param name="ascending2">optional object ascending2</param>
        /// <param name="key3">optional object key3</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Sort(object key1, object ascending1, object key2, object ascending2, object key3)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Sort", new object[] { key1, ascending1, key2, ascending2, key3 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="key1">optional object key1</param>
        /// <param name="ascending1">optional object ascending1</param>
        /// <param name="key2">optional object key2</param>
        /// <param name="ascending2">optional object ascending2</param>
        /// <param name="key3">optional object key3</param>
        /// <param name="ascending3">optional object ascending3</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Sort(object key1, object ascending1, object key2, object ascending2, object key3, object ascending3)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Sort", new object[] { key1, ascending1, key2, ascending2, key3, ascending3 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="key1">optional object key1</param>
        /// <param name="ascending1">optional object ascending1</param>
        /// <param name="key2">optional object key2</param>
        /// <param name="ascending2">optional object ascending2</param>
        /// <param name="key3">optional object key3</param>
        /// <param name="ascending3">optional object ascending3</param>
        /// <param name="renumber">optional object renumber</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Sort(object key1, object ascending1, object key2, object ascending2, object key3, object ascending3, object renumber)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Sort", new object[] { key1, ascending1, key2, ascending2, key3, ascending3, renumber });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BarBoxStyles()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BarBoxStyles");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">optional object taskID</param>
        /// <param name="ganttStyle">optional object ganttStyle</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="endShape">optional object endShape</param>
        /// <param name="endType">optional object endType</param>
        /// <param name="endColor">optional object endColor</param>
        /// <param name="leftText">optional object leftText</param>
        /// <param name="rightText">optional object rightText</param>
        /// <param name="topText">optional object topText</param>
        /// <param name="bottomText">optional object bottomText</param>
        /// <param name="insideText">optional object insideText</param>
        /// <param name="reset">optional object reset</param>
        /// <param name="projectName">optional object projectName</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarFormat(object taskID, object ganttStyle, object startShape, object startType, object startColor, object middleShape, object middlePattern, object middleColor, object endShape, object endType, object endColor, object leftText, object rightText, object topText, object bottomText, object insideText, object reset, object projectName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarFormat", new object[] { taskID, ganttStyle, startShape, startType, startColor, middleShape, middlePattern, middleColor, endShape, endType, endColor, leftText, rightText, topText, bottomText, insideText, reset, projectName });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarFormat()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarFormat");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">optional object taskID</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarFormat(object taskID)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarFormat", taskID);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">optional object taskID</param>
        /// <param name="ganttStyle">optional object ganttStyle</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarFormat(object taskID, object ganttStyle)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarFormat", taskID, ganttStyle);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">optional object taskID</param>
        /// <param name="ganttStyle">optional object ganttStyle</param>
        /// <param name="startShape">optional object startShape</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarFormat(object taskID, object ganttStyle, object startShape)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarFormat", taskID, ganttStyle, startShape);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">optional object taskID</param>
        /// <param name="ganttStyle">optional object ganttStyle</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarFormat(object taskID, object ganttStyle, object startShape, object startType)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarFormat", taskID, ganttStyle, startShape, startType);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">optional object taskID</param>
        /// <param name="ganttStyle">optional object ganttStyle</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarFormat(object taskID, object ganttStyle, object startShape, object startType, object startColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarFormat", new object[] { taskID, ganttStyle, startShape, startType, startColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">optional object taskID</param>
        /// <param name="ganttStyle">optional object ganttStyle</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarFormat(object taskID, object ganttStyle, object startShape, object startType, object startColor, object middleShape)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarFormat", new object[] { taskID, ganttStyle, startShape, startType, startColor, middleShape });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">optional object taskID</param>
        /// <param name="ganttStyle">optional object ganttStyle</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarFormat(object taskID, object ganttStyle, object startShape, object startType, object startColor, object middleShape, object middlePattern)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarFormat", new object[] { taskID, ganttStyle, startShape, startType, startColor, middleShape, middlePattern });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">optional object taskID</param>
        /// <param name="ganttStyle">optional object ganttStyle</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="middleColor">optional object middleColor</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarFormat(object taskID, object ganttStyle, object startShape, object startType, object startColor, object middleShape, object middlePattern, object middleColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarFormat", new object[] { taskID, ganttStyle, startShape, startType, startColor, middleShape, middlePattern, middleColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">optional object taskID</param>
        /// <param name="ganttStyle">optional object ganttStyle</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="endShape">optional object endShape</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarFormat(object taskID, object ganttStyle, object startShape, object startType, object startColor, object middleShape, object middlePattern, object middleColor, object endShape)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarFormat", new object[] { taskID, ganttStyle, startShape, startType, startColor, middleShape, middlePattern, middleColor, endShape });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">optional object taskID</param>
        /// <param name="ganttStyle">optional object ganttStyle</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="endShape">optional object endShape</param>
        /// <param name="endType">optional object endType</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarFormat(object taskID, object ganttStyle, object startShape, object startType, object startColor, object middleShape, object middlePattern, object middleColor, object endShape, object endType)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarFormat", new object[] { taskID, ganttStyle, startShape, startType, startColor, middleShape, middlePattern, middleColor, endShape, endType });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">optional object taskID</param>
        /// <param name="ganttStyle">optional object ganttStyle</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="endShape">optional object endShape</param>
        /// <param name="endType">optional object endType</param>
        /// <param name="endColor">optional object endColor</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarFormat(object taskID, object ganttStyle, object startShape, object startType, object startColor, object middleShape, object middlePattern, object middleColor, object endShape, object endType, object endColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarFormat", new object[] { taskID, ganttStyle, startShape, startType, startColor, middleShape, middlePattern, middleColor, endShape, endType, endColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">optional object taskID</param>
        /// <param name="ganttStyle">optional object ganttStyle</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="endShape">optional object endShape</param>
        /// <param name="endType">optional object endType</param>
        /// <param name="endColor">optional object endColor</param>
        /// <param name="leftText">optional object leftText</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarFormat(object taskID, object ganttStyle, object startShape, object startType, object startColor, object middleShape, object middlePattern, object middleColor, object endShape, object endType, object endColor, object leftText)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarFormat", new object[] { taskID, ganttStyle, startShape, startType, startColor, middleShape, middlePattern, middleColor, endShape, endType, endColor, leftText });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">optional object taskID</param>
        /// <param name="ganttStyle">optional object ganttStyle</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="endShape">optional object endShape</param>
        /// <param name="endType">optional object endType</param>
        /// <param name="endColor">optional object endColor</param>
        /// <param name="leftText">optional object leftText</param>
        /// <param name="rightText">optional object rightText</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarFormat(object taskID, object ganttStyle, object startShape, object startType, object startColor, object middleShape, object middlePattern, object middleColor, object endShape, object endType, object endColor, object leftText, object rightText)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarFormat", new object[] { taskID, ganttStyle, startShape, startType, startColor, middleShape, middlePattern, middleColor, endShape, endType, endColor, leftText, rightText });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">optional object taskID</param>
        /// <param name="ganttStyle">optional object ganttStyle</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="endShape">optional object endShape</param>
        /// <param name="endType">optional object endType</param>
        /// <param name="endColor">optional object endColor</param>
        /// <param name="leftText">optional object leftText</param>
        /// <param name="rightText">optional object rightText</param>
        /// <param name="topText">optional object topText</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarFormat(object taskID, object ganttStyle, object startShape, object startType, object startColor, object middleShape, object middlePattern, object middleColor, object endShape, object endType, object endColor, object leftText, object rightText, object topText)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarFormat", new object[] { taskID, ganttStyle, startShape, startType, startColor, middleShape, middlePattern, middleColor, endShape, endType, endColor, leftText, rightText, topText });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">optional object taskID</param>
        /// <param name="ganttStyle">optional object ganttStyle</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="endShape">optional object endShape</param>
        /// <param name="endType">optional object endType</param>
        /// <param name="endColor">optional object endColor</param>
        /// <param name="leftText">optional object leftText</param>
        /// <param name="rightText">optional object rightText</param>
        /// <param name="topText">optional object topText</param>
        /// <param name="bottomText">optional object bottomText</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarFormat(object taskID, object ganttStyle, object startShape, object startType, object startColor, object middleShape, object middlePattern, object middleColor, object endShape, object endType, object endColor, object leftText, object rightText, object topText, object bottomText)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarFormat", new object[] { taskID, ganttStyle, startShape, startType, startColor, middleShape, middlePattern, middleColor, endShape, endType, endColor, leftText, rightText, topText, bottomText });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">optional object taskID</param>
        /// <param name="ganttStyle">optional object ganttStyle</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="endShape">optional object endShape</param>
        /// <param name="endType">optional object endType</param>
        /// <param name="endColor">optional object endColor</param>
        /// <param name="leftText">optional object leftText</param>
        /// <param name="rightText">optional object rightText</param>
        /// <param name="topText">optional object topText</param>
        /// <param name="bottomText">optional object bottomText</param>
        /// <param name="insideText">optional object insideText</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarFormat(object taskID, object ganttStyle, object startShape, object startType, object startColor, object middleShape, object middlePattern, object middleColor, object endShape, object endType, object endColor, object leftText, object rightText, object topText, object bottomText, object insideText)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarFormat", new object[] { taskID, ganttStyle, startShape, startType, startColor, middleShape, middlePattern, middleColor, endShape, endType, endColor, leftText, rightText, topText, bottomText, insideText });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="taskID">optional object taskID</param>
        /// <param name="ganttStyle">optional object ganttStyle</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="endShape">optional object endShape</param>
        /// <param name="endType">optional object endType</param>
        /// <param name="endColor">optional object endColor</param>
        /// <param name="leftText">optional object leftText</param>
        /// <param name="rightText">optional object rightText</param>
        /// <param name="topText">optional object topText</param>
        /// <param name="bottomText">optional object bottomText</param>
        /// <param name="insideText">optional object insideText</param>
        /// <param name="reset">optional object reset</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarFormat(object taskID, object ganttStyle, object startShape, object startType, object startColor, object middleShape, object middlePattern, object middleColor, object endShape, object endType, object endColor, object leftText, object rightText, object topText, object bottomText, object insideText, object reset)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarFormat", new object[] { taskID, ganttStyle, startShape, startType, startColor, middleShape, middlePattern, middleColor, endShape, endType, endColor, leftText, rightText, topText, bottomText, insideText, reset });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="draw">optional object draw</param>
        /// <param name="calendar">optional object calendar</param>
        /// <param name="color">optional object color</param>
        /// <param name="pattern">optional object pattern</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleNonWorking(object draw, object calendar, object color, object pattern)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleNonWorking", draw, calendar, color, pattern);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleNonWorking()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleNonWorking");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="draw">optional object draw</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleNonWorking(object draw)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleNonWorking", draw);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="draw">optional object draw</param>
        /// <param name="calendar">optional object calendar</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleNonWorking(object draw, object calendar)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleNonWorking", draw, calendar);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="draw">optional object draw</param>
        /// <param name="calendar">optional object calendar</param>
        /// <param name="color">optional object color</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool TimescaleNonWorking(object draw, object calendar, object color)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "TimescaleNonWorking", draw, calendar, color);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="show">optional object show</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BoxShowHideFields(object show)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BoxShowHideFields", show);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BoxShowHideFields()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BoxShowHideFields");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Layout()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Layout");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="straight">optional object straight</param>
        /// <param name="displayArrows">optional object displayArrows</param>
        /// <param name="adjustForPageBreaks">optional object adjustForPageBreaks</param>
        /// <param name="displayPageBreaks">optional object displayPageBreaks</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTLayout(object straight, object displayArrows, object adjustForPageBreaks, object displayPageBreaks)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTLayout", straight, displayArrows, adjustForPageBreaks, displayPageBreaks);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTLayout()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTLayout");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="straight">optional object straight</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTLayout(object straight)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTLayout", straight);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="straight">optional object straight</param>
        /// <param name="displayArrows">optional object displayArrows</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTLayout(object straight, object displayArrows)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTLayout", straight, displayArrows);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="straight">optional object straight</param>
        /// <param name="displayArrows">optional object displayArrows</param>
        /// <param name="adjustForPageBreaks">optional object adjustForPageBreaks</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTLayout(object straight, object displayArrows, object adjustForPageBreaks)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTLayout", straight, displayArrows, adjustForPageBreaks);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool LayoutNow()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "LayoutNow");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        /// <param name="noncriticalStyle">optional object noncriticalStyle</param>
        /// <param name="noncriticalColor">optional object noncriticalColor</param>
        /// <param name="criticalMilestoneStyle">optional object criticalMilestoneStyle</param>
        /// <param name="criticalMilestoneColor">optional object criticalMilestoneColor</param>
        /// <param name="noncriticalMilestoneStyle">optional object noncriticalMilestoneStyle</param>
        /// <param name="noncriticalMilestoneColor">optional object noncriticalMilestoneColor</param>
        /// <param name="criticalSummaryStyle">optional object criticalSummaryStyle</param>
        /// <param name="criticalSummaryColor">optional object criticalSummaryColor</param>
        /// <param name="noncriticalSummaryStyle">optional object noncriticalSummaryStyle</param>
        /// <param name="noncriticalSummaryColor">optional object noncriticalSummaryColor</param>
        /// <param name="criticalSubprojectStyle">optional object criticalSubprojectStyle</param>
        /// <param name="criticalSubprojectColor">optional object criticalSubprojectColor</param>
        /// <param name="noncriticalSubprojectStyle">optional object noncriticalSubprojectStyle</param>
        /// <param name="noncriticalSubprojectColor">optional object noncriticalSubprojectColor</param>
        /// <param name="criticalMarkedStyle">optional object criticalMarkedStyle</param>
        /// <param name="criticalMarkedColor">optional object criticalMarkedColor</param>
        /// <param name="noncriticalMarkedStyle">optional object noncriticalMarkedStyle</param>
        /// <param name="noncriticalMarkedColor">optional object noncriticalMarkedColor</param>
        /// <param name="criticalExternalTaskStyle">optional object criticalExternalTaskStyle</param>
        /// <param name="criticalExternalTaskColor">optional object criticalExternalTaskColor</param>
        /// <param name="noncriticalExternalTaskStyle">optional object noncriticalExternalTaskStyle</param>
        /// <param name="noncriticalExternalTaskColor">optional object noncriticalExternalTaskColor</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor, object noncriticalStyle, object noncriticalColor, object criticalMilestoneStyle, object criticalMilestoneColor, object noncriticalMilestoneStyle, object noncriticalMilestoneColor, object criticalSummaryStyle, object criticalSummaryColor, object noncriticalSummaryStyle, object noncriticalSummaryColor, object criticalSubprojectStyle, object criticalSubprojectColor, object noncriticalSubprojectStyle, object noncriticalSubprojectColor, object criticalMarkedStyle, object criticalMarkedColor, object noncriticalMarkedStyle, object noncriticalMarkedColor, object criticalExternalTaskStyle, object criticalExternalTaskColor, object noncriticalExternalTaskStyle, object noncriticalExternalTaskColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", new object[] { criticalStyle, criticalColor, noncriticalStyle, noncriticalColor, criticalMilestoneStyle, criticalMilestoneColor, noncriticalMilestoneStyle, noncriticalMilestoneColor, criticalSummaryStyle, criticalSummaryColor, noncriticalSummaryStyle, noncriticalSummaryColor, criticalSubprojectStyle, criticalSubprojectColor, noncriticalSubprojectStyle, noncriticalSubprojectColor, criticalMarkedStyle, criticalMarkedColor, noncriticalMarkedStyle, noncriticalMarkedColor, criticalExternalTaskStyle, criticalExternalTaskColor, noncriticalExternalTaskStyle, noncriticalExternalTaskColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", criticalStyle);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", criticalStyle, criticalColor);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        /// <param name="noncriticalStyle">optional object noncriticalStyle</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor, object noncriticalStyle)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", criticalStyle, criticalColor, noncriticalStyle);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        /// <param name="noncriticalStyle">optional object noncriticalStyle</param>
        /// <param name="noncriticalColor">optional object noncriticalColor</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor, object noncriticalStyle, object noncriticalColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", criticalStyle, criticalColor, noncriticalStyle, noncriticalColor);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        /// <param name="noncriticalStyle">optional object noncriticalStyle</param>
        /// <param name="noncriticalColor">optional object noncriticalColor</param>
        /// <param name="criticalMilestoneStyle">optional object criticalMilestoneStyle</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor, object noncriticalStyle, object noncriticalColor, object criticalMilestoneStyle)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", new object[] { criticalStyle, criticalColor, noncriticalStyle, noncriticalColor, criticalMilestoneStyle });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        /// <param name="noncriticalStyle">optional object noncriticalStyle</param>
        /// <param name="noncriticalColor">optional object noncriticalColor</param>
        /// <param name="criticalMilestoneStyle">optional object criticalMilestoneStyle</param>
        /// <param name="criticalMilestoneColor">optional object criticalMilestoneColor</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor, object noncriticalStyle, object noncriticalColor, object criticalMilestoneStyle, object criticalMilestoneColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", new object[] { criticalStyle, criticalColor, noncriticalStyle, noncriticalColor, criticalMilestoneStyle, criticalMilestoneColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        /// <param name="noncriticalStyle">optional object noncriticalStyle</param>
        /// <param name="noncriticalColor">optional object noncriticalColor</param>
        /// <param name="criticalMilestoneStyle">optional object criticalMilestoneStyle</param>
        /// <param name="criticalMilestoneColor">optional object criticalMilestoneColor</param>
        /// <param name="noncriticalMilestoneStyle">optional object noncriticalMilestoneStyle</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor, object noncriticalStyle, object noncriticalColor, object criticalMilestoneStyle, object criticalMilestoneColor, object noncriticalMilestoneStyle)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", new object[] { criticalStyle, criticalColor, noncriticalStyle, noncriticalColor, criticalMilestoneStyle, criticalMilestoneColor, noncriticalMilestoneStyle });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        /// <param name="noncriticalStyle">optional object noncriticalStyle</param>
        /// <param name="noncriticalColor">optional object noncriticalColor</param>
        /// <param name="criticalMilestoneStyle">optional object criticalMilestoneStyle</param>
        /// <param name="criticalMilestoneColor">optional object criticalMilestoneColor</param>
        /// <param name="noncriticalMilestoneStyle">optional object noncriticalMilestoneStyle</param>
        /// <param name="noncriticalMilestoneColor">optional object noncriticalMilestoneColor</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor, object noncriticalStyle, object noncriticalColor, object criticalMilestoneStyle, object criticalMilestoneColor, object noncriticalMilestoneStyle, object noncriticalMilestoneColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", new object[] { criticalStyle, criticalColor, noncriticalStyle, noncriticalColor, criticalMilestoneStyle, criticalMilestoneColor, noncriticalMilestoneStyle, noncriticalMilestoneColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        /// <param name="noncriticalStyle">optional object noncriticalStyle</param>
        /// <param name="noncriticalColor">optional object noncriticalColor</param>
        /// <param name="criticalMilestoneStyle">optional object criticalMilestoneStyle</param>
        /// <param name="criticalMilestoneColor">optional object criticalMilestoneColor</param>
        /// <param name="noncriticalMilestoneStyle">optional object noncriticalMilestoneStyle</param>
        /// <param name="noncriticalMilestoneColor">optional object noncriticalMilestoneColor</param>
        /// <param name="criticalSummaryStyle">optional object criticalSummaryStyle</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor, object noncriticalStyle, object noncriticalColor, object criticalMilestoneStyle, object criticalMilestoneColor, object noncriticalMilestoneStyle, object noncriticalMilestoneColor, object criticalSummaryStyle)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", new object[] { criticalStyle, criticalColor, noncriticalStyle, noncriticalColor, criticalMilestoneStyle, criticalMilestoneColor, noncriticalMilestoneStyle, noncriticalMilestoneColor, criticalSummaryStyle });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        /// <param name="noncriticalStyle">optional object noncriticalStyle</param>
        /// <param name="noncriticalColor">optional object noncriticalColor</param>
        /// <param name="criticalMilestoneStyle">optional object criticalMilestoneStyle</param>
        /// <param name="criticalMilestoneColor">optional object criticalMilestoneColor</param>
        /// <param name="noncriticalMilestoneStyle">optional object noncriticalMilestoneStyle</param>
        /// <param name="noncriticalMilestoneColor">optional object noncriticalMilestoneColor</param>
        /// <param name="criticalSummaryStyle">optional object criticalSummaryStyle</param>
        /// <param name="criticalSummaryColor">optional object criticalSummaryColor</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor, object noncriticalStyle, object noncriticalColor, object criticalMilestoneStyle, object criticalMilestoneColor, object noncriticalMilestoneStyle, object noncriticalMilestoneColor, object criticalSummaryStyle, object criticalSummaryColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", new object[] { criticalStyle, criticalColor, noncriticalStyle, noncriticalColor, criticalMilestoneStyle, criticalMilestoneColor, noncriticalMilestoneStyle, noncriticalMilestoneColor, criticalSummaryStyle, criticalSummaryColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        /// <param name="noncriticalStyle">optional object noncriticalStyle</param>
        /// <param name="noncriticalColor">optional object noncriticalColor</param>
        /// <param name="criticalMilestoneStyle">optional object criticalMilestoneStyle</param>
        /// <param name="criticalMilestoneColor">optional object criticalMilestoneColor</param>
        /// <param name="noncriticalMilestoneStyle">optional object noncriticalMilestoneStyle</param>
        /// <param name="noncriticalMilestoneColor">optional object noncriticalMilestoneColor</param>
        /// <param name="criticalSummaryStyle">optional object criticalSummaryStyle</param>
        /// <param name="criticalSummaryColor">optional object criticalSummaryColor</param>
        /// <param name="noncriticalSummaryStyle">optional object noncriticalSummaryStyle</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor, object noncriticalStyle, object noncriticalColor, object criticalMilestoneStyle, object criticalMilestoneColor, object noncriticalMilestoneStyle, object noncriticalMilestoneColor, object criticalSummaryStyle, object criticalSummaryColor, object noncriticalSummaryStyle)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", new object[] { criticalStyle, criticalColor, noncriticalStyle, noncriticalColor, criticalMilestoneStyle, criticalMilestoneColor, noncriticalMilestoneStyle, noncriticalMilestoneColor, criticalSummaryStyle, criticalSummaryColor, noncriticalSummaryStyle });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        /// <param name="noncriticalStyle">optional object noncriticalStyle</param>
        /// <param name="noncriticalColor">optional object noncriticalColor</param>
        /// <param name="criticalMilestoneStyle">optional object criticalMilestoneStyle</param>
        /// <param name="criticalMilestoneColor">optional object criticalMilestoneColor</param>
        /// <param name="noncriticalMilestoneStyle">optional object noncriticalMilestoneStyle</param>
        /// <param name="noncriticalMilestoneColor">optional object noncriticalMilestoneColor</param>
        /// <param name="criticalSummaryStyle">optional object criticalSummaryStyle</param>
        /// <param name="criticalSummaryColor">optional object criticalSummaryColor</param>
        /// <param name="noncriticalSummaryStyle">optional object noncriticalSummaryStyle</param>
        /// <param name="noncriticalSummaryColor">optional object noncriticalSummaryColor</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor, object noncriticalStyle, object noncriticalColor, object criticalMilestoneStyle, object criticalMilestoneColor, object noncriticalMilestoneStyle, object noncriticalMilestoneColor, object criticalSummaryStyle, object criticalSummaryColor, object noncriticalSummaryStyle, object noncriticalSummaryColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", new object[] { criticalStyle, criticalColor, noncriticalStyle, noncriticalColor, criticalMilestoneStyle, criticalMilestoneColor, noncriticalMilestoneStyle, noncriticalMilestoneColor, criticalSummaryStyle, criticalSummaryColor, noncriticalSummaryStyle, noncriticalSummaryColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        /// <param name="noncriticalStyle">optional object noncriticalStyle</param>
        /// <param name="noncriticalColor">optional object noncriticalColor</param>
        /// <param name="criticalMilestoneStyle">optional object criticalMilestoneStyle</param>
        /// <param name="criticalMilestoneColor">optional object criticalMilestoneColor</param>
        /// <param name="noncriticalMilestoneStyle">optional object noncriticalMilestoneStyle</param>
        /// <param name="noncriticalMilestoneColor">optional object noncriticalMilestoneColor</param>
        /// <param name="criticalSummaryStyle">optional object criticalSummaryStyle</param>
        /// <param name="criticalSummaryColor">optional object criticalSummaryColor</param>
        /// <param name="noncriticalSummaryStyle">optional object noncriticalSummaryStyle</param>
        /// <param name="noncriticalSummaryColor">optional object noncriticalSummaryColor</param>
        /// <param name="criticalSubprojectStyle">optional object criticalSubprojectStyle</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor, object noncriticalStyle, object noncriticalColor, object criticalMilestoneStyle, object criticalMilestoneColor, object noncriticalMilestoneStyle, object noncriticalMilestoneColor, object criticalSummaryStyle, object criticalSummaryColor, object noncriticalSummaryStyle, object noncriticalSummaryColor, object criticalSubprojectStyle)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", new object[] { criticalStyle, criticalColor, noncriticalStyle, noncriticalColor, criticalMilestoneStyle, criticalMilestoneColor, noncriticalMilestoneStyle, noncriticalMilestoneColor, criticalSummaryStyle, criticalSummaryColor, noncriticalSummaryStyle, noncriticalSummaryColor, criticalSubprojectStyle });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        /// <param name="noncriticalStyle">optional object noncriticalStyle</param>
        /// <param name="noncriticalColor">optional object noncriticalColor</param>
        /// <param name="criticalMilestoneStyle">optional object criticalMilestoneStyle</param>
        /// <param name="criticalMilestoneColor">optional object criticalMilestoneColor</param>
        /// <param name="noncriticalMilestoneStyle">optional object noncriticalMilestoneStyle</param>
        /// <param name="noncriticalMilestoneColor">optional object noncriticalMilestoneColor</param>
        /// <param name="criticalSummaryStyle">optional object criticalSummaryStyle</param>
        /// <param name="criticalSummaryColor">optional object criticalSummaryColor</param>
        /// <param name="noncriticalSummaryStyle">optional object noncriticalSummaryStyle</param>
        /// <param name="noncriticalSummaryColor">optional object noncriticalSummaryColor</param>
        /// <param name="criticalSubprojectStyle">optional object criticalSubprojectStyle</param>
        /// <param name="criticalSubprojectColor">optional object criticalSubprojectColor</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor, object noncriticalStyle, object noncriticalColor, object criticalMilestoneStyle, object criticalMilestoneColor, object noncriticalMilestoneStyle, object noncriticalMilestoneColor, object criticalSummaryStyle, object criticalSummaryColor, object noncriticalSummaryStyle, object noncriticalSummaryColor, object criticalSubprojectStyle, object criticalSubprojectColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", new object[] { criticalStyle, criticalColor, noncriticalStyle, noncriticalColor, criticalMilestoneStyle, criticalMilestoneColor, noncriticalMilestoneStyle, noncriticalMilestoneColor, criticalSummaryStyle, criticalSummaryColor, noncriticalSummaryStyle, noncriticalSummaryColor, criticalSubprojectStyle, criticalSubprojectColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        /// <param name="noncriticalStyle">optional object noncriticalStyle</param>
        /// <param name="noncriticalColor">optional object noncriticalColor</param>
        /// <param name="criticalMilestoneStyle">optional object criticalMilestoneStyle</param>
        /// <param name="criticalMilestoneColor">optional object criticalMilestoneColor</param>
        /// <param name="noncriticalMilestoneStyle">optional object noncriticalMilestoneStyle</param>
        /// <param name="noncriticalMilestoneColor">optional object noncriticalMilestoneColor</param>
        /// <param name="criticalSummaryStyle">optional object criticalSummaryStyle</param>
        /// <param name="criticalSummaryColor">optional object criticalSummaryColor</param>
        /// <param name="noncriticalSummaryStyle">optional object noncriticalSummaryStyle</param>
        /// <param name="noncriticalSummaryColor">optional object noncriticalSummaryColor</param>
        /// <param name="criticalSubprojectStyle">optional object criticalSubprojectStyle</param>
        /// <param name="criticalSubprojectColor">optional object criticalSubprojectColor</param>
        /// <param name="noncriticalSubprojectStyle">optional object noncriticalSubprojectStyle</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor, object noncriticalStyle, object noncriticalColor, object criticalMilestoneStyle, object criticalMilestoneColor, object noncriticalMilestoneStyle, object noncriticalMilestoneColor, object criticalSummaryStyle, object criticalSummaryColor, object noncriticalSummaryStyle, object noncriticalSummaryColor, object criticalSubprojectStyle, object criticalSubprojectColor, object noncriticalSubprojectStyle)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", new object[] { criticalStyle, criticalColor, noncriticalStyle, noncriticalColor, criticalMilestoneStyle, criticalMilestoneColor, noncriticalMilestoneStyle, noncriticalMilestoneColor, criticalSummaryStyle, criticalSummaryColor, noncriticalSummaryStyle, noncriticalSummaryColor, criticalSubprojectStyle, criticalSubprojectColor, noncriticalSubprojectStyle });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        /// <param name="noncriticalStyle">optional object noncriticalStyle</param>
        /// <param name="noncriticalColor">optional object noncriticalColor</param>
        /// <param name="criticalMilestoneStyle">optional object criticalMilestoneStyle</param>
        /// <param name="criticalMilestoneColor">optional object criticalMilestoneColor</param>
        /// <param name="noncriticalMilestoneStyle">optional object noncriticalMilestoneStyle</param>
        /// <param name="noncriticalMilestoneColor">optional object noncriticalMilestoneColor</param>
        /// <param name="criticalSummaryStyle">optional object criticalSummaryStyle</param>
        /// <param name="criticalSummaryColor">optional object criticalSummaryColor</param>
        /// <param name="noncriticalSummaryStyle">optional object noncriticalSummaryStyle</param>
        /// <param name="noncriticalSummaryColor">optional object noncriticalSummaryColor</param>
        /// <param name="criticalSubprojectStyle">optional object criticalSubprojectStyle</param>
        /// <param name="criticalSubprojectColor">optional object criticalSubprojectColor</param>
        /// <param name="noncriticalSubprojectStyle">optional object noncriticalSubprojectStyle</param>
        /// <param name="noncriticalSubprojectColor">optional object noncriticalSubprojectColor</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor, object noncriticalStyle, object noncriticalColor, object criticalMilestoneStyle, object criticalMilestoneColor, object noncriticalMilestoneStyle, object noncriticalMilestoneColor, object criticalSummaryStyle, object criticalSummaryColor, object noncriticalSummaryStyle, object noncriticalSummaryColor, object criticalSubprojectStyle, object criticalSubprojectColor, object noncriticalSubprojectStyle, object noncriticalSubprojectColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", new object[] { criticalStyle, criticalColor, noncriticalStyle, noncriticalColor, criticalMilestoneStyle, criticalMilestoneColor, noncriticalMilestoneStyle, noncriticalMilestoneColor, criticalSummaryStyle, criticalSummaryColor, noncriticalSummaryStyle, noncriticalSummaryColor, criticalSubprojectStyle, criticalSubprojectColor, noncriticalSubprojectStyle, noncriticalSubprojectColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        /// <param name="noncriticalStyle">optional object noncriticalStyle</param>
        /// <param name="noncriticalColor">optional object noncriticalColor</param>
        /// <param name="criticalMilestoneStyle">optional object criticalMilestoneStyle</param>
        /// <param name="criticalMilestoneColor">optional object criticalMilestoneColor</param>
        /// <param name="noncriticalMilestoneStyle">optional object noncriticalMilestoneStyle</param>
        /// <param name="noncriticalMilestoneColor">optional object noncriticalMilestoneColor</param>
        /// <param name="criticalSummaryStyle">optional object criticalSummaryStyle</param>
        /// <param name="criticalSummaryColor">optional object criticalSummaryColor</param>
        /// <param name="noncriticalSummaryStyle">optional object noncriticalSummaryStyle</param>
        /// <param name="noncriticalSummaryColor">optional object noncriticalSummaryColor</param>
        /// <param name="criticalSubprojectStyle">optional object criticalSubprojectStyle</param>
        /// <param name="criticalSubprojectColor">optional object criticalSubprojectColor</param>
        /// <param name="noncriticalSubprojectStyle">optional object noncriticalSubprojectStyle</param>
        /// <param name="noncriticalSubprojectColor">optional object noncriticalSubprojectColor</param>
        /// <param name="criticalMarkedStyle">optional object criticalMarkedStyle</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor, object noncriticalStyle, object noncriticalColor, object criticalMilestoneStyle, object criticalMilestoneColor, object noncriticalMilestoneStyle, object noncriticalMilestoneColor, object criticalSummaryStyle, object criticalSummaryColor, object noncriticalSummaryStyle, object noncriticalSummaryColor, object criticalSubprojectStyle, object criticalSubprojectColor, object noncriticalSubprojectStyle, object noncriticalSubprojectColor, object criticalMarkedStyle)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", new object[] { criticalStyle, criticalColor, noncriticalStyle, noncriticalColor, criticalMilestoneStyle, criticalMilestoneColor, noncriticalMilestoneStyle, noncriticalMilestoneColor, criticalSummaryStyle, criticalSummaryColor, noncriticalSummaryStyle, noncriticalSummaryColor, criticalSubprojectStyle, criticalSubprojectColor, noncriticalSubprojectStyle, noncriticalSubprojectColor, criticalMarkedStyle });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        /// <param name="noncriticalStyle">optional object noncriticalStyle</param>
        /// <param name="noncriticalColor">optional object noncriticalColor</param>
        /// <param name="criticalMilestoneStyle">optional object criticalMilestoneStyle</param>
        /// <param name="criticalMilestoneColor">optional object criticalMilestoneColor</param>
        /// <param name="noncriticalMilestoneStyle">optional object noncriticalMilestoneStyle</param>
        /// <param name="noncriticalMilestoneColor">optional object noncriticalMilestoneColor</param>
        /// <param name="criticalSummaryStyle">optional object criticalSummaryStyle</param>
        /// <param name="criticalSummaryColor">optional object criticalSummaryColor</param>
        /// <param name="noncriticalSummaryStyle">optional object noncriticalSummaryStyle</param>
        /// <param name="noncriticalSummaryColor">optional object noncriticalSummaryColor</param>
        /// <param name="criticalSubprojectStyle">optional object criticalSubprojectStyle</param>
        /// <param name="criticalSubprojectColor">optional object criticalSubprojectColor</param>
        /// <param name="noncriticalSubprojectStyle">optional object noncriticalSubprojectStyle</param>
        /// <param name="noncriticalSubprojectColor">optional object noncriticalSubprojectColor</param>
        /// <param name="criticalMarkedStyle">optional object criticalMarkedStyle</param>
        /// <param name="criticalMarkedColor">optional object criticalMarkedColor</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor, object noncriticalStyle, object noncriticalColor, object criticalMilestoneStyle, object criticalMilestoneColor, object noncriticalMilestoneStyle, object noncriticalMilestoneColor, object criticalSummaryStyle, object criticalSummaryColor, object noncriticalSummaryStyle, object noncriticalSummaryColor, object criticalSubprojectStyle, object criticalSubprojectColor, object noncriticalSubprojectStyle, object noncriticalSubprojectColor, object criticalMarkedStyle, object criticalMarkedColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", new object[] { criticalStyle, criticalColor, noncriticalStyle, noncriticalColor, criticalMilestoneStyle, criticalMilestoneColor, noncriticalMilestoneStyle, noncriticalMilestoneColor, criticalSummaryStyle, criticalSummaryColor, noncriticalSummaryStyle, noncriticalSummaryColor, criticalSubprojectStyle, criticalSubprojectColor, noncriticalSubprojectStyle, noncriticalSubprojectColor, criticalMarkedStyle, criticalMarkedColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        /// <param name="noncriticalStyle">optional object noncriticalStyle</param>
        /// <param name="noncriticalColor">optional object noncriticalColor</param>
        /// <param name="criticalMilestoneStyle">optional object criticalMilestoneStyle</param>
        /// <param name="criticalMilestoneColor">optional object criticalMilestoneColor</param>
        /// <param name="noncriticalMilestoneStyle">optional object noncriticalMilestoneStyle</param>
        /// <param name="noncriticalMilestoneColor">optional object noncriticalMilestoneColor</param>
        /// <param name="criticalSummaryStyle">optional object criticalSummaryStyle</param>
        /// <param name="criticalSummaryColor">optional object criticalSummaryColor</param>
        /// <param name="noncriticalSummaryStyle">optional object noncriticalSummaryStyle</param>
        /// <param name="noncriticalSummaryColor">optional object noncriticalSummaryColor</param>
        /// <param name="criticalSubprojectStyle">optional object criticalSubprojectStyle</param>
        /// <param name="criticalSubprojectColor">optional object criticalSubprojectColor</param>
        /// <param name="noncriticalSubprojectStyle">optional object noncriticalSubprojectStyle</param>
        /// <param name="noncriticalSubprojectColor">optional object noncriticalSubprojectColor</param>
        /// <param name="criticalMarkedStyle">optional object criticalMarkedStyle</param>
        /// <param name="criticalMarkedColor">optional object criticalMarkedColor</param>
        /// <param name="noncriticalMarkedStyle">optional object noncriticalMarkedStyle</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor, object noncriticalStyle, object noncriticalColor, object criticalMilestoneStyle, object criticalMilestoneColor, object noncriticalMilestoneStyle, object noncriticalMilestoneColor, object criticalSummaryStyle, object criticalSummaryColor, object noncriticalSummaryStyle, object noncriticalSummaryColor, object criticalSubprojectStyle, object criticalSubprojectColor, object noncriticalSubprojectStyle, object noncriticalSubprojectColor, object criticalMarkedStyle, object criticalMarkedColor, object noncriticalMarkedStyle)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", new object[] { criticalStyle, criticalColor, noncriticalStyle, noncriticalColor, criticalMilestoneStyle, criticalMilestoneColor, noncriticalMilestoneStyle, noncriticalMilestoneColor, criticalSummaryStyle, criticalSummaryColor, noncriticalSummaryStyle, noncriticalSummaryColor, criticalSubprojectStyle, criticalSubprojectColor, noncriticalSubprojectStyle, noncriticalSubprojectColor, criticalMarkedStyle, criticalMarkedColor, noncriticalMarkedStyle });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        /// <param name="noncriticalStyle">optional object noncriticalStyle</param>
        /// <param name="noncriticalColor">optional object noncriticalColor</param>
        /// <param name="criticalMilestoneStyle">optional object criticalMilestoneStyle</param>
        /// <param name="criticalMilestoneColor">optional object criticalMilestoneColor</param>
        /// <param name="noncriticalMilestoneStyle">optional object noncriticalMilestoneStyle</param>
        /// <param name="noncriticalMilestoneColor">optional object noncriticalMilestoneColor</param>
        /// <param name="criticalSummaryStyle">optional object criticalSummaryStyle</param>
        /// <param name="criticalSummaryColor">optional object criticalSummaryColor</param>
        /// <param name="noncriticalSummaryStyle">optional object noncriticalSummaryStyle</param>
        /// <param name="noncriticalSummaryColor">optional object noncriticalSummaryColor</param>
        /// <param name="criticalSubprojectStyle">optional object criticalSubprojectStyle</param>
        /// <param name="criticalSubprojectColor">optional object criticalSubprojectColor</param>
        /// <param name="noncriticalSubprojectStyle">optional object noncriticalSubprojectStyle</param>
        /// <param name="noncriticalSubprojectColor">optional object noncriticalSubprojectColor</param>
        /// <param name="criticalMarkedStyle">optional object criticalMarkedStyle</param>
        /// <param name="criticalMarkedColor">optional object criticalMarkedColor</param>
        /// <param name="noncriticalMarkedStyle">optional object noncriticalMarkedStyle</param>
        /// <param name="noncriticalMarkedColor">optional object noncriticalMarkedColor</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor, object noncriticalStyle, object noncriticalColor, object criticalMilestoneStyle, object criticalMilestoneColor, object noncriticalMilestoneStyle, object noncriticalMilestoneColor, object criticalSummaryStyle, object criticalSummaryColor, object noncriticalSummaryStyle, object noncriticalSummaryColor, object criticalSubprojectStyle, object criticalSubprojectColor, object noncriticalSubprojectStyle, object noncriticalSubprojectColor, object criticalMarkedStyle, object criticalMarkedColor, object noncriticalMarkedStyle, object noncriticalMarkedColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", new object[] { criticalStyle, criticalColor, noncriticalStyle, noncriticalColor, criticalMilestoneStyle, criticalMilestoneColor, noncriticalMilestoneStyle, noncriticalMilestoneColor, criticalSummaryStyle, criticalSummaryColor, noncriticalSummaryStyle, noncriticalSummaryColor, criticalSubprojectStyle, criticalSubprojectColor, noncriticalSubprojectStyle, noncriticalSubprojectColor, criticalMarkedStyle, criticalMarkedColor, noncriticalMarkedStyle, noncriticalMarkedColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        /// <param name="noncriticalStyle">optional object noncriticalStyle</param>
        /// <param name="noncriticalColor">optional object noncriticalColor</param>
        /// <param name="criticalMilestoneStyle">optional object criticalMilestoneStyle</param>
        /// <param name="criticalMilestoneColor">optional object criticalMilestoneColor</param>
        /// <param name="noncriticalMilestoneStyle">optional object noncriticalMilestoneStyle</param>
        /// <param name="noncriticalMilestoneColor">optional object noncriticalMilestoneColor</param>
        /// <param name="criticalSummaryStyle">optional object criticalSummaryStyle</param>
        /// <param name="criticalSummaryColor">optional object criticalSummaryColor</param>
        /// <param name="noncriticalSummaryStyle">optional object noncriticalSummaryStyle</param>
        /// <param name="noncriticalSummaryColor">optional object noncriticalSummaryColor</param>
        /// <param name="criticalSubprojectStyle">optional object criticalSubprojectStyle</param>
        /// <param name="criticalSubprojectColor">optional object criticalSubprojectColor</param>
        /// <param name="noncriticalSubprojectStyle">optional object noncriticalSubprojectStyle</param>
        /// <param name="noncriticalSubprojectColor">optional object noncriticalSubprojectColor</param>
        /// <param name="criticalMarkedStyle">optional object criticalMarkedStyle</param>
        /// <param name="criticalMarkedColor">optional object criticalMarkedColor</param>
        /// <param name="noncriticalMarkedStyle">optional object noncriticalMarkedStyle</param>
        /// <param name="noncriticalMarkedColor">optional object noncriticalMarkedColor</param>
        /// <param name="criticalExternalTaskStyle">optional object criticalExternalTaskStyle</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor, object noncriticalStyle, object noncriticalColor, object criticalMilestoneStyle, object criticalMilestoneColor, object noncriticalMilestoneStyle, object noncriticalMilestoneColor, object criticalSummaryStyle, object criticalSummaryColor, object noncriticalSummaryStyle, object noncriticalSummaryColor, object criticalSubprojectStyle, object criticalSubprojectColor, object noncriticalSubprojectStyle, object noncriticalSubprojectColor, object criticalMarkedStyle, object criticalMarkedColor, object noncriticalMarkedStyle, object noncriticalMarkedColor, object criticalExternalTaskStyle)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", new object[] { criticalStyle, criticalColor, noncriticalStyle, noncriticalColor, criticalMilestoneStyle, criticalMilestoneColor, noncriticalMilestoneStyle, noncriticalMilestoneColor, criticalSummaryStyle, criticalSummaryColor, noncriticalSummaryStyle, noncriticalSummaryColor, criticalSubprojectStyle, criticalSubprojectColor, noncriticalSubprojectStyle, noncriticalSubprojectColor, criticalMarkedStyle, criticalMarkedColor, noncriticalMarkedStyle, noncriticalMarkedColor, criticalExternalTaskStyle });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        /// <param name="noncriticalStyle">optional object noncriticalStyle</param>
        /// <param name="noncriticalColor">optional object noncriticalColor</param>
        /// <param name="criticalMilestoneStyle">optional object criticalMilestoneStyle</param>
        /// <param name="criticalMilestoneColor">optional object criticalMilestoneColor</param>
        /// <param name="noncriticalMilestoneStyle">optional object noncriticalMilestoneStyle</param>
        /// <param name="noncriticalMilestoneColor">optional object noncriticalMilestoneColor</param>
        /// <param name="criticalSummaryStyle">optional object criticalSummaryStyle</param>
        /// <param name="criticalSummaryColor">optional object criticalSummaryColor</param>
        /// <param name="noncriticalSummaryStyle">optional object noncriticalSummaryStyle</param>
        /// <param name="noncriticalSummaryColor">optional object noncriticalSummaryColor</param>
        /// <param name="criticalSubprojectStyle">optional object criticalSubprojectStyle</param>
        /// <param name="criticalSubprojectColor">optional object criticalSubprojectColor</param>
        /// <param name="noncriticalSubprojectStyle">optional object noncriticalSubprojectStyle</param>
        /// <param name="noncriticalSubprojectColor">optional object noncriticalSubprojectColor</param>
        /// <param name="criticalMarkedStyle">optional object criticalMarkedStyle</param>
        /// <param name="criticalMarkedColor">optional object criticalMarkedColor</param>
        /// <param name="noncriticalMarkedStyle">optional object noncriticalMarkedStyle</param>
        /// <param name="noncriticalMarkedColor">optional object noncriticalMarkedColor</param>
        /// <param name="criticalExternalTaskStyle">optional object criticalExternalTaskStyle</param>
        /// <param name="criticalExternalTaskColor">optional object criticalExternalTaskColor</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor, object noncriticalStyle, object noncriticalColor, object criticalMilestoneStyle, object criticalMilestoneColor, object noncriticalMilestoneStyle, object noncriticalMilestoneColor, object criticalSummaryStyle, object criticalSummaryColor, object noncriticalSummaryStyle, object noncriticalSummaryColor, object criticalSubprojectStyle, object criticalSubprojectColor, object noncriticalSubprojectStyle, object noncriticalSubprojectColor, object criticalMarkedStyle, object criticalMarkedColor, object noncriticalMarkedStyle, object noncriticalMarkedColor, object criticalExternalTaskStyle, object criticalExternalTaskColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", new object[] { criticalStyle, criticalColor, noncriticalStyle, noncriticalColor, criticalMilestoneStyle, criticalMilestoneColor, noncriticalMilestoneStyle, noncriticalMilestoneColor, criticalSummaryStyle, criticalSummaryColor, noncriticalSummaryStyle, noncriticalSummaryColor, criticalSubprojectStyle, criticalSubprojectColor, noncriticalSubprojectStyle, noncriticalSubprojectColor, criticalMarkedStyle, criticalMarkedColor, noncriticalMarkedStyle, noncriticalMarkedColor, criticalExternalTaskStyle, criticalExternalTaskColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="criticalStyle">optional object criticalStyle</param>
        /// <param name="criticalColor">optional object criticalColor</param>
        /// <param name="noncriticalStyle">optional object noncriticalStyle</param>
        /// <param name="noncriticalColor">optional object noncriticalColor</param>
        /// <param name="criticalMilestoneStyle">optional object criticalMilestoneStyle</param>
        /// <param name="criticalMilestoneColor">optional object criticalMilestoneColor</param>
        /// <param name="noncriticalMilestoneStyle">optional object noncriticalMilestoneStyle</param>
        /// <param name="noncriticalMilestoneColor">optional object noncriticalMilestoneColor</param>
        /// <param name="criticalSummaryStyle">optional object criticalSummaryStyle</param>
        /// <param name="criticalSummaryColor">optional object criticalSummaryColor</param>
        /// <param name="noncriticalSummaryStyle">optional object noncriticalSummaryStyle</param>
        /// <param name="noncriticalSummaryColor">optional object noncriticalSummaryColor</param>
        /// <param name="criticalSubprojectStyle">optional object criticalSubprojectStyle</param>
        /// <param name="criticalSubprojectColor">optional object criticalSubprojectColor</param>
        /// <param name="noncriticalSubprojectStyle">optional object noncriticalSubprojectStyle</param>
        /// <param name="noncriticalSubprojectColor">optional object noncriticalSubprojectColor</param>
        /// <param name="criticalMarkedStyle">optional object criticalMarkedStyle</param>
        /// <param name="criticalMarkedColor">optional object criticalMarkedColor</param>
        /// <param name="noncriticalMarkedStyle">optional object noncriticalMarkedStyle</param>
        /// <param name="noncriticalMarkedColor">optional object noncriticalMarkedColor</param>
        /// <param name="criticalExternalTaskStyle">optional object criticalExternalTaskStyle</param>
        /// <param name="criticalExternalTaskColor">optional object criticalExternalTaskColor</param>
        /// <param name="noncriticalExternalTaskStyle">optional object noncriticalExternalTaskStyle</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBorders(object criticalStyle, object criticalColor, object noncriticalStyle, object noncriticalColor, object criticalMilestoneStyle, object criticalMilestoneColor, object noncriticalMilestoneStyle, object noncriticalMilestoneColor, object criticalSummaryStyle, object criticalSummaryColor, object noncriticalSummaryStyle, object noncriticalSummaryColor, object criticalSubprojectStyle, object criticalSubprojectColor, object noncriticalSubprojectStyle, object noncriticalSubprojectColor, object criticalMarkedStyle, object criticalMarkedColor, object noncriticalMarkedStyle, object noncriticalMarkedColor, object criticalExternalTaskStyle, object criticalExternalTaskColor, object noncriticalExternalTaskStyle)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBorders", new object[] { criticalStyle, criticalColor, noncriticalStyle, noncriticalColor, criticalMilestoneStyle, criticalMilestoneColor, noncriticalMilestoneStyle, noncriticalMilestoneColor, criticalSummaryStyle, criticalSummaryColor, noncriticalSummaryStyle, noncriticalSummaryColor, criticalSubprojectStyle, criticalSubprojectColor, noncriticalSubprojectStyle, noncriticalSubprojectColor, criticalMarkedStyle, criticalMarkedColor, noncriticalMarkedStyle, noncriticalMarkedColor, criticalExternalTaskStyle, criticalExternalTaskColor, noncriticalExternalTaskStyle });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool Gridlines()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "Gridlines");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">NetOffice.MSProjectApi.Enums.PjGridline item</param>
        /// <param name="normalType">optional object normalType</param>
        /// <param name="normalColor">optional object normalColor</param>
        /// <param name="interval">optional object interval</param>
        /// <param name="intervalType">optional object intervalType</param>
        /// <param name="intervalColor">optional object intervalColor</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GridlinesEdit(NetOffice.MSProjectApi.Enums.PjGridline item, object normalType, object normalColor, object interval, object intervalType, object intervalColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GridlinesEdit", new object[] { item, normalType, normalColor, interval, intervalType, intervalColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">NetOffice.MSProjectApi.Enums.PjGridline item</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GridlinesEdit(NetOffice.MSProjectApi.Enums.PjGridline item)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GridlinesEdit", item);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">NetOffice.MSProjectApi.Enums.PjGridline item</param>
        /// <param name="normalType">optional object normalType</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GridlinesEdit(NetOffice.MSProjectApi.Enums.PjGridline item, object normalType)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GridlinesEdit", item, normalType);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">NetOffice.MSProjectApi.Enums.PjGridline item</param>
        /// <param name="normalType">optional object normalType</param>
        /// <param name="normalColor">optional object normalColor</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GridlinesEdit(NetOffice.MSProjectApi.Enums.PjGridline item, object normalType, object normalColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GridlinesEdit", item, normalType, normalColor);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">NetOffice.MSProjectApi.Enums.PjGridline item</param>
        /// <param name="normalType">optional object normalType</param>
        /// <param name="normalColor">optional object normalColor</param>
        /// <param name="interval">optional object interval</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GridlinesEdit(NetOffice.MSProjectApi.Enums.PjGridline item, object normalType, object normalColor, object interval)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GridlinesEdit", item, normalType, normalColor, interval);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">NetOffice.MSProjectApi.Enums.PjGridline item</param>
        /// <param name="normalType">optional object normalType</param>
        /// <param name="normalColor">optional object normalColor</param>
        /// <param name="interval">optional object interval</param>
        /// <param name="intervalType">optional object intervalType</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GridlinesEdit(NetOffice.MSProjectApi.Enums.PjGridline item, object normalType, object normalColor, object interval, object intervalType)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GridlinesEdit", new object[] { item, normalType, normalColor, interval, intervalType });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="show">optional object show</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewShowSelectedTasks(object show)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewShowSelectedTasks", show);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ViewShowSelectedTasks()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ViewShowSelectedTasks");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="show">optional object show</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PageBreaksShow(object show)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PageBreaksShow", show);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PageBreaksShow()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PageBreaksShow");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FindNext()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FindNext");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool FindPrevious()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "FindPrevious");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ZoomOut()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ZoomOut");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ZoomIn()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ZoomIn");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        /// <param name="create">optional object create</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SetField(string field, string value, object create)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SetField", field, value, create);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SetField(string field, string value)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SetField", field, value);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        /// <param name="allSelectedTasks">optional object allSelectedTasks</param>
        /// <param name="create">optional object create</param>
        /// <param name="taskID">optional object taskID</param>
        /// <param name="projectName">optional object projectName</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SetTaskField(string field, string value, object allSelectedTasks, object create, object taskID, object projectName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SetTaskField", new object[] { field, value, allSelectedTasks, create, taskID, projectName });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SetTaskField(string field, string value)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SetTaskField", field, value);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        /// <param name="allSelectedTasks">optional object allSelectedTasks</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SetTaskField(string field, string value, object allSelectedTasks)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SetTaskField", field, value, allSelectedTasks);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        /// <param name="allSelectedTasks">optional object allSelectedTasks</param>
        /// <param name="create">optional object create</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SetTaskField(string field, string value, object allSelectedTasks, object create)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SetTaskField", field, value, allSelectedTasks, create);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        /// <param name="allSelectedTasks">optional object allSelectedTasks</param>
        /// <param name="create">optional object create</param>
        /// <param name="taskID">optional object taskID</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SetTaskField(string field, string value, object allSelectedTasks, object create, object taskID)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SetTaskField", new object[] { field, value, allSelectedTasks, create, taskID });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        /// <param name="allSelectedResources">optional object allSelectedResources</param>
        /// <param name="create">optional object create</param>
        /// <param name="resourceID">optional object resourceID</param>
        /// <param name="projectName">optional object projectName</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SetResourceField(string field, string value, object allSelectedResources, object create, object resourceID, object projectName)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SetResourceField", new object[] { field, value, allSelectedResources, create, resourceID, projectName });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SetResourceField(string field, string value)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SetResourceField", field, value);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        /// <param name="allSelectedResources">optional object allSelectedResources</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SetResourceField(string field, string value, object allSelectedResources)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SetResourceField", field, value, allSelectedResources);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        /// <param name="allSelectedResources">optional object allSelectedResources</param>
        /// <param name="create">optional object create</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SetResourceField(string field, string value, object allSelectedResources, object create)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SetResourceField", field, value, allSelectedResources, create);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        /// <param name="allSelectedResources">optional object allSelectedResources</param>
        /// <param name="create">optional object create</param>
        /// <param name="resourceID">optional object resourceID</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SetResourceField(string field, string value, object allSelectedResources, object create, object resourceID)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SetResourceField", new object[] { field, value, allSelectedResources, create, resourceID });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="value">string value</param>
        /// <param name="create">optional object create</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SetActiveCell(string value, object create)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SetActiveCell", value, create);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="value">string value</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SetActiveCell(string value)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SetActiveCell", value);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        /// <param name="test">optional object test</param>
        /// <param name="op">optional object op</param>
        /// <param name="field2">optional object field2</param>
        /// <param name="value2">optional object value2</param>
        /// <param name="test2">optional object test2</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static object CheckField(string field, string value, object test, object op, object field2, object value2, object test2)
        {
            return Factory.ExecuteVariantMethodGet(_instance, "CheckField", new object[] { field, value, test, op, field2, value2, test2 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static object CheckField(string field, string value)
        {
            return Factory.ExecuteVariantMethodGet(_instance, "CheckField", field, value);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        /// <param name="test">optional object test</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static object CheckField(string field, string value, object test)
        {
            return Factory.ExecuteVariantMethodGet(_instance, "CheckField", field, value, test);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        /// <param name="test">optional object test</param>
        /// <param name="op">optional object op</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static object CheckField(string field, string value, object test, object op)
        {
            return Factory.ExecuteVariantMethodGet(_instance, "CheckField", field, value, test, op);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        /// <param name="test">optional object test</param>
        /// <param name="op">optional object op</param>
        /// <param name="field2">optional object field2</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static object CheckField(string field, string value, object test, object op, object field2)
        {
            return Factory.ExecuteVariantMethodGet(_instance, "CheckField", new object[] { field, value, test, op, field2 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        /// <param name="test">optional object test</param>
        /// <param name="op">optional object op</param>
        /// <param name="field2">optional object field2</param>
        /// <param name="value2">optional object value2</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static object CheckField(string field, string value, object test, object op, object field2, object value2)
        {
            return Factory.ExecuteVariantMethodGet(_instance, "CheckField", new object[] { field, value, test, op, field2, value2 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        /// <param name="checkField">string checkField</param>
        /// <param name="checkValue">string checkValue</param>
        /// <param name="checkTest">optional object checkTest</param>
        /// <param name="checkOperation">optional object checkOperation</param>
        /// <param name="checkField2">optional object checkField2</param>
        /// <param name="checkValue2">optional object checkValue2</param>
        /// <param name="checkTest2">optional object checkTest2</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SetMatchingField(string field, string value, string checkField, string checkValue, object checkTest, object checkOperation, object checkField2, object checkValue2, object checkTest2)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SetMatchingField", new object[] { field, value, checkField, checkValue, checkTest, checkOperation, checkField2, checkValue2, checkTest2 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        /// <param name="checkField">string checkField</param>
        /// <param name="checkValue">string checkValue</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SetMatchingField(string field, string value, string checkField, string checkValue)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SetMatchingField", field, value, checkField, checkValue);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        /// <param name="checkField">string checkField</param>
        /// <param name="checkValue">string checkValue</param>
        /// <param name="checkTest">optional object checkTest</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SetMatchingField(string field, string value, string checkField, string checkValue, object checkTest)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SetMatchingField", new object[] { field, value, checkField, checkValue, checkTest });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        /// <param name="checkField">string checkField</param>
        /// <param name="checkValue">string checkValue</param>
        /// <param name="checkTest">optional object checkTest</param>
        /// <param name="checkOperation">optional object checkOperation</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SetMatchingField(string field, string value, string checkField, string checkValue, object checkTest, object checkOperation)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SetMatchingField", new object[] { field, value, checkField, checkValue, checkTest, checkOperation });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        /// <param name="checkField">string checkField</param>
        /// <param name="checkValue">string checkValue</param>
        /// <param name="checkTest">optional object checkTest</param>
        /// <param name="checkOperation">optional object checkOperation</param>
        /// <param name="checkField2">optional object checkField2</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SetMatchingField(string field, string value, string checkField, string checkValue, object checkTest, object checkOperation, object checkField2)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SetMatchingField", new object[] { field, value, checkField, checkValue, checkTest, checkOperation, checkField2 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="field">string field</param>
        /// <param name="value">string value</param>
        /// <param name="checkField">string checkField</param>
        /// <param name="checkValue">string checkValue</param>
        /// <param name="checkTest">optional object checkTest</param>
        /// <param name="checkOperation">optional object checkOperation</param>
        /// <param name="checkField2">optional object checkField2</param>
        /// <param name="checkValue2">optional object checkValue2</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool SetMatchingField(string field, string value, string checkField, string checkValue, object checkTest, object checkOperation, object checkField2, object checkValue2)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "SetMatchingField", new object[] { field, value, checkField, checkValue, checkTest, checkOperation, checkField2, checkValue2 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="window">optional object window</param>
        /// <param name="command">optional object command</param>
        /// <param name="minimize">optional object minimize</param>
        /// <param name="activate">optional object activate</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AppExecute(object window, object command, object minimize, object activate)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "AppExecute", window, command, minimize, activate);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AppExecute()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "AppExecute");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="window">optional object window</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AppExecute(object window)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "AppExecute", window);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="window">optional object window</param>
        /// <param name="command">optional object command</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AppExecute(object window, object command)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "AppExecute", window, command);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="window">optional object window</param>
        /// <param name="command">optional object command</param>
        /// <param name="minimize">optional object minimize</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AppExecute(object window, object command, object minimize)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "AppExecute", window, command, minimize);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="application">string application</param>
        /// <param name="document">optional object document</param>
        /// <param name="activate">optional object activate</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AppLaunch(string application, object document, object activate)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "AppLaunch", application, document, activate);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="application">string application</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AppLaunch(string application)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "AppLaunch", application);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="application">string application</param>
        /// <param name="document">optional object document</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool AppLaunch(string application, object document)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "AppLaunch", application, document);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool DDELinksUpdate()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "DDELinksUpdate");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GotoTaskDates()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GotoTaskDates");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="display">optional NetOffice.MSProjectApi.Enums.PjGanttBarLink Display = 0</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarLinks(object display)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarLinks", display);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarLinks()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarLinks");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="display">optional object display</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttShowDrawings(object display)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttShowDrawings", display);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttShowDrawings()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttShowDrawings");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="on">optional object on</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BarRounding(object on)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BarRounding", on);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool BarRounding()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "BarRounding");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="alwaysRollup">optional object alwaysRollup</param>
        /// <param name="hideWhenSummaryExpanded">optional object hideWhenSummaryExpanded</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttRollup(object alwaysRollup, object hideWhenSummaryExpanded)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttRollup", alwaysRollup, hideWhenSummaryExpanded);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttRollup()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttRollup");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="alwaysRollup">optional object alwaysRollup</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttRollup(object alwaysRollup)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttRollup", alwaysRollup);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="dateFormat">NetOffice.MSProjectApi.Enums.PjDateFormat dateFormat</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarTextDateFormat(NetOffice.MSProjectApi.Enums.PjDateFormat dateFormat)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarTextDateFormat", dateFormat);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="size">NetOffice.MSProjectApi.Enums.PjBarSize size</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarSize(NetOffice.MSProjectApi.Enums.PjBarSize size)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarSize", size);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">string item</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarStyleDelete(string item)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarStyleDelete", item);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">string item</param>
        /// <param name="create">optional object create</param>
        /// <param name="name">optional object name</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="endShape">optional object endShape</param>
        /// <param name="endType">optional object endType</param>
        /// <param name="endColor">optional object endColor</param>
        /// <param name="showFor">optional object showFor</param>
        /// <param name="row">optional object row</param>
        /// <param name="from">optional object from</param>
        /// <param name="to">optional object to</param>
        /// <param name="bottomText">optional object bottomText</param>
        /// <param name="topText">optional object topText</param>
        /// <param name="leftText">optional object leftText</param>
        /// <param name="rightText">optional object rightText</param>
        /// <param name="insideText">optional object insideText</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarStyleEdit(string item, object create, object name, object startShape, object startType, object startColor, object middleShape, object middleColor, object middlePattern, object endShape, object endType, object endColor, object showFor, object row, object from, object to, object bottomText, object topText, object leftText, object rightText, object insideText)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarStyleEdit", new object[] { item, create, name, startShape, startType, startColor, middleShape, middleColor, middlePattern, endShape, endType, endColor, showFor, row, from, to, bottomText, topText, leftText, rightText, insideText });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">string item</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarStyleEdit(string item)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarStyleEdit", item);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">string item</param>
        /// <param name="create">optional object create</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarStyleEdit(string item, object create)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarStyleEdit", item, create);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">string item</param>
        /// <param name="create">optional object create</param>
        /// <param name="name">optional object name</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarStyleEdit(string item, object create, object name)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarStyleEdit", item, create, name);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">string item</param>
        /// <param name="create">optional object create</param>
        /// <param name="name">optional object name</param>
        /// <param name="startShape">optional object startShape</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarStyleEdit(string item, object create, object name, object startShape)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarStyleEdit", item, create, name, startShape);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">string item</param>
        /// <param name="create">optional object create</param>
        /// <param name="name">optional object name</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarStyleEdit(string item, object create, object name, object startShape, object startType)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarStyleEdit", new object[] { item, create, name, startShape, startType });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">string item</param>
        /// <param name="create">optional object create</param>
        /// <param name="name">optional object name</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarStyleEdit(string item, object create, object name, object startShape, object startType, object startColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarStyleEdit", new object[] { item, create, name, startShape, startType, startColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">string item</param>
        /// <param name="create">optional object create</param>
        /// <param name="name">optional object name</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarStyleEdit(string item, object create, object name, object startShape, object startType, object startColor, object middleShape)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarStyleEdit", new object[] { item, create, name, startShape, startType, startColor, middleShape });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">string item</param>
        /// <param name="create">optional object create</param>
        /// <param name="name">optional object name</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middleColor">optional object middleColor</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarStyleEdit(string item, object create, object name, object startShape, object startType, object startColor, object middleShape, object middleColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarStyleEdit", new object[] { item, create, name, startShape, startType, startColor, middleShape, middleColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">string item</param>
        /// <param name="create">optional object create</param>
        /// <param name="name">optional object name</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarStyleEdit(string item, object create, object name, object startShape, object startType, object startColor, object middleShape, object middleColor, object middlePattern)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarStyleEdit", new object[] { item, create, name, startShape, startType, startColor, middleShape, middleColor, middlePattern });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">string item</param>
        /// <param name="create">optional object create</param>
        /// <param name="name">optional object name</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="endShape">optional object endShape</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarStyleEdit(string item, object create, object name, object startShape, object startType, object startColor, object middleShape, object middleColor, object middlePattern, object endShape)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarStyleEdit", new object[] { item, create, name, startShape, startType, startColor, middleShape, middleColor, middlePattern, endShape });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">string item</param>
        /// <param name="create">optional object create</param>
        /// <param name="name">optional object name</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="endShape">optional object endShape</param>
        /// <param name="endType">optional object endType</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarStyleEdit(string item, object create, object name, object startShape, object startType, object startColor, object middleShape, object middleColor, object middlePattern, object endShape, object endType)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarStyleEdit", new object[] { item, create, name, startShape, startType, startColor, middleShape, middleColor, middlePattern, endShape, endType });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">string item</param>
        /// <param name="create">optional object create</param>
        /// <param name="name">optional object name</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="endShape">optional object endShape</param>
        /// <param name="endType">optional object endType</param>
        /// <param name="endColor">optional object endColor</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarStyleEdit(string item, object create, object name, object startShape, object startType, object startColor, object middleShape, object middleColor, object middlePattern, object endShape, object endType, object endColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarStyleEdit", new object[] { item, create, name, startShape, startType, startColor, middleShape, middleColor, middlePattern, endShape, endType, endColor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">string item</param>
        /// <param name="create">optional object create</param>
        /// <param name="name">optional object name</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="endShape">optional object endShape</param>
        /// <param name="endType">optional object endType</param>
        /// <param name="endColor">optional object endColor</param>
        /// <param name="showFor">optional object showFor</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarStyleEdit(string item, object create, object name, object startShape, object startType, object startColor, object middleShape, object middleColor, object middlePattern, object endShape, object endType, object endColor, object showFor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarStyleEdit", new object[] { item, create, name, startShape, startType, startColor, middleShape, middleColor, middlePattern, endShape, endType, endColor, showFor });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">string item</param>
        /// <param name="create">optional object create</param>
        /// <param name="name">optional object name</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="endShape">optional object endShape</param>
        /// <param name="endType">optional object endType</param>
        /// <param name="endColor">optional object endColor</param>
        /// <param name="showFor">optional object showFor</param>
        /// <param name="row">optional object row</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarStyleEdit(string item, object create, object name, object startShape, object startType, object startColor, object middleShape, object middleColor, object middlePattern, object endShape, object endType, object endColor, object showFor, object row)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarStyleEdit", new object[] { item, create, name, startShape, startType, startColor, middleShape, middleColor, middlePattern, endShape, endType, endColor, showFor, row });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">string item</param>
        /// <param name="create">optional object create</param>
        /// <param name="name">optional object name</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="endShape">optional object endShape</param>
        /// <param name="endType">optional object endType</param>
        /// <param name="endColor">optional object endColor</param>
        /// <param name="showFor">optional object showFor</param>
        /// <param name="row">optional object row</param>
        /// <param name="from">optional object from</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarStyleEdit(string item, object create, object name, object startShape, object startType, object startColor, object middleShape, object middleColor, object middlePattern, object endShape, object endType, object endColor, object showFor, object row, object from)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarStyleEdit", new object[] { item, create, name, startShape, startType, startColor, middleShape, middleColor, middlePattern, endShape, endType, endColor, showFor, row, from });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">string item</param>
        /// <param name="create">optional object create</param>
        /// <param name="name">optional object name</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="endShape">optional object endShape</param>
        /// <param name="endType">optional object endType</param>
        /// <param name="endColor">optional object endColor</param>
        /// <param name="showFor">optional object showFor</param>
        /// <param name="row">optional object row</param>
        /// <param name="from">optional object from</param>
        /// <param name="to">optional object to</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarStyleEdit(string item, object create, object name, object startShape, object startType, object startColor, object middleShape, object middleColor, object middlePattern, object endShape, object endType, object endColor, object showFor, object row, object from, object to)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarStyleEdit", new object[] { item, create, name, startShape, startType, startColor, middleShape, middleColor, middlePattern, endShape, endType, endColor, showFor, row, from, to });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">string item</param>
        /// <param name="create">optional object create</param>
        /// <param name="name">optional object name</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="endShape">optional object endShape</param>
        /// <param name="endType">optional object endType</param>
        /// <param name="endColor">optional object endColor</param>
        /// <param name="showFor">optional object showFor</param>
        /// <param name="row">optional object row</param>
        /// <param name="from">optional object from</param>
        /// <param name="to">optional object to</param>
        /// <param name="bottomText">optional object bottomText</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarStyleEdit(string item, object create, object name, object startShape, object startType, object startColor, object middleShape, object middleColor, object middlePattern, object endShape, object endType, object endColor, object showFor, object row, object from, object to, object bottomText)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarStyleEdit", new object[] { item, create, name, startShape, startType, startColor, middleShape, middleColor, middlePattern, endShape, endType, endColor, showFor, row, from, to, bottomText });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">string item</param>
        /// <param name="create">optional object create</param>
        /// <param name="name">optional object name</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="endShape">optional object endShape</param>
        /// <param name="endType">optional object endType</param>
        /// <param name="endColor">optional object endColor</param>
        /// <param name="showFor">optional object showFor</param>
        /// <param name="row">optional object row</param>
        /// <param name="from">optional object from</param>
        /// <param name="to">optional object to</param>
        /// <param name="bottomText">optional object bottomText</param>
        /// <param name="topText">optional object topText</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarStyleEdit(string item, object create, object name, object startShape, object startType, object startColor, object middleShape, object middleColor, object middlePattern, object endShape, object endType, object endColor, object showFor, object row, object from, object to, object bottomText, object topText)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarStyleEdit", new object[] { item, create, name, startShape, startType, startColor, middleShape, middleColor, middlePattern, endShape, endType, endColor, showFor, row, from, to, bottomText, topText });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">string item</param>
        /// <param name="create">optional object create</param>
        /// <param name="name">optional object name</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="endShape">optional object endShape</param>
        /// <param name="endType">optional object endType</param>
        /// <param name="endColor">optional object endColor</param>
        /// <param name="showFor">optional object showFor</param>
        /// <param name="row">optional object row</param>
        /// <param name="from">optional object from</param>
        /// <param name="to">optional object to</param>
        /// <param name="bottomText">optional object bottomText</param>
        /// <param name="topText">optional object topText</param>
        /// <param name="leftText">optional object leftText</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarStyleEdit(string item, object create, object name, object startShape, object startType, object startColor, object middleShape, object middleColor, object middlePattern, object endShape, object endType, object endColor, object showFor, object row, object from, object to, object bottomText, object topText, object leftText)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarStyleEdit", new object[] { item, create, name, startShape, startType, startColor, middleShape, middleColor, middlePattern, endShape, endType, endColor, showFor, row, from, to, bottomText, topText, leftText });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="item">string item</param>
        /// <param name="create">optional object create</param>
        /// <param name="name">optional object name</param>
        /// <param name="startShape">optional object startShape</param>
        /// <param name="startType">optional object startType</param>
        /// <param name="startColor">optional object startColor</param>
        /// <param name="middleShape">optional object middleShape</param>
        /// <param name="middleColor">optional object middleColor</param>
        /// <param name="middlePattern">optional object middlePattern</param>
        /// <param name="endShape">optional object endShape</param>
        /// <param name="endType">optional object endType</param>
        /// <param name="endColor">optional object endColor</param>
        /// <param name="showFor">optional object showFor</param>
        /// <param name="row">optional object row</param>
        /// <param name="from">optional object from</param>
        /// <param name="to">optional object to</param>
        /// <param name="bottomText">optional object bottomText</param>
        /// <param name="topText">optional object topText</param>
        /// <param name="leftText">optional object leftText</param>
        /// <param name="rightText">optional object rightText</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool GanttBarStyleEdit(string item, object create, object name, object startShape, object startType, object startColor, object middleShape, object middleColor, object middlePattern, object endShape, object endType, object endColor, object showFor, object row, object from, object to, object bottomText, object topText, object leftText, object rightText)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "GanttBarStyleEdit", new object[] { item, create, name, startShape, startType, startColor, middleShape, middleColor, middlePattern, endShape, endType, endColor, showFor, row, from, to, bottomText, topText, leftText, rightText });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="size">optional object size</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="gridlines">optional object gridlines</param>
        /// <param name="crossMarks">optional object crossMarks</param>
        /// <param name="field1">optional object field1</param>
        /// <param name="field2">optional object field2</param>
        /// <param name="field3">optional object field3</param>
        /// <param name="field4">optional object field4</param>
        /// <param name="field5">optional object field5</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBoxStyles(object size, object dateFormat, object gridlines, object crossMarks, object field1, object field2, object field3, object field4, object field5)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBoxStyles", new object[] { size, dateFormat, gridlines, crossMarks, field1, field2, field3, field4, field5 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBoxStyles()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBoxStyles");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="size">optional object size</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBoxStyles(object size)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBoxStyles", size);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="size">optional object size</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBoxStyles(object size, object dateFormat)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBoxStyles", size, dateFormat);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="size">optional object size</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="gridlines">optional object gridlines</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBoxStyles(object size, object dateFormat, object gridlines)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBoxStyles", size, dateFormat, gridlines);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="size">optional object size</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="gridlines">optional object gridlines</param>
        /// <param name="crossMarks">optional object crossMarks</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBoxStyles(object size, object dateFormat, object gridlines, object crossMarks)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBoxStyles", size, dateFormat, gridlines, crossMarks);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="size">optional object size</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="gridlines">optional object gridlines</param>
        /// <param name="crossMarks">optional object crossMarks</param>
        /// <param name="field1">optional object field1</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBoxStyles(object size, object dateFormat, object gridlines, object crossMarks, object field1)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBoxStyles", new object[] { size, dateFormat, gridlines, crossMarks, field1 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="size">optional object size</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="gridlines">optional object gridlines</param>
        /// <param name="crossMarks">optional object crossMarks</param>
        /// <param name="field1">optional object field1</param>
        /// <param name="field2">optional object field2</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBoxStyles(object size, object dateFormat, object gridlines, object crossMarks, object field1, object field2)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBoxStyles", new object[] { size, dateFormat, gridlines, crossMarks, field1, field2 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="size">optional object size</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="gridlines">optional object gridlines</param>
        /// <param name="crossMarks">optional object crossMarks</param>
        /// <param name="field1">optional object field1</param>
        /// <param name="field2">optional object field2</param>
        /// <param name="field3">optional object field3</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBoxStyles(object size, object dateFormat, object gridlines, object crossMarks, object field1, object field2, object field3)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBoxStyles", new object[] { size, dateFormat, gridlines, crossMarks, field1, field2, field3 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="size">optional object size</param>
        /// <param name="dateFormat">optional object dateFormat</param>
        /// <param name="gridlines">optional object gridlines</param>
        /// <param name="crossMarks">optional object crossMarks</param>
        /// <param name="field1">optional object field1</param>
        /// <param name="field2">optional object field2</param>
        /// <param name="field3">optional object field3</param>
        /// <param name="field4">optional object field4</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTBoxStyles(object size, object dateFormat, object gridlines, object crossMarks, object field1, object field2, object field3, object field4)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTBoxStyles", new object[] { size, dateFormat, gridlines, crossMarks, field1, field2, field3, field4 });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="create">optional object create</param>
        /// <param name="move">optional object move</param>
        /// <param name="taskID">optional object taskID</param>
        /// <param name="xPosition">optional object xPosition</param>
        /// <param name="yPosition">optional object yPosition</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTSetTask(object create, object move, object taskID, object xPosition, object yPosition)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTSetTask", new object[] { create, move, taskID, xPosition, yPosition });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTSetTask()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTSetTask");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="create">optional object create</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTSetTask(object create)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTSetTask", create);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="create">optional object create</param>
        /// <param name="move">optional object move</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTSetTask(object create, object move)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTSetTask", create, move);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="create">optional object create</param>
        /// <param name="move">optional object move</param>
        /// <param name="taskID">optional object taskID</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTSetTask(object create, object move, object taskID)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTSetTask", create, move, taskID);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="create">optional object create</param>
        /// <param name="move">optional object move</param>
        /// <param name="taskID">optional object taskID</param>
        /// <param name="xPosition">optional object xPosition</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool PERTSetTask(object create, object move, object taskID, object xPosition)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "PERTSetTask", create, move, taskID, xPosition);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="topLeftShowAs">optional object topLeftShowAs</param>
        /// <param name="topLeftColor">optional object topLeftColor</param>
        /// <param name="topLeftPattern">optional object topLeftPattern</param>
        /// <param name="bottomLeftShowAs">optional object bottomLeftShowAs</param>
        /// <param name="bottomLeftColor">optional object bottomLeftColor</param>
        /// <param name="bottomLeftPattern">optional object bottomLeftPattern</param>
        /// <param name="topRightShowAs">optional object topRightShowAs</param>
        /// <param name="topRightColor">optional object topRightColor</param>
        /// <param name="topRightPattern">optional object topRightPattern</param>
        /// <param name="bottomRightShowAs">optional object bottomRightShowAs</param>
        /// <param name="bottomRightColor">optional object bottomRightColor</param>
        /// <param name="bottomRightPattern">optional object bottomRightPattern</param>
        /// <param name="showValues">optional object showValues</param>
        /// <param name="showAvailabilityLine">optional object showAvailabilityLine</param>
        /// <param name="percentBarOverlap">optional object percentBarOverlap</param>
        /// <param name="proposedLeftShowAs">optional object proposedLeftShowAs</param>
        /// <param name="proposedLeftColor">optional object proposedLeftColor</param>
        /// <param name="proposedLeftPattern">optional object proposedLeftPattern</param>
        /// <param name="proposedRightShowAs">optional object proposedRightShowAs</param>
        /// <param name="proposedRightColor">optional object proposedRightColor</param>
        /// <param name="proposedRightPattern">optional object proposedRightPattern</param>
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceGraphBarStyles(object topLeftShowAs, object topLeftColor, object topLeftPattern, object bottomLeftShowAs, object bottomLeftColor, object bottomLeftPattern, object topRightShowAs, object topRightColor, object topRightPattern, object bottomRightShowAs, object bottomRightColor, object bottomRightPattern, object showValues, object showAvailabilityLine, object percentBarOverlap, object proposedLeftShowAs, object proposedLeftColor, object proposedLeftPattern, object proposedRightShowAs, object proposedRightColor, object proposedRightPattern)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceGraphBarStyles", new object[] { topLeftShowAs, topLeftColor, topLeftPattern, bottomLeftShowAs, bottomLeftColor, bottomLeftPattern, topRightShowAs, topRightColor, topRightPattern, bottomRightShowAs, bottomRightColor, bottomRightPattern, showValues, showAvailabilityLine, percentBarOverlap, proposedLeftShowAs, proposedLeftColor, proposedLeftPattern, proposedRightShowAs, proposedRightColor, proposedRightPattern });
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceGraphBarStyles()
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceGraphBarStyles");
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="topLeftShowAs">optional object topLeftShowAs</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceGraphBarStyles(object topLeftShowAs)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceGraphBarStyles", topLeftShowAs);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="topLeftShowAs">optional object topLeftShowAs</param>
        /// <param name="topLeftColor">optional object topLeftColor</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceGraphBarStyles(object topLeftShowAs, object topLeftColor)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceGraphBarStyles", topLeftShowAs, topLeftColor);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="topLeftShowAs">optional object topLeftShowAs</param>
        /// <param name="topLeftColor">optional object topLeftColor</param>
        /// <param name="topLeftPattern">optional object topLeftPattern</param>
        [CustomMethod]
        [SupportByVersion("MSProject", 11, 12, 14)]
        public static bool ResourceGraphBarStyles(object topLeftShowAs, object topLeftColor, object topLeftPattern)
        {
            return Factory.ExecuteBoolMethodGet(_instance, "ResourceGraphBarStyles", topLeftShowAs, topLeftColor, topLeftPattern);
        }

        /// <summary>
        /// SupportByVersion MSProject 11, 12, 14
        /// </summary>
        /// <param name="topLeftShowAs">optional object topLeftShowAs</param>
        /// <param name="topLeftColor">optional object topLeftColor</param>
        /// <param name="topLeftPattern">optional object topLeftPattern</param>
        /// <param name="bottomLeftShowAs">optional object bottomLeftShowAs</param>
        [CustomMethod]
        [SupportByVersi